   
var win = getParentWindow();
var neObj = getNeProperty(win.self);
var neIdValue = neObj["neid"];

var packID =  win.selectPackID;
var boardType =  win.selectBoardType;

var availableBoardRes =  new Object(); 
var subrackList = [];

window.tree.showCheckBox=1;
var root = null;


var BOARD_OFFSET = 65536;
/**
*         UI
*/
function init()   
{ 
   
  sendGetAvailableResourceInfo();
  
   
	$("btnOk").value = RESOURCE["okbutton"];
 	$("btnCancel").value = RESOURCE["cancelbutton"];
 	
 	$("btnOk").disabled = true;		
    
} 


/**
 *          
 */
function createTree()
{
	setImagePath("../../../../../../images/tree/");
	
	root = new TreeNode("root" , null, availableBoardRes.neName, nodeSelectedEvent);	
	for (var i=0; i< subrackList.length; i++)
	{
		var subrackID = subrackList[i];
	    var subrackObj = availableBoardRes.subrackList[subrackID];
	
		var node = new TreeNode("subrack_"+subrackID ,root,subrackObj.subrackName,nodeSelectedEvent);
		
		for (var j=0; j < subrackObj.boardList.length; j++)
		{
			var boardObj  = subrackObj.boardList[j];		
			new TreeNode(boardObj.slotId , node, getSoltName(boardObj.slotId, boardObj.boardName), nodeSelectedEvent);
		}
	}
	$("selectboardTree").appendChild(root.drawTree());
	root.expand();
}

function getSoltName(slotId, boardName)
{
	return slotId % BOARD_OFFSET + "-" +boardName
}

  /**
 * 
 *   node    
 * 
 */
function nodeSelectedEvent()
{
	var isContainsSelectNode = false;
	for( var i=0; i<root.childNodes.length; i++)
	{
		var childnode=root.childNodes[i];
		if(childnode.isNodeSelected() && childnode.hasChildren())
		{
			for( var j=0; j<childnode.childNodes.length; j++)
			{   			
				if(childnode.childNodes[j].isNodeSelected())
				{
					isContainsSelectNode = true;
					break;
				}
			}
		}
	}//end for loop
	
	if(isContainsSelectNode)
	{
		$("btnOk").disabled = false;
	}
	else
	{
	  $("btnOk").disabled = true;	
	}
}

/**
 *         
 */
function getSelectedSoltIDList(node)
{	var selectedSoltIdArray = new Array();
	for( var i=0; i<node.childNodes.length; i++)
	{
		var childnode=node.childNodes[i];
		if(childnode.isNodeSelected())
		{	
			if(childnode.hasChildren())
			{
				for( var j=0; j<childnode.childNodes.length; j++)
				{   			
					if(childnode.childNodes[j].isNodeSelected())
					{
						selectedSoltIdArray.push(childnode.childNodes[j].id);
					}
				}
			}
		}
	}//end for loop   
	return selectedSoltIdArray;	
}
  
  /**
 * 
 *             ,           
 * 
 * @return
 */
function sendGetAvailableResourceInfo()
{
	var xmlstr = createGetAvailableResourceXML();
	var url = "../../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_NGWDM_QUERY_PACKAGE_BOARD
			+ "&flag=1&timestamp=" + new Date().getTime();
	loadXMLdoc(url, "POST", true, callbackQueryBoards, null,
			"inputdata=" + xmlstr);
}


/**
*             
*/
  function createGetAvailableResourceXML()
  {  
      var di = new inputxml("datainterface");
      var bussiness = new tagElement("bussiness-params");

      var row = new tagElement("row-params");
      var param = new tagElement("param");

      param.setAttribute("name","neid");     
      param.setAttribute("value",neIdValue);
      row.appendChild(param);

      param = new tagElement("param");
      param.setAttribute("name","boardtype");
      param.setAttribute("value",boardType);
      row.appendChild(param);

      bussiness.appendChild(row);
      di.getRoot().appendChild(bussiness);

      return di.toString();
  }
    
/**
*          
*/
function callbackQueryBoards(doc)
{
	availableBoardRes.subrackList = [];
	var dinterface = EncapsulateData(doc);
	var errorCode = dinterface.getSErrorCode();   
    if(errorCode == OPERATION_SUCCESS)
    {
    	for(var i = 0,len = dinterface.getDataRowLength();i < len; i++)
	  	{
	  	 	var obj = dinterface.rows[i];
	  	 	availableBoardRes.neName = obj.nename.value;
	  	 	availableBoardRes.neID= obj.neid.value;
	  	 	if(obj.subrackid == null)
	  	 	{
	  	 		continue;
	  	 	}
	  	 	
	  	   	var subrackid = obj.subrackid.value; 
	  	 	var boardObj = new Object();
	  	 	boardObj.slotId = obj.slotid.value;
	  	 	boardObj.boardName = obj.boardname.value;	  	 
	  	 	
	  	   if(availableBoardRes.subrackList[subrackid] == null)
	  	   {
			    var subrackObj = new Object();
			    var boardArray = [];     	    
			    boardArray.push(boardObj);
			    subrackObj.boardList = boardArray;
			   
			    subrackObj.subrackName =   obj.subrackname.value;
			    subrackObj.subrackId =  subrackid;			   
			    availableBoardRes.subrackList[subrackid] = subrackObj;
			    subrackList.push(subrackid);
    	   }
    	   else    	   	   
	   	   {
	   	   	   availableBoardRes.subrackList[subrackid].boardList.push(boardObj);
	   	   }
      }     
    	
       createTree();
    }
    else
    {
      showErrorDialog(dinterface);
 	} 	
}
/*
     
*/
function showErrorDialog(data)
{
  var errArr = [];
  errArr[0] = "nename";
  errArr[1] = "slotid";
  errArr[3] = "boardname";
  openErrPage("../../../../../../page/", data.getError(), errArr);   
}

/**
 *      ,    
 * @return
 */
function cancelClick()
{
	 xcloseDialog();
}

/**
 * OK    ,              
 * 
 * @return
 */
function okClick()
{
	var showStr = RESOURCE["setvaluetips"];
	if(!confirm(showStr))
	{
		return;	
	}
	sendApplyInfo();	
	
}

/**
 * 
 *             ,    
 * 
 * @return
 */
function sendApplyInfo()
{
	var xmlstr = createApplyInfoXML();
	var url = "../../../../../../tl1NEExlorerServlet?sfid=" + TECMDCODE_NGWDM_SET_BUSINESS_PACKAGE
			+ "&flag=1&timestamp=" + new Date().getTime();

	loadXMLdoc(url, "POST", true, callbackSetBusinessPackage, null,
			"inputdata=" + xmlstr);
	
	showLoadProcess("../../../../../../");
}


/**
*           
*/
  function createApplyInfoXML()
  { 	 
      var di = new inputxml("datainterface");
      var bussiness = new tagElement("bussiness-params");

      var soltList = getSelectedSoltIDList(root);
      var len = soltList.length ;
      for(var i= 0; i < len; i++)
 	 {	
    	  var row = new tagElement("row-params");
          var param = new tagElement("param");

          param.setAttribute("name","neid");     
          param.setAttribute("value",neIdValue);
          row.appendChild(param);

          param = new tagElement("param");
          param.setAttribute("name","slotid");
          param.setAttribute("value",soltList[i]);
          row.appendChild(param);
          
          param = new tagElement("param");
          param.setAttribute("name","TEMPNAME");
          param.setAttribute("value",packID);
          row.appendChild(param);

          bussiness.appendChild(row); 		 
 	 } 
      di.getRoot().appendChild(bussiness);
      return di.toString();
  }
  
  
  
  /**
  *           
  */
function createApplyInfoXML()
{ 	 
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");

    var soltList = getSelectedSoltIDList(root);
    var len = soltList.length ;
    for(var i= 0; i < len; i++)
   	{	
      	var row = new tagElement("row-params");
        var param = new tagElement("param");

        param.setAttribute("name","neid");     
        param.setAttribute("value",neIdValue);
        row.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name","slotid");
        param.setAttribute("value",soltList[i]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","tempname");
        param.setAttribute("value",cfgBusinessPackages[packID]);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name","isCreateEXC");
        param.setAttribute("value",win.isCreateEXCFlag);
        row.appendChild(param);

        bussiness.appendChild(row); 		 
   	 } 
       di.getRoot().appendChild(bussiness);
       return di.toString();
}


    
  
/**
*           
*/
function callbackSetBusinessPackage(doc)
{	
	removeLoadProcess();
	var dinterface = EncapsulateData(doc);
	var errorCode = dinterface.getSErrorCode();  
    if(errorCode != OPERATION_SUCCESS)   
    {
      showErrorDialog(dinterface);
 	} 	
    else
    {
    	xcloseDialog();	
    }
}



/*
 * selfid   id ptreenode     nodestr       , func    onclick argus
 * func                  (argus = [tabName, tabLink])
 * 
 */
function TreeNode(selfid, ptreenode, nodestr, func, argus,beforenode)
{
	this.id = selfid; //     id
	this.parent = ptreenode; //    
	this.text = nodestr; //         
	this.childNodes = new Array();
	window.tree[this.id] = this;
	this.node = null;
	this.children = null;
	this.nodeimage = "";
	this.nodefunc = func;
	nodeSelectedEventHandler = func;
	this.openFlag = false;
	this.argus = argus;

	this.onClick = function()
	{
		if (this.nodefunc)
		{
			this.nodefunc(this.argus);
		}
	}

	this.appendToParent = function(obj)
	{
		if (obj)
		{
			obj.childNodes[obj.childNodes.length] = this;
		}
	}
	if(typeof(beforenode) == "undefined" || beforenode == null)
	{
		this.appendToParent(this.parent);
	}
	else if(this.parent)
	{
		for(var i = 0,m = this.parent.childNodes.length;i < m;i++)
		{
			if(this.parent.childNodes[i] == beforenode)
			{
				this.parent.childNodes.splice(i, 0, this);
				break;
			}
		}
	}
	this.drawNode = function()
	{
		var div = document.createElement("div");
		div.style.whiteSpace = "nowrap";
		div.style.height = "16px";

		var span = document.createElement("span");
		span.appendChild(document.createTextNode(this.text));
		span.setAttribute("id", "span_" + this.id);

		var nodeimage = new Image();
		nodeimage.setAttribute("align", "absmiddle");
		nodeimage.style.border = "0px";
		nodeimage.style.width = "16px";
		nodeimage.style.height = "16px";

		nodeanchor = document.createElement("a");
		nodeanchor.onfocus = focusHandler;
		nodeanchor.setAttribute("target", "_self");

		if (this.nodefunc)
		{
			nodeanchor.setAttribute("href", "#");
			nodeanchor.onclick = function()
			{
				window.tree[this.nid].isSelect();
				window.tree[this.nid].openFolder();
				window.tree[this.nid].onClick();
			};
		}
		else
		{
			nodeanchor.setAttribute("href", "#");
			nodeanchor.onclick = function()
			{
				window.tree[this.nid].isSelect();
				window.tree[this.nid].openFolder();
			};

		}

		if (window.tree.showCheckBox == 1)
		{
			var input = document.createElement("input");
			input.type = "checkbox";
			input.style.width = "16px";
			input.style.height = "16px";
			input.style.margin = "0px";
			input.style.border = "0px";
			input.setAttribute("id", "checkbox_" + this.id);
			input.onclick = handleCheckBoxSelect;
			div.appendChild(input);
		}

		if (window.tree.treeCellRender && this.userObject)
		{
			span.innerHTML = "";
			var render = new window.tree.treeCellRender(this.userObject);
			span.appendChild(render.getDomElement());
		}

		nodeanchor.appendChild(span);
		div.appendChild(nodeanchor);

		if (this.hasChildren())
		{
			var imgstr = this.openFlag?"minus":"plus";
			if (this.parent)
			{
				if (this.isLastChild())
				{
					nodeimage.src = Icon["end_" + imgstr].src;
				}
				else
				{
					nodeimage.src = Icon["cross_" + imgstr].src;
				}
			}
			else
			{
				nodeimage.src = Icon[imgstr].src;
			}

			nodeanchor = document.createElement("a");
			nodeanchor.onfocus = focusHandler;
			nodeanchor.setAttribute("target", "_self");
			nodeanchor.nid = this.id;
			nodeanchor.onclick = function () 
			{ 
				window.tree[this.nid].openHandler(); 
			}
			this.nodeimage = nodeimage;
			nodeanchor.appendChild(nodeimage);
			div.insertBefore(nodeanchor, div.firstChild);
		}
		else
		{
			if (this.isLastChild())
			{
				if ((this.childNodes.length > 0) || (this.parent))
				{
					nodeimage.src = Icon["end"].src;
				}
				else
				{
					nodeimage.src = Icon["blank"].src;
				}

			}
			else
			{
				nodeimage.src = Icon["cross"].src;
			}
			div.insertBefore(nodeimage, div.firstChild);
		}
		var p = this;
		while (p.parent)
		{
			nodeimage = new Image();
			nodeimage.setAttribute("align", "absmiddle");
			nodeimage.style.width = "16px";
			nodeimage.style.height = "16px";

			if (p.parent.isLastChild())
			{
				nodeimage.src = Icon["blank"].src;
			}
			else
			{
				nodeimage.src = Icon["line"].src;
			}
			div.insertBefore(nodeimage, div.firstChild);
			p = p.parent;
		}
		return div;
	}

	this.drawChildren = function()
	{
		var div = document.createElement("div");
		if (this.hasChildren())
		{
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				var d = this.childNodes[i].drawTree()
				div.appendChild(d);
			}
			if (this.openFlag)
			{
				div.style.display = "";
			}
			else
			{
				div.style.display = "none";
			}
			return div;

		}
		else
		{
			return null;
		}
	}

	this.isLastChild = function()
	{
		if (this.parent != null)
		{
			return this.parent.childNodes[this.parent.childNodes.length - 1].id == this.id;
		}
		else
		{
			return true;
		}
	}

	this.hasChildren = function()
	{
		return this.childNodes.length > 0;
	}

	this.openHandler = function()
	{
		if (this.children)
		{
			if (this.nodeimage.src == Icon["plus"].src
					|| this.nodeimage.src == Icon["minus"].src)
			{
				this.nodeimage.src == Icon["plus"].src ? this.nodeimage.src = Icon["minus"].src
						: this.nodeimage.src = Icon["plus"].src;
			}
			else if (this.nodeimage.src == Icon["cross_plus"].src
					|| this.nodeimage.src == Icon["cross_minus"].src)
			{
				this.nodeimage.src == Icon["cross_plus"].src ? this.nodeimage.src = Icon["cross_minus"].src
						: this.nodeimage.src = Icon["cross_plus"].src;
			}
			else
			{
				this.nodeimage.src == Icon["end_plus"].src ? this.nodeimage.src = Icon["end_minus"].src
						: this.nodeimage.src = Icon["end_plus"].src;
			}
			if (this.children.style.display == "")
			{
				this.children.style.display = "none"
				this.openFlag = false;
			}
			else
			{
				this.children.style.display = ""
				this.openFlag = true;
			}
		}
	}

	this.openFolder = function()
	{
		if (this.children)
		{
			if (this.nodeimage.src == Icon["plus"].src)
			{
				this.nodeimage.src = Icon["minus"].src;
			}
			else if (this.nodeimage.src == Icon["cross_plus"].src)
			{
				this.nodeimage.src = Icon["cross_minus"].src;
			}
			else if (this.nodeimage.src == Icon["end_plus"].src)
			{
				this.nodeimage.src = Icon["end_minus"].src;
			}
			this.children.style.display = "";
			this.openFlag = true;
		}
	}
	/*
	 *      
	 */

	this.closeFolder = function()
	{
		if (this.children)
		{
			if (this.nodeimage.src == Icon["minus"].src)
			{
				this.nodeimage.src = Icon["plus"].src;
			}
			else if (this.nodeimage.src == Icon["cross_minus"].src)
			{
				this.nodeimage.src = Icon["cross_plus"].src;
			}
			else if (this.nodeimage.src == Icon["end_minus"].src)
			{
				this.nodeimage.src = Icon["end_plus"].src;
			}
			this.children.style.display = "none";
			this.openFlag = false;
		}
	}

	this.drawTree = function()
	{
		var div;
		this.node = this.drawNode();
		this.children = this.drawChildren();
		div = document.createElement("div");
		div.appendChild(this.node);
		if (this.children && (this.children != null))
		{
			div.appendChild(this.children);
		}
		return div;
	}
	this.redrawTree = function()
	{
		if(this.parent && this.node)
		{
			if(this.parent.children)
			{
				var parentnode = this.node.parentNode;
				parentnode.removeChild(this.node);
				this.node = this.drawNode();
				parentnode.appendChild(this.node);
				this.children = this.drawChildren();
				if (this.children && (this.children != null))
				{
					parentnode.appendChild(this.children);
				}
			}
		}
	}
	this.isSelect = function()
	{
		if (window.tree.selectID)
		{
			var lastSelectElem = document.getElementById("span_"
					+ window.tree.selectID);
			if (lastSelectElem)
			{
				lastSelectElem.style.backgroundColor = "";
				lastSelectElem.style.border = "none";
			}
		}
		window.tree.selectID = this.id;
		var currSelectElem = document.getElementById("span_" + this.id);
		if(currSelectElem != null)
		{
			if (window.tree.treeCellRender != null)
			{
				currSelectElem.style.border = "solid 1px black";
			}
			else
			{
				currSelectElem.style.backgroundColor = "#B2C3C4";
			}
		}
	}

	/**
	 *                 checkbox   
	 */
	this.isNodeSelected = function()
	{

		var element = document.getElementById("checkbox_" + this.id);
		if (element)
		{
			return document.getElementById("checkbox_" + this.id).checked;
		}
		else
		{
			return (window.tree.selectID == this.id);
		}

	}

	this.setNodeSelected = function()
	{
		document.getElementById("checkbox_" + this.id).checked = true;
	}
	this.setNodeUnSelected = function()
	{
		document.getElementById("checkbox_" + this.id).checked = false;
	}
	


	this.removeNode = function()
	{
		if (this.parent && this.node)
		{
			if (this.parent.children)
			{
				for ( var i = 0, m = this.parent.childNodes.length; i < m; i++)
				{
					if (this.parent.childNodes[i] == this)
					{
						this.parent.childNodes.splice(i, 1);
					}
				}
				this.parent.children.removeChild(this.node.parentNode);
			}
		}
		else if (!this.parent)
		{
			if (this.children)
			{
				this.node.parentNode.removeChild(this.children);
			}
			this.node.parentNode.removeChild(this.node);
		}
		this.removeWindowTreeNode();
	}
	this.removeWindowTreeNode = function()
	{
		for ( var i = 0; i < this.childNodes.length; i++)
		{
			this.childNodes[i].removeWindowTreeNode();
		}
		delete window.tree[this.id];
	}

	this.expand = function()
	{
		var p = this;
		while (p.parent)
		{
			p.parent.openFolder();
			p = p.parent;

		}
		this.openFolder();
	}
	/*
	 *         
	 */
	this.expandAll = function()
	{
		this.openFolder();
		if (this.hasChildren())
		{
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				this.childNodes[i].expandAll();
			}
		}
	}
	/*
	 *               
	 */
	this.collapseAll = function()
	{
		this.closeFolder();
		if (this.hasChildren())
		{
			for ( var i = 0; i < this.childNodes.length; i++)
			{
				this.childNodes[i].collapseAll();
			}
		}
	}
}
function showLoadProcess(path)
{
	LoadingProcess.showWaitStatus(path + "images/");
}

function removeLoadProcess()
{
	LoadingProcess.removeWaitStatus();
}
