 loadXMLdoc("../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../res/subrackres_"+ language +".xml"); //      
document.title = RESOURCE["addsubrack"];
var table = new  CTable();
var win = window.dialogArguments;
var NETYPE_8800A = "73";//8800     
var NETYPE_6800A = "71";//6800     
var NETYPE_8800II = "75";//6800     
var OSN_3800_A = 70;
var OSN_6800_A = 71;
var OSN_8800_A = 73;
var OSN_8800_A_II = 75;

var OLDNEVERSION = "5.51.05.99";
var OLDNEVERSION_3800A = 70;
var OLDNEVERSION_6800A = 71;

    
function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	
	var atom = new Atom("select");
	var existSubrackIDArr = win.Tab.getAllTabsID();
	for(var i = 1; i <= win.MAX_SUBRACK_NUM; i++)
	{
		if(!existSubrackIDArr.contains(i)) // i       
		{
			atom.addOption(i, i);
		}
	}
	table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
	

	atom = new Atom("select");

	table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
	if(win.nePro["neType"] == NETYPE_8800II)
	{
		atom.addOption(RESOURCE["TYPE_71"], "136");
		atom.addOption(RESOURCE["TYPE_85"], "1985");
		atom.addOption(RESOURCE["TYPE_73"], "2043");
		if(compare(win.nePro["neversion"],"5.51.07.64") >= 0 )
        {
			atom.addOption(RESOURCE["TYPE_100"], "2044");
        }
		atom.addOption(RESOURCE["TYPE_75"], "1975");	
		if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
        {
			atom.addOption(RESOURCE["TYPE_101"], "101");
        }
	}
	atom.element["onchange"] = function()
    {
        $("applybtn").disabled = false;
        handelCrs(this.value);
    }
	atom = new Atom("text");
	checkInputData(atom.element, 16);
	table.addAttrRow("subrackName",RESOURCE["subrackName"], atom);
	atom.element.style.imeMode = "disabled";
	atom.element.onpaste = function()
	{
		return false;
	}
	atom.element["onkeypress"] = function()
    {
        $("applybtn").disabled = false;
        if (restrictByAllow(this,window.event,"\"`'\\=,:;?&!(){}[]<>/"))
        {
        	return calStrSinoLen(this,16);
        }
        else
        {
        	return false;
        }
    }
	
	atom = new Atom("text");
	checkInputData(atom.element, 20);
	table.addAttrRow("subrackFIC",RESOURCE["subrackFIC"], atom);
	atom.element.style.imeMode = "disabled";
	atom.element.onpaste = function()
	{
		return false;
	}
	atom.element["onkeypress"] = function()
    {
        $("applybtn").disabled = false;
        if (restrictByAllow(this,window.event,"\"`'\\=,:;?&!(){}[]<>/"))
        {
        	return calStrSinoLen(this,20);
        }
        else
        {
        	return false;
        }
    }    
	atom = new Atom("select");
	table.addAttrRow("crossType",RESOURCE["crossType"], atom);
	atom.addOption("NONE", "NONE");
	atom.addOption("OTN", "OTN");
	
	atom = new Atom("select");
	atom.addOption(RESOURCE["crossCapacity0"], 0);
	atom.addOption(RESOURCE["crossCapacity1"], 360);
	if(compare(win.nePro["neversion"],"5.51.07.10") >= 0 )
	{
	    atom.addOption(RESOURCE["crossCapacity7"], 640);
	}
	atom.addOption(RESOURCE["crossCapacity2"], 720);
	atom.addOption(RESOURCE["crossCapacity3"], 1280);
	atom.addOption(RESOURCE["crossCapacity4"], 2560);
	if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
    {
        atom.addOption(RESOURCE["crossCapacity8"], 3200);
        atom.addOption(RESOURCE["crossCapacity9"], 6400);
    }
	table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);
	document.body.insertBefore(table.getTable(), $("AddTable"));
	handelCrs(table.getAttrValue("subrackType"));
}

function handelCrs(curtype)
{
	if (curtype == 136)
    {
        table.getAtom("crossType").element.disabled = true;
        table.getAtom("crossCapacity").element.disabled = true;
    }
    else
    {
        table.getAtom("crossType").element.disabled = false;
        table.getAtom("crossCapacity").element.disabled = false;
        var atom = table.getAtom("crossCapacity");
        if (curtype == 1985) // 8800T16A
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
        }
        else if (curtype == 2043) // 8800T32A
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
		    {
				atom.addOption(RESOURCE["crossCapacity4"], 2560);
		    }
        }
        else if(curtype == 2044) // 8800T32AE
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
		    {
		    	atom.addOption(RESOURCE["crossCapacity4"], 2560);
		        atom.addOption(RESOURCE["crossCapacity8"], 3200);
		    }
        }
        else if (curtype == 1975) // 8800T64A
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	atom.addOption(RESOURCE["crossCapacity4"], 2560);
        }
        else if (curtype == 101) // 8800T64AE
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	atom.addOption(RESOURCE["crossCapacity4"], 2560);
		    atom.addOption(RESOURCE["crossCapacity8"], 3200);
        	atom.addOption(RESOURCE["crossCapacity9"], 6400);
        }
    }
}

/**
 *           xml  
 */
function createAddXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType");
	var subrackFIC = table.getAttrValue("subrackFIC");
	var subrackName = table.getAttrValue("subrackName");
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackType");
	var isNewVer = isNewNEVersion(win.nePro["neType"], win.nePro["neversion"]);
	var subrackTypeName = "SHELF8800II";
	if (isNewVer)
	{
	    subrackTypeName = "SHELF8800T64";
	}
	if(subrackType=="136")
	{
		subrackTypeName = "SHELF6800A";
	}
	else if(subrackType=="2043")
	{
		subrackTypeName = "SHELF8800I";
		if (isNewVer)
    	{
    	    subrackTypeName = "SHELF8800T32";
    	}
	}
	else if(subrackType=="1985")
	{
		subrackTypeName = "SHELF8800T16";
	}
	else if(subrackType=="2044")
	{
		subrackTypeName = "SHELF8800T32E";
	}
	else if (subrackType == "101")
	{
		subrackTypeName = "SHELF8800T64E";
	}
	param.setAttribute("value",subrackTypeName);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackFIC");
	if(subrackFIC!="")
	{
		param.setAttribute("value",subrackFIC);
		row.appendChild(param);
	}

	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackName");
	if(subrackName!="")
	{
		param.setAttribute("value",subrackName);
		row.appendChild(param);
	}

	
	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


/**
 *        
 */
function addSubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
		
	var subrackID = table.getAttrValue("subrackID"); //          ID
	if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
	if(subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	var existSubrackIDArr = win.Tab.getAllTabsID();
	if(existSubrackIDArr.contains(subrackID)) //          ,     
	{
		alert(RESOURCE["subrackExist"]); //                   
		return;
	}
	
	$("okBtn").disabled = true;
	$("applyBtn").disabled = true;
	var addXML = createAddXML(); //        xml
	var paramArr = [];
	paramArr[0] = subrackID;
	paramArr[1] = table.getAttrValue("subrackType");;
	paramArr[2] = btnFlg;
	paramArr[3] = table.getAttrValue("subrackFIC");
	paramArr[4] = table.getAttrValue("subrackName");
	loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_ADD_SUBRACK, "POST", false,addSubrackCallBack, paramArr,"inputdata="+addXML);
}


/**
 *             
 */
function addSubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	var subrackType = table.getAttrValue("subrackType");
	
	if (subrackType != 136)
	{
	    setCrsCop();
	}
	
	win.refreshShowAfterAddTab(paramArr[0], paramArr[1],paramArr[4],paramArr[3]); //      Tab   
	win.strShowTab = -1;
	win.endShowTab = -1;
	win.strHidTab = -1;
	win.endHidTab = -1;
	
	if(paramArr[2]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		var subrackIDAtom = table.getAtom("subrackID").element;
		subrackIDAtom.options.remove(subrackIDAtom.selectedIndex);
		if(subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}

function setCrsCop()
{
    var xml = createSetCrsCopXML();  
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid=2010100&flag=0&timeStamp="+new Date().getTime(),"POST",false,setCrsCopCallback,null,"inputdata="+xml);
}

function setCrsCopCallback(doc)
{
    var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		return;
	}
}

function createSetCrsCopXML()
{
    var subrackID = table.getAttrValue("subrackID");
    if(subrackID.indexOf("-")!=-1)
	{
		subrackID = subrackID.split("-")[0];
	}
    
    
    var crstype = table.getAttrValue("crossType");
	var crscap = table.getAttrValue("crossCapacity");
	
    var root = new inputxml("datainterface");         
    firstlevel = new tagElement("bussiness-params");      
    secondlevel = new tagElement("row-params");
       
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",win.neid);
    secondlevel.appendChild(thirdlevel);
   
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","subrackID");
    thirdlevel.setAttribute("value", subrackID);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","CRSTYPE");
    thirdlevel.setAttribute("value",crstype);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","CRSCAP");
    thirdlevel.setAttribute("value",crscap);
    secondlevel.appendChild(thirdlevel);
       
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
       
    return root.toString();
}
/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //         ID
	openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
*           
*/
function cancelBtnAction()
{
	xcloseDialog();//     
}
function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
}
function isNewNEVersion(neType, version)
{
	var ver = version.split(".");
    var criticalver = parseInt(ver[1], 10);
    if (neType == OSN_3800_A)
    {
        if (criticalver == OLDNEVERSION_3800A)
        {
            return false;
        }

        return compare(version,OLDNEVERSION) > 0;
    }
    else if (neType == OSN_6800_A)
    {
        if (criticalver == OLDNEVERSION_6800A)
        {
            return false;
        }

        return compare(version,OLDNEVERSION) > 0;
    }
    else if (neType == OSN_8800_A)
    {
        return compare(version,OLDNEVERSION) > 0;
    }
    else if (neType == OSN_8800_A_II)
    {
        return compare(version,OLDNEVERSION) > 0;
    }
    
    return true;
}
