 loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../res/necommres_" + language + ".xml"); //       
getResourse("../res/subrackres_" + language + ".xml"); //       
if (unescape(getNeProperty(self).subrackID) == "1")
{
	document.title = RESOURCE["getmastersubrack"];
}
else
{
	document.title = RESOURCE["getslavesubrack"];
}

var table = new CTable();
var win = window.dialogArguments;
var NETYPE_8800 = "68";// 8800     
var NETYPE_6800A = "71";// 6800     

function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);

	var atom = new Atom("span");
	atom.setValue(unescape(getNeProperty(self).subrackID));
	table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);

	atom = new Atom("span");
	var shelfType = unescape(getNeProperty(self).subrackType);
	var shelfTypeName= "";
	if (shelfType == "2043")
	{
		shelfTypeName = "OSN8800 T32(NA)"
	}
	else if (shelfType == "136")
	{
		shelfTypeName = "OSN6800A"
	}
	else if (shelfType == "1975")
	{
		shelfTypeName = "OSN8800 T64(NA)";
	}
	
	atom.setValue(shelfTypeName);
	table.addAttrRow("subrackType", RESOURCE["subrackType"], atom);

	atom = new Atom("text");
	checkInputData(atom.element, 16);

	atom.setValue(unescape(getNeProperty(self).subrackName));
	table.addAttrRow("subrackName", RESOURCE["subrackName"], atom);
	atom.element.style.imeMode = "disabled";
	atom.element.onpaste = function()
	{
		return false;
	}
	atom.element["onkeypress"] = function()
	{
		$("applybtn").disabled = false;
		if (restrictByAllow(this, window.event, "\"`'\\=,:;?&!(){}[]<>/"))
		{
			return calStrSinoLen(this, 16);
		}
		else
		{
			return false;
		}
	}
	atom = new Atom("text");
	checkInputData(atom.element, 20);
	atom.setValue(unescape(getNeProperty(self).ficInfo));
	table.addAttrRow("subrackFIC", RESOURCE["subrackFIC"], atom);
	atom.element.style.imeMode = "disabled";
	atom.element.onpaste = function()
	{
		return false;
	}
	atom.element["onkeypress"] = function()
	{
		$("applybtn").disabled = false;
		if (restrictByAllow(this, window.event, "\"`'\\=,:;?&!(){}[]<>/"))
		{
			return calStrSinoLen(this, 20);
		}
		else
		{
			return false;
		}
	}

	atom = new Atom("select");
	table.addAttrRow("crossType",RESOURCE["crossType"], atom);
	atom.addOption("NONE", "NONE");
	atom.addOption("OTN", "OTN");
	
	atom = new Atom("select");
	table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);
	atom.addOption("0G", "0");
	atom.addOption("360G", "360");
	atom.addOption("640G", "640");
	atom.addOption("720G", "720");
	atom.addOption("1.28T", "1280");
	atom.addOption("2.56T", "2560");
	
	document.body.insertBefore(table.getTable(), $("AddTable"));
	
	if (shelfType != 136)//6800A         
	{
	    queryCrsCapacity();
	}
	
	
	handelCrs(table.getAttrValue("subrackType"));
}

function queryCrsCapacity()
{
	var xml = createCrsCapacityXML();  
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid=2010099&flag=0&timeStamp="+new Date().getTime(),"POST",false,crsCapacityCallback,null,"inputdata="+xml);
}

function createCrsCapacityXML()
{
    var root = new inputxml("datainterface");         
    firstlevel = new tagElement("bussiness-params");      
    secondlevel = new tagElement("row-params");
       
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",win.neid);
    secondlevel.appendChild(thirdlevel);
   
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","subrackID");
    thirdlevel.setAttribute("value",unescape(getNeProperty(self).subrackID));
    secondlevel.appendChild(thirdlevel);
       
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
       
    return root.toString();
}

function crsCapacityCallback(doc)
{
    var data = EncapsulateData(doc); //       
    
	if(data.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(data); 
		return;
	}
	
	var crstype = data.getDataRowParam(0, "CRSTYPE");
    var crscap = data.getDataRowParam(0, "CRSCAP");
    table.getAtom("crossType").setValue(crstype);
    table.getAtom("crossCapacity").setValue(crscap);
}

function handelCrs(curtype)
{
    if (curtype == "OSN6800A")
    {
        table.getAtom("crossType").element.disabled = true;
        table.getAtom("crossCapacity").element.disabled = true;
        table.getAtom("crossType").clearOptions();
        table.getAtom("crossCapacity").clearOptions();
        table.getAtom("crossType").addOption("-", -1);
        table.getAtom("crossCapacity").addOption("-", -1);
    }
    else
    {
        table.getAtom("crossType").element.disabled = false;
        table.getAtom("crossCapacity").element.disabled = false;
    }
}
/**
 *           xml  
 */
function createModifyXML()
{
	var subrackID = table.getAttrValue("subrackID"); //           ID
	var subrackType = table.getAttrValue("subrackType");
	var subrackFIC = table.getAttrValue("subrackFIC");
	var subrackName = table.getAttrValue("subrackName");

	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neID");
	param.setAttribute("value", win.neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "subrackID");
	param.setAttribute("value", subrackID);
	row.appendChild(param);


	param = new tagElement("param");
	param.setAttribute("name", "subrackFIC");
	if (subrackFIC == "")
	{
		param.setAttribute("value", "NULL");
	}
	else
	{
		param.setAttribute("value", subrackFIC);
	}
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "subrackName");
	if (subrackName == "")
	{
		param.setAttribute("value", "NULL");
	}
	else
	{
		param.setAttribute("value", subrackName);
	}
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *        
 */
function modifySubrack(btnFlg)
{
	if (btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                         
		return;
	}

	var subrackID = table.getAttrValue("subrackID"); //           ID
	if (subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	$("applyBtn").disabled = true;
	var addXML = createModifyXML(); //         xml

	var subrackName = table.getAttrValue("subrackName")


	if (addXML != null)
	{
		var paramArr = [];
		paramArr[0] = subrackID;
		paramArr[1] = table.getAttrValue("subrackType");
		;
		paramArr[2] = btnFlg;
		paramArr[3] = "FIC:" + table.getAttrValue("subrackFIC");

		if (subrackName.toUpperCase() == "NULL")
		{
			subrackName = "";
		}

		paramArr[4] = " " + subrackID + ": " + subrackName;
		loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="
				+ TECMDCODE_MOD_SUBRACK, "POST", false, modifySubrackCallBack,
				paramArr, "inputdata=" + addXML);
	}
	else
	{
		window.close();
	}

}

/**
 *             
 */
function modifySubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //        
	if (addData.getSErrorCode() != 0) //     
	{
		win.showErrorDialog(addData);
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	var shelfType = unescape(getNeProperty(self).subrackType);
	if (shelfType != 136)//6800A         
	{
	   setCrsCop();
	}
	
	win.setTabTips(paramArr[0], paramArr[3]);//     Tips
	win.setTabHeadName(paramArr[0], paramArr[4])
	win.Tab.selectTab(paramArr[0]);

	if (paramArr[2]) //     
	{
		xcloseDialog(); //      
	}
	else
	{
		$("okBtn").disabled = false;
		var subrackIDAtom = table.getAtom("subrackID").element;
		if (subrackIDAtom.options && subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}
function setCrsCop()
{
    var xml = createSetCrsCopXML();  
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid=2010100&flag=0&timeStamp="+new Date().getTime(),"POST",false,setCrsCopCallback,null,"inputdata="+xml);
}

function setCrsCopCallback(doc)
{
    var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		return;
	}
}

function createSetCrsCopXML()
{
    var subrackID = table.getAttrValue("subrackID");
    
    var crstype = table.getAttrValue("crossType");
	var crscap = table.getAttrValue("crossCapacity");
	
    var root = new inputxml("datainterface");         
    firstlevel = new tagElement("bussiness-params");      
    secondlevel = new tagElement("row-params");
       
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",win.neid);
    secondlevel.appendChild(thirdlevel);
   
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","subrackID");
    thirdlevel.setAttribute("value", subrackID);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","CRSTYPE");
    thirdlevel.setAttribute("value",crstype);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","CRSCAP");
    thirdlevel.setAttribute("value",crscap);
    secondlevel.appendChild(thirdlevel);
       
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
       
    return root.toString();
}

/**
 *               
 */
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //          ID
	openErrPage("../../../../../page/", data.getError(), errArr);
	errArr = null;
}

/**
 *           
 */
function cancelBtnAction()
{
	xcloseDialog();//      
}
function checkInputData(obj, maxlen)
{
	obj.onkeyup = function()
	{
		return calStrSinoLen(this, maxlen);
	}
}
