 loadXMLdoc("../../../../../conf/system.xml","GET",false,EncapsulateSConf);
var language = SYSTEMCONF.getLanguage();
getResourse("../../../../../res/necommres_"+ language +".xml"); //      
getResourse("../res/subrackres_"+ language +".xml"); //      
if(unescape(getNeProperty(self).subrackID)=="1")
{
	document.title = RESOURCE["getmastersubrack"];
}
else
{
	document.title = RESOURCE["getslavesubrack"];
}


var table = new  CTable();
var win = window.dialogArguments;
var NETYPE_8800 = "68";//8800     
var NETYPE_6800A = "71";//6800     

    
function init()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];   
	$("applyBtn").value = RESOURCE["applybutton"];   
	table.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
	
	var atom = new Atom("span");
	atom.setValue(unescape(getNeProperty(self).subrackID));
	table.addAttrRow("subrackID", RESOURCE["subrackID"], atom);
	

	atom = new Atom("span");
	var shelfType = unescape(getNeProperty(self).subrackType);
	var shelfTypeName= "";
	if (shelfType == "2043")
	{
		shelfTypeName = "OSN8800 T32(NA) Standard"
	}
	else if (shelfType == "1975")
	{
	    shelfTypeName = "OSN8800 T64(NA) Standard"
	}
	else if (shelfType == "1985")
	{
		shelfTypeName = "OSN8800 T16(NA)"
	}
	else if (shelfType == "136")
	{
		shelfTypeName = "OSN6800A"
	}
	else if(shelfType == "2044")
	{
		shelfTypeName = "OSN8800 T32(NA) Enhanced";
	}
	else if (shelfType == "101")
	{
	    shelfTypeName = "OSN8800 T64(NA) Enhanced"
	}
	atom.setValue(shelfTypeName);
	table.addAttrRow("subrackType",RESOURCE["subrackType"], atom);
	
    atom = new Atom("text");
	checkInputData(atom.element, 16);

	atom.setValue(unescape(getNeProperty(self).subrackName));
	table.addAttrRow("subrackName",RESOURCE["subrackName"], atom);
	atom.element.style.imeMode = "disabled";
	atom.element.onpaste = function()
	{
		return false;
	}
	atom.element["onkeypress"] = function()
    {
        $("applybtn").disabled = false;
        if (restrictByAllow(this,window.event,"\"`'\\=,:;?&!(){}[]<>/"))
        {
        	return calStrSinoLen(this,16);
        }
        else
        {
        	return false;
        }
    }
	atom = new Atom("text");
	checkInputData(atom.element, 20);
	atom.setValue(unescape(getNeProperty(self).ficInfo));
	table.addAttrRow("subrackFIC",RESOURCE["subrackFIC"], atom);
	atom.element.style.imeMode = "disabled";
	atom.element.onpaste = function()
	{
		return false;
	}
	atom.element["onkeypress"] = function()
    {
        $("applybtn").disabled = false;
        if (restrictByAllow(this,window.event,"\"`'\\=,:;?&!(){}[]<>/"))
        {
        	return calStrSinoLen(this,20);
        }
        else
        {
        	return false;
        }
    }

	atom = new Atom("select");
	table.addAttrRow("crossType",RESOURCE["crossType"], atom);
	atom.addOption("NONE", "NONE");
	atom.addOption("OTN", "OTN");
	
	atom = new Atom("select");
	atom.addOption(RESOURCE["crossCapacity0"], 0);
	atom.addOption(RESOURCE["crossCapacity1"], 360);
	if(compare(win.nePro["neversion"],"5.51.07.10") >= 0 )
	{
	    atom.addOption(RESOURCE["crossCapacity7"], 640);
	}
	atom.addOption(RESOURCE["crossCapacity2"], 720);
	atom.addOption(RESOURCE["crossCapacity3"], 1280);
	atom.addOption(RESOURCE["crossCapacity4"], 2560);
	if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
    {
        atom.addOption(RESOURCE["crossCapacity8"], 3200);
        atom.addOption(RESOURCE["crossCapacity9"], 6400);
    }
	table.addAttrRow("crossCapacity",RESOURCE["crossCapacity"], atom);
	
	document.body.insertBefore(table.getTable(), $("AddTable"));
	handelCrs(shelfType);
	if (shelfType != 136)//6800A         
	{
	    queryCrsCapacity();
	}
	
}

function queryCrsCapacity()
{
	var xml = createCrsCapacityXML();  
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid=2010099&flag=0&timeStamp="+new Date().getTime(),"POST",false,crsCapacityCallback,null,"inputdata="+xml);
}

function createCrsCapacityXML()
{
    var root = new inputxml("datainterface");         
    firstlevel = new tagElement("bussiness-params");      
    secondlevel = new tagElement("row-params");
       
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",win.neid);
    secondlevel.appendChild(thirdlevel);
   
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","subrackID");
    thirdlevel.setAttribute("value",unescape(getNeProperty(self).subrackID));
    secondlevel.appendChild(thirdlevel);
       
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
       
    return root.toString();
}

function crsCapacityCallback(doc)
{
    var data = EncapsulateData(doc); //       
    
	if(data.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(data); 
		return;
	}
	
	var crstype = data.getDataRowParam(0, "CRSTYPE");
    var crscap = data.getDataRowParam(0, "CRSCAP");
    table.getAtom("crossType").setValue(crstype == "FREE" ? "NONE" :crstype);
    table.getAtom("crossCapacity").setValue(crscap == "FREE" ? 0 :crscap);
}

function handelCrs(curtype)
{
	if (curtype == "136")
    {
        table.getAtom("crossType").element.disabled = true;
        table.getAtom("crossCapacity").element.disabled = true;
        table.getAtom("crossType").clearOptions();
        table.getAtom("crossCapacity").clearOptions();
        table.getAtom("crossType").addOption("-", -1);
        table.getAtom("crossCapacity").addOption("-", -1);
    }
    else
    {
        table.getAtom("crossType").element.disabled = false;
        table.getAtom("crossCapacity").element.disabled = false;
        var atom = table.getAtom("crossCapacity");
        if (curtype == 1985) // 8800T16A
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
        }
        else if (curtype == 2043) // 8800T32A
        {
        	atom.clearOptions();
			atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
		    {
				atom.addOption(RESOURCE["crossCapacity4"], 2560);
		    }
        }
        else if(curtype == 2044) // 8800T32AE
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	if(compare(win.nePro["neversion"],"5.51.08.10") >= 0 )
		    {
		    	atom.addOption(RESOURCE["crossCapacity4"], 2560);
		        atom.addOption(RESOURCE["crossCapacity8"], 3200);
		    }
        }
        else if (curtype == 1975) // 8800T64A
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	atom.addOption(RESOURCE["crossCapacity4"], 2560);
        }
        else if (curtype == 101) // 8800T64AE
        {
        	atom.clearOptions();
        	atom.addOption(RESOURCE["crossCapacity0"], 0);
			atom.addOption(RESOURCE["crossCapacity1"], 360);
			atom.addOption(RESOURCE["crossCapacity7"], 640);
			atom.addOption(RESOURCE["crossCapacity2"], 720);
			atom.addOption(RESOURCE["crossCapacity3"], 1280);
        	atom.addOption(RESOURCE["crossCapacity4"], 2560);
		    atom.addOption(RESOURCE["crossCapacity8"], 3200);
        	atom.addOption(RESOURCE["crossCapacity9"], 6400);
        }
    }
}

/**
 *           xml  
 */
function createModifyXML()
{ 
	var subrackID = table.getAttrValue("subrackID"); //          ID
	var subrackType = table.getAttrValue("subrackType");
	var subrackFIC = table.getAttrValue("subrackFIC");
	var subrackName = table.getAttrValue("subrackName");
	
	var root = new inputxml("datainterface"); 
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param"); 
	param.setAttribute("name", "neID");
	param.setAttribute("value",win.neid);
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackID");
	param.setAttribute("value",subrackID);
	row.appendChild(param);
	
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackFIC");
	if(subrackFIC=="")
	{
		param.setAttribute("value","NULL");
	}
	else
	{
		param.setAttribute("value",subrackFIC);
	}
	row.appendChild(param);
	
	param = new tagElement("param"); 
	param.setAttribute("name", "subrackName");
	if(subrackName=="")
	{
		param.setAttribute("value","NULL");
	}
	else
	{
		param.setAttribute("value",subrackName);
	}
	row.appendChild(param);

	bussiness.appendChild(row); 
	root.getRoot().appendChild(bussiness);
	return root.toString();	
}


/**
 *        
 */
function modifySubrack(btnFlg)
{
	if(btnFlg && $("applyBtn").disabled)
	{
		xcloseDialog(); //                        
		return;
	}
		
	var subrackID = table.getAttrValue("subrackID"); //          ID
	if(subrackID == null || subrackID == "")
	{
		alert(RESOURCE["cannotadd"]);
		return;
	}
	$("applyBtn").disabled = true;
	var addXML = createModifyXML(); //        xml
	
	var subrackName = table.getAttrValue("subrackName")

	
	if(addXML!=null)
	{
		var paramArr = [];
		paramArr[0] = subrackID;
		paramArr[1] = table.getAttrValue("subrackType");;
		paramArr[2] = btnFlg;
		paramArr[3] = "FIC:" + table.getAttrValue("subrackFIC");
		
		if (subrackName.toUpperCase() == "NULL")
		{
			subrackName = "";
		}

		paramArr[4] = " "+subrackID+": " + subrackName;
		loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_MOD_SUBRACK, "POST", false,modifySubrackCallBack, paramArr,"inputdata="+addXML);	
	}
	else
	{
		window.close();
	}
	
}


/**
 *             
 */
function modifySubrackCallBack(doc, paramArr)
{
	var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		$("okBtn").disabled = false;
		$("applyBtn").disabled = false;
		return;
	}
	var shelfType = unescape(getNeProperty(self).subrackType);
	if (shelfType != 136)//6800A         
	{
	   setCrsCop();
	}
	win.setTabTips(paramArr[0],paramArr[3]);//    Tips
	win.setTabHeadName(paramArr[0],paramArr[4])
	win.Tab.selectTab(paramArr[0]);
	
	if(paramArr[2]) //    
	{
		xcloseDialog(); //     
	}
	else
	{
		$("okBtn").disabled = false;
		var subrackIDAtom = table.getAtom("subrackID").element;
		if(subrackIDAtom.options&&subrackIDAtom.options.length > 0)
		{
			$("applyBtn").disabled = false;
		}
	}
}
function setCrsCop()
{
    var xml = createSetCrsCopXML();  
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid=2010100&flag=0&timeStamp="+new Date().getTime(),"POST",false,setCrsCopCallback,null,"inputdata="+xml);
}

function setCrsCopCallback(doc)
{
    var addData = EncapsulateData(doc); //       
	if(addData.getSErrorCode() != 0) //    
	{
		win.showErrorDialog(addData); 
		return;
	}
}

function createSetCrsCopXML()
{
    var subrackID = table.getAttrValue("subrackID");
    
    var crstype = table.getAttrValue("crossType");
	var crscap = table.getAttrValue("crossCapacity");
	
    var root = new inputxml("datainterface");         
    firstlevel = new tagElement("bussiness-params");      
    secondlevel = new tagElement("row-params");
       
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",win.neid);
    secondlevel.appendChild(thirdlevel);
   
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","subrackID");
    thirdlevel.setAttribute("value", subrackID);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","CRSTYPE");
    thirdlevel.setAttribute("value",crstype);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","CRSCAP");
    thirdlevel.setAttribute("value",crscap);
    secondlevel.appendChild(thirdlevel);
       
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
       
    return root.toString();
}

/**
*               
*/
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "subrackID"; //         ID
	openErrPage("../../../../../page/", data.getError(), errArr);
	errArr = null;
}

/**
*           
*/
function cancelBtnAction()
{
	xcloseDialog();//     
}
function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
}
