 
/*
                
*/

loadXMLdoc("../../../../../conf/system.xml","GET",false,EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../res/boardview_" + language +".xml");
colon = ": ";
if ("zh" == language)
{
	colon = " ";
}

var eid;
var BLANK_AREAR = 1;
var SLOT_AREAR = 2;
var BOARD_AREAR = 3;

function hfInitDiv()
{
	$("bpgimg").alt = RESOURCE["bpgimg"] ;
	$("showmap").alt = RESOURCE["showmap"];	
	$("refreshView").alt = RESOURCE["refreshView"];	
}	

/**
 *           
 * @param evt:  
 * @return  
 */
function hfItemContextMenuHandler(evt)
{
	hfClearSelState();
	var eid = hfGetEIDFromEvent(evt);
	if (!eid)
	{
		return;
	}
	
  if(eid.cid == SLOT_AREAR){
 	    var boardid = 'o.3.'+eid.id;
 	    var elem = document.getElementById(boardid); 
   	   if(elem){
   	   	return true;
   	   }
  }
	
	hfSetSelState(eid);
	hfSetSelectedItem(eid.asOID());
	hfGetPopupMenu(eid);
	rightClickHandler(evt);
    return false;
}

/*
Event handler that handles left click event.
*/
function leftClickHandler(e) { // Private method

  if (getX(e) > getClientWidth() || getY(e) > getClientHeight()) {
    return;
  }
  if (!e) {
    var e = window.event;
  }
  if (e.button && e.button == 2) {
    return;
  }
  hideVisibleMenus();
  hideMenu(e);
  
	var eid = hfGetEIDFromEvent(hfWrapEvent(event, this));
	if (!eid)
	{
		return false;
	}
	
  if(eid.cid == BOARD_AREAR)
  {
	  var slotid = eid.id;
	
    var bdEle = window.top.frames["objecttree"].tree[slotid];
    if(null == bdEle)
    {
    	return;
    }

    
    bdEle.isSelect();
    
	window.top.frames["functiontree"].refreshLastFuncID();
	
    
    bdEle.onClick();  	
 	}	
}

/**
 *         
 * @param eid   ID
 * @return String:   XML  
 */
function hfGetPopupMenu(eid)
{
	  var menuObj = null;
    for(var i = 1;i<= menuCount;i++)
    {
    	menuObj = $("DOMenu"+i);
    	menuObj.parentNode.removeChild(menuObj);
    }
    menuCount = 0;
		if (eid.cid == BLANK_AREAR)
		{
					
			createjsDOMenu();
		}
    else if (eid.cid == SLOT_AREAR) //slot
    {
    	var url = "../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_SUPPORTED_CIRCUITPACK;
    	loadXMLdoc(url, "POST", false, getSlotCardCallback, eid, "inputdata="+createGetBoardXML(eid.id));
    }
    else if (eid.cid == BOARD_AREAR) //board
    {
		  if(eid.bstate == "2")//      60020637
    	{
    		var url = "../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_SUPPORTED_CIRCUITPACK;
    		loadXMLdoc(url, "POST", false, getSlotCardCallback, eid, "inputdata="+createGetBoardXML(eid.id));
    	}
    	else
    	{
			var url = "../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_CPINFO;
			loadXMLdoc(url,"POST",false,initMenu, eid,"inputdata="+createGetMenuXML(eid.id));
      }
    }
}

/**
 *              XML  
 * @param slotid   ID
 * @return String:   XML  
 */
function createGetMenuXML (slotid)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row =  new tagElement("row-params");
    var param = new tagElement("param");
    var neid =  getNeProperty(top).neid;
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *      
 * @param doc         evt:  
 * @return  
 */
function initMenu (doc,eid)
{
	var data = EncapsulateData(doc);

       var topmenuList = getChildMenuItemList(data,"");
       if(0 != data.getSErrorCode() || 0 == topmenuList.length)
       {
       	  isRefreshBoard = true;
          hfClearSelState();
          return;
       }

    var menuLen = 150;
    if(SYSTEMCONF.getLanguage() == "en")
    {
    	menuLen = 170;
    }
    var topmenu = new jsDOMenu(menuLen);
    var num = 0;
    var flag = false;//     state    
    for(var i = 0, len = topmenuList.length; i < len; i++)
    {
    	var id = topmenuList[i]["id"].value;
    	var name = topmenuList[i]["name"].value;
    	var funcid = topmenuList[i]["funcid"].value;
    	var action = topmenuList[i]["action"].value;
    	var parent = topmenuList[i]["parent"].value;
    	var paramArr = [eid,funcid];
    	with(topmenu)
    	{
    		if("" == id)
    		{
    			addMenuItem(new menuItem(name));
    		}
    		else if (id=="202")
    		{
    			addMenuItem(new menuItem("State"));
				num = i;
				flag = true;
    		}
    		else
    		{
		    	addMenuItem(new menuItem(name,id,eval(action),paramArr));
    	        handleSubMenu(data,topmenu, id,eid,topmenu.items.length-1);
    		}
    	}    	
    }
    if(flag)
    {
    	addState(topmenu,num,eid);
    }
   setPopUpMenu(topmenu);
   return topmenu;
}

function addState(topmenu,num,eid)
{
	var subMenu=new jsDOMenu(100)
    subMenu.addMenuItem(new menuItem("IS","",setState,["IS",eid]));
	subMenu.addMenuItem(new menuItem("OOS","",setState,["OOS",eid]));
	subMenu.addMenuItem(new menuItem("AINS","",setState,["AINS",eid]));
	topmenu.items[num].setSubMenu(subMenu);
	
}
function setState(params)
{
	var state = params[0];
	var eid = params[1];
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    var slotid = eid.id;
    param.setAttribute("value", slotid);
    row.appendChild(param);
    var subrackid = parseURLStr(window).subtrackid;//  ID
    var AID = "";
    if(subrackid==null)
    {
    	AID="SLOT-"+slotid;	
    }
    else
    {
    	AID = "SLOT-"+subrackid+"-"+getSlotID(slotid);
    }
    param = new tagElement("param");
    param.setAttribute("name","AID");
    param.setAttribute("value",AID);
    row.appendChild(param);
    
    param = new tagElement("param");
    if(state=="IS"||state=="OOS")
    {
    	param.setAttribute("name", "PST");
    	param.setAttribute("value", state);
    }
    else if(state == "AINS")
    {
    	param.setAttribute("name", "SST");
    	param.setAttribute("value", state);
    }
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "mod2");
    var slotid = eid.id;
    param.setAttribute("value", "SFP");
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_CIRCUITPACK, "POST", false, boardStateCallback, eid, "inputdata="+di.toString());
}

function boardStateCallback(doc)
{
	var result = EncapsulateData(doc);
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
 		var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
        openErrPage("../../../../../page/",result.getError(),oArray);
        return;
    }
}
/**
 * 
 *      ID        
 * @param data         parentid:   ID
 * @return Array:     
 */
function getChildMenuItemList(data,parentid)
{
	var childMenuItemList = [];
	var parent = null;
	var count = 0;
    for(var i = 0, len = data.getDataRowLength(); i < len; i++)
    {
    	parent = data.getDataRowParam(i,"parent");
    	if(parent == parentid)
    	{
    		childMenuItemList[count] = data.rows[i];
    		count ++;
    	}
    }
    return childMenuItemList;
}

/**
 *      
 * @param data         parentmenu       parentMenuid:   ID
 * @return  
 */
function handleSubMenu(data ,parentmenu, parentMenuid,eid,menuItemIndex)
{
	var subMenuList = getChildMenuItemList(data,parentMenuid);
    if(0 == subMenuList.length)
    {
        return
    }
    var subMenu = new jsDOMenu();


    for(var i = 0, len = subMenuList.length; i < len; i++)
    {
    	var id = subMenuList[i]["id"].value; //  ID
    	var name = subMenuList[i]["name"].value; //    
    	var funcid = subMenuList[i]["funcid"].value; //     ID
    	var action = subMenuList[i]["action"].value; //   action
    	var parent = subMenuList[i]["parent"].value; //    ID
    	var paramArr = [eid,funcid];
    	with(subMenu)
    	{
    		if("" == id)
    		{
    			addMenuItem(new menuItem(name));
    		}
    		else
    		{
	    		addMenuItem(new menuItem(name,id,eval(action),paramArr));
    			handleSubMenu(data,subMenu, id,subMenu.items.length-1);
    		}
    	}    	
    }
    parentmenu.items[menuItemIndex].setSubMenu(subMenu);
}

/**
 *                
 * @param paramArr          ID   ID
 * @return  
 */
function goNEFuncBrowse(paramArr)
{
    hfClearSelState();
    
	eid = paramArr[0];
    var funcid = paramArr[1];
    
	
    var bdEle = window.top.frames["objecttree"].tree[getNeProperty(top).realNEID];
    if(null == bdEle)
    {
    	return;
    }

    
    bdEle.isSelect();
    
    
    bdEle.onClick();


    var fun = window.top.frames["functiontree"].tree[funcid];
    if(null == fun)
    {
    	return;
    }

    
    fun.expand();
    
    
    fun.isSelect();
    
    
    fun.onClick();
    if(3084==funcid)
    {
        goAlarm();
    }
    else
    {
        fun = null;
        bdEle = null; 
    }
    
       
}

function goAlarm()
{
    top.globalparam = 1;
    if(top.frames["data"].frames["tab_body_3084"].slotId)
	{
	   var curAlarmWin = top.frames["data"].frames["tab_body_3084"];
	   
       curAlarmWin.slotId = eid.id;
       
       curAlarmWin.refreshAlarmlist();
       
       fun = null;
       bdEle = null;
       top.globalparam = 0;
    }
	else
	{
	   window.setTimeout(goAlarm,100);	   
    }
    
}
/**
 *                
 * @param paramArr          ID   ID
 * @return  
 */
function goBoardFuncBrowse(paramArr)
{
    hfClearSelState();
    
	var eid = paramArr[0];
    var funcid = paramArr[1];
    
	var slotid = eid.id;
	
    var bdEle = window.top.frames["objecttree"].tree[slotid];
    if(null == bdEle)
    {
    	return;
    }

    
    bdEle.isSelect();
    
    
    bdEle.onClick();


    var fun = window.top.frames["functiontree"].tree[funcid];
    if(null == fun)
    {
    	return;
    }

    
    fun.expand();
    
    
    fun.isSelect();
    
    
    fun.onClick();
    fun = null;
    bdEle = null;    
}

/**
 *              XML  
 * @param slotid   ID
 * @return String:   XML  
 */
function createGetBoardXML(slotid)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slotid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "shelfType");
    var shelf =document.getElementById("o.1.1").getAttribute("shelfType");
    param.setAttribute("value", shelf);
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *                 
 * @param doc         eid:  ID
 * @return  
 */
function getSlotCardCallback(doc,eid)
{
    var result = EncapsulateData(doc);
    if(0 != result.getError().getGlobleECode())
    {
    	return;
    }

    var topmenu=getSlotPopupMenu(result,eid);
    
    setPopUpMenu(topmenu);
}
/*
         
@param doc     
*/
function getSlotPopupMenu(result,eid){
	  var topmenu = new jsDOMenu(150);
	  topmenu.setMenuType(eid.cid);
	  
	  if(result.getDataRowLength() > 10)
	  {
	  	topmenu.setMenuType(slotMenuType);
	  }
	  
	  
    with(topmenu)
    {
    	if(eid.bstate == "2")
	    {
		  	var bdname = eid.bname;
		    var boardType = eid.btype;
		    var slotList = eid.bslotlist;
		    var paramArr = [eid.id,boardType,bdname,slotList,"16"];
		    addMenuItem(new menuItem(RESOURCE['addPhyBoard'],boardType,addCard,paramArr));		 
	    }
	    
	    for(var rowidx = 0; rowidx < result.getDataRowLength(); rowidx++)
	    {
	        var bdname = result.getDataRowParam(rowidx, 'boardName');
	        var boardType = result.getDataRowParam(rowidx, 'boardType');
	        var slotList = result.getDataRowParam(rowidx, 'slotList');
	        var paramArr = [eid.id,boardType,bdname,slotList,"16"];
 	      addMenuItem(new menuItem(RESOURCE['add']+' '+bdname,boardType,addCard,paramArr));	
	    }
    }
   return topmenu;
}


/**
 *     
 * @param args     
 * @return  
 */
function addCard(args)
{
		var subrackid = parseURLStr(window).subtrackid;//  ID
		disableRefreshBoard=true;
		var slot = args[0]; //  ID
		var bdid = args[1]; //  ID
		var boardname = args[2]; //    
		var slotList = args[3]; //       
		var state = args[4]; //  
	  if(slot == '6' && ($('o.3.7') || $('o.3.8')))
	  { 
	      if($('o.3.7') == null && $('o.3.8')!= null && bdid == '60039')
	      {
	          alert(RESOURCE['isusing']);
	          return;
	      }
	      
	      if($('o.3.7') != null)
	      {
	          if($('o.3.7').innerText == '21APIU' && $('o.3.7').className != "Cardphy SelStateOff" && bdid == '1308' || ($('o.3.7').innerText == '61PIU' && $('o.3.7').className != "Cardphy SelStateOff") && bdid == '60039')
	          {
	              alert(RESOURCE['isusing']);
	              return;
	          }
	      }
	    
	  } else if(slot == '7' && ($('o.3.6') || $('o.3.8'))){
	      if($('o.3.6') == null && $('o.3.8') != null && bdid == '60039')
	      {
	          alert(RESOURCE['isusing']);
	          return;
	      }
	  
	      if($('o.3.6') != null)
	      {
	          if( $('o.3.6').innerText == '21APIU' && $('o.3.6').className != "Cardphy SelStateOff" && bdid == '1308' || ($('o.3.6').innerText == '61PIU' && $('o.3.6').className != "Cardphy SelStateOff" || $('o.3.8') != null) && bdid == '60039')
	          {
	              alert(RESOURCE['isusing']);
	              return;
	          }
	      }
	  }
    if(1 == SYSTEMCONF.getDemo())
    {
        paintCard(slot,bdid,boardname);
        return false;
    }

    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slot);
    row.appendChild(param);
    var AID = "";
    if(subrackid==null)
    {
    	AID="SLOT-"+slot;	
    }
    else
    {
    	AID = "SLOT-"+subrackid+"-"+getSlotID(slot);
    }
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "TYPE");
    param.setAttribute("value", boardname);
    row.appendChild(param);
	
	param = new tagElement("param");
    param.setAttribute("name", "BDTYPE");
    param.setAttribute("value", bdid);
    row.appendChild(param);
	
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	
    if (!isAdding)
    {
    	isAdding = true;
    	loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_CREATE_CIRCUITPACK, "POST", false, addCardCallback, args, "inputdata="+di.toString());
    }
    else
    {
    	alert(RESOURCE["isadding"]);
    }
}

/**
 *          
 * @param doc        args     
 * @return  
 */
function addCardCallback(doc, args)
{
	  
	  disableRefreshBoard=false;
    var result = EncapsulateData(doc);
    if(0 == result.getError().getGlobleECode())
    {
    	
		    if( "2" == args[4])
		    {
				    $('o.3.'+args[0]).className = 'Cardphylog SelStateOff';
				    $('o.3.'+args[0]).firstChild.childNodes[0].style.visibility ="visible"
				    $('o.3.'+args[0]).bstate = "3" ;
		    }
		    else
		   	{
		        if (null == args[3]) //slotList
		        {
 		            paintCard(args[0],args[1],args[2]);
		        }
		        else
		        {
	        				        			  
		        	 var winid=Math.floor((args[0]-0)/65536);
	                 var win =window.parent.frames[window.parent.Tab.getSelectedTabIndex()];
		        		var slotArray = args[3].split(",");
		        		for (var k=0; k<slotArray.length; k++)
		        		{
		        			
		        				var tmpCard = win.document.getElementById("o.3."+slotArray[k]);
		        				if (tmpCard != null)
		        				{
		        						tmpCard.parentNode.removeChild(tmpCard);
		        				}
		        		}
		        	
		            paintCard(args[0],args[1],args[2],args[3],"undefined",args[4]);
		        }
		    }
        top.frames["objecttree"].opentree_servlet(); 
    }
    else
    {
        var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
        openErrPage("../../../../../page/",result.getError(),oArray);
    }
    
    isAdding = false;
}

/**
 *     
 * @param args:    
 * @return  
 */
function delCard(args)
{
	 disableRefreshBoard=true;
	 
	  var eid = args[0];

    if(1 == SYSTEMCONF.getDemo())
    {
        var card = document.getElementById(eid.toString());
        card.parentNode.removeChild(card);
        return false;
    }
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    var slotid = eid.id;
    param.setAttribute("value", slotid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "INCL");
    param.setAttribute("value","Y");
    row.appendChild(param);
    var subrackid = parseURLStr(window).subtrackid;//  ID
    var AID = "";
    if(subrackid==null)
    {
    	AID="SLOT-"+slotid;	
    }
    else
    {
    	AID = "SLOT-"+subrackid+"-"+getSlotID(slotid);
    }
    param = new tagElement("param");
    param.setAttribute("name","AID");
    param.setAttribute("value",AID);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_DEL_CIRCUITPACK, "POST", false, delCardCallback, eid, "inputdata="+di.toString());
}

/**
 *          
 * @param doc        eid   ID
 * @return  
 */
function delCardCallback(doc, eid)
{
	
	 disableRefreshBoard=false;
    var result = EncapsulateData(doc);
    if(0 == result.getError().getGlobleECode())
    {
        var card = document.getElementById(eid.toString());
        var boardName=card.boardName;
        card.parentNode.removeChild(card);
        var soltid=eid.id;
       	var rootNode=top.frames["objecttree"].rootNode;
        if(rootNode&&(soltid==top.frames["objecttree"].tree.selectID)){
        	 rootNode.isSelect();
           rootNode.expand();
           rootNode.onClick();
        }
        adjustBoardviewLayout("delCard",eid.bname);
        top.frames["objecttree"].opentree_servlet(); 
    }
    else //           
    {

        var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
        openErrPage("../../../../../page/",result.getError(),oArray);
    }
}



/*
 *      
*/
function boardHardReset(args){
	if(confirm(RESOURCE["resetinfo"]))
	{
		var eid = args[0];
		eid.mode="COLD";
		boardReset(eid); 	
	}
}

function boardSoftReset(args){
	var eid = args[0];
  eid.mode="WARM";
  boardReset(eid); 	
}
/*
    
*/
function sccBoardSoftReset(args)
{
	if(confirm(RESOURCE["resetsccalarm"]))
	{
	  var eid = args[0];
      eid.mode="COLD";
      boardReset(eid); 	
   }
}

function boardReset(eid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", eid.id);
    row.appendChild(param);
    var subrackid = parseURLStr(window).subtrackid;//  ID
    var AID = "";
    if(subrackid==null)
    {
    	AID="SLOT-"+eid.id;	
    }
    else
    {
    	if(eid.scc==null)
    	{
    		AID = "SLOT-"+subrackid+"-"+getSlotID(eid.id);
    	}
    	else
    	{
    		AID = "SLOT-"+subrackid+"-"+getSlotID(eid.scc);
    	}
    	
    }
    param = new tagElement("param");
    param.setAttribute("name", "AID");
    param.setAttribute("value", AID);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "TYPE");
    param.setAttribute("value", eid.mode);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);    
	  loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_RESETBOARDSOFT, "POST", true, boardResetCallback, "", "inputdata="+di.toString());
}
/*
 *          
*/
function boardResetCallback(doc){
	
	  var result = EncapsulateData(doc);
    if(0 == result.getError().getGlobleECode())
    {
    	var error = new AllError();
		  var eTag = new ErrorTag();
		  eTag.code = "succ";
		  eTag.info = RESOURCE["optSucc"];
		  error.s_error = eTag;
		  openErrPage("../../../../../page/", error, "");
    }
    else
    {
        if(41020008==result.getError().getGlobleECode())
        {
            return;
        }
        var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "boardname";
        openErrPage("../../../../../page/",result.getError(),oArray);
    }
	 
}

/*
       
*/
function boardVersion(args)
{
    var eid = args[0];
    var xml = createBoardVersionXml(eid,1);
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_QUERY_BD_VER, "POST", true, boardVersionCallback, "", "inputdata="+xml);
}

/*
        
*/
function sccBoardVersion(args)
{
    var eid = args[0];	
     var xml = createBoardVersionXml(eid,1);
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_SCCVER, "POST", true, boardVersionCallback, "", "inputdata="+xml);
}
	
function createBoardVersionXml(eid,verid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    if(verid==1)
    {
	    param = new tagElement("param");
	    param.setAttribute("name", "slotID");
	    param.setAttribute("value", eid.id);
	    row.appendChild(param);
	    var subrackid = parseURLStr(window).subtrackid;//  ID
	    var AID = "";
	    if(subrackid==null)
	    {
	    	AID="SLOT-"+eid.id;	
	    }
	    else
	    {
	    	AID = "SLOT-"+subrackid+"-"+getSlotID(eid.id);
	    }
	    param = new tagElement("param");
	    param.setAttribute("name","AID");
	    param.setAttribute("value",AID);
	    row.appendChild(param);
    }
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
	}
	
function boardVersionCallback(doc)
{
	var result = EncapsulateData(doc);
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
 		var oArray = new Array();
        oArray[0]= "nename";
        oArray[1]= "slotID";
        oArray[2]= "boardname";
        openErrPage("../../../../../page/",result.getError(),oArray);
        return;
    }
    verString = RESOURCE["boardversion"] + colon + result.getDataRowParam(0, "SWVER");
    alert (verString);
	}

function SccBoardVersionCallback(doc)
{
	var result = EncapsulateData(doc);
	var verSignal = "";
	var verString = "";
    if(0 != result.getError().getGlobleECode())
    {
 				var oArray = new Array();
        oArray[0]= "nename";
        openErrPage("../../../../../page/",result.getError(),oArray);
        return;
    }
    for(i=0 , resultlen = result.getDataRowLength() ; i < resultlen ; i++)
    {
        verSignal = result.getDataRowParam(i, "verSignal");
        if( verSignal=="NSF1" || verSignal=="NSF2")
        {
        	if("active" == result.getDataRowParam(i, "activeSignal"))//          
          { 
           verString = RESOURCE["sccversion"] + colon + result.getDataRowParam(i, "versionStr");
           break;
          }
        }
    }
	}
	
	
/*
     
*/
function goPathChannel(args){
	  
	  var eid = args[0];
	  if(eid)
	  {
	    var pos = eid.toString().lastIndexOf(".");
	    var slotID = eid.toString().substring(pos+1); 	
	    var neProperty = getNeProperty(top);
	    var neid = neProperty.neid;
	    var neVersion = neProperty.neversion;
	    var rVer = parseInt(neVersion.split(".")[2]);
  
	    var pageurl =  "../../../../tl1ngwdm/page/channelpathgraph.html?"+"neid="+neid+"&slotID="+slotID;   
	    var sFeatures = "top=100,left=100,height=400,width=600,status=yes,toolbar=no,menubar=no,location=no";
        var newWin = window.open(pageurl,"channelpath", sFeatures);
        newWin.focus();
	  	
	  }
	 
}

/* 
       
 o.1.* represent NE
 o.2.* represent slot
 o.3.* represent board/card
 
*/

	var neSlots=new Array(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,28,29,30,31);
	

/*
      
*/
function initBoardView()
{
   if(0 == SYSTEMCONF.getDemo()){ 
   	qLogicboard()
    window.setInterval("qLogicboard()",6000);
   }
}

    
/*
     ,  6800      boardview0.html        
                 
*/
function qLogicboard(isManual)//      
{
	  /*
	  loadXMLdoc("../../../../../demo/boardview.xml", "GET", false, refreshBoardCallBack);
	  return;
	  */
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    
    param = new tagElement("param");
	param.setAttribute("name", "manual");
	if(isManual)
	{
	    param.setAttribute("value", "true");
	   
	}
	else
	{
		param.setAttribute("value", "false");
	}
	row.appendChild(param);
	
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_QUERY_LOGIC_CIRCUITPACK, "POST", true, refreshBoardCallBack, new Date(), "inputdata="+di.toString());
}

var bfirstenter=true;
/*
           
*/
function refreshBoardCallBack(doc)
{  
	  if(popUpMenuObj && "hidden" != popUpMenuObj.menuObj.style.visibility && !isRefreshBoard)
    {
    	  isRefreshBoard = false;
	 	    return;
	 	}
	  
    if(disableRefreshBoard)
    {
  	    return;	
	  }
	
	  var data = EncapsulateData(doc);
	  
    if(data.getSErrorCode()!=0)
    {
        return;
    }
    
    
    qLogicboardCallback(data);
     
    
    /*
	  var boardupdateflag=data.getDataRowParam(0, "boardupgateflag");
	  if (!bfirstenter && (boardupdateflag =="false"))
	  {
	    return;	
	  }
    */
	  
	  if(top.frames["objecttree"]&&top.frames["objecttree"].handlerTreeDate)
    {
        top.frames["objecttree"].window.handlerTreeDate(data);
    }
}

/*
    ,         
*/
function qLogicboardCallback(result)
{
	 
    if(0 == result.getError().getGlobleECode())
    {

          for(var j=0; j < result.getDataRowLength(); j++)
    	  {

    	     var label = result.getDataRowParam(j, 'boardName');
    	     if(label == '21APIU' && !hasBoard(result,'61PIU') && isNullInSlot(result, '8')){
    	       	adjustBoardviewLayout('query',label);
    	       	break;
    	     }
    	     
    	     if(label == '21APIU' && !hasBoard(result,'61PIU') && !isNullInSlot(result, '8')){
    	       	adjustBoardviewLayout('query','6_8');
    	       	break;
    	     }
    	    
    	     if((label == '61PIU' || !isNullInSlot(result, '8'))&& !hasBoard(result,'21APIU')){
    	       	adjustBoardviewLayout('query','61PIU');
    	       	break;
    	     }
    	  }
        var boardSlot = neSlots.slice(0);
        
        for (var rowidx = 1; rowidx < result.getDataRowLength(); rowidx++)
        {        	 
        	  var slot = result.getDataRowParam(rowidx, 'slotID');   //   
            var bdid = result.getDataRowParam(rowidx, 'boardType');
            var label = result.getDataRowParam(rowidx, 'boardName');
            var bstate = result.getDataRowParam(rowidx, 'boardState');//60020637   
            var color = result.getDataRowParam(rowidx, 'boardColor');
            var bloop = result.getDataRowParam(rowidx, 'boardLoop');//60020637     
            var bpg = result.getDataRowParam(rowidx, 'boardPG');//60020637     
            var slotList = result.getDataRowParam(rowidx, 'slotList');  //    
				var topalmlevel = result.getDataRowParam(rowidx, 'topAlmLevel');
          if(slot == '6' || slot == '7')
            {
                if($('o.3.'+slot) != null)
                {
                    $('o.3.'+slot).parentNode.removeChild($('o.3.'+slot));
                }
                
            }
            
		        var slotDiv = document.getElementById('o.3.'+slot)  	
         
	        if(null == slotDiv)
	        {
		           paintCard(slot,bdid,label,slotList,bstate,color,bloop,bpg);//60020637         
            }
            else
            {
                   repaintCardLabel(slot,bdid,label,slotList,bstate,color,bloop,bpg);//     
            }
           
           if(bstate != "2")
           {
					setBoardLED(slot, topalmlevel);
           }               
		       rmFromArray(slot,boardSlot);
				         
        }
        
        for (var k=0; k < boardSlot.length; k++)
        {
        	  var card = document.getElementById("o.3."+boardSlot[k]);
            if (null != card)
            {
                card.parentNode.removeChild(card);
            }
        }
    }

}

function hasBoard(result, board)
{
        var slot;
        var label;
        var bstate;
        for (var rowidx = 1; rowidx < result.getDataRowLength(); rowidx++)
        {        	 
            slot = result.getDataRowParam(rowidx, 'slotID');   //   
            label = result.getDataRowParam(rowidx, 'boardName');
            bstate = result.getDataRowParam(rowidx, 'boardState');//60020637   
            
            if((slot == '6' || slot == '7') && label == board && (bstate == '1' || bstate == '3'))
            {
                return true;
            }
        }
     
	return false;
}  

function isNullInSlot(result, slotid)
{
      var slot;
      var label;
      var bstate;
      for (var rowidx = 1; rowidx < result.getDataRowLength(); rowidx++)
      {        	 
          slot = result.getDataRowParam(rowidx, 'slotID');   //   
          bstate = result.getDataRowParam(rowidx, 'boardState');//60020637   
          
          if(slot == slotid && (bstate =='1' ||bstate == '3'))
          {
              return false;
          }
      }
     
      return true;
}

function repaintCardLabel(slot,bdid,label,slotList,bstate,color,bloop,bpg)
{
  	var board = document.getElementById("o.3."+slot);
  	board.bstate = bstate;
	 var childDiv = board.firstChild.childNodes;//   Div
	 var childDivlength = childDiv.length ;
	 var labelDiv ;
   if (!board)
   {
     return false; 
   }
   if(bdid != board.bdid)//                    
   { 
   	if(slotList != board.slotlist)//        ,     
   	{
   	 	var  slotDiv = calcBoardPostion(slotList);
      board.style.top = (parseInt(slotDiv.top)+1)+'px';
      if(slotDiv.left) board.style.left = (parseInt(slotDiv.left)+1)+'px';
      if(slotDiv.right) board.style.right = (parseInt(slotDiv.right)+1)+'px';
      board.style.width = (parseInt(slotDiv.width)-4)+'px';
      board.style.height = (parseInt(slotDiv.height)-4)+'px'; 
      board.firstChild.style.width = (parseInt(board.style.width)-4)+'px';
      board.firstChild.style.height = (parseInt(board.style.height)-4)+'px';
      var lposition = parseInt(board.style.width)-4 ;	 	
      board.slotlist = slotList ;
   	}  
    if( label != board.blabel) //        
    {
        for(var i = 0 ; i < childDivlength ;i++)
        {
        	if('Label' == childDiv[i].className)
        	{
        	  	labelDiv = childDiv[i];//  Label Div
        	  	break;
        	}
        }  
        if(labelDiv)     
        {
           var boardwidth  = parseInt(board.firstChild.style.width);
           var boardheight = parseInt(board.firstChild.style.height);
       
           if (boardwidth < boardheight)
           {
           	  var str = "";
           	  for (var i=0; i<label.length-1; i++)
           	  {
           	  	str = str+label.charAt(i)+'<br/>';
           	  }
           	  labelDiv.innerHTML = str+label.charAt(label.length-1);
           }
           else
           {
           	  labelDiv.innerHTML = label;
           }
           if(lposition)
           {
           	 labelDiv.style.right = (lposition-15)/2+"px";
           }
        }
        board.blabel = label;  
        labelDiv = null; 
    }
    board.bdid = bdid ;
   }
if( color == "7")
      {
          board.className = 'unknownColor SelStateOff';
      }
      else if(color == "22")
      	{
      		board.className = 'noProvisionedAndRemovedColor SelStateOff';
      	}
      else if(color == "21")
      	{
      		board.className = 'noProvisionedColor SelStateOff';
      	}
      else if(color == "19")
      	{
      		board.className = 'enabledAndRemovedColor SelStateOff';
      	}
      else if(color == "16")
      	{
      		board.className = 'enabledColor SelStateOff';
      	}
      else if(color == "18")
      	{
      		board.className = 'autoInServiceColor SelStateOff';
      	}
      else if(color == "17")
      	{
      		board.className = 'disabledColor SelStateOff';
      	}
      else if(color == "20")
      	{
      		board.className = 'enableAndFailedColor SelStateOff';
      	}
      else if(color == "24")
      	{
      		board.className = 'maintenanceColor SelStateOff';
      	}
      else
      	{
      		board.className = 'unknownColor SelStateOff';
      	} 
      {
      var labelDiv ;
        for(var i = 0 ; i < childDivlength ;i++)
        {
        	if('alarmlight' == childDiv[i].id)
        	{
        	  	labelDiv = childDiv[i];//      DIV
        	  	break;
        	}
        }  
      	if(board.bstate == "2")//            DIV    
      	{     		
      	  labelDiv.style.visibility = "Hidden" ;	
      	} 
      	else
      	{
      		labelDiv.style.visibility = "visible" ;		
      	} 
     labelDiv = null;
 }
   if(bloop != board.bloop)//         60020637
   {
    for(var i = 0 ; i < childDivlength ;i++)
    {
    	if('Loop' == childDiv[i].className)
    	{
    	  	labelDiv = childDiv[i];
    	  	break;
    	}
    }  
    if(labelDiv)//        
    {
     if(bloop == "1")	
     {
     	 labelDiv.style.visibility = "visible";    
     }
     else
     {
     	 labelDiv.style.visibility = "hidden";
     }
    }
    else if(bloop == "1")//bloop               Div 
    {
       var div5 = board.firstChild.appendChild(document.createElement('div'));
       div5.style.position = 'absolute';
       div5.className = 'Loop';	
       div5.style.left= '-2px';                     
       div5.style.bottom = '-7px';                     
       div5.style.width = '10px';                     
       div5.style.height = '10px';    	 
    }  
    board.bloop = bloop;
    labelDiv = null;
   }   

    if(bpg != board.bpg)//        60020637
   {
    for(var i = 0 ; i < childDivlength ;i++)
    {
    	if('bpg' == childDiv[i].className)
    	{
    	  	labelDiv = childDiv[i];
    	  	break;
    	}
    }  
    if(labelDiv)//        
    {
     if(bpg == "1")	
     {
     	 labelDiv.style.visibility ="visible";    
     }
     else
     {
     	 labelDiv.style.visibility = "hidden";
     }
    }
    else if(bpg == "1")
    {
    	 var div6 = board.firstChild.appendChild(document.createElement('div'));
    	 div6.style.position = 'absolute';
       div6.className = 'bpg';
       div6.style.right= '-5px';
       div6.style.bottom = '-5px';
       div6.style.width = '10px';
       div6.style.height = '10px';   	 
    }  
    board.bpg = bpg;
    labelDiv = null ;
   }   
   
      
}


/*
tab       
*/

function tabSelectHandler()
{
	  var selecttabIndex=window.parent.Tab.getSelectedTabIndex();
	  var selecttabid = window.parent.Tab.selectTabid;
	  var result=window.parent.result;
	  if(!result) return;
	  
	  if(0 == result.getError().getGlobleECode())
    {
        var boardSlot = neSlots.slice(0); //copy neSlots array
        
        var winid;
        
        var win =null;
        
        var removeSelectedBoardview = true;
        
        for (var rowidx = 1; rowidx < result.getDataRowLength(); rowidx++)
        {
            var slot = result.getDataRowParam(rowidx, 'slotID');   //   
            var bdid = result.getDataRowParam(rowidx, 'boardType');
            var label = result.getDataRowParam(rowidx, 'boardName');
            var bstate = result.getDataRowParam(rowidx, 'boardState');
            var color = result.getDataRowParam(rowidx, 'boardColor');
            var bloop = result.getDataRowParam(rowidx, 'boardLoop');//60020637     
            var bpg = result.getDataRowParam(rowidx, 'boardPG');//60020637     
            var slotList = result.getDataRowParam(rowidx, 'slotList');  //    
			var topalmlevel = result.getDataRowParam(rowidx, 'topAlmLevel');

            winid = Math.floor((slot-0)/100);
            
            if( selecttabid ==winid) 
            {
            	  removeSelectedBoardview = false;
		            win =window.parent.frames[selecttabIndex];
		            
		            var slotDiv = document.getElementById('o.3.'+slot)  	            
	            if(null == slotDiv)
	            {
	               win.paintCard(slot,bdid,label,slotList,bstate,color,bloop,bpg);//60020637         
                }
                else
                {
                   win.repaintCardLabel(slot,bdid,label,slotList,bstate,color,bloop,bpg);//     
                }
               
                if(bstate != "2")
                {
					setBoardLED(slot, topalmlevel);
                }               
				       
				        win.rmFromArray(slot,boardSlot);
            }
        }
        
				for (var j=0; j < boardSlot.length && win; j++)
        {
         		 var card = win.document.getElementById("o.3."+boardSlot[j]);
             if (null != card)
             {
                 card.parentNode.removeChild(card);
             }
        }
         
        if (removeSelectedBoardview)
        {
        		win = window.parent.frames[selecttabIndex];
        		
        		boardSlot = window.parent.Tab.getTab(window.parent.Tab.selectTabid).body.contentWindow.neSlots.slice(0);
        		
	         	for (var k=0; k<boardSlot.length; k++)
			      {
			      		var card = win.document.getElementById("o.3."+boardSlot[k]);
	
			          if (null != card)
			          {
			          		card.parentNode.removeChild(card);
			          }
			      }
			  }
        
    }
}

/*
              
@param  value         
@param         
*/
function rmFromArray(value,oArray)
{
    var i=0;
    for(i=0;i<oArray.length;i++)
    {
        if(value == oArray[i])
        {
            oArray.splice(i,1);
        }
    }
}


/*
        
@param action     
@param argus          
*/ 
function adjustBoardviewLayout(action,argus)
{
	if(action == 'addCard'){
		
	  var e3=document.getElementById("o.3.6");
	  if(e3)
	  {
	  	e3.parentNode.removeChild(e3);
	  }
	  changePowerBoardSlot(argus);	  
	}else if(action == 'delCard'&&argus=='21APIU'){
		
	  var e1=document.getElementById("o.3.6");
	  var e2=document.getElementById("o.3.7");
	  if(!e1 &&!e2)
	  {
	  	var e3=document.getElementById("o.3.8");
	  	if(e3)
	  	{
	  		e3.parentNode.removeChild(e3);
	  	}
	  	changePowerBoardSlot("61PIU");
	  }
	}else if(action =='query'){
	  	changePowerBoardSlot(argus);
	}
} 
 

/*
             6,7,8       
      wei       
                     
*/ 
function changePowerBoardSlot(type)
{
	 var html=panelText[type];
	 if(html)
	 {
	 	 var element= document.getElementById("powerpanel");
	 	 element.innerHTML=html;
	 }
 
}  

    
/*
     left,top,width,height(           
*/
    
function calcBoardPostion(slotList){

    var boardPos=new Object();
    boardPos.top=Number.MAX_VALUE;
    boardPos.left=Number.MAX_VALUE;
    boardPos.right=0;
    boardPos.bottom=0;

   
   var top,left,right,bottom;
   
   var slotArray = slotList.split(",");
   
   for (var j=0; j<slotArray.length; j++)
   {
   	   var slotDiv = document.getElementById('o.2.'+slotArray[j]);
	   if(slotDiv==null)
	   {	
	   	 return null;
	   }
   	   if(!slotDiv)
   	   {
   	     continue;	
       }
       
   	   top=parseInt(slotDiv.style.top);
       if(top<boardPos.top){
        	boardPos.top =top;
       }
       
       left=parseInt(slotDiv.style.left);
       if(left<boardPos.left)
       {
       	 boardPos.left=left;
       }
       
       right=parseInt(slotDiv.style.left)+parseInt(slotDiv.style.width);
       if(right>boardPos.right)
       {
         	boardPos.right = right;
       }
       
       
       bottom =parseInt(slotDiv.style.top)+parseInt(slotDiv.style.height);
       if(bottom >boardPos.bottom)
       {
         	boardPos.bottom =bottom;
       }
       
   }
	
	   boardPos.width = boardPos.right-boardPos.left;
	   boardPos.height = boardPos.bottom-boardPos.top;
	   
	   return boardPos;
	   
	  
}


/*
         ,       ,            .
 @param slot    
 @param bdid      
 @param lable     
 @param slotList           (        1   ,    slotList)
 
 60020637       
*/
function paintCard(slot,bdid,label,slotList,bstate,color,bloop,bpg)
{
    if((bdid == '60039' && $('o.2.8') != null || bdid == '1308' && $('o.2.8') == null)  && bstate == 'undefined')
    { 
        if($('o.3.'+slot) != null)
        {
            $('o.3.'+slot).parentNode.removeChild($('o.3.'+slot));
        }
        
        var slot1;
        
        if(slot == '6')
        {
            slot1 = '7';
        } else if( slot == '7' ) {
            slot1 = '6';
        }
        
        if(bdid == '60039' && $('o.3.'+slot1) != null)
        {
            $('o.3.'+slot1).parentNode.removeChild($('o.3.'+slot1));        
        }
       
        if(bdid == '60039')
        {
            if($('o.3.8') != null && $('o.3.8').className != "Cardphy SelStateOff")
            {
             
                adjustBoardviewLayout('addCard', '6-8');
            } else {
                adjustBoardviewLayout('addCard', '21APIU');
            }
        }
        else adjustBoardviewLayout('addCard', '61PIU');
        
    }
		if (null != document.getElementById('o.3.'+slot))
		{
				return;	
		}
    
    var  slotDiv = calcBoardPostion(slotList);
	if(slotDiv==null)
	{
		return;
	}
    var neDiv =document.getElementById("o.1.1");
    var shelfDiv = gerFirstTagElement(neDiv);
        
    var div = shelfDiv.appendChild(document.createElement("div"));
    
      if( color == "7")
      {
          div.className = 'unknownColor SelStateOff';
      }
      else if(color == "22")
      	{
      		div.className = 'noProvisionedAndRemovedColor SelStateOff';
      	}
      else if(color == "21")
      	{
      		div.className = 'noProvisionedColor SelStateOff';
      	}
      else if(color == "19")
      	{
      		div.className = 'enabledAndRemovedColor SelStateOff';
      	}
      else if(color == "16")
      	{
      		div.className = 'enabledColor SelStateOff';
      	}
      else if(color == "18")
      	{
      		div.className = 'autoInServiceColor SelStateOff';
      	}
      else if(color == "17")
      	{
      		div.className = 'disabledColor SelStateOff';
      	}
      else if(color == "20")
      	{
      		div.className = 'enableAndFailedColor SelStateOff';
      	}
      else if(color == "24")
      	{
      		div.className = 'maintenanceColor SelStateOff';
      	}
      else
      	{
      		div.className = 'unknownColor SelStateOff';
      	}    
    div.setAttribute('id', 'o.3.'+slot);
    div.setAttribute('bdid', bdid);
    if (color == "21")
    {
    	 div.style.zIndex = "0";
    }
    else
    {
    	div.style.zIndex = "1";
    }
   
    div.setAttribute('bstate',bstate);
    div.setAttribute('color',color);
    div.setAttribute('bloop',bloop);
    div.setAttribute('bpg',bpg);
    div.setAttribute('blabel',label);
    div.setAttribute('slotlist',slotList);
    div.style.position = 'absolute';
    div.style.padding = '1px';
    
    div.boardType=bdid;
    div.boardName=label;
    
    div.style.top = (parseInt(slotDiv.top)+1)+'px';
    if(slotDiv.left) div.style.left = (parseInt(slotDiv.left)+1)+'px';
    if(slotDiv.right) div.style.right = (parseInt(slotDiv.right)+1)+'px';
    div.style.width = (parseInt(slotDiv.width)-4)+'px';
    div.style.height = (parseInt(slotDiv.height)-4)+'px';
    
    var div2 = div.appendChild(document.createElement("div"));
    div2.style.position = 'relative';
    div2.style.width = (parseInt(div.style.width)-4)+'px';
    div2.style.height = (parseInt(div.style.height)-4)+'px';
    
    var ycenter= parseInt(div2.style.height);
    
    var div3 = div2.appendChild(document.createElement('div'));
    div3.style.position = 'absolute';
    div3.className = 'LED';
    div3.setAttribute('id', 'alarmlight');//      ID  
    div3.style.top="6px";  
    div3.style.left = '6px';
    div3.style.width = '7px';
    div3.style.height = '7px';
    if("2" == bstate) //            
    {
        div3.style.visibility = "hidden" ;  
    }
    
    if (parseInt(div2.style.width) > parseInt(div2.style.height))
    {
    	 div3.style.top = (ycenter-7)/2 +'px';
    }
    
    var div4 = div2.appendChild(document.createElement('div'));
    div4.style.position = 'absolute';
    div4.className = 'Label';
    div4.style.right = '1px';
    div4.style.bottom = '1px';

    if (parseInt(div2.style.width) > parseInt(div2.style.height))
    {
        div4.appendChild(document.createTextNode(label));
    }
    else
    {
        var s = '';
        for (var i=0;i<label.length ;i++)
        {
            s = s + label.charAt(i) ;
            if (i < label.length-1) // last char need not append <br />
            {
                s = s + "<br />";
            }
        }
        div4.innerHTML = s;

        var slotWidth = 26; //    
        var len = slotList.split(",").length;
        var div2width = slotWidth*len + 3*(len-1) - 8;
        div4.style.right = (div2width-15)/2+"px";
    }
    
   
   
		if (bloop == "1")
    {
		    var div5 = div2.appendChild(document.createElement('div'));
		    div5.style.position = 'absolute';
		    div5.className = 'Loop';
		    div5.style.left= '-2px';
		    div5.style.bottom = '-7px';
		    div5.style.width = '10px';
		    div5.style.height = '10px';
    }
   
    if(bpg == "1")
    {
		    var div6 = div2.appendChild(document.createElement('div'));
		    div6.style.position = 'absolute';
		    div6.className = 'bpg';
		    div6.style.right= '-5px';
		    div6.style.bottom = '-5px';
		    div6.style.width = '10px';
		    div6.style.height = '10px';
    }    
}

/*
        
*/
function boardAlarmLevelCallback(doc, slot)
    {
        var result = EncapsulateData(doc);

        if(result.getDataRowLength() > 0)
        {
            var lev = result.getDataRowParam(0, 'topAlmLevel');
           
            setBoardLED(slot,lev);
        }
}

/*
           
*/
function boardAlarmLevel(slot)
{
	/*
    loadXMLdoc("../../../../../demo/boardalarm.xml", "GET", true, boardAlarmLevelCallback, slot);
    return;
  */
   
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");

    var param = new tagElement("param");
    param.setAttribute("name", "neID");
    param.setAttribute("value", getNeProperty(top).neid);
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name", "slotID");
    param.setAttribute("value", slot);
    row.appendChild(param);
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    loadXMLdoc("../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_NECPSANDALM, "POST", true, boardAlarmLevelCallback, slot, "inputdata="+di.toString());
  
}

/*
              
*/
function setBoardLED(slot,almLevel)
{
    var board = document.getElementById("o.3."+slot);
    
	if (!board || !board.firstChild || board.almLevel == almLevel)
    {

        return false; 
    }
	board.almLevel = almLevel;
    var c = board.firstChild.childNodes;
    var ledDiv = ('Label' == c[0].className) ? c[1] : c[0];
    
     switch(almLevel)
    {
        case"-1":  if("LED" !=ledDiv.className)
                   {
                       ledDiv.className = "LED";
                   }
                   break;
        case"1":  if("RedLED" !=ledDiv.className)
                   {
                       ledDiv.className = "RedLED";
                   }
                   break;
        case"2":  if("major" !=ledDiv.className)
                   {
                       ledDiv.className = "major";
                   }
                   break;
        case"3":  if("YellowLED" !=ledDiv.className)
                   {
                       ledDiv.className = "YellowLED";
                   }
                   break;
        case"4":  if("warning" !=ledDiv.className)
                   {
                       ledDiv.className = "warning";
                   }
                   break;
                   /*
         case"5":  if("NotReport" !=ledDiv.className)
                   {
                       ledDiv.className = "NotReport";
                   }
                   break;
                   */
        default :  ledDiv.className = "GreenLED";
        
    }
}
/*
*      60020637
*
*/

function tableview()
{
    if($('maptable').style.visibility =="hidden")
    {
    $('maptable').style.visibility ="visible";
    $('showmap').src = "../../../../../images/tree/mapsample.gif";
    }
    else if($('maptable').style.visibility =="visible")
    {
    $('maptable').style.visibility ="hidden"
    $('showmap').src = "../../../../../images/tree/mapsamplesaw.gif";
    }
}
function getPhyBoard(eid)
{
	var PHYSTATE = "2" ;
    var topmenu = new jsDOMenu(100);
	topmenu.setMenuType(PHYSTATE);
    with(topmenu)
    {    
    	    var bdname = eid.bname;
	        var boardType = eid.btype;
	        var slotList = eid.bslotlist;
	        var paramArr = [eid.id,boardType,bdname,slotList,PHYSTATE];	        
 	   	    addMenuItem(new menuItem(RESOURCE['add']+' '+bdname,boardType,addCard,paramArr));		    	 
	}
 setPopUpMenu(topmenu);
}
function createjsDOMenu()
{
	removejsDOMmenu(); 
    var cursorMenu1 = new jsDOMenu(150); //   150
    		    
    with (cursorMenu1)
    {   	
  	  	addMenuItem(new menuItem(RESOURCE["clear_alarm_indication"],"",alarmReset,0));
  	}
    setPopUpMenu(cursorMenu1); 
    
}

/*
 *        
 */
function alarmReset()
{
	 
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");
	var neid =  getNeProperty(top).neid;

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","neid");
	thirdlevel.setAttribute("value",neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","reset");
	thirdlevel.setAttribute("value","0");//    
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	var xml = root.toString();	 	 
	var URL = "../../../../../tl1NEExlorerServlet?sfid="+TE_CLR_NE_ALM_INDICATE_CMD+"&flag=1";
	loadXMLdoc(URL,"POST",true,alarmResetHandBack,null,"inputdata="+xml); 
}

function alarmResetHandBack(doc)
{
	var datainterface = EncapsulateData(doc);
	 
	var errArr = [];
	errArr[0] = "nename";	  
    openErrPage("../../../../../page/", datainterface.getError(), errArr);     	    
}
function getSlotID(slotID)
{
	return slotID%100;
}
/**
is board can update 
 */
var disableRefreshBoard=false;

var isAdding = false;

var isRefreshBoard = false;
