/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.subrack;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class TESubrackQueryBean
extends TETL1NEExplorerBean {
    public static final int COMM_ABNORMAL = 1090617361;
    private static final String MAIN_SUBRACK_ID = "1";
    private Vector lastSubrackList = new Vector();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            Vector subrackList = neObj.getClonedSubrackList();
            if (subrackList == null || subrackList.size() == 0) {
                TESubrack defaultSubrack = new TESubrack(MAIN_SUBRACK_ID, String.valueOf(neObj.getNEType()), "");
                this.outputData.getBussinessParams().addRowParams(this.addRow((TENE)neObj, defaultSubrack, 1, null));
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                TELogFactory.getNormalLogger().error("Query Subrack failed! Use default subrack.");
                return this.outputData;
            }
            if (subrackList.containsAll(this.lastSubrackList) && this.lastSubrackList.containsAll(subrackList)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)38662));
                return this.outputData;
            }
            this.lastSubrackList.clear();
            this.lastSubrackList.addAll((Vector)subrackList.clone());
            boolean isException = this.handleExceptionStates((TENE)neObj, subrackList);
            if (isException) {
                return this.outputData;
            }
            Param tmpParam = inputData.getBussinessParams().getRowParams(0).getParam("subrackID");
            SubrackComparator comp = new SubrackComparator();
            Collections.sort(subrackList, comp);
            int size = subrackList.size();
            for (int i = 0; i < size; ++i) {
                TESubrack subrackObj = (TESubrack)subrackList.get(i);
                RowParams rParams = this.addRow((TENE)neObj, subrackObj, i + 1, tmpParam);
                if (rParams.getParamCount() == 0) continue;
                this.outputData.getBussinessParams().addRowParams(rParams);
            }
            this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private boolean handleExceptionStates(TENE ne, Vector subrackList) {
        if (0 == ne.getComStarus()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090617361));
            return true;
        }
        if (0 == ne.getLogStatus()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)37926));
            return true;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return false;
    }

    private RowParams addRow(TENE neObj, TESubrack subrack, int num, Param param) {
        RowParams rParams = new RowParams();
        if (param == null || param.getValue().equals(subrack.getSubrackID())) {
            rParams.addParam("serialNum", String.valueOf(num));
            rParams.addParam("nename", neObj.getNEName());
            rParams.addParam("neType", neObj.getDeviceType());
            rParams.addParam("subrackID", subrack.getSubrackID());
            if (subrack.getShelfType() == -1) {
                rParams.addParam("logicSubrackType", String.valueOf(subrack.getLogicSubrackType()));
            } else {
                rParams.addParam("logicSubrackType", String.valueOf(subrack.getShelfType()));
            }
            rParams.addParam("subrackState", subrack.getSubrackState());
            rParams.addParam("phySubrackType", subrack.getPhySubrackType());
            rParams.addParam("ficInfo", subrack.getFicInfo() == null ? "" : subrack.getFicInfo());
            rParams.addParam("subrackName", subrack.getSubrackName() == null ? "" : subrack.getSubrackName());
            rParams.addParam("subrackTopLevelAlm", String.valueOf(neObj.getCurTopLevelAlmOnSubrack(Integer.valueOf(subrack.getSubrackID()).intValue()).getTopAlmLevel()));
        }
        if (66 == neObj.getNEType() && subrack.getSubrackState().equals(MAIN_SUBRACK_ID) && !subrack.getBarCode().equals("")) {
            rParams.addParam("subrackBarCode", subrack.getBarCode());
        }
        return rParams;
    }

    private RowParams addBarcodeRow(TENE neObj, TESubrack subrack) {
        RowParams rParams = new RowParams();
        if (66 == neObj.getNEType() && subrack.getSubrackState().equals(MAIN_SUBRACK_ID) && !subrack.getBarCode().equals("")) {
            rParams.addParam("subrackBarCode", subrack.getBarCode());
        }
        return rParams;
    }

    class SubrackComparator
    implements Comparator {
        SubrackComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            TESubrack s1 = (TESubrack)arg0;
            TESubrack s2 = (TESubrack)arg1;
            if (Integer.parseInt(s1.getSubrackID()) < Integer.parseInt(s2.getSubrackID())) {
                return -1;
            }
            if (Integer.parseInt(s1.getSubrackID()) > Integer.parseInt(s2.getSubrackID())) {
                return 1;
            }
            return 0;
        }
    }
}

