/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.subrack;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class TESubrackDeleteBean
extends TETL1NEExplorerBean {
    private static final int OPERATION_SUCESS = 0;
    private static final int SUBRACK_IS_NOT_EXIST = 43350;

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param tempParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            StringBuffer sb = new StringBuffer();
            sb.append("SHELF-");
            tempParam = rowparams.getParam("subrackID");
            if (tempParam == null) {
                return false;
            }
            sb.append(tempParam.getValue());
            part.setValue(sb.toString());
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation oOper = (TL1Operation)operationList.get(0);
        OutMsg[] out = oOper.getOutMsg();
        boolean flag = false;
        boolean hasBoard = false;
        if (out == null || out.length == 0) {
            flag = true;
        } else {
            int errorCode = out[0].getFault().getCompletionCode();
            if (0 == errorCode || 43350 == errorCode) {
                flag = true;
            }
        }
        InMsg inPut = oOper.getInMsg();
        Part AID2 = inPut.getPart("AID");
        String subrackID = AID2.getValue().split("-")[1];
        int subrackIDNum = Integer.parseInt(subrackID);
        TENE ne = TENEListUtils.getNEObj((int)neid);
        Vector v = ne.getBoardList();
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            TEBoard board = (TEBoard)v.get(i);
            int slotID = board.getSlotID();
            if ((slotID >= subrackIDNum * 65536 + 16 || subrackIDNum * 65536 >= slotID) && (slotID != subrackIDNum * 65536 + 17 || board.getBoardName().indexOf("SCC") != -1)) continue;
            hasBoard = true;
            break;
        }
        if (hasBoard) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            RowErrors rowError = new RowErrors();
            RowParams rowParam = new RowParams();
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)39970));
            rowParam.addRowErrors(rowError);
            rowError.addParam(new Param("nename", ne.getNEName()));
            this.outputData.getBussinessParams().addRowParams(rowParam);
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
        }
        if (!hasBoard && flag) {
            Vector subrackList = ne.getClonedSubrackList();
            for (int i = subrackList.size() - 1; i >= 0; --i) {
                TESubrack sigleSubrack = (TESubrack)subrackList.get(i);
                if (!sigleSubrack.getSubrackID().equals(subrackID)) continue;
                subrackList.remove(i);
            }
            ne.setSubrackList(subrackList);
            this.deleteSubrackBoard(neid, subrackIDNum);
            super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        } else {
            super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        }
    }

    private void deleteSubrackBoard(int neid, int subrackid) {
        TENE ne = TENEListUtils.getNEObj((int)neid);
        Iterator iteratortl1 = ne.getBoardList().iterator();
        TEBoard board = null;
        boolean bRefresh = false;
        while (iteratortl1.hasNext()) {
            board = (TEBoard)iteratortl1.next();
            if (TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)board.getSlotID()) != subrackid) continue;
            iteratortl1.remove();
            ne.removeAlarm(board.getSlotID(), 0);
            ne.removeLogicPortBySlot(neid, board.getSlotID(), board.getBoardType());
            bRefresh = true;
        }
        if (bRefresh) {
            ne.setLastBoardModifyTime();
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = super.getFilterErrorCodeList();
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(43350);
        return list;
    }
}

