/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.subrack;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.po.TESubrackTypes;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TESubrackAddBean
extends TETL1NEExplorerBean {
    private static final int OPERATION_SUCESS = 0;

    public TESubrackAddBean() {
        this.msgBlockFlag = false;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param tempParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            StringBuffer sb = new StringBuffer();
            sb.append("SHELF-");
            tempParam = rowparams.getParam("subrackID");
            if (tempParam == null) {
                return false;
            }
            sb.append(tempParam.getValue());
            part.setValue(sb.toString());
            return true;
        }
        if (part.getName().equalsIgnoreCase("PROVTYPE")) {
            tempParam = rowparams.getParam("subrackType");
            if (tempParam == null) {
                return false;
            }
            if (this.curTL1Operation == null || !this.curTL1Operation.getName().equals("ENT-EQPT")) {
                return false;
            }
            part.setValue(tempParam.getValue());
            return true;
        }
        if (part.getName().equalsIgnoreCase("USERLBL")) {
            tempParam = rowparams.getParam("subrackFIC");
            if (tempParam == null) {
                return false;
            }
            if (tempParam.getValue().equals("")) {
                return false;
            }
            part.setValue(tempParam.getValue());
            return true;
        }
        if (part.getName().equalsIgnoreCase("SHELFLBL")) {
            tempParam = rowparams.getParam("subrackName");
            if (tempParam == null) {
                part.setValue("");
                return false;
            }
            part.setValue(tempParam.getValue());
            return true;
        }
        return flag;
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int num = 0;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                if (!this.convertPartValue(part, rowparams)) continue;
                if (null != part.getDefault()) {
                    part.setValue(part.getDefault());
                    continue;
                }
                if (part.getValue() == null) continue;
                ++num;
            }
        }
        if (num < 1) {
            flag = false;
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation oOper = (TL1Operation)operationList.get(0);
        OutMsg[] out = oOper.getOutMsg();
        boolean flag = false;
        if (out == null || out.length == 0) {
            flag = true;
        } else {
            int errorCode = out[0].getFault().getCompletionCode();
            if (0 == errorCode) {
                flag = true;
            }
        }
        if (flag) {
            InMsg inPut = oOper.getInMsg();
            Part AID2 = inPut.getPart("AID");
            String subrackID = AID2.getValue().split("-")[1];
            String subrackType = inPut.getPart("PROVTYPE").getValue();
            TESubrack tempSubrack = new TESubrack(subrackID, subrackType, "");
            tempSubrack.setSubrackName("");
            tempSubrack.setShelfType(this.returnShelfType(subrackType));
            TENE ne = TENEListUtils.getNEObj((int)neid);
            Vector subrackList = ne.getClonedSubrackList();
            subrackList.add(tempSubrack);
            Collections.sort(subrackList);
            ne.setSubrackList(subrackList);
        }
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
    }

    public int returnShelfType(String subrackName) {
        if (subrackName.equals("SHELF6800A")) {
            return 136;
        }
        if (subrackName.equals("SHELF8800I") || subrackName.equals("SHELF8800") || subrackName.equals("SHELF8800T32")) {
            return 2043;
        }
        if (subrackName.equals("SHELF8800II") || subrackName.equals("SHELF8800T64")) {
            return 1975;
        }
        if (subrackName.equals("SHELF8800T16")) {
            return 1985;
        }
        if (subrackName.equals("SHELF8800T32E")) {
            return 2044;
        }
        if (subrackName.equalsIgnoreCase("SHELF8800T64E")) {
            return 101;
        }
        return TESubrackTypes.getInstance().getTL1SubrackType(subrackName);
    }
}

