/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.reportform;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1ngwdm.reportform.TEBdDetailCache;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Vector;

public class TENEQueryBdDetailBean
extends TETL1NEExplorerBean {
    TENE ne;
    private String neName = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.ne = TENEListUtils.getNEObj((int)neid);
            if (this.ne.getLogStatus() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
                return this.outputData;
            }
            this.neName = this.ne.getNEName();
            int result = this.sendMessageOperationList();
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, user, ipAddress, (ArrayList)this.tl1OperList.clone());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public int getTimeOut() {
        return 40;
    }

    public int sendMessageOperationList() {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        this.tl1OperList = new ArrayList();
        int retCode = 0;
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            Vector boardList = ne.getPhyBoardList();
            int n = boardList.size();
            for (int i = 0; i < n; ++i) {
                operList.clear();
                TEBoard board = (TEBoard)boardList.get(i);
                TL1Operation queryOper = definitions.getTL1Operation("RTRV-BDINFO-EQPT");
                InMsg input = queryOper.getInMsg();
                String shelfSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)board.getSlotID());
                input.getPart("AID").setValue("SLOT-" + shelfSlot);
                operList.add(queryOper);
                retCode = this.sendMessage(this.neid, operList);
                this.tl1OperList.addAll(operList);
                if (retCode == 0) continue;
                TELogFactory.getNormalLogger().info("send command:" + queryOper.getCmdDetail() + ", resut:" + retCode);
            }
            if (retCode == 0) {
                this.addCmdFaultInfo(this.tl1OperList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEQueryBdDetailBean.sendMessageOperationList() fail!", (Throwable)e);
            return 1090650120;
        }
        return retCode;
    }

    private void addCmdFaultInfo(ArrayList tl1OperList) {
        TL1Operation tl1Oper = null;
        OutMsg curOutput = null;
        String errorCode = "OK";
        for (int i = tl1OperList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperList.get(i);
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = String.valueOf(curOutput.getFault().getCompletionCode());
                if ("0".equals(errorCode)) continue;
                tl1Oper.addCmdFault(curOutput.getFault());
            }
        }
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc) {
        int i;
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        RowParams rowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        TEBdDetailCache.getInstance().clearCahce(neid);
        int n = tl1OperList.size();
        for (i = 0; i < n; ++i) {
            boolean flag = true;
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            for (OutMsg out : tl1Operation.getOutMsg()) {
                RowErrors errors;
                if (out.getFault().getCompletionCode() == 0 || (errors = this.handleRowData(neid, tl1Operation.getInMsg(), out)) == null) continue;
                errorDataList.add(errors);
                flag = false;
                break;
            }
            if (!flag || null == tl1Operation.getStrTL1Info()) continue;
            TEBdDetailCache.getInstance().addCahce(neid, tl1Operation.getStrTL1Info());
        }
        n = TEBdDetailCache.getInstance().getSize(neid);
        for (i = 0; i < n; ++i) {
            String boardDetail = TEBdDetailCache.getInstance().getCahce(neid, i);
            boardDetail = boardDetail.replaceAll("\\>", "");
            boardDetail = boardDetail.replaceAll("\r\n", "<p>");
            boardDetail = boardDetail.replaceAll("\\\\\"\"", "");
            boardDetail = boardDetail.replaceAll("\"\\\\\"", "");
            boardDetail = boardDetail.replaceAll("\\/\\$", "");
            rowparams = new RowParams();
            rowparams.addParam(new Param("neid", String.valueOf(neid)));
            rowparams.addParam(new Param("nename", this.ne.getNEName()));
            rowparams.addParam(new Param("boardDetail", boardDetail));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (errorDataList.size() != 0) {
            rowparams = new RowParams();
            int y = errorDataList.size();
            for (int x = 0; x < y; ++x) {
                rowparams.addRowErrors((RowErrors)errorDataList.get(x));
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
            if (errorDataList.size() == tl1OperList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    protected RowErrors handleRowData(int neid, InMsg input, OutMsg output) {
        Fault fault = output.getFault();
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        String aidstr = input.getStagBlock().getAID().getPart(0).getValue();
        int slotID = TETL1CommonUtil.getNMSlotStr((String)aidstr, (int)neid);
        if (this.ne.getBoard(slotID) != null) {
            String boardName = this.ne.getBoard(slotID).getBoardName();
            RowErrors rowError = new RowErrors();
            ErrorMessage errorMessage = new ErrorMessage();
            Param errorparam = null;
            errorMessage.setErrorcode(errorCode);
            errorMessage.setErrorinfo(errorinfo);
            rowError.setErrorMessage(errorMessage);
            errorparam = new Param("nename", this.neName);
            rowError.addParam(errorparam);
            errorparam = new Param("slotID", String.valueOf(slotID));
            rowError.addParam(errorparam);
            errorparam = new Param("boardname", boardName);
            rowError.addParam(errorparam);
            return rowError;
        }
        return null;
    }
}

