/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.pulloutboard;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TENEQueryPullOutBoardStatus
extends TETL1NEExplorerBean {
    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        TL1Definitions tl1definitions;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getBoardList();
        Vector phyboardList = ne.getPhyBoardList();
        Collections.sort(phyboardList);
        TEBoard board = null;
        ArrayList<TL1Operation> list = new ArrayList<TL1Operation>();
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return list;
        }
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-LEDSTATE");
        int len = phyboardList.size();
        for (int i = 0; i < len; ++i) {
            board = (TEBoard)phyboardList.get(i);
            TL1Operation tl1Operationclone = (TL1Operation)tl1Operation.clone();
            tl1Operationclone.getInMsg().getStagBlock().getAID().getPart(0).setValue("SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)board.getSlotID()));
            list.add(tl1Operationclone);
        }
        return list;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equals("enableStatus")) {
            Part part = (Part)partmap.get("LEDSTATE");
            String value = part.getValue();
            if (value.equalsIgnoreCase("ON")) {
                oldParam.setValue("1");
            } else {
                oldParam.setValue("0");
            }
            return oldParam;
        }
        if (oldParam.getName().equals("board")) {
            Part part = (Part)partmap.get("AID");
            String value = part.getValue();
            oldParam.setValue(TETL1CommonUtil.getBoardStructFromAID((String)value, (int)this.neid, (boolean)true));
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add("INVALID DATA PARAMETER, Error of board type unsupported");
        codeList.add("REPLY TIMEOUT OCCURRED, REPLY TIMEOUT OCCURRED");
        return codeList;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
        if (Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()) == 2) {
            return;
        }
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            RowParams row = this.outputData.getBussinessParams().getRowParams(i);
            if (row.getParam("board") != null) {
                String boardName = row.getParam("board").getValue();
                if (boardName.indexOf("UNKNOWN") == -1) continue;
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            this.outputData.getBussinessParams().removeRowParams(i);
        }
    }
}

