/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.vlangroup;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;

public class TEGetPortInfoBean
implements TENEMgrInterface {
    private int neID = -1;
    private int boardType = -1;
    private int slotID = -1;
    private Datainterface output = null;
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_NAME_PARAM = "boardName";
    private static final String PORT_NM_PARAM = "portName";
    private static final String PORT_NO_PARAM = "portNO";
    private static final String SHELF_NAME_PARAM = "shelfName";
    private final Logger log = TELogFactory.getNormalLogger();
    private static final int LGCBD_NOTINSTALL = 24588;
    private boolean fail = false;
    private TEAIDAndTypeList aidAndTypeList = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        this.output = new Datainterface();
        try {
            Param param = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
            this.slotID = Integer.parseInt(param.getValue());
            HashSet<Integer> slotIDList = new HashSet<Integer>();
            slotIDList.add(this.slotID);
            this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, slotIDList);
            if (this.aidAndTypeList == null) {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                return this.output;
            }
            this.getEthBoardInfo(subFunc, memeryData);
            if (!this.fail) {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        catch (Exception e) {
            this.log.error("Get BoardInfo Fail!\n", (Throwable)e);
        }
        return this.output;
    }

    private void getEthBoardInfo(SubFunc subFunc, Datainterface memeryData) {
        int portNO = -1;
        RowParams rowParam = null;
        String portName = "";
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        if (null == configurDataMgr.getBoard(this.neID, this.slotID)) {
            this.fail = true;
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)24588));
            return;
        }
        this.boardType = configurDataMgr.getBoard(this.neID, this.slotID).getBoardType();
        Param param = null;
        rowParam = new RowParams();
        param = new Param(BOARD_NAME_PARAM, configurDataMgr.getBoardTypeName(this.neID, this.boardType));
        rowParam.addParam(param);
        param = new Param(SHELF_NAME_PARAM, TETL1CommonUtil.getShelfSlotName((int)this.neID, (int)this.slotID));
        rowParam.addParam(param);
        this.output.setBussinessParams(new BussinessParams());
        this.output.getBussinessParams().addRowParams(rowParam);
        ArrayList macPortList = TETL1CommonUtil.getMacPortList((int)this.neID, (int)this.slotID, (TEAIDAndTypeList)this.aidAndTypeList);
        int len = macPortList.size();
        for (int i = 0; i < len; ++i) {
            portNO = Integer.parseInt(macPortList.get(i).toString());
            portName = TEConfigurationDataMgr.getMACName((int)portNO);
            rowParam = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNO));
            rowParam.addParam(param);
            param = new Param(PORT_NM_PARAM, portName);
            rowParam.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam);
        }
        ArrayList vcPortList = TETL1CommonUtil.getVCTrunkPortList((int)this.neID, (int)this.slotID, (TEAIDAndTypeList)this.aidAndTypeList);
        int len2 = vcPortList.size();
        for (int i = 0; i < len2; ++i) {
            portNO = Integer.parseInt(vcPortList.get(i).toString());
            if (TETL1CommonUtil.isFilterVCTrunkPort((int)this.neID, (int)this.boardType, (int)this.slotID, (int)portNO)) continue;
            portName = TEConfigurationDataMgr.getVCTrunkName((int)(portNO - 32768));
            rowParam = new RowParams();
            param = new Param(PORT_NO_PARAM, String.valueOf(portNO));
            rowParam.addParam(param);
            param = new Param(PORT_NM_PARAM, portName);
            rowParam.addParam(param);
            this.output.getBussinessParams().addRowParams(rowParam);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

