/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPLContainer;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPLPortProperty;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TEEVPLSetPortInfo
extends TETL1NEExplorerBean {
    private static final String RTRV_GETH = "RTRV-GETH";
    private static final String RTRV_XGETH = "RTRV-XGETH";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.curUser = user;
            this.curIpAddress = ipAddress;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            this.neType = ne.getNEType();
            if (inputData.getBussinessParams().getRowParamsCount() == 1) {
                String tmpaid = this.getAIDFromInput(inputData);
                int tmpSlotid = TETL1CommonUtil.getNMSlotStr((String)tmpaid, (int)neid);
                int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, tmpSlotid);
                boolean isQuery = false;
                isQuery = boardtype == 2292 ? false : this.queryVlanGroup(tmpaid);
                Param porttypeParam = inputData.getBussinessParams().getRowParams(0).getParam("PORTTYPE");
                if (isQuery && porttypeParam != null && "UNI".equalsIgnoreCase(porttypeParam.getValue())) {
                    Datainterface outputData = new Datainterface();
                    outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    return outputData;
                }
            }
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        this.addRTRVPORTError(neid, (TENE)ne);
                        return this.outputData;
                    }
                }
            }
            this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            if (null == this.tl1OperList) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            for (int i = this.tl1OperList.size() - 1; i >= 0; --i) {
                TL1Operation tmpopr = (TL1Operation)this.tl1OperList.get(i);
                String sendAid = tmpopr.getInMsg().getStagBlock().getAID().getPart(0).getValue();
                Part sendTypeParam = tmpopr.getInMsg().getPart("PORTTYPE");
                boolean isQuery = this.queryVlanGroup(sendAid);
                if (!isQuery || sendTypeParam == null || !"UNI".equalsIgnoreCase(sendTypeParam.getValue())) continue;
                this.tl1OperList.remove(i);
            }
            if (this.tl1OperList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.printLog();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private String getAIDFromInput(Datainterface inputData) {
        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
        return this.getAIDFromRowParams(rowparams);
    }

    private String getAIDFromRowParams(RowParams rowparams) {
        int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
        String shelfanslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotid);
        int portid = Integer.parseInt(rowparams.getParam("portid").getValue());
        StringBuffer AID2 = null;
        if (portid > 32768) {
            AID2 = new StringBuffer("ACC");
            portid -= 32768;
        } else {
            AID2 = new StringBuffer("FAC");
        }
        AID2.append("-");
        AID2.append(shelfanslot);
        AID2.append("-");
        AID2.append(portid);
        return AID2.toString();
    }

    private boolean queryVlanGroup(String AID2) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            ArrayList<TL1Operation> queryVlanIDList = new ArrayList<TL1Operation>();
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-PORT-VLANGROUP");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue(AID2);
            queryVlanIDList.add(queryOper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, queryVlanIDList, this.TIME_OUT);
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().error("Query subrack fail, the errorCode is" + result.retCode);
                return true;
            }
            OutMsg[] outputArr = ((TL1Operation)queryVlanIDList.get(0)).getOutMsg();
            if (outputArr.length == 0) {
                return false;
            }
            return outputArr[0].getFault().getCompletionCode() == 0;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return false;
        }
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        Param portIdParam = rowparams.getParam("portid");
        Param slotIdParam = rowparams.getParam("slotid");
        int portId = -1;
        int slotId = -1;
        String mod1_temp = "";
        String cmdCode = "";
        if (slotIdParam != null && slotIdParam.getValue() != null && portIdParam != null && portIdParam.getValue() != null) {
            portId = Integer.parseInt(portIdParam.getValue());
            slotId = Integer.parseInt(slotIdParam.getValue());
            mod1_temp = TEEVPLContainer.getInstance().getAidAndTypeList().getPayLoadMod2(this.neid, slotId, portId);
            if (!mod1_temp.equals("")) {
                cmdCode = tl1Operation.getCmdCode();
                tl1Operation.setName(cmdCode + "-" + mod1_temp);
                tl1Operation.setMod1(mod1_temp);
            }
        }
    }

    protected boolean convertPartValue(Part part_temp, RowParams rowparams) {
        Param slotIdParam = null;
        Param portIdParam = null;
        String tempStr1 = "";
        int slotId = 0;
        int portId = -1;
        String prefix = "";
        if (part_temp.getName().equalsIgnoreCase("AID")) {
            slotIdParam = rowparams.getParam("slotid");
            portIdParam = rowparams.getParam("portid");
            if (slotIdParam == null || slotIdParam.getValue() == null || portIdParam == null || portIdParam.getValue() == null) {
                return false;
            }
            slotId = Integer.parseInt(slotIdParam.getValue());
            portId = Integer.parseInt(portIdParam.getValue());
            prefix = portId < 32768 ? "FAC" : "ACC";
            portId = portId < 32768 ? portId : portId - 32768;
            tempStr1 = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            tempStr1 = prefix + "-" + tempStr1 + "-" + portId;
            part_temp.setValue(tempStr1);
            return true;
        }
        if (part_temp.getName().equalsIgnoreCase("PORTTYPE")) {
            Param portTypeParam = rowparams.getParam("PORTTYPE");
            String AId = this.getAIDFromRowParams(rowparams);
            if (portTypeParam.getValue().equals(TEEVPLSetPortInfo.queryPortType(this.neid, AId))) {
                return false;
            }
        }
        return super.convertPartValue(part_temp, rowparams);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TEEVPLPortProperty portProperty = null;
        TL1Operation oper = null;
        OutMsg outMsg = null;
        InMsg inmsg = null;
        int portId = -1;
        String prefix = "";
        String tempStr = "";
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            oper = (TL1Operation)tl1OperList.get(i);
            if (oper.getOutMsgCount() != 0 && (outMsg = oper.getOutMsg(0)).getFault().getErrCode() != "OK") continue;
            inmsg = oper.getInMsg();
            String[] aidSplit = TETL1CommonUtil.parseAID((String)inmsg.getPart("AID").getValue(), (int)this.neid);
            prefix = aidSplit[0];
            portId = Integer.parseInt(aidSplit[3]);
            portId = prefix.equals("FAC") ? portId : portId + 32768;
            portProperty = new TEEVPLPortProperty();
            portProperty.setPortId(portId);
            tempStr = inmsg.getPart("PORTTYPE").getValue();
            if (null != tempStr && !"-".equals(tempStr)) {
                portProperty.setPortType(tempStr);
            }
            if (null != (tempStr = inmsg.getPart("PORTENABLE").getValue()) && !"-".equals(tempStr)) {
                portProperty.setPortEnable(tempStr);
            }
            if (null != (tempStr = inmsg.getPart("TAGTYPE").getValue()) && !"-".equals(tempStr)) {
                portProperty.setPortTag(tempStr);
            }
            portProperty.setMod1(oper.getMod1());
            TEEVPLContainer.getInstance().modifyPortProperty(portId, portProperty);
        }
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
    }

    public static String queryPortType(int neid, String Aid) {
        TL1Definitions tl1definitions = null;
        String portType = "";
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return portType;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation(RTRV_GETH);
        TL1Operation tl1Operation2 = tl1definitions.getTL1Operation(RTRV_XGETH);
        String tmpAid = Aid;
        tl1Operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(tmpAid);
        tl1Operation2.getInMsg().getStagBlock().getAID().getPart(0).setValue(tmpAid);
        tl1OperList.add(tl1Operation);
        tl1OperList.add(tl1Operation2);
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 60);
        if (result.retCode == 0) {
            int len = tl1OperList.size();
            for (int i = 0; i < len; ++i) {
                TL1Operation tOper = (TL1Operation)tl1OperList.get(i);
                int size = tOper.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    HashMap partMap;
                    Part portTypePart;
                    OutMsg output = tOper.getOutMsg(row);
                    if (output.getFault().getCompletionCode() != 0 || (portTypePart = (Part)(partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output)).get("PORTTYPE")) == null) continue;
                    portType = portTypePart.getValue();
                    return portType;
                }
            }
        }
        return portType;
    }
}

