/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPLContainer;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPLPortProperty;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.HashMap;
import java.util.HashSet;

public class TEEVPLQueryPort
extends TETL1NEExplorerBean {
    public TEEVPLQueryPort() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            boolean queryFromNEFlag = false;
            BussinessParams newBussiness = new BussinessParams();
            BussinessParams oldBussiness = inputData.getBussinessParams();
            RowParams rowparams = null;
            String slotIdStr = null;
            int portId = -1;
            TEEVPLPortProperty portProperty = null;
            HashMap portPropertyMap = null;
            Param param = null;
            param = this.inputData.getBussinessParams().getRowParams(0).getParam("queryFromNEFlag");
            if (param != null && "1".equals(param.getValue())) {
                queryFromNEFlag = true;
            } else {
                int len = oldBussiness.getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    rowparams = oldBussiness.getRowParams(i);
                    slotIdStr = rowparams.getParam("slotid").getValue();
                    portId = Integer.parseInt(rowparams.getParam("portid").getValue());
                    portPropertyMap = TEEVPLContainer.getInstance().getPortPropertyMap();
                    if (null != portPropertyMap) {
                        portProperty = (TEEVPLPortProperty)portPropertyMap.get(portId);
                        if (portProperty == null) {
                            queryFromNEFlag = true;
                            break;
                        }
                    } else {
                        queryFromNEFlag = true;
                        break;
                    }
                    RowParams newrow = new RowParams();
                    param = new Param();
                    param.setName("slotid");
                    param.setValue(slotIdStr);
                    newrow.addParam(param);
                    param = new Param();
                    param.setName("shelfName");
                    param.setValue(TETL1CommonUtil.getShelfSlotName((int)neid, (int)Integer.parseInt(slotIdStr)));
                    newrow.addParam(param);
                    param = new Param();
                    param.setName("port");
                    param.setValue("" + portId);
                    newrow.addParam(param);
                    param = new Param();
                    param.setName("PORTTYPE");
                    param.setValue(portProperty.getPortType());
                    newrow.addParam(param);
                    param = new Param();
                    param.setName("PORTENABLE");
                    param.setValue(portProperty.getPortEnable());
                    newrow.addParam(param);
                    param = new Param();
                    param.setName("TAGTYPE");
                    param.setValue(portProperty.getPortTag());
                    newrow.addParam(param);
                    newBussiness.addRowParams(newrow);
                }
                if (!queryFromNEFlag) {
                    this.outputData.setBussinessParams(newBussiness);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    return this.outputData;
                }
            }
            if (queryFromNEFlag) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    TEEVPLContainer.getInstance().setAidAndTypeList(this.aidAndTypeList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        Object[] slotIDArr = this.slotIDList.toArray();
                        int slotID = (Integer)slotIDArr[0];
                        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
                        return this.outputData;
                    }
                }
                this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
                if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    return this.outputData;
                }
                int result = this.sendMessage(neid, this.tl1OperList);
                if (result == 0) {
                    this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList());
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        Param portIdParam = rowparams.getParam("portid");
        Param slotIdParam = rowparams.getParam("slotid");
        int portId = -1;
        int slotId = -1;
        String mod1 = "";
        String cmdCode = "";
        if (slotIdParam != null && slotIdParam.getValue() != null && portIdParam != null && portIdParam.getValue() != null) {
            portId = Integer.parseInt(portIdParam.getValue());
            slotId = Integer.parseInt(slotIdParam.getValue());
            mod1 = this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId);
            if (!mod1.equals("")) {
                cmdCode = tl1Operation.getCmdCode();
                tl1Operation.setName(cmdCode + "-" + mod1);
                tl1Operation.setMod1(mod1);
            }
        }
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        Param portIdParam = null;
        String tempStr = "";
        int slotId = 0;
        int portId = -1;
        String prefix = "";
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIdParam = rowparams.getParam("slotid");
            portIdParam = rowparams.getParam("portid");
            if (slotIdParam == null || slotIdParam.getValue() == null || portIdParam == null || portIdParam.getValue() == null) {
                return false;
            }
            slotId = Integer.parseInt(slotIdParam.getValue());
            portId = Integer.parseInt(portIdParam.getValue());
            prefix = portId < 32768 ? "FAC" : "ACC";
            portId = portId < 32768 ? portId : portId - 32768;
            tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            tempStr = prefix + "-" + tempStr + "-" + portId;
            part.setValue(tempStr);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public Param convertParamValue(Param oldParam, HashMap partmap) {
        Part part = null;
        String tempStr = "";
        int slotId = -1;
        String prefix = "";
        int portId = -1;
        if (oldParam.getName().equals("slotid")) {
            tempStr = "";
            part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                tempStr = part.getValue();
                slotId = TETL1CommonUtil.getNMSlotStr((String)tempStr, (int)this.neid);
                tempStr = String.valueOf(slotId);
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("port")) {
            tempStr = "";
            part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                String[] aidSplit = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
                portId = Integer.parseInt(aidSplit[3]);
                prefix = aidSplit[0];
                portId = prefix.equals("FAC") ? portId : portId + 32768;
                tempStr = String.valueOf(portId);
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("PORTENABLE")) {
            tempStr = "-";
            part = (Part)partmap.get("PORTENABLE");
            if (part != null && part.getValue() != null) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }
}

