/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPL;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPLContainer;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.service.TEEVPLPortProperty;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.TETL1OperationLogInterface;
import com.huawei.nglct.tl1.TETL1OperlogProcessImpl;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEEVPLMgmt
extends TETL1NEExplorerBean {
    private static final int TIME_OUT = 60;
    private static final String EVPL = "EVPL";
    private static final String SHOW_SHARED = "1";
    private static final String STRING_FAC = "FAC";
    private static final String STRING_SLOT = "SLOT";
    private static final String STRING_NULL = "NULL";
    private static final int VCTRUNK_FLAG = 32768;
    private static final int AP3_PORT = 32771;
    private static final int AP4_PORT = 32772;
    private int boardType = -1;
    private int nmSlotId = -1;
    private TETL1OperationLogInterface operlogInterface = new TETL1OperlogProcessImpl();

    protected void printLog() {
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, this.curUser, this.curIpAddress, (ArrayList)this.operlogInterface.getOperationToLogList());
        }
    }

    public TEEVPLMgmt() {
        this.bQueryAidAndType = true;
    }

    public int getTimeOut() {
        return 60;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            int i;
            TEEVPLContainer.getInstance().setAidAndTypeList(this.aidAndTypeList);
            int slotId = -1;
            int portId = -1;
            String mod1 = "";
            String cmdCode = "";
            String aidStr = "";
            String tempStr = "";
            Param param = null;
            TL1Operation operation = null;
            InMsg inMsg = null;
            Part part = null;
            ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            BussinessParams bussiness = inputData.getBussinessParams();
            RowParams rowparams = bussiness.getRowParams(0);
            param = rowparams.getParam("boardType");
            this.boardType = Integer.parseInt(param.getValue());
            param = rowparams.getParam("slotid");
            slotId = Integer.parseInt(param.getValue());
            this.nmSlotId = Integer.parseInt(param.getValue());
            tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)this.nmSlotId);
            ArrayList macPortList = TETL1CommonUtil.getMacPortList((int)neid, (int)this.nmSlotId, (TEAIDAndTypeList)this.aidAndTypeList);
            ArrayList vctrunkPortList = TETL1CommonUtil.getVCTrunkPortList((int)neid, (int)this.nmSlotId, (TEAIDAndTypeList)this.aidAndTypeList);
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            String shelfType = TEBoardUtil.getTl1SubrackType((int)neid, (int)ne.getNEType(), (int)this.nmSlotId);
            int len = macPortList.size();
            for (i = 0; i < len; ++i) {
                portId = (Integer)macPortList.get(i);
                aidStr = "FAC-" + tempStr + "-" + portId;
                operation = tl1definitions.getTL1Operation("RTRV-GETH");
                inMsg = operation.getInMsg();
                part = inMsg.getPart("AID");
                part.setValue(aidStr);
                mod1 = this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId);
                if (mod1.equalsIgnoreCase("UNEQ") || mod1.equalsIgnoreCase("NA") || mod1.equals("")) continue;
                cmdCode = operation.getCmdCode();
                operation.setName(cmdCode + "-" + mod1);
                operation.setMod1(mod1);
                tl1OperList.add(operation);
            }
            len = vctrunkPortList.size();
            for (i = 0; i < len; ++i) {
                portId = (Integer)vctrunkPortList.get(i);
                if (!(!shelfType.equals("SHELF8800T32") && !shelfType.equals("SHELF8800T64") && !shelfType.equals("SHELF8800I") && !shelfType.equals("SHELF8800II") && !shelfType.equals("SHELF8800T16") || this.boardType != 2110 && this.boardType != 2109 || portId != 32771 && portId != 32772)) continue;
                aidStr = "ACC-" + tempStr + "-" + (portId - 32768);
                operation = tl1definitions.getTL1Operation("RTRV-GETH");
                inMsg = operation.getInMsg();
                part = inMsg.getPart("AID");
                part.setValue(aidStr);
                mod1 = this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId);
                if (mod1.equalsIgnoreCase("UNEQ") || mod1.equalsIgnoreCase("NA") || mod1.equals("")) continue;
                cmdCode = operation.getCmdCode();
                operation.setName(cmdCode + "-" + mod1);
                operation.setMod1(mod1);
                tl1OperList.add(operation);
            }
            tl1OperList.addAll(super.convertToTL1Operation(subFunc, inputData, tl1definitions, null));
            return tl1OperList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        Param param = null;
        String tempStr = "";
        if (part.getName().equalsIgnoreCase("LINKFROM")) {
            param = rowparams.getParam("boardType");
            if (null != param) {
                this.boardType = Integer.parseInt(param.getValue());
            }
            slotIdParam = rowparams.getParam("slotid");
            tempStr = "";
            if (slotIdParam != null && slotIdParam.getValue() != null) {
                this.nmSlotId = Integer.parseInt(slotIdParam.getValue());
                tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)this.nmSlotId);
                tempStr = "SLOT-" + tempStr;
            }
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("LINKTO")) {
            slotIdParam = rowparams.getParam("slotid");
            tempStr = "";
            if (slotIdParam != null && slotIdParam.getValue() != null) {
                this.nmSlotId = Integer.parseInt(slotIdParam.getValue());
                tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)this.nmSlotId);
                tempStr = "SLOT-" + tempStr;
            }
            part.setValue(tempStr);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public Param convertParamValue(Param oldParam, HashMap partmap) {
        Part part = null;
        String prefix = "";
        String tempStr = "";
        int portId = -1;
        if (oldParam.getName().equals("upLinkID")) {
            tempStr = "-";
            part = (Part)partmap.get("LINKFROM");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("downLinkID")) {
            tempStr = "-";
            part = (Part)partmap.get("LINKTO");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("linkType")) {
            tempStr = "";
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("direction")) {
            tempStr = "-";
            part = (Part)partmap.get("CTYPE");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("srcPort")) {
            part = (Part)partmap.get("LINKFROM");
            String[] aidSplit = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
            prefix = aidSplit[0];
            tempStr = aidSplit[3];
            portId = Integer.parseInt(tempStr);
            portId = prefix.equals(STRING_FAC) ? portId : portId + 32768;
            tempStr = String.valueOf(portId);
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("srcVlan")) {
            tempStr = "-";
            part = (Part)partmap.get("INTAG");
            if (null != part && null != part.getValue() && STRING_NULL.equals(tempStr = part.getValue())) {
                tempStr = "-";
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("srcSVlan")) {
            tempStr = "-";
            part = (Part)partmap.get("INSTAG");
            if (null != part && null != part.getValue() && STRING_NULL.equals(tempStr = part.getValue())) {
                tempStr = "-";
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("snkPort")) {
            part = (Part)partmap.get("LINKTO");
            String[] aidSplit = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
            prefix = aidSplit[0];
            tempStr = aidSplit[3];
            portId = Integer.parseInt(tempStr);
            portId = prefix.equals(STRING_FAC) ? portId : portId + 32768;
            tempStr = String.valueOf(portId);
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("snkVlan")) {
            tempStr = "-";
            part = (Part)partmap.get("OUTTAG");
            if (null != part && null != part.getValue() && STRING_NULL.equals(tempStr = part.getValue())) {
                tempStr = "-";
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("snkSVlan")) {
            tempStr = "-";
            part = (Part)partmap.get("OUTSTAG");
            if (null != part && null != part.getValue() && STRING_NULL.equals(tempStr = part.getValue())) {
                tempStr = "-";
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("cVlanPri")) {
            tempStr = "-";
            part = (Part)partmap.get("OUTTAGPRI");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("sVlanPri")) {
            tempStr = "-";
            part = (Part)partmap.get("OUTSTAGPRI");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("oamEN")) {
            tempStr = "-";
            part = (Part)partmap.get("OAMFLAG");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        int i;
        TL1Operation tl1Oper = null;
        String mod1 = "";
        OutMsg outMsg = null;
        String linkfrom = null;
        String linkto = null;
        String[] aidSplit = null;
        String fromPrefix = "";
        String toPrefix = "";
        Part part = null;
        HashMap<Integer, TEEVPLPortProperty> portPropertyMap = new HashMap<Integer, TEEVPLPortProperty>();
        TEEVPLPortProperty portProperty = null;
        String prefix = "";
        int portId = -1;
        String tempStr = "";
        Param param = null;
        boolean eplflag = true;
        for (i = tl1OperList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperList.get(i);
            this.operlogInterface.addOperationToLogList(tl1Oper);
            mod1 = tl1Oper.getMod1();
            if (!mod1.equals("FETH") && !mod1.equals("GETH") && !mod1.equals("XGETH")) continue;
            portProperty = new TEEVPLPortProperty();
            if (tl1Oper.getOutMsgCount() == 0 || tl1Oper.getOutMsg(0).getFault().getCompletionCode() != 0) continue;
            part = tl1Oper.getOutMsg(0).getMsgBlock().getPart("AID");
            aidSplit = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
            portId = Integer.parseInt(aidSplit[3]);
            prefix = aidSplit[0];
            portId = prefix.equals(STRING_FAC) ? portId : portId + 32768;
            portProperty.setPortId(portId);
            tempStr = "-";
            part = tl1Oper.getOutMsg(0).getMsgBlock().getPart("PORTTYPE");
            if (part != null && part.getValue() != null) {
                tempStr = part.getValue();
            }
            portProperty.setPortType(tempStr);
            tempStr = "-";
            part = tl1Oper.getOutMsg(0).getMsgBlock().getPart("PORTENABLE");
            if (part != null && part.getValue() != null) {
                tempStr = part.getValue();
            }
            portProperty.setPortEnable(tempStr);
            tempStr = "-";
            part = tl1Oper.getOutMsg(0).getMsgBlock().getPart("TAGTYPE");
            if (part != null && part.getValue() != null) {
                tempStr = part.getValue();
            }
            portProperty.setPortTag(tempStr);
            portProperty.setMod1(mod1);
            portPropertyMap.put(portId, portProperty);
            tl1OperList.remove(i);
        }
        TEEVPLContainer.getInstance().setPortPropertyMap(portPropertyMap);
        int size = tl1OperList.size();
        for (i = 0; i < size; ++i) {
            tl1Oper = (TL1Operation)tl1OperList.get(i);
            if (tl1Oper.getName().equals("RTRV-ETHLINK") && tl1Oper.getOutMsgCount() != 0 && tl1Oper.getOutMsg(0).getFault().getCompletionCode() != 0) {
                eplflag = false;
            }
            if (tl1Oper.getOutMsgCount() == 0 || tl1Oper.getOutMsg(0).getFault().getCompletionCode() != 0 || !tl1Oper.getName().equals("RTRV-ETHLINK")) continue;
            for (int j = tl1Oper.getOutMsgCount() - 1; j >= 0; --j) {
                outMsg = tl1Oper.getOutMsg(j);
                if (!outMsg.getFault().getErrCode().equals("")) continue;
                linkfrom = outMsg.getMsgBlock().getPart("LINKFROM").getValue();
                aidSplit = TETL1CommonUtil.parseAID((String)linkfrom, (int)this.neid);
                fromPrefix = aidSplit[0];
                linkto = outMsg.getMsgBlock().getPart("LINKTO").getValue();
                aidSplit = TETL1CommonUtil.parseAID((String)linkto, (int)this.neid);
                toPrefix = aidSplit[0];
                if (!fromPrefix.equals("VBLP") && !toPrefix.equals("VBLP")) continue;
                tl1Oper.removeOutMsg(outMsg);
            }
            break;
        }
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        if (eplflag) {
            this.addOperationType(this.outputData);
        }
        RowParams[] rowparams = this.inputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i2 = 0; i2 < len; ++i2) {
            param = rowparams[i2].getParam("showShared");
            if (param.getValue().equals(SHOW_SHARED)) continue;
            RowParams[] params = this.outputData.getBussinessParams().getRowParams();
            int size2 = params.length;
            for (int j = 0; j < size2; ++j) {
                RowErrors[] rowerrors = params[j].getRowErrors();
                if (rowerrors.length != 0 || !params[j].getParam("linkType").getValue().equals(EVPL)) continue;
                this.outputData.getBussinessParams().removeRowParams(params[j]);
            }
        }
    }

    public void addOperationType(Datainterface data) {
        HashMap portPropertyMap = TEEVPLContainer.getInstance().getPortPropertyMap();
        RowParams row = null;
        TEEVPL evpl = null;
        TEEVPLPortProperty porProperty = null;
        String tempStr = "";
        Param param = null;
        BussinessParams bussiness = data.getBussinessParams();
        BussinessParams newBussiness = new BussinessParams();
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            evpl = new TEEVPL();
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) {
                newBussiness.addRowParams(row);
            }
            if (row.getParamCount() == 0) continue;
            tempStr = "";
            param = row.getParam("upLinkID");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setUpLinkID(tempStr);
            tempStr = "";
            param = row.getParam("downLinkID");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setDownLinkID(tempStr);
            tempStr = "1WAY";
            param = row.getParam("direction");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setDirection(tempStr);
            tempStr = "";
            param = row.getParam("srcPort");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setSrcPort(tempStr);
            tempStr = "-";
            param = row.getParam("srcVlan");
            if (param != null && param.getValue() != null && param.getValue() != STRING_NULL) {
                tempStr = param.getValue();
            }
            evpl.setSrcCVlan(tempStr);
            tempStr = "-";
            param = row.getParam("srcSVlan");
            if (param != null && param.getValue() != null && param.getValue() != STRING_NULL) {
                tempStr = param.getValue();
            }
            evpl.setSrcSVlan(tempStr);
            tempStr = "";
            param = row.getParam("snkPort");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setSnkPort(tempStr);
            tempStr = "-";
            param = row.getParam("snkVlan");
            if (param != null && param.getValue() != null && param.getValue() != STRING_NULL) {
                tempStr = param.getValue();
            }
            evpl.setSnkCVlan(tempStr);
            tempStr = "-";
            param = row.getParam("snkSVlan");
            if (param != null && param.getValue() != null && param.getValue() != STRING_NULL) {
                tempStr = param.getValue();
            }
            evpl.setSnkSVlan(tempStr);
            tempStr = "-";
            param = row.getParam("cVlanPri");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setCVlanPri(tempStr);
            tempStr = "-";
            param = row.getParam("sVlanPri");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setSVlanPri(tempStr);
            tempStr = "-";
            param = row.getParam("oamEN");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
            }
            evpl.setOamEnable(tempStr);
            tempStr = "";
            param = row.getParam("srcPort");
            if (param != null && param.getValue() != null && (porProperty = (TEEVPLPortProperty)portPropertyMap.get(new Integer(param.getValue()))) != null) {
                tempStr = porProperty.getPortType();
            }
            evpl.setSrcPortType(tempStr);
            tempStr = "";
            param = row.getParam("snkPort");
            if (param != null && param.getValue() != null && (porProperty = (TEEVPLPortProperty)portPropertyMap.get(new Integer(param.getValue()))) != null) {
                tempStr = porProperty.getPortType();
            }
            evpl.setSnkPortType(tempStr);
            if (this.boardType == 60010) {
                evpl.getOperationTypeL4G();
            } else {
                evpl.getOperationTypeTBE();
            }
            param = row.getParam("linkType");
            if (param == null) {
                param = new Param();
                param.setName("linkType");
                row.addParam(param);
            }
            param.setValue(evpl.getLinkType());
            param = row.getParam("operationType");
            if (param == null) {
                param = new Param();
                param.setName("operationType");
                row.addParam(param);
            }
            param.setValue(evpl.getLinkType());
            row = evpl.toRowParams();
            newBussiness.addRowParams(row);
        }
        data.setBussinessParams(newBussiness);
    }
}

