/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.service;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TECreateEVPLBean
extends TETL1NEExplorerBean {
    private static final int TIME_OUT = 180;
    private static int DEL_NUM_ONE_TIME = 30;

    public int getTimeOut() {
        return 180;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        ArrayList oldOperList = null;
        TL1Operation oldOper = null;
        TL1Operation newOper = null;
        InMsg inmsg = null;
        String intag = null;
        String outtag = null;
        ArrayList intagList = new ArrayList();
        ArrayList outtagList = new ArrayList();
        int intagListSize = 0;
        int outtagListSize = 0;
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            oldOperList = this.convertToTL1Operation(subFunc, inputData, tl1definitions, null);
            int size = oldOperList.size();
            for (int i = 0; i < size; ++i) {
                int j;
                oldOper = (TL1Operation)oldOperList.get(i);
                inmsg = oldOper.getInMsg();
                intag = inmsg.getPart("INTAG").getValue();
                outtag = inmsg.getPart("OUTTAG").getValue();
                if (null != intag) {
                    intagList = TETL1CommonUtil.getCvlanRange((String)intag);
                }
                if (null != outtag) {
                    outtagList = TETL1CommonUtil.getCvlanRange((String)outtag);
                }
                intagListSize = intagList.size();
                outtagListSize = outtagList.size();
                if (intagListSize == 0 && outtagListSize == 0) {
                    operList.add(oldOper);
                    continue;
                }
                if (intagListSize != 0 && outtagListSize != 0) {
                    for (j = 0; j < intagListSize; ++j) {
                        intag = (String)intagList.get(j);
                        outtag = (String)outtagList.get(j);
                        newOper = (TL1Operation)oldOper.clone();
                        newOper.getInMsg().getPart("INTAG").setValue(intag);
                        newOper.getInMsg().getPart("OUTTAG").setValue(outtag);
                        operList.add(newOper);
                    }
                    continue;
                }
                if (intagListSize != 0 && outtagListSize == 0) {
                    for (j = 0; j < intagListSize; ++j) {
                        intag = (String)intagList.get(j);
                        newOper = (TL1Operation)oldOper.clone();
                        newOper.getInMsg().getPart("INTAG").setValue(intag);
                        operList.add(newOper);
                    }
                    continue;
                }
                if (intagListSize != 0 || outtagListSize == 0) continue;
                for (j = 0; j < outtagListSize; ++j) {
                    outtag = (String)outtagList.get(j);
                    newOper = (TL1Operation)oldOper.clone();
                    newOper.getInMsg().getPart("OUTTAG").setValue(outtag);
                    operList.add(newOper);
                }
            }
            return operList;
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        Param srcPortParam = null;
        Param snkPortParam = null;
        Param param = null;
        String prefix = "";
        String tempStr = "";
        int slotId = -1;
        int portId = -1;
        if (part.getName().equalsIgnoreCase("LINKFROM")) {
            slotIdParam = rowparams.getParam("slotID");
            srcPortParam = rowparams.getParam("srcPort");
            tempStr = "";
            if (slotIdParam != null && slotIdParam.getValue() != null && srcPortParam != null && srcPortParam.getValue() != null) {
                tempStr = slotIdParam.getValue();
                slotId = Integer.parseInt(tempStr);
                tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
                portId = Integer.parseInt(srcPortParam.getValue());
                prefix = portId < 32768 ? "FAC" : "ACC";
                portId = portId < 32768 ? portId : portId - 32768;
            }
            part.setValue(prefix + "-" + tempStr + "-" + portId);
            return true;
        }
        if (part.getName().equalsIgnoreCase("LINKTO")) {
            slotIdParam = rowparams.getParam("slotID");
            snkPortParam = rowparams.getParam("snkPort");
            tempStr = "";
            if (slotIdParam != null && slotIdParam.getValue() != null && snkPortParam != null && snkPortParam.getValue() != null) {
                tempStr = slotIdParam.getValue();
                slotId = Integer.parseInt(tempStr);
                tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
                portId = Integer.parseInt(snkPortParam.getValue());
                prefix = portId < 32768 ? "FAC" : "ACC";
                portId = portId < 32768 ? portId : portId - 32768;
            }
            part.setValue(prefix + "-" + tempStr + "-" + portId);
            return true;
        }
        if (part.getName().equalsIgnoreCase("INTAG")) {
            tempStr = "";
            param = rowparams.getParam("srcCVlan");
            if (param != null && param.getValue() != null && !(tempStr = param.getValue()).equals("-") && !tempStr.equals("")) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
        }
        if (part.getName().equalsIgnoreCase("OUTTAG")) {
            tempStr = "";
            param = rowparams.getParam("snkCVlan");
            if (param != null && param.getValue() != null && !(tempStr = param.getValue()).equals("-") && !tempStr.equals("")) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
        }
        if (part.getName().equalsIgnoreCase("INSTAG")) {
            tempStr = "";
            param = rowparams.getParam("srcSVlan");
            if (param != null && param.getValue() != null && !(tempStr = param.getValue()).equals("-") && !tempStr.equals("")) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
        }
        if (part.getName().equalsIgnoreCase("OUTSTAG")) {
            tempStr = "";
            param = rowparams.getParam("snkSVlan");
            if (param != null && param.getValue() != null && !(tempStr = param.getValue()).equals("-") && !tempStr.equals("")) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
        }
        if (part.getName().equalsIgnoreCase("OUTTAGPRI")) {
            tempStr = "";
            param = rowparams.getParam("cVlanPri");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
                part.setValue(tempStr);
            } else {
                return false;
            }
        }
        if (part.getName().equalsIgnoreCase("OUTSTAGPRI")) {
            tempStr = "";
            param = rowparams.getParam("sVlanPri");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
            return false;
        }
        if (part.getName().equalsIgnoreCase("CTYPE")) {
            tempStr = "";
            param = rowparams.getParam("direction");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
            return false;
        }
        if (part.getName().equalsIgnoreCase("OAMFLAG")) {
            tempStr = "";
            param = rowparams.getParam("oamEN");
            if (param != null && param.getValue() != null) {
                tempStr = param.getValue();
                part.setValue(tempStr);
                return true;
            }
            return false;
        }
        return super.convertPartValue(part, rowparams);
    }

    public int sendMessage(int neid, ArrayList tl1OperList) {
        OperationResult result = null;
        int retCode = 0;
        ArrayList operList = null;
        int m = DEL_NUM_ONE_TIME;
        int n = tl1OperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList();
            if (i + m > n) {
                operList.addAll(tl1OperList.subList(i, n));
            } else {
                operList.addAll(tl1OperList.subList(i, i + m));
            }
            result = TETL1NECommMgr.getInstance().sendCommand(neid, operList, this.getTimeOut());
            if (result.retCode != 0) break;
        }
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public void addErrorParam(int neid, RowErrors rowError) {
        int slotid = 0;
        int bdtype = 0;
        Param paramTmp = null;
        int shelfID = 0;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (null != rowError.getParam("neid")) {
            paramTmp = new Param("nename", neObj.getNEName());
            rowError.addParam(paramTmp);
        }
        if (null != rowError.getParam("LINKFROM")) {
            try {
                String[] aid = TETL1CommonUtil.parseAID((String)rowError.getParam("LINKFROM").getValue(), (int)neid);
                shelfID = Integer.parseInt(aid[1]);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (shelfID != -1) {
                paramTmp = new Param("subrackID", "Subrack" + shelfID);
                rowError.addParam(paramTmp);
            }
            try {
                slotid = TETL1CommonUtil.getNMSlotStr((String)rowError.getParam("LINKFROM").getValue(), (int)neid);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (slotid != -1) {
                if (null != rowError.getParam("boardtype")) {
                    try {
                        bdtype = Integer.parseInt(rowError.getParam("boardtype").getValue());
                    }
                    catch (NumberFormatException numberEx) {
                        bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                        rowError.getParam("boardtype").setValue(bdtype + "");
                    }
                } else {
                    bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    paramTmp = new Param("boardtype", bdtype + "");
                    rowError.addParam(paramTmp);
                }
                String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, bdtype);
                if (boardName.indexOf("UNKNOWN") == -1) {
                    String showSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)slotid);
                    paramTmp = new Param("boardname", showSlot + "-" + boardName);
                }
                rowError.addParam(paramTmp);
            }
        }
    }
}

