/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.portshaping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.portshaping.TEQoSPortShapingData;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.portshaping.TEQoSPortShapingInstance;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TEQoSQueryPortShapingBean
extends TETL1NEExplorerBean {
    private String slotID = "";
    ArrayList operationList = null;
    private static final int innerPort = 32768;
    private static final String innerAID = "ACC";
    private static final String clientAID = "FAC";

    public TEQoSQueryPortShapingBean() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rParams = inputData.getBussinessParams().getRowParams(0);
        String isQueryFromNE = rParams.getParam("isQueryFromNE").getValue();
        this.slotID = rParams.getParam("slotid").getValue();
        if (!"1".equals(isQueryFromNE)) {
            return this.queryFromMemery(inputData);
        }
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (this.bQueryAidAndType) {
            this.slotIDList = this.getSlotIDFromInputDdata(inputData);
            if (this.slotIDList.size() > 0) {
                this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                if (this.aidAndTypeList == null) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                    return this.outputData;
                }
                if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                    this.addRTRVPORTError(neid, (TENE)ne);
                    return this.outputData;
                }
            }
        }
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.parseInt(this.slotID));
        ArrayList portList = TETL1CommonUtil.getUsableEthPortList((int)neid, (int)Integer.parseInt(this.slotID), (TEAIDAndTypeList)this.aidAndTypeList);
        TEQoSPortShapingData.getInstance().clear();
        Datainterface tempoutputData = new Datainterface();
        try {
            String mod1 = "";
            BussinessParams tempParams = new BussinessParams();
            int rowErrorCount = 0;
            int portListSize = portList.size();
            for (int i = 0; i < portListSize; ++i) {
                Integer portidforquery = (Integer)portList.get(i);
                if (TETL1CommonUtil.isFilterVCTrunkPort((int)neid, (int)boardType, (int)Integer.parseInt(this.slotID), (int)portidforquery) || (mod1 = this.aidAndTypeList.getPayLoadMod2(neid, Integer.parseInt(this.slotID), portidforquery.intValue())).equalsIgnoreCase("UNEQ") || mod1.equalsIgnoreCase("NA")) continue;
                String aidinput = clientAID;
                int relativeportid = portidforquery;
                if (portidforquery > 32768) {
                    aidinput = innerAID;
                    relativeportid = portidforquery - 32768;
                }
                String shelfandslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)Integer.parseInt(this.slotID));
                StringBuffer aidbuff = new StringBuffer(aidinput);
                aidbuff.append("-");
                aidbuff.append(shelfandslot);
                aidbuff.append("-");
                aidbuff.append(relativeportid);
                inputData.getBussinessParams().getRowParams(0).getParam("AID").setValue(aidbuff.toString());
                this.operationList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
                if (null == this.operationList || this.operationList.size() == 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    return this.outputData;
                }
                int result = super.sendMessage(neid, this.operationList);
                if (result != 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    return this.outputData;
                }
                this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
                if (this.isNeedOperationlog()) {
                    this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
                }
                RowParams tempoutputParams = new RowParams();
                tempoutputParams.addParam("port", String.valueOf(portidforquery));
                tempoutputParams.addParam("mod2", mod1);
                if (this.outputData.getBussinessParams().getRowParams(0).getRowErrorsCount() != 0) {
                    ++rowErrorCount;
                    tempoutputParams.addRowErrors(this.outputData.getBussinessParams().getRowParams(0).getRowErrors(0));
                }
                tempParams.addRowParams(tempoutputParams);
            }
            tempoutputData.setBussinessParams(tempParams);
            int totalErrorCode = 0;
            if (rowErrorCount == 0) {
                totalErrorCode = 0;
            } else if (rowErrorCount > 0 && rowErrorCount < portListSize) {
                totalErrorCode = 1;
            } else if (rowErrorCount == portListSize) {
                totalErrorCode = 2;
            }
            tempoutputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)totalErrorCode));
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return tempoutputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
        if (Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()) != 0 && !this.outputData.getErrorMessage().getErrorinfo().equals("")) {
            return;
        }
        ArrayList rParamList = this.outputData.getBussinessParams().getRowParamList();
        RowParams rParam = null;
        String port = "";
        String queueID = "";
        String enable = "";
        String cir = "";
        String dcbs = "";
        String pir = "";
        String dmbs = "";
        HashSet<String> tempPortSet = new HashSet<String>();
        for (int i = rParamList.size() - 1; i >= 0; --i) {
            rParam = (RowParams)rParamList.get(i);
            port = rParam.getParam("port").getValue();
            queueID = rParam.getParam("portqueid").getValue();
            enable = rParam.getParam("enable").getValue();
            cir = rParam.getParam("cir").getValue();
            dcbs = rParam.getParam("dcbs").getValue();
            pir = rParam.getParam("pir").getValue();
            dmbs = rParam.getParam("dmbs").getValue();
            TEQoSPortShapingData.getInstance().addQueue(neid, this.slotID, port, queueID, new TEQoSPortShapingInstance(queueID, enable, cir, dcbs, pir, dmbs));
            if (tempPortSet.contains(port)) {
                rParamList.remove(i);
                continue;
            }
            tempPortSet.add(port);
        }
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equals("slotid")) {
            Part slotaid = (Part)partmap.get("AID");
            int neslotid = TETL1CommonUtil.getNMSlotStr((String)slotaid.getValue(), (int)this.neid);
            oldParam.setValue(neslotid + "");
            return oldParam;
        }
        if (oldParam.getName().equals("port")) {
            Part portaid = (Part)partmap.get("AID");
            String[] portarr = TETL1CommonUtil.parseAID((String)portaid.getValue(), (int)this.neid);
            String aidsign = portarr[0];
            int portvar = Integer.parseInt(portarr[3]);
            if (aidsign.equals(innerAID)) {
                portvar += 32768;
            }
            oldParam.setValue(portvar + "");
            return oldParam;
        }
        oldParam = super.convertParamValue(oldParam, partmap);
        return oldParam;
    }

    private Datainterface queryFromMemery(Datainterface inputData) {
        RowParams rParams = inputData.getBussinessParams().getRowParams(0);
        String port = rParams.getParam("port").getValue();
        this.outputData = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        HashMap queueMap = TEQoSPortShapingData.getInstance().getQueueMapByPort(this.neid, this.slotID, port);
        if (queueMap == null) {
            return this.outputData;
        }
        TEQoSPortShapingInstance tempInstance = null;
        List queueIDList = TEQoSPortShapingData.getInstance().getSortQueueIDList(this.neid, this.slotID, port);
        int size = queueIDList.size();
        for (int i = 0; i < size; ++i) {
            RowParams outputRParams = new RowParams();
            tempInstance = (TEQoSPortShapingInstance)queueMap.get(queueIDList.get(i));
            outputRParams.addParam("portqueid", tempInstance.getPortQueueId());
            outputRParams.addParam("enable", tempInstance.getEnable());
            outputRParams.addParam("cir", tempInstance.getCir());
            outputRParams.addParam("dcbs", tempInstance.getDcbs());
            outputRParams.addParam("pir", tempInstance.getPir());
            outputRParams.addParam("dmbs", tempInstance.getDmbs());
            bParams.addRowParams(outputRParams);
        }
        this.outputData.setBussinessParams(bParams);
        return this.outputData;
    }
}

