/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.portshaping;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.portshaping.TEQoSPortShapingData;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.portshaping.TEQoSPortShapingInstance;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEQoSModifyPortShapingBean
extends TETL1NEExplorerBean {
    private static final int innerPort = 32768;
    private static final String innerAID = "ACC";
    private static final String clientAID = "FAC";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        for (int i = 0; i < inputData.getBussinessParams().getRowParamsCount(); ++i) {
            RowParams intputParams = inputData.getBussinessParams().getRowParams(i);
            String slotid = intputParams.getParam("slotid").getValue();
            String portid = intputParams.getParam("portid").getValue();
            String inputslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)Integer.parseInt(slotid));
            String aid = clientAID;
            if (Integer.parseInt(portid) > 32768) {
                aid = innerAID;
                portid = String.valueOf(Integer.parseInt(portid) - 32768);
            }
            StringBuffer inputaid = new StringBuffer(aid);
            inputaid.append("-");
            inputaid.append(inputslot);
            inputaid.append("-");
            inputaid.append(portid);
            inputData.getBussinessParams().getRowParams(i).getParam("AID").setValue(inputaid.toString());
        }
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation getinfo = (TL1Operation)tl1OperList.get(0);
        InMsg getmsginfo = getinfo.getInMsg();
        String mapaid = getmsginfo.getPart("AID").getValue();
        String[] slotarr = TETL1CommonUtil.parseAID((String)mapaid, (int)neid);
        int mapslotid = TETL1CommonUtil.getNMSlotStr((String)mapaid, (int)neid);
        String mapportid = slotarr[3];
        if (slotarr[0].equalsIgnoreCase(innerAID)) {
            mapportid = String.valueOf(Integer.parseInt(mapportid) + 32768);
        }
        TEQoSPortShapingInstance tempInstance = null;
        for (int i = 0; i < tl1OperList.size(); ++i) {
            TL1Operation tl1oper = (TL1Operation)tl1OperList.get(i);
            if (tl1oper.getOutMsgCount() != 0) continue;
            HashMap queueMap = TEQoSPortShapingData.getInstance().getQueueMapByPort(neid, mapslotid + "", mapportid);
            tempInstance = (TEQoSPortShapingInstance)queueMap.get(tl1oper.getInMsg().getPart("QUEUEID").getValue());
            if (tl1oper.getInMsg().getPart("SHAPINGENABLE").getValue() != null) {
                tempInstance.setEnable(tl1oper.getInMsg().getPart("SHAPINGENABLE").getValue());
            }
            if (tl1oper.getInMsg().getPart("CIR").getValue() != null) {
                tempInstance.setCir(tl1oper.getInMsg().getPart("CIR").getValue());
            }
            if (tl1oper.getInMsg().getPart("PIR").getValue() != null) {
                tempInstance.setPir(tl1oper.getInMsg().getPart("PIR").getValue());
            }
            if (tl1oper.getInMsg().getPart("DCBS").getValue() == null) continue;
            tempInstance.setDcbs(tl1oper.getInMsg().getPart("DCBS").getValue());
        }
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        this.addErrorParams(this.inputData, this.outputData, neid);
    }

    public void addErrorParams(Datainterface inputData, Datainterface outputData, int neid) {
        RowParams rowparams = null;
        Param param = null;
        RowErrors rowerror = null;
        if (outputData == null || outputData.getBussinessParams() == null || inputData == null) {
            return;
        }
        int rowCount = outputData.getBussinessParams().getRowParamsCount();
        if (rowCount == 0) {
            return;
        }
        rowparams = outputData.getBussinessParams().getRowParams(rowCount - 1);
        RowParams inputRow = inputData.getBussinessParams().getRowParams(0);
        String portName = "UNKNOWN";
        int portId = -1;
        String prefix = null;
        if (inputRow != null && (param = inputRow.getParam("portid")) != null && param.getValue() != null) {
            portId = Integer.parseInt(param.getValue());
            prefix = portId < 32768 ? clientAID : innerAID;
            portName = prefix.equals(clientAID) ? "PORT" + portId : "VCTRUNK" + (portId - 32768);
        }
        int size = rowparams.getRowErrorsCount();
        for (int i = 0; i < size; ++i) {
            rowerror = rowparams.getRowErrors(i);
            param = rowerror.getParam("portname");
            if (param == null) {
                param = new Param();
                param.setName("portname");
                param.setValue(portName);
                rowerror.addParam(param);
                continue;
            }
            param.setValue(portName);
        }
    }
}

