/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.qos;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TEQueryCosBean
extends TETL1NEExplorerBean {
    public static final String type1 = "1";
    public static final String type2 = "2";
    public static final String type3 = "3";
    public static final String type4 = "4";
    public static Properties cospara_paramProperties = new Properties();
    public static Properties pri_paramProperties = new Properties();

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        Param cosIDaram = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            StringBuffer sb = new StringBuffer();
            sb.append("COS-");
            slotIDParam = rowparams.getParam("slotid");
            cosIDaram = rowparams.getParam("cosid");
            if (slotIDParam == null || cosIDaram == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append('-').append(cosIDaram.getValue());
            part.setValue(sb.toString());
        }
        return flag;
    }

    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        if (null == tl1OperList) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            return this.outputData;
        }
        int tl1OperSize = tl1OperList.size();
        ArrayList errorData = this.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        if (tl1OperList.isEmpty()) {
            if (null != errorData && !errorData.isEmpty()) {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
            return outputData;
        }
        InMsg input = null;
        OutMsg output = null;
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                output = tl1Operation.getOutMsg(row);
                HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
                for (Map.Entry entry : partmap.entrySet()) {
                    rowparams = new RowParams();
                    String name = (String)entry.getKey();
                    Part value = (Part)entry.getValue();
                    if (name.equals("AID") || name.equals("COSTYPE") || value.getValue() == null || !this.handleRowData(neid, subfunc, rowparams, input, output, value, partmap)) continue;
                    if (null != errorData && !errorData.isEmpty()) {
                        rowparams = new RowParams();
                        int sizei = errorData.size();
                        for (int ii = 0; ii < sizei; ++ii) {
                            rowparams.addRowErrors((RowErrors)errorData.get(ii));
                        }
                    }
                    outputData.getBussinessParams().addRowParams(rowparams);
                }
            }
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (null == errorData || errorData.isEmpty()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output, Part part, HashMap partmap) {
        Part tmpPart = null;
        if (this.isFilterRowData(partmap)) {
            return false;
        }
        Param param = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            param = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            if (null != input) {
                tmpPart = input.getPart(param.getName());
            }
            if (null != tmpPart) {
                param.setValue(tmpPart.getValue());
            }
            if ((param = this.convertParamValue(param, partmap, part)) == null) continue;
            rowparams.addParam(param);
        }
        TETL1DataConverter.addReturnParam((int)neid, (RowParams)rowparams);
        return true;
    }

    public Param convertParamValue(Param oldParam, HashMap partmap, Part part) {
        if (oldParam.getName().equalsIgnoreCase("slotid")) {
            Part AID2 = (Part)partmap.get("AID");
            String[] str = TETL1CommonUtil.parseAID((String)AID2.getValue(), (int)this.neid);
            oldParam.setValue(this.isNull(str[2]));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("cosid")) {
            Part AID3 = (Part)partmap.get("AID");
            String[] str = TETL1CommonUtil.parseAID((String)AID3.getValue(), (int)this.neid);
            oldParam.setValue(this.isNull(str[3]));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("costype")) {
            Part type = (Part)partmap.get("COSTYPE");
            if (type.getValue().equals("SIMPLE")) {
                oldParam.setValue(type1);
            } else if (type.getValue().equals("TAGPRI")) {
                oldParam.setValue(type2);
            } else if (type.getValue().equals("MPLSEXP")) {
                oldParam.setValue(type3);
            } else if (type.getValue().equals("DSCP")) {
                oldParam.setValue(type4);
            } else {
                oldParam.setValue("");
            }
            return oldParam;
        }
        if (this.isCosPara(oldParam, part)) {
            oldParam.setValue(cospara_paramProperties.getProperty(part.getName()));
        }
        if (this.isPriParam(oldParam, part)) {
            Part type = (Part)partmap.get(pri_paramProperties.getProperty(part.getName()));
            oldParam.setValue(this.isNull(type.getValue()));
        }
        return oldParam;
    }

    private boolean isPriParam(Param oldParam, Part part) {
        return oldParam.getName().equalsIgnoreCase("pri") && pri_paramProperties.containsKey(part.getName());
    }

    private boolean isCosPara(Param oldParam, Part part) {
        return oldParam.getName().equalsIgnoreCase("cospara") && cospara_paramProperties.containsKey(part.getName());
    }

    private String isNull(String temp) {
        String str = temp;
        if (str == null) {
            str = "";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCosparaProperties() {
        String cosParamFilePath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "ip" + File.separator + "qos" + File.separator + "cos_cospara.properties";
        InputStream is = null;
        try {
            is = TEResourceManager.getInputStream((String)cosParamFilePath);
            cospara_paramProperties.load(is);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("Load tl1 cospara failed!", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("Close tl1 cospara file failed!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPriProperties() {
        String cosParamFilePath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "ne_attribute" + File.separator + "config" + File.separator + "ip" + File.separator + "qos" + File.separator + "cos_pri.properties";
        InputStream is = null;
        try {
            is = TEResourceManager.getInputStream((String)cosParamFilePath);
            pri_paramProperties.load(is);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("Load tl1 cos pri param failed!", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("Close tl1 cos pri file failed!", (Throwable)e);
                }
            }
        }
    }

    static {
        TEQueryCosBean.loadCosparaProperties();
        TEQueryCosBean.loadPriProperties();
    }
}

