/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.qos;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.qos.TEQosFlowData;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQosFlowCache {
    private Map<Integer, List<TEQosFlowData>> flowDatas = new HashMap<Integer, List<TEQosFlowData>>();
    private int numOfData = 20;
    private double maxVelocity = 0.0;
    private double minVelocity = 0.0;
    private static final int OFFSET = 15;
    static final double INVALIDVALUE = 4.294967295E9;
    private static TEQosFlowCache instance = null;

    private TEQosFlowCache() {
    }

    public double getMinVelocity() {
        return this.minVelocity;
    }

    public List<TEQosFlowData> getFlowDatas(int neid) {
        return this.flowDatas.get(neid);
    }

    public int getNumOfData() {
        return this.numOfData;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public static synchronized TEQosFlowCache getInstance() {
        if (instance == null) {
            instance = new TEQosFlowCache();
        }
        return instance;
    }

    public List<TEQosFlowData> parseFlowData(int neid, Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        RowParams rowParams = null;
        RowErrors rowerror = null;
        TimeZoneDateBean timezone = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        ArrayList<TEQosFlowData> list = new ArrayList<TEQosFlowData>();
        int m = bussiness.getRowParamsCount();
        for (int i = 0; i < m; ++i) {
            rowParams = bussiness.getRowParams(i);
            if (rowParams.getRowErrorsCount() > 0) {
                int n = rowParams.getRowErrorsCount();
                for (int j = 0; j < n; ++j) {
                    rowerror = rowParams.getRowErrors(j);
                    if (rowerror.getParam("begindate") != null) {
                        rowerror.getParam("begindate").setValue("");
                    }
                    if (rowerror.getParam("enddate") == null) continue;
                    rowerror.getParam("enddate").setValue("");
                }
                continue;
            }
            int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            String flowid = rowParams.getParam("flowid").getValue();
            Calendar calendar = TEDateUtils.byteStrToCalendar((String)rowParams.getParam("date").getValue());
            if (calendar == null) {
                return list;
            }
            String values = rowParams.getParam("daterate").getValue();
            TEQosFlowData qosdata = new TEQosFlowData(slotid, flowid);
            calendar.add(12, 15);
            qosdata.setDate(timezone.calendarToTime((Calendar)calendar.clone()));
            qosdata.setFlowVelocity(Double.parseDouble(values));
            list.add(qosdata);
        }
        this.flowDatas.put(neid, list);
        return list;
    }
}

