/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.Part;
import java.util.ArrayList;
import java.util.HashMap;

public class TETL1QueryPortFlowBean
extends TETL1NEExplorerBean {
    public static final String NM_FLUXMON_NO = "0";
    public static final String NM_FLUXMON_YES = "1";
    public static final String NE_FLUXMON_NO = "N";
    public static final String NE_FLUXMON_YES = "Y";

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        Param portIdParam = null;
        Param prefixParam = null;
        int slotId = 0;
        String tempStr = "";
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIdParam = rowparams.getParam("slotid");
            portIdParam = rowparams.getParam("port");
            prefixParam = rowparams.getParam("prefix");
            if (slotIdParam == null || slotIdParam.getValue() == null || portIdParam == null || portIdParam.getValue() == null) {
                return false;
            }
            tempStr = slotIdParam.getValue();
            slotId = Integer.parseInt(tempStr);
            tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            tempStr = prefixParam.getValue() + "-" + tempStr + "-" + portIdParam.getValue();
            part.setValue(tempStr);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public Param convertParamValue(Param oldParam, HashMap partmap) {
        Part AID2 = null;
        Part tempPart = null;
        String tempStr = null;
        int slotId = 0;
        if (oldParam.getName().equals("slotid")) {
            tempStr = "";
            AID2 = (Part)partmap.get("AID");
            if (AID2 != null && AID2.getValue() != null) {
                slotId = TETL1CommonUtil.getNMSlotStr((String)AID2.getValue(), (int)this.neid);
                tempStr = String.valueOf(slotId);
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("port")) {
            tempStr = "";
            AID2 = (Part)partmap.get("AID");
            if (AID2 != null && AID2.getValue() != null) {
                tempStr = this.getSplitPortName(AID2);
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("enable")) {
            tempStr = "-";
            tempPart = (Part)partmap.get("FLUXMON");
            if (tempPart != null && tempPart.getValue() != null) {
                tempStr = this.convertFLUXMON(tempPart.getValue());
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        BussinessParams bussiness = this.outputData.getBussinessParams();
        if (null == bussiness) {
            return;
        }
        RowParams[] rowparamsArr = bussiness.getRowParams();
        Param portnameParam = null;
        Param portParam = null;
        for (RowParams rowparams : rowparamsArr) {
            if (0 != rowparams.getRowErrorsCount()) continue;
            portnameParam = rowparams.getParam("portname");
            portParam = rowparams.getParam("port");
            if (null == portnameParam || null == portParam) continue;
            portnameParam.setValue(portParam.getValue());
        }
    }

    private String convertFLUXMON(String neValue) {
        String nmValue = "-";
        if (NE_FLUXMON_YES.equals(neValue)) {
            nmValue = NM_FLUXMON_YES;
        } else if (NE_FLUXMON_NO.equals(neValue)) {
            nmValue = NM_FLUXMON_NO;
        }
        return nmValue;
    }

    public String getSplitPortName(Part AID2) {
        if (AID2 == null) {
            return "";
        }
        String[] aidSplit = TETL1CommonUtil.parseAID((String)AID2.getValue(), (int)this.neid);
        if (aidSplit.length <= 1) {
            return "NULL";
        }
        String aidPrefix = aidSplit[0];
        int portID = Integer.parseInt(aidSplit[3]);
        String portName = "";
        if (aidPrefix.equals("FAC")) {
            portName = "PORT" + portID;
        } else if (aidPrefix.equals("ACC")) {
            portName = "VCTRUNK" + portID;
        }
        return portName;
    }
}

