/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;

public class TETL1GetPortFlowResBean
extends TETL1NEExplorerBean {
    private static final String NE_ID_PARAM = "neid";
    private static final String SLOT_ID_PARAM = "slotid";
    private static final String NE_NAME_PARAM = "nename";
    private static final String BOARD_NAME_PARAM = "boardname";
    private static final String SUB_CARD_ID_PARAM = "subcardID";
    private static final String PORT_PARAM = "port";
    private static final String PORT_NAME_PARAM = "portname";
    private static final int LGCBD_NOTINSTALL = 24588;
    private int slotID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.curUser = user;
            this.curIpAddress = ipAddress;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            Param param = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)SLOT_ID_PARAM);
            this.slotID = Integer.parseInt(param.getValue());
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
                return this.outputData;
            }
            if (null == TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotID)) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)24588));
                return this.outputData;
            }
            this.getAvaliableBoard();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NEExplorerBean.performBussinessProcess() fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void getAvaliableBoard() {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int boardType = configurDataMgr.getBoard(this.neid, this.slotID).getBoardType();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList macPortList = configurDataMgr.getETHMACPort(this.neid, boardType);
        Collections.sort(macPortList);
        int portNO = -1;
        RowParams rowParam = null;
        int len = macPortList.size();
        for (int i = 0; i < len; ++i) {
            portNO = (Integer)macPortList.get(i);
            rowParam = new RowParams();
            rowParam.addParam(new Param(NE_ID_PARAM, String.valueOf(this.neid)));
            rowParam.addParam(new Param(NE_NAME_PARAM, configurDataMgr.getNEName(this.neid)));
            rowParam.addParam(new Param(SLOT_ID_PARAM, String.valueOf(this.slotID)));
            rowParam.addParam(new Param(BOARD_NAME_PARAM, configurDataMgr.getBoardTypeName(this.neid, boardType)));
            rowParam.addParam(new Param(SUB_CARD_ID_PARAM, "0"));
            rowParam.addParam(new Param(PORT_PARAM, String.valueOf(portNO)));
            rowParam.addParam(new Param(PORT_NAME_PARAM, TEConfigurationDataMgr.getMACName((int)portNO)));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
        ArrayList vctrunkPortList = configurDataMgr.getETHVCTrunkPort(this.neid, boardType);
        Collections.sort(vctrunkPortList);
        int len2 = vctrunkPortList.size();
        for (int i = 0; i < len2; ++i) {
            portNO = (Integer)vctrunkPortList.get(i);
            rowParam = new RowParams();
            rowParam.addParam(new Param(NE_ID_PARAM, String.valueOf(this.neid)));
            rowParam.addParam(new Param(NE_NAME_PARAM, configurDataMgr.getNEName(this.neid)));
            rowParam.addParam(new Param(SLOT_ID_PARAM, String.valueOf(this.slotID)));
            rowParam.addParam(new Param(BOARD_NAME_PARAM, configurDataMgr.getBoardTypeName(this.neid, boardType)));
            rowParam.addParam(new Param(SUB_CARD_ID_PARAM, "0"));
            rowParam.addParam(new Param(PORT_PARAM, String.valueOf(portNO)));
            rowParam.addParam(new Param(PORT_NAME_PARAM, TEConfigurationDataMgr.getVCTrunkName((int)(portNO - 32768))));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

