/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow.TEQosFlowData;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQosFlowCache {
    private Map<Integer, List<TEQosFlowData>> flowDatas = new HashMap<Integer, List<TEQosFlowData>>();
    private int numOfData = 20;
    private double maxVelocity = 0.0;
    private double minVelocity = 0.0;
    private static final int OFFSET = 15;
    private static final int UNITOFFSET = 1;
    static final double INVALIDVALUE = 4.294967295E9;
    private static TEQosFlowCache instance = null;

    public int getNumOfData() {
        return this.numOfData;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public double getMinVelocity() {
        return this.minVelocity;
    }

    public List<TEQosFlowData> getFlowDatas(int neid) {
        return this.flowDatas.get(neid);
    }

    private TEQosFlowCache() {
    }

    public static synchronized TEQosFlowCache getInstance() {
        if (instance == null) {
            instance = new TEQosFlowCache();
        }
        return instance;
    }

    public List<TEQosFlowData> parseFlowData(int neid, Datainterface outputData) {
        BussinessParams bussiness = outputData.getBussinessParams();
        RowParams row = null;
        RowErrors rowerror = null;
        TimeZoneDateBean timezone = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        Calendar calendar = null;
        TEQosFlowData qosdata = null;
        ArrayList<TEQosFlowData> list = new ArrayList<TEQosFlowData>();
        int m = bussiness.getRowParamsCount();
        for (int i = 0; i < m; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) {
                int n = row.getRowErrorsCount();
                for (int j = 0; j < n; ++j) {
                    rowerror = row.getRowErrors(j);
                    if (rowerror.getParam("begindate") != null) {
                        rowerror.getParam("begindate").setValue("");
                    }
                    if (rowerror.getParam("enddate") == null) continue;
                    rowerror.getParam("enddate").setValue("");
                }
                continue;
            }
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int flowid = Integer.parseInt(row.getParam("flowid").getValue());
            int datenum = Integer.parseInt(row.getParam("datenum").getValue());
            calendar = TEDateUtils.byteStrToCalendar((String)row.getParam("date").getValue());
            if (calendar == null) {
                return list;
            }
            String values = row.getParam("daterate").getValue();
            int n = datenum;
            for (int j = 0; j < n; ++j) {
                qosdata = new TEQosFlowData(slotid, flowid);
                if (j > 0) {
                    calendar.add(12, 15);
                }
                qosdata.setDate(timezone.calendarToTime((Calendar)calendar.clone()));
                String value = "0";
                double dbvalue = 0.0;
                if (values.length() < j * 8 + 8) continue;
                value = values.substring(j * 8, j * 8 + 8);
                dbvalue = IOStreamConvertor.readUnSignedPositiveLong((byte[])value.getBytes(), (int)0);
                if (Double.compare(dbvalue, 4.294967295E9) != 0 && Double.compare(this.maxVelocity, dbvalue /= 1.0) < 0) {
                    this.maxVelocity = dbvalue;
                }
                qosdata.setFlowVelocity(dbvalue);
                list.add(qosdata);
            }
        }
        this.flowDatas.put(neid, list);
        return list;
    }
}

