/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow.TEPortFlowCache;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow.TEQosPortFlowData;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TEPortFlowInitTable
extends TETL1NEExplorerBean {
    private static final String TIME_FORMAT_HH_MM_SS = "HH-mm-ss";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.splitTime(inputData);
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        List<TEQosPortFlowData> list = TEPortFlowCache.getInstance().parsePortFlowData(neid, this.tl1OperList);
        if (!list.isEmpty()) {
            BussinessParams bParam = new BussinessParams();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                TEQosPortFlowData temp = list.get(i);
                bParam.addRowParams(temp.toRowParam());
            }
            this.outputData.setBussinessParams(bParam);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TL1Operation oper = null;
        boolean flg = true;
        int ilen = operationList.size();
        for (int i = 0; i < ilen; ++i) {
            oper = (TL1Operation)operationList.get(i);
            if (oper.getOutMsg(0).getFault().getCompletionCode() != 0) continue;
            flg = false;
        }
        if (flg) {
            super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        }
    }

    private void splitTime(Datainterface inputData) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        Calendar beg = TEDateUtils.strToCalendar((String)rowParams.getParam("begindate").getValue(), (String)"yyyy-MM-dd HH:mm:ss");
        Calendar end = TEDateUtils.strToCalendar((String)rowParams.getParam("enddate").getValue(), (String)"yyyy-MM-dd HH:mm:ss");
        this.refTime(beg, false);
        this.refTime(end, true);
        BussinessParams bussiness_new = new BussinessParams();
        Calendar tmp = null;
        RowParams tmpRow = null;
        while (beg.get(5) != end.get(5) || beg.get(2) != end.get(2)) {
            tmp = (Calendar)beg.clone();
            beg.add(5, 1);
            beg.set(11, 0);
            beg.set(12, 0);
            beg.set(13, 0);
            tmpRow = (RowParams)rowParams.clone();
            this.appendTL1Param(tmpRow, tmp, beg);
            bussiness_new.addRowParams(tmpRow);
        }
        if (beg.compareTo(end) < 0) {
            tmpRow = (RowParams)rowParams.clone();
            this.appendTL1Param(tmpRow, beg, end);
            bussiness_new.addRowParams(tmpRow);
        }
        inputData.setBussinessParams(bussiness_new);
    }

    private void appendTL1Param(RowParams rowparams, Calendar beginCalendar, Calendar endCalendar) {
        rowparams.removeParam(rowparams.getParam("begindate"));
        rowparams.removeParam(rowparams.getParam("enddate"));
        rowparams.addParam(new Param("BGNDATE", TEDateUtils.calendarToStrYmd((Calendar)beginCalendar)));
        rowparams.addParam(new Param("BGNTIME", TEDateUtils.calendarToStr((Calendar)beginCalendar, (String)TIME_FORMAT_HH_MM_SS)));
        rowparams.addParam(new Param("ENDDATE", TEDateUtils.calendarToStrYmd((Calendar)endCalendar)));
        rowparams.addParam(new Param("ENDTIME", TEDateUtils.calendarToStr((Calendar)endCalendar, (String)TIME_FORMAT_HH_MM_SS)));
        String aidStr = this.getAIDStr(rowparams);
        rowparams.addParam(new Param("AID", aidStr));
    }

    private String getAIDStr(RowParams rowparams) {
        String aidStr = "";
        Param slotIdParam = rowparams.getParam("slotid");
        Param portIdParam = rowparams.getParam("port");
        if (slotIdParam == null || slotIdParam.getValue() == null || portIdParam == null || portIdParam.getValue() == null) {
            return aidStr;
        }
        int slotId = Integer.parseInt(slotIdParam.getValue());
        int portID = Integer.parseInt(portIdParam.getValue());
        String prefix = portID > 32768 ? "ACC" : "FAC";
        String shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
        int tmpPort = portID > 32768 ? portID - 32768 : portID;
        aidStr = prefix + "-" + shelfSlotStr + "-" + tmpPort;
        return aidStr;
    }

    private void refTime(Calendar cal, boolean flg) {
        int sec;
        int basicTime = 900;
        int min = cal.get(12);
        int total = min * 60 + (sec = cal.get(13));
        if (total % basicTime != 0) {
            cal.set(12, 0);
            cal.set(13, 0);
            if (flg) {
                cal.add(13, (total / basicTime + 1) * basicTime);
            } else {
                cal.add(13, total / basicTime * basicTime);
            }
        }
    }
}

