/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow;

import com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow.TEQosPortFlowData;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEPortFlowCache {
    private static final String PARAM_TXRATE = "TXRATE";
    private static final String PARAM_RXRATE = "RXRATE";
    private static final String PARAM_RECTIME = "RECTIME";
    private static final String PARAM_RECDATE = "RECDATE";
    private static final String PARAM_AID = "AID";
    private Map<Integer, List<TEQosPortFlowData>> flowDatas = new HashMap<Integer, List<TEQosPortFlowData>>();
    private int numOfData = 20;
    private double maxVelocity = 0.0;
    private double minVelocity = 0.0;
    static final double INVALIDVALUE = 4.294967295E9;
    private static TEPortFlowCache instance = null;

    public int getNumOfData() {
        return this.numOfData;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = maxVelocity;
    }

    public double getMinVelocity() {
        return this.minVelocity;
    }

    public void setFlowDatas(Map<Integer, List<TEQosPortFlowData>> flowDatas) {
        this.flowDatas = flowDatas;
    }

    public List<TEQosPortFlowData> getFlowDatas(int neid) {
        return this.flowDatas.get(neid);
    }

    private TEPortFlowCache() {
    }

    public static synchronized TEPortFlowCache getInstance() {
        if (instance == null) {
            instance = new TEPortFlowCache();
        }
        return instance;
    }

    public List<TEQosPortFlowData> parsePortFlowData(int neid, List opers) {
        String calendar = null;
        TEQosPortFlowData qosdata = null;
        ArrayList<TEQosPortFlowData> list = new ArrayList<TEQosPortFlowData>();
        int ilen = opers.size();
        for (int i = 0; i < ilen; ++i) {
            TL1Operation oper = (TL1Operation)opers.get(i);
            for (OutMsg outPut : oper.getOutMsg()) {
                if (0 != Integer.valueOf(outPut.getFault().getCompletionCode())) continue;
                String aidStr = this.getPartValue(outPut, PARAM_AID);
                int slotid = this.getSlotID(neid, aidStr);
                int port = this.getPortID(neid, aidStr);
                calendar = this.getDate(this.getPartValue(outPut, PARAM_RECDATE), this.getPartValue(outPut, PARAM_RECTIME));
                double rxData = Double.valueOf(this.getPartValue(outPut, PARAM_RXRATE));
                double txData = Double.valueOf(this.getPartValue(outPut, PARAM_TXRATE));
                if (Double.compare(rxData, 4.294967295E9) != 0 && Double.compare(this.maxVelocity, rxData) < 0) {
                    this.maxVelocity = rxData;
                }
                if (Double.compare(txData, 4.294967295E9) != 0 && Double.compare(this.maxVelocity, txData) < 0) {
                    this.maxVelocity = txData;
                }
                qosdata = new TEQosPortFlowData(slotid, port);
                qosdata.setDate(calendar);
                qosdata.setFlowVelocityIn(rxData);
                qosdata.setFlowVelocityOut(txData);
                list.add(qosdata);
            }
        }
        this.flowDatas.put(neid, list);
        return list;
    }

    private String getPartValue(OutMsg outPut, String partName) {
        String partValue = "";
        if (null == outPut.getMsgBlock()) {
            return partValue;
        }
        if (null == outPut.getMsgBlock().getPart(partName)) {
            return partValue;
        }
        return outPut.getMsgBlock().getPart(partName).getValue();
    }

    private int getSlotID(int neID, String aidStr) {
        int slotID = -1;
        if (null != aidStr) {
            slotID = TETL1CommonUtil.getNMSlotStr((String)aidStr, (int)neID);
        }
        return slotID;
    }

    private int getPortID(int neID, String aidStr) {
        int portID = -1;
        if (null != aidStr) {
            String[] aidSplit = TETL1CommonUtil.parseAID((String)aidStr, (int)neID);
            if (aidSplit.length <= 1) {
                return portID;
            }
            String aidPrefix = aidSplit[0];
            int tempPortID = Integer.parseInt(aidSplit[3]);
            if (aidPrefix.equals("FAC")) {
                portID = tempPortID;
            } else if (aidPrefix.equals("ACC")) {
                portID = 32768 + portID;
            }
        }
        return portID;
    }

    private String getDate(String recdate, String rectime) {
        return recdate + ' ' + rectime.replace('-', ':');
    }
}

