/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow;

import com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow.TEPortFlowCache;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.portflow.TEQosPortFlowData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

public class TEDrawPortFlowPic {
    private static final String BASE_PATH = "ip" + File.separator + "sdh" + File.separator + "res" + File.separator;
    private static final String PAKAGE_PATH = BASE_PATH + "qos_u2kv1r2" + File.separator + "flowchart_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private String labelX = "labelx";
    private String labelY = "labely";
    private String tl1input = "Input";
    private String tl1output = "Output";
    List<TEQosPortFlowData> tl1data = null;
    private static final int PIC_HEIGHT = 379;
    private static final int PIC_WIDTH = 900;
    private BufferedImage flowImage = new BufferedImage(900, 379, 1);
    private Color standcoler = new Color(239, 239, 239);
    private int xLeft = 115;
    private int xRight = 885;
    private int yTop = 8;
    private int yBottom = 344;
    private int yGridNum = 20;
    private int minXSclae = 2;
    private static double yGridValue = 0.05;
    private static final String inval = "4294967295";
    DecimalFormat format = new DecimalFormat("0.0");
    private static TEDrawPortFlowPic instance = null;

    private TEDrawPortFlowPic() {
    }

    public static synchronized TEDrawPortFlowPic getInstance() {
        if (instance == null) {
            instance = new TEDrawPortFlowPic();
        }
        return instance;
    }

    public BufferedImage drawBitTestPic(int neid) {
        this.initResource(neid);
        this.tl1data = TEPortFlowCache.getInstance().getFlowDatas(neid);
        if (this.tl1data == null) {
            this.drawInitPic();
        } else {
            this.drawDataPic();
        }
        return this.flowImage;
    }

    private void initResource(int neid) {
        this.labelX = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelX);
        this.labelY = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.labelY);
        this.tl1input = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.tl1input);
        this.tl1output = TEGetFilePath.getResource((int)neid, (String)PAKAGE_PATH).getString(this.tl1output);
    }

    public void drawInitPic() {
        Graphics2D wavegtl12d = this.getSVGGraphics();
        this.paintFrame(wavegtl12d);
        this.paintYScale(wavegtl12d, yGridValue);
    }

    private void drawDataPic() {
        Graphics2D wavegtl12d = this.getSVGGraphics();
        this.paintFrame(wavegtl12d);
        double maxYValue = TEPortFlowCache.getInstance().getMaxVelocity();
        double scaleValue = yGridValue;
        if (maxYValue > (double)this.yGridNum * yGridValue) {
            scaleValue = maxYValue / (double)this.yGridNum;
        }
        this.paintYScale(wavegtl12d, scaleValue);
        this.paintXScale(wavegtl12d);
        this.paintFlowData(wavegtl12d, scaleValue);
    }

    public Graphics2D getSVGGraphics() {
        return (Graphics2D)this.flowImage.getGraphics();
    }

    public void paintFrame(Graphics2D tl1dc) {
        FontMetrics fontmetri = tl1dc.getFontMetrics();
        Font tmpFont = tl1dc.getFont();
        int speedW = fontmetri.stringWidth(this.labelX);
        tl1dc.setFont(new Font("Dialog", 0, 10));
        this.xLeft = speedW + fontmetri.stringWidth(inval);
        tl1dc.setFont(tmpFont);
        tl1dc.setColor(this.standcoler);
        tl1dc.fillRect(0, 0, 900, 379);
        tl1dc.setColor(Color.LIGHT_GRAY);
        tl1dc.fillRect(this.xLeft, this.yTop, this.xRight - this.xLeft, this.yBottom - this.yTop);
        tl1dc.setColor(Color.BLACK);
        tl1dc.drawLine(this.xLeft, this.yBottom, this.xRight, this.yBottom);
        tl1dc.drawLine(this.xLeft, this.yBottom, this.xLeft, this.yTop);
        Font biggerFont = new Font("Dialog", 0, 14);
        tl1dc.setColor(Color.BLACK);
        tl1dc.setFont(biggerFont);
        tl1dc.drawString(this.labelX, 3, this.yBottom / 2);
        tl1dc.drawString(this.labelY, this.xRight / 2, this.yBottom + 33);
        tl1dc.drawString(this.tl1input, this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6, this.yBottom + 33);
        tl1dc.drawString(this.tl1output, this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.tl1input) + 40, this.yBottom + 33);
        tl1dc.setColor(Color.BLUE);
        tl1dc.fillRect(this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.tl1input) + 10, this.yBottom + 27, 20, 5);
        tl1dc.setColor(Color.GREEN);
        tl1dc.fillRect(this.xRight / 2 + fontmetri.stringWidth(this.labelY) + this.xRight / 6 + fontmetri.stringWidth(this.tl1input) + fontmetri.stringWidth(this.tl1output) + 55, this.yBottom + 27, 20, 5);
    }

    public void paintYScale(Graphics2D tl1dc, double scaleValue) {
        BasicStroke normal = new BasicStroke();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 6.0f, 0.0f, 6.0f}, 0.0f);
        FontMetrics fontmetri = tl1dc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        Font smallerFont = new Font("Dialog", 0, 10);
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        for (int i = 0; i <= this.yGridNum; ++i) {
            tl1dc.setColor(Color.BLACK);
            tl1dc.setStroke(normal);
            tl1dc.setFont(normalFont);
            tl1dc.drawLine(this.xLeft - 2, this.yBottom - y_gridh * i, this.xLeft + 2, this.yBottom - y_gridh * i);
            int cswidth = fontmetri.stringWidth(this.format.format(scaleValue) + "");
            int csheight = fontmetri.getHeight();
            tl1dc.setColor(Color.BLACK);
            tl1dc.setFont(smallerFont);
            tl1dc.drawString(this.format.format(scaleValue * (double)i) + "", this.xLeft - cswidth, this.yBottom - y_gridh * i + csheight / 4);
            if (i == 0) continue;
            tl1dc.setColor(Color.WHITE);
            tl1dc.setStroke(dotted);
            tl1dc.drawLine(this.xLeft + 2, this.yBottom - y_gridh * i, this.xRight, this.yBottom - y_gridh * i);
        }
    }

    public void paintXScale(Graphics2D tl1dc) {
        BasicStroke normal = new BasicStroke();
        FontMetrics fontmetri = tl1dc.getFontMetrics();
        Font normalFont = new Font("Dialog", 0, 12);
        int xGridNum = this.tl1data.size();
        if (xGridNum <= 0) {
            return;
        }
        int x_gridw = (this.xRight - this.xLeft) / xGridNum;
        tl1dc.setStroke(normal);
        tl1dc.setFont(normalFont);
        int gap = 0;
        if (x_gridw < this.minXSclae) {
            x_gridw = this.minXSclae;
            gap = xGridNum * x_gridw % (this.xRight - this.xLeft) == 0 ? xGridNum * x_gridw / (this.xRight - this.xLeft) : xGridNum * x_gridw / (this.xRight - this.xLeft) + 1;
        }
        int tmpX = 0;
        int basLen = 0;
        for (int j = 0; j < xGridNum; ++j) {
            if (gap != 0) {
                if (j % gap != 0) continue;
                basLen = j / gap;
            } else {
                basLen = j;
            }
            tl1dc.setColor(Color.BLACK);
            tl1dc.drawLine(this.xLeft + x_gridw * basLen, this.yBottom + 2, this.xLeft + x_gridw * basLen, this.yBottom - 2);
            tl1dc.setColor(Color.BLUE);
            tl1dc.drawLine(this.xLeft + x_gridw * basLen, this.yBottom + 2, this.xLeft + x_gridw * basLen, this.yBottom - 5);
            String scale = this.tl1data.get(j).getDate();
            int cswidth = fontmetri.stringWidth(scale);
            if (tmpX >= this.xLeft + x_gridw * basLen - cswidth / 2 - 20) continue;
            tl1dc.drawString(scale, this.xLeft + x_gridw * basLen - cswidth / 2, this.yBottom + 20);
            tmpX = this.xLeft + x_gridw * basLen - cswidth / 2 + cswidth;
        }
    }

    public void paintFlowData(Graphics2D tl1dc, double yScaleValue) {
        BasicStroke normal = new BasicStroke();
        int xScaleNum = this.tl1data.size();
        if (xScaleNum <= 0) {
            return;
        }
        int y_gridh = (this.yBottom - this.yTop) / this.yGridNum;
        int x_gridw = (this.xRight - this.xLeft) / xScaleNum;
        tl1dc.setColor(Color.BLUE);
        tl1dc.setStroke(normal);
        TEQosPortFlowData inTl1Tmp1 = null;
        TEQosPortFlowData inTl1Tmp2 = null;
        int gap = 0;
        int tmpXCount = 0;
        boolean firstFlg = false;
        if (x_gridw < this.minXSclae) {
            x_gridw = this.minXSclae;
            gap = xScaleNum * x_gridw % (this.xRight - this.xLeft) == 0 ? xScaleNum * x_gridw / (this.xRight - this.xLeft) : xScaleNum * x_gridw / (this.xRight - this.xLeft) + 1;
        }
        int basLen = 0;
        int len = xScaleNum;
        for (int i = 0; i < len; ++i) {
            if (gap != 0) {
                if (i % gap != 0) continue;
                basLen = i / gap;
            } else {
                basLen = i;
            }
            inTl1Tmp1 = this.tl1data.get(i);
            if (firstFlg) {
                ++tmpXCount;
            }
            if (Double.compare(inTl1Tmp1.getFlowVelocityIn(), 4.294967295E9) == 0) continue;
            int y1 = this.compute(inTl1Tmp1.getFlowVelocityIn(), yScaleValue, y_gridh);
            firstFlg = true;
            tl1dc.fillOval(this.xLeft + x_gridw * basLen - 3, this.yBottom - y1 - 3, 6, 6);
            if (inTl1Tmp2 != null && Double.compare(inTl1Tmp2.getFlowVelocityIn(), 4.294967295E9) != 0) {
                int y2 = this.compute(inTl1Tmp2.getFlowVelocityIn(), yScaleValue, y_gridh);
                tl1dc.drawLine(this.xLeft + x_gridw * (basLen - tmpXCount), this.yBottom - y2, this.xLeft + x_gridw * basLen, this.yBottom - y1);
                tmpXCount = 0;
            }
            inTl1Tmp2 = inTl1Tmp1;
        }
        tl1dc.setColor(Color.GREEN);
        tl1dc.setStroke(normal);
        TEQosPortFlowData outTl1Tmp1 = null;
        TEQosPortFlowData outTl1Tmp2 = null;
        firstFlg = false;
        tmpXCount = 0;
        basLen = 0;
        int len2 = xScaleNum;
        for (int i = 0; i < len2; ++i) {
            if (gap != 0) {
                if (i % gap != 0) continue;
                basLen = i / gap;
            } else {
                basLen = i;
            }
            outTl1Tmp1 = this.tl1data.get(i);
            if (firstFlg) {
                ++tmpXCount;
            }
            if (Double.compare(outTl1Tmp1.getFlowVelocityOut(), 4.294967295E9) == 0) continue;
            int y1 = this.compute(outTl1Tmp1.getFlowVelocityOut(), yScaleValue, y_gridh);
            tl1dc.fillOval(this.xLeft + x_gridw * basLen - 3, this.yBottom - y1 - 3, 6, 6);
            firstFlg = true;
            if (outTl1Tmp2 != null && Double.compare(outTl1Tmp2.getFlowVelocityOut(), 4.294967295E9) != 0) {
                int y2 = this.compute(outTl1Tmp2.getFlowVelocityOut(), yScaleValue, y_gridh);
                tl1dc.drawLine(this.xLeft + x_gridw * (basLen - tmpXCount), this.yBottom - y2, this.xLeft + x_gridw * basLen, this.yBottom - y1);
                tmpXCount = 0;
            }
            outTl1Tmp2 = outTl1Tmp1;
        }
    }

    private int compute(double value, double yScaleValue, int tl1gap) {
        BigDecimal inData = new BigDecimal(value);
        BigDecimal yScl = new BigDecimal(yScaleValue);
        BigDecimal grad = new BigDecimal(tl1gap);
        return inData.divide(yScl, 2, 5).multiply(grad).intValue();
    }
}

