/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.macforbid;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;

public class TEGetAvailPort
extends TETL1NEExplorerBean {
    private Datainterface datainterface = null;
    int neID = 0;
    int slotID = 0;
    int VCTRUNK_BASIC = 32768;
    private Logger log = TELogFactory.getNormalLogger();

    public TEGetAvailPort() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        this.slotID = Integer.parseInt(slotidParam.getValue());
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (this.bQueryAidAndType) {
            this.slotIDList = this.getSlotIDFromInputDdata(inputData);
            if (this.slotIDList.size() > 0) {
                this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                if (this.aidAndTypeList == null) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                    return this.outputData;
                }
                if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                    this.addRTRVPORTError(neid, (TENE)ne);
                    return this.outputData;
                }
            }
        }
        this.datainterface = this.constructPortData();
        if (null != this.datainterface && null != this.datainterface.getBussinessParams()) {
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.log.error("Get BoardInfo Fail!\n");
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        return this.datainterface;
    }

    public Datainterface constructPortData() {
        String portname;
        RowParams rParams;
        int portID;
        int j;
        Datainterface data = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        Param param = null;
        String mod1 = "";
        int boardType = TEConfigurationDataMgr.getInstance().getBoard(this.neID, this.slotID).getBoardType();
        ArrayList boardPortList = TETL1CommonUtil.getVCTrunkPortList((int)this.neID, (int)this.slotID, (TEAIDAndTypeList)this.aidAndTypeList);
        int len = boardPortList.size();
        for (j = 0; j < len; ++j) {
            portID = (Integer)boardPortList.get(j);
            if (TETL1CommonUtil.isFilterVCTrunkPort((int)this.neID, (int)boardType, (int)this.slotID, (int)portID)) continue;
            rParams = new RowParams();
            portname = "";
            if (portID > this.VCTRUNK_BASIC) {
                portname = "VCTRUNK" + (portID - this.VCTRUNK_BASIC);
            }
            param = new Param("portname", portname);
            rParams.addParam(param);
            param = new Param("port", portname);
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        boardPortList.clear();
        boardPortList = TETL1CommonUtil.getMacPortList((int)this.neID, (int)this.slotID, (TEAIDAndTypeList)this.aidAndTypeList);
        len = boardPortList.size();
        for (j = 0; j < len; ++j) {
            portID = (Integer)boardPortList.get(j);
            mod1 = this.aidAndTypeList.getPayLoadMod2(this.neID, this.slotID, portID);
            if (mod1.equalsIgnoreCase("UNEQ") || mod1.equalsIgnoreCase("NA")) continue;
            rParams = new RowParams();
            portname = "PORT" + portID;
            param = new Param("portname", portname);
            rParams.addParam(param);
            param = new Param("port", portname);
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        data.setBussinessParams(bParams);
        return data;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

