/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.linkaggregation.mclag;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TEQueryMCLagPort
extends TETL1NEExplorerBean {
    private List ethnPortList = new ArrayList();
    private static final int VCTRUNK_BASE = 32768;

    public TEQueryMCLagPort() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.curUser = user;
        this.curIpAddress = ipAddress;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.neType = ne.getNEType();
        this.slotIDList = this.getSlotIDFromInputDdata(inputData);
        if (this.slotIDList.size() > 0) {
            this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
            if (this.aidAndTypeList == null) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                return this.outputData;
            }
            if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                this.addRTRVPORTError(neid, (TENE)ne);
                return this.outputData;
            }
        }
        this.getPortAndVCtrunk(neid, inputData);
        this.constructOutputData();
        return this.outputData;
    }

    private void getPortAndVCtrunk(int neid, Datainterface inputData) {
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int slotID = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"slotid").getValue());
        this.ethnPortList.addAll(TETL1CommonUtil.getUsableEthPortList((int)neid, (int)slotID, (TEAIDAndTypeList)this.aidAndTypeList));
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("AID")) {
            String slotstr = rowparams.getParam("slotid").getValue();
            String aidPre = rowparams.getParam("aidpre").getValue();
            String neslotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotstr));
            String aid = aidPre + "-" + neslotStr + "-" + "ALL";
            part.setValue(aid);
            return true;
        }
        if (part.getName().equalsIgnoreCase("LAGAID")) {
            String slotstr = rowparams.getParam("slotid").getValue();
            String aidPre = rowparams.getParam("aidpre").getValue();
            String neslotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotstr));
            String aid = aidPre + "-" + neslotStr + "-" + "ALL";
            part.setValue(aid);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    private void constructOutputData() {
        this.outputData.setBussinessParams(new BussinessParams());
        if (this.ethnPortList.size() > 0) {
            Option option;
            Integer portId;
            RowParams rowParams = new RowParams();
            Param param = new Param("mainPort", "");
            int mm = this.ethnPortList.size();
            for (int ii = 0; ii < mm; ++ii) {
                portId = (Integer)this.ethnPortList.get(ii);
                if (portId > 32768) continue;
                option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            param = new Param("southPort", "");
            int nn = this.ethnPortList.size();
            for (int jj = 0; jj < nn; ++jj) {
                portId = (Integer)this.ethnPortList.get(jj);
                option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }
}

