/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.linkaggregation;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TEQueryLagPort
extends TETL1NEExplorerBean {
    private Set usedPortSet = new HashSet();
    private Set ethnPortList = new HashSet();
    private Set servicePortSet = new HashSet();
    private Set allEthPortList = new HashSet();

    public TEQueryLagPort() {
        this.bQueryAidAndType = true;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        if (part.getName().equalsIgnoreCase("LINKFROM")) {
            part.setValue("ALL");
        } else if (part.getName().equalsIgnoreCase("LINKTO")) {
            part.setValue("ALL");
        } else if (part.getName().equals("AID")) {
            StringBuffer sb = new StringBuffer();
            slotIDParam = rowparams.getParam("slotid");
            sb.append("FAC-");
            if (slotIDParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append("ALL");
            part.setValue(sb.toString());
        } else {
            return super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                if (null == tl1Operation) continue;
                tl1Operation.clearCmdFaultInfo();
                this.changeMod2(tl1Operation, rowparams);
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
                if (!tl1Operation.getName().equals("RTRV-LAG")) continue;
                TL1Operation anOther = (TL1Operation)tl1Operation.clone();
                String aid = anOther.getInMsg().getPart("AID").getValue();
                aid = aid.replaceAll("FAC", "ACC");
                anOther.getInMsg().getPart("AID").setValue(aid);
                tl1OperList.add(anOther);
            }
        }
        return tl1OperList;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.getPortAndVCtrunk(neid, this.inputData);
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        int len = tl1OperList.size();
        for (int t = 0; t < len; ++t) {
            tempOperationList.add(((TL1Operation)tl1OperList.get(t)).clone());
        }
        Param[] params = this.inputData.getBussinessParams().getRowParams(0).getParam();
        Param boardTypeParam = Datainterface.getParam((Param[])params, (String)"boardType");
        Param slotTypeParam = Datainterface.getParam((Param[])params, (String)"slotid");
        int slotId = Integer.parseInt(slotTypeParam.getValue());
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation temp = (TL1Operation)tl1OperList.get(i);
            if (temp.getName().equals("RTRV-LAG")) {
                this.getLagPorts(temp);
                continue;
            }
            if (!temp.getName().equals("RTRV-ETHLINK")) continue;
            this.getEthLinkPorts(temp, slotId);
        }
        Iterator it = this.usedPortSet.iterator();
        while (it.hasNext()) {
            String port = String.valueOf(it.next());
            Iterator itEth = this.ethnPortList.iterator();
            while (itEth.hasNext()) {
                Integer temp = (Integer)itEth.next();
                if (!String.valueOf(temp).equals(port)) continue;
                itEth.remove();
            }
        }
        this.servicePortSet.removeAll(this.usedPortSet);
        this.outputData.setBussinessParams(new BussinessParams());
        TENE ne = TENEListUtils.getNEObj((int)neid);
        String shelfType = TEBoardUtil.getTl1SubrackType((int)neid, (int)ne.getNEType(), (int)slotId);
        if (this.ethnPortList.size() > 0) {
            RowParams rowParams = new RowParams();
            Param param = new Param("mainport", "");
            ArrayList list = new ArrayList(this.ethnPortList);
            Collections.sort(list);
            ArrayList alllist = new ArrayList(this.allEthPortList);
            Collections.sort(alllist);
            int nn = this.allEthPortList.size();
            for (int ii = 0; ii < nn; ++ii) {
                Option option;
                Integer portId = (Integer)alllist.get(ii);
                int bdType = Integer.parseInt(boardTypeParam.getValue());
                if (bdType == 60031 && portId == 3) continue;
                if (portId < 50) {
                    option = new Option(String.valueOf("PORT" + portId));
                    param.addOption(option);
                }
                if (!this.isFilterPort(shelfType, bdType, portId) || portId <= Short.MAX_VALUE) continue;
                option = new Option(String.valueOf("VCTRUNK" + (portId - 32768)));
                param.addOption(option);
            }
            rowParams.addParam(param);
            Iterator ita = this.servicePortSet.iterator();
            while (ita.hasNext()) {
                String port = String.valueOf(ita.next());
                Iterator itn = this.ethnPortList.iterator();
                while (itn.hasNext()) {
                    Integer temp = (Integer)itn.next();
                    if (!String.valueOf(temp).equals(port)) continue;
                    itn.remove();
                }
            }
            param = new Param("branchport", "");
            int nn2 = this.ethnPortList.size();
            for (int jj = 0; jj < nn2; ++jj) {
                Option option;
                int bdType = Integer.parseInt(boardTypeParam.getValue());
                Integer portId = (Integer)list.get(jj);
                if (bdType == 60031 && portId == 3) continue;
                if (portId < 50) {
                    option = new Option(String.valueOf("PORT" + portId));
                    param.addOption(option);
                }
                if (!this.isFilterPort(shelfType, bdType, portId) || portId <= Short.MAX_VALUE) continue;
                option = new Option(String.valueOf("VCTRUNK" + (portId - 32768)));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private boolean isFilterPort(String shelfType, int bdType, Integer portId) {
        return !shelfType.equals("SHELF8800T32") && !shelfType.equals("SHELF8800T64") || bdType != 2109 && bdType != 2110 || portId <= 32770;
    }

    private void getEthLinkPorts(TL1Operation ethLink, int slotID) {
        if (ethLink == null) {
            return;
        }
        for (OutMsg out : ethLink.getOutMsg()) {
            if (out.getFault().getCompletionCode() != 0) continue;
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            for (Map.Entry entry : partmap.entrySet()) {
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (!name.equals("LINKFROM") && !name.equals("LINKTO")) continue;
                String[] str = TETL1CommonUtil.parseAID((String)value.getValue(), (int)this.neid);
                if (slotID != TETL1CommonUtil.getNMSlotStr((String)value.getValue(), (int)this.neid)) continue;
                if (str[0].equals("FAC")) {
                    this.usedPortSet.add(str[3]);
                    continue;
                }
                if (!str[0].equals("ACC")) continue;
                int port = Integer.parseInt(str[3]) + 32768;
                this.usedPortSet.add(String.valueOf(port));
            }
        }
    }

    private void getLagPorts(TL1Operation lag) {
        if (lag == null) {
            return;
        }
        for (OutMsg out : lag.getOutMsg()) {
            if (out.getFault().getCompletionCode() != 0) continue;
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            for (Map.Entry entry : partmap.entrySet()) {
                int i;
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (name.equals("AID")) {
                    String[] str = TETL1CommonUtil.parseAID((String)value.getValue(), (int)this.neid);
                    if (str[0].equals("FAC")) {
                        this.usedPortSet.add(str[3]);
                    } else if (str[0].equals("ACC")) {
                        int port = Integer.parseInt(str[3]) + 32768;
                        this.usedPortSet.add(String.valueOf(port));
                    }
                }
                if (!name.equals("SLVPORTS") || value.getValue() == null) continue;
                String[] slvPort = value.getValue().split("&&");
                StringBuffer sb = new StringBuffer();
                String index = "";
                int m = slvPort.length;
                for (int i2 = 0; i2 < m; ++i2) {
                    String[] ports = slvPort[i2].split("&");
                    int y = ports.length;
                    for (int x = 0; x < y; ++x) {
                        String[] aid = TETL1CommonUtil.parseAID((String)ports[x], (int)this.neid);
                        index = aid[0];
                        sb.append(aid[3]);
                        if (x >= y - 1) continue;
                        sb.append("&");
                    }
                    if (i2 >= m - 1) continue;
                    sb.append("&&");
                }
                Object[] result = TETL1CommonUtil.getPorts((String)sb.toString());
                if (index.equals("FAC")) {
                    int m2 = result.length;
                    for (i = 0; i < m2; ++i) {
                        this.usedPortSet.add(result[i]);
                    }
                    continue;
                }
                if (!index.equals("ACC")) continue;
                int m3 = result.length;
                for (i = 0; i < m3; ++i) {
                    this.usedPortSet.add(String.valueOf(Integer.parseInt((String)result[i]) + 32768));
                }
            }
        }
    }

    private void getPortAndVCtrunk(int neid, Datainterface inputData) {
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int slotID = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"slotid").getValue());
        this.ethnPortList.addAll(TETL1CommonUtil.getUsableEthPortList((int)neid, (int)slotID, (TEAIDAndTypeList)this.aidAndTypeList));
        this.allEthPortList.addAll(TETL1CommonUtil.getUsableEthPortList((int)neid, (int)slotID, (TEAIDAndTypeList)this.aidAndTypeList));
    }
}

