/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.linkaggregation;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.linkaggregation.TENELAGContainer;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TEQueryLagParams
extends TETL1NEExplorerBean {
    HashSet set = new HashSet();
    HashSet tempAid = TENELAGContainer.getInstance().getLagAid();

    public TEQueryLagParams() {
        this.msgBlockFlag = false;
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                boolean commFlag = this.convertPartValue(part, rowparams, null);
                if (commFlag) continue;
                if (null != part.getDefault()) {
                    part.setValue(part.getDefault());
                    continue;
                }
                flag = false;
            }
        }
        return flag;
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        String slotid = inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                for (String aid : this.tempAid) {
                    String tempSlotID = String.valueOf(TETL1CommonUtil.getNMSlotStr((String)aid, (int)this.neid));
                    if (!tempSlotID.equals(slotid)) continue;
                    tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                    this.changeMod2(tl1Operation, rowparams);
                    if (null == tl1Operation) continue;
                    inputMsg = tl1Operation.getInMsg();
                    if (null == inputMsg) {
                        tl1OperList.add(tl1Operation);
                        continue;
                    }
                    tl1Operation.clearCmdFaultInfo();
                    fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock(), aid);
                    if (fillComplete) {
                        fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                    }
                    if (!this.msgBlockFlag && !fillComplete) continue;
                    tl1OperList.add(tl1Operation);
                }
            }
        }
        return tl1OperList;
    }

    protected boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock, String aid) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (this.convertPartValue(part, rowparams, aid)) continue;
            if (null != part.getDefault()) {
                part.setValue(part.getDefault());
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams, String AID2) {
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("AID")) {
            StringBuffer sb = new StringBuffer();
            String[] aid = TETL1CommonUtil.parseAID((String)AID2, (int)this.neid);
            sb.append(aid[0]).append("-");
            if (!aid[1].equals("-1")) {
                sb.append(aid[1]).append("-");
            }
            sb.append(aid[2]);
            sb.append("-").append("ALL");
            if (this.set.contains(sb.toString())) {
                return false;
            }
            this.set.add(sb.toString());
            part.setValue(sb.toString());
        } else if (part.getName().equalsIgnoreCase("SLOT")) {
            StringBuffer sb = new StringBuffer();
            sb.append("SLOT-");
            Param slotIDParam = rowparams.getParam("slotid");
            if (slotIDParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            if (this.set.contains(sb.toString())) {
                return false;
            }
            this.set.add(sb.toString());
            part.setValue(sb.toString());
            part.setValue(sb.toString());
        } else if (part.getName().equalsIgnoreCase("FRAMETYPE")) {
            part.setValue("ALL");
        } else {
            return super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData.setBussinessParams(new BussinessParams());
        RowErrors rowError = new RowErrors();
        RowParams rowParams = new RowParams();
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            ErrorMessage bigErr;
            ErrorMessage errorMesage;
            TL1Operation portOper = (TL1Operation)tl1OperList.get(i);
            if (portOper != null && portOper.getName().equals("RTRV-LAGPORT")) {
                rowError.addParam(new Param("neid", ""));
                rowError.addParam(new Param("AID", portOper.getInMsg().getStagBlock().getAID().getPart(0).getValue()));
                if (portOper.getOutMsgCount() == 0) continue;
                if (portOper.getOutMsg(0).getFault().getCompletionCode() == 0) {
                    this.setOutPutData(this.outputData, portOper);
                } else {
                    errorMesage = new ErrorMessage();
                    errorMesage.setErrorcode(portOper.getOutMsg(0).getFault().getErrCode());
                    errorMesage.setErrorinfo(portOper.getOutMsg(0).getFault().getErrDesc());
                    rowError.setErrorMessage(errorMesage);
                    this.addErrorParam(neid, rowError);
                    rowParams.addRowErrors(rowError);
                }
            }
            if (portOper != null && portOper.getName().equals("RTRV-LAGSYS")) {
                rowError.addParam(new Param("neid", ""));
                rowError.addParam(new Param("AID", portOper.getInMsg().getStagBlock().getAID().getPart(0).getValue()));
                if (portOper.getOutMsg(0).getFault().getCompletionCode() == 0) {
                    this.setOutPutData(this.outputData, portOper);
                } else {
                    errorMesage = new ErrorMessage();
                    errorMesage.setErrorcode(portOper.getOutMsg(0).getFault().getErrCode());
                    errorMesage.setErrorinfo(portOper.getOutMsg(0).getFault().getErrDesc());
                    rowError.setErrorMessage(errorMesage);
                    this.addErrorParam(neid, rowError);
                    rowParams.addRowErrors(rowError);
                }
            }
            if (rowError.getErrorMessage() != null) {
                bigErr = TEErrorResourceUtil.getErrorMessage((int)2);
                this.outputData.setErrorMessage(bigErr);
                continue;
            }
            bigErr = TEErrorResourceUtil.getErrorMessage((int)0);
            this.outputData.setErrorMessage(bigErr);
        }
        this.outputData.getBussinessParams().addRowParams(rowParams);
    }

    private void setOutPutData(Datainterface outputData, TL1Operation operation) {
        for (OutMsg out : operation.getOutMsg()) {
            RowParams rowParams = new RowParams();
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            for (Map.Entry entry : partmap.entrySet()) {
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (operation.getName().equals("RTRV-LAGPORT")) {
                    if (name.equals("AID")) {
                        String[] temp = TETL1CommonUtil.parseAID((String)value.getValue(), (int)this.neid);
                        int slotID = TETL1CommonUtil.getNMSlotStr((String)value.getValue(), (int)this.neid);
                        rowParams.addParam(new Param("slotid", this.isNull(String.valueOf(slotID))));
                        String port = "";
                        if (temp[0].equals("FAC")) {
                            port = "PORT";
                        } else if (temp[0].equals("ACC")) {
                            port = "VCTRUNK";
                        }
                        port = port + this.isNull(temp[3]);
                        rowParams.addParam(new Param("portid", port));
                        continue;
                    }
                    if (!name.equals("PRIORITY")) continue;
                    rowParams.addParam(new Param("LAGPortPriority", this.isNull(value.getValue())));
                    continue;
                }
                if (!operation.getName().equals("RTRV-LAGSYS")) continue;
                if (name.equals("MAC")) {
                    rowParams.addParam(new Param("systemMAC", this.isNull(value.getValue())));
                    continue;
                }
                if (!name.equals("PRIORITY")) continue;
                rowParams.addParam(new Param("LAGSystemPriority", this.isNull(value.getValue())));
            }
            outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    protected void addRTRVPORTError(int neid, TENE ne) {
        Object[] slotIDArr = this.slotIDList.toArray();
        int slotID = (Integer)slotIDArr[0];
        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
    }

    private String isNull(String temp) {
        if (temp == null) {
            temp = "";
        }
        return temp;
    }
}

