/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.linkaggregation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.linkaggregation.TENELAGContainer;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TEQueryLAGBean
extends TETL1NEExplorerBean {
    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams2 = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList2 = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams2 = null;
        ArrayList<String> tl1List2 = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List2 = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List2.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams2.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams2 = businessparams2.getRowParams(row);
            int size = tl1List2.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List2.get(i));
                if (null == tl1Operation) continue;
                tl1Operation.clearCmdFaultInfo();
                this.changeMod2(tl1Operation, rowparams2);
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList2.add(tl1Operation);
                    continue;
                }
                fillComplete = this.fillStagBlock(rowparams2, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams2, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList2.add(tl1Operation);
                TL1Operation anOther = (TL1Operation)tl1Operation.clone();
                String aid = anOther.getInMsg().getPart("AID").getValue();
                aid = aid.replaceAll("FAC", "ACC");
                anOther.getInMsg().getPart("AID").setValue(aid);
                tl1OperList2.add(anOther);
            }
        }
        return tl1OperList2;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        Param portIDaram = null;
        Param portTypeParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            StringBuffer sb = new StringBuffer();
            portTypeParam = rowparams.getParam("porttype");
            slotIDParam = rowparams.getParam("slotid");
            portIDaram = rowparams.getParam("portid");
            if (portTypeParam == null || slotIDParam == null || portIDaram == null) {
                return false;
            }
            sb.append(portTypeParam.getValue());
            sb.append("-");
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append(portIDaram.getValue());
            part.setValue(sb.toString());
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList errorDataList = new ArrayList();
        RowParams rowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        HashMap<String, LagParam> lagMap = new HashMap<String, LagParam>();
        String errorCode = "OK";
        this.cloneTL1OperationList.clear();
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            OutMsg[] outs = tl1Operation.getOutMsg();
            int m = outs.length;
            for (int j = 0; j < m; ++j) {
                List branchPortLsit;
                Part branchPortListPart;
                rowparams = new RowParams();
                OutMsg out = outs[j];
                errorCode = String.valueOf(out.getFault().getCompletionCode());
                if (!"0".equals(errorCode)) {
                    tl1Operation.addCmdFault(out.getFault());
                }
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                Part aidPart = tl1Operation.getInMsg().getPart("AID");
                if (out.getFault().getCompletionCode() != 0) {
                    this.setErrorOutput(neid, errorDataList, rowparams, out, aidPart);
                    continue;
                }
                Part mainPort = (Part)hm.get("AID");
                LagParam lagParam = (LagParam)lagMap.get(mainPort.getValue());
                if (lagMap.get(mainPort.getValue()) == null) {
                    lagParam = new LagParam();
                    lagParam.setAid(mainPort.getValue());
                    lagMap.put(mainPort.getValue(), lagParam);
                    TENELAGContainer.getInstance().addLagAid(mainPort.getValue());
                }
                int slotid = TETL1CommonUtil.getNMSlotStr((String)mainPort.getValue(), (int)neid);
                lagParam.setSlotid(String.valueOf(slotid));
                lagParam.setAggregationNO(mainPort.getValue());
                String[] str = TETL1CommonUtil.parseAID((String)mainPort.getValue(), (int)neid);
                lagParam.setMainPort(this.getPortNameByIndex(str));
                int portID = TETL1CommonUtil.getNMPortNOFromNEPort((String)str[0], (int)slotid, (int)Integer.parseInt(str[3]), (int)neid);
                lagParam.setMainPortid(String.valueOf(portID));
                Part branchPortPart = (Part)hm.get("LOCPORT");
                Part state = (Part)hm.get("WORKSTATE");
                if (this.isNull(branchPortPart.getValue()).equals(this.isNull(mainPort.getValue()))) {
                    lagParam.setState(this.isNull(state.getValue()));
                    branchPortListPart = (Part)hm.get("SLVPORTS");
                    branchPortLsit = this.getBranchPortList(lagParam.getBranchPort(), branchPortListPart.getValue());
                    lagParam.setBranchPort(branchPortLsit);
                } else if (branchPortPart.getValue() != null) {
                    ArrayList branchPortList = (ArrayList)lagParam.getBranchPort();
                    this.setBrachPortState(branchPortList, branchPortPart.getValue(), this.isNull(state.getValue()));
                } else {
                    branchPortListPart = (Part)hm.get("SLVPORTS");
                    branchPortLsit = this.getBranchPortList(lagParam.getBranchPort(), branchPortListPart.getValue());
                    lagParam.setBranchPort(branchPortLsit);
                }
                Part temp = (Part)hm.get("NAME");
                lagParam.setName(this.isNull(temp.getValue()));
                temp = (Part)hm.get("TYPE");
                lagParam.setLagType(this.isNull(temp.getValue()));
                temp = (Part)hm.get("BALANCE");
                lagParam.setLoadSharing(this.isNull(temp.getValue()));
                temp = (Part)hm.get("LAGSHAREMODE");
                String sharingtemp = temp == null ? "" : this.isNull(temp.getValue());
                if (sharingtemp.equals("")) {
                    sharingtemp = "-";
                }
                lagParam.setSharingMode(sharingtemp);
                temp = (Part)hm.get("LAGHOTIME");
                String hotime = null;
                hotime = temp == null || temp.getValue() == null ? "-" : temp.getValue();
                lagParam.setHoTime(hotime);
            }
            this.cloneTL1OperationList.add(tl1Operation.clone());
        }
        List list = this.sortHashMap(lagMap);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            rowparams = new RowParams();
            LagParam lamParam = (LagParam)list.get(i);
            rowparams.addParam(new Param("AID", lamParam.getAggregationNO()));
            rowparams.addParam(new Param("slotid", lamParam.getSlotid()));
            rowparams.addParam(new Param("aggregationNO", lamParam.getAggregationNO()));
            rowparams.addParam(new Param("mainPort", lamParam.getMainPort()));
            rowparams.addParam(new Param("mainPortid", lamParam.getMainPortid()));
            rowparams.addParam(new Param("aggregationName", lamParam.getName()));
            rowparams.addParam(new Param("aggregationType", lamParam.getLagType()));
            rowparams.addParam(new Param("partakeType", lamParam.getLoadSharing()));
            rowparams.addParam(new Param("sharingMode", lamParam.getSharingMode()));
            rowparams.addParam(new Param("hoTime", lamParam.getHoTime()));
            List branchPortList = lamParam.getBranchPort();
            StringBuffer portStr = new StringBuffer();
            int m = branchPortList.size();
            for (int j = 0; j < m; ++j) {
                BranchPortEntry branchPort = (BranchPortEntry)branchPortList.get(j);
                portStr.append(branchPort.getBranchPortName()).append("-").append(branchPort.getBranchPort()).append("-").append(branchPort.getBranchPortState());
                if (j >= m - 1) continue;
                portStr.append(",");
            }
            rowparams.addParam(new Param("branchPort", portStr.toString()));
            rowparams.addParam(new Param("state", lamParam.getState()));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
        this.outputData.setErrorMessage(new ErrorMessage());
        if (errorDataList.size() != 0) {
            if (errorDataList.size() == tl1OperList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    public int sendMessage(int neid, ArrayList tl1OperList) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null == ne) {
            TELogFactory.getNormalLogger().error("ne is null! neid->" + neid);
            return 1090646019;
        }
        int neType = ne.getNEType();
        if (neType == 66) {
            int retCode = 0;
            ArrayList tempOperList = new ArrayList();
            int size = tl1OperList.size();
            for (int i = 0; i < size; ++i) {
                tempOperList.clear();
                tempOperList.add(tl1OperList.get(i));
                retCode = super.sendMessage(neid, tempOperList);
                if (0 == retCode) continue;
                return retCode;
            }
            return 0;
        }
        return super.sendMessage(neid, tl1OperList);
    }

    private List getBranchPortList(List branchList, String value) {
        ArrayList<BranchPortEntry> list = new ArrayList<BranchPortEntry>();
        if (value == null) {
            return list;
        }
        String[] values = value.split("&");
        boolean isHas = false;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            int m = branchList.size();
            for (int j = 0; j < m; ++j) {
                BranchPortEntry entry = (BranchPortEntry)branchList.get(j);
                if (!entry.getBranchAid().equals(values[i])) continue;
                isHas = true;
            }
            if (isHas) continue;
            BranchPortEntry entry = new BranchPortEntry();
            String[] aids = TETL1CommonUtil.parseAID((String)values[i], (int)this.neid);
            entry.setBranchAid(values[i]);
            entry.setBranchPortName(this.getPortNameByIndex(aids));
            entry.setBranchPort(aids[3]);
            entry.setBranchPortState("");
            list.add(entry);
        }
        return list;
    }

    private List sortHashMap(HashMap hashMap) {
        ArrayList portList = new ArrayList();
        Object[] keys = hashMap.keySet().toArray();
        Arrays.sort(keys);
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            portList.add(hashMap.get(keys[i]));
        }
        return portList;
    }

    private void setBrachPortState(ArrayList branchPortList, String aid, String state) {
        int y = branchPortList.size();
        for (int x = 0; x < y; ++x) {
            BranchPortEntry temp = (BranchPortEntry)branchPortList.get(x);
            if (!temp.getBranchAid().equals(aid)) continue;
            temp.setBranchPortState(state);
            break;
        }
    }

    private String getPortNameByIndex(String[] aid) {
        String portName = "";
        if (aid[0].equals("FAC")) {
            portName = "PORT" + aid[3];
        } else if (aid[0].equals("ACC")) {
            portName = "VCTRUNK" + aid[3];
        }
        return portName;
    }

    private void setErrorOutput(int neid, List errorDataList, RowParams rowparams, OutMsg out, Part aidPart) {
        String errorCode = out.getFault().getErrCode();
        String errorinfo = out.getFault().getErrDesc();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        RowErrors errorRowparams = new RowErrors();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        errorRowparams.setErrorMessage(errorMessage);
        String tempAID = aidPart.getValue();
        String[] aidArr = TETL1CommonUtil.parseAID((String)tempAID, (int)neid);
        String tempPort = aidArr[3];
        String aidvar = aidPart.getValue();
        if (tempPort.equalsIgnoreCase("ALL")) {
            StringBuffer tempsb = new StringBuffer();
            tempsb.append(aidArr[0]);
            tempsb.append("-");
            tempsb.append(aidArr[1]);
            tempsb.append("-");
            tempsb.append(aidArr[2]);
            aidvar = tempsb.toString();
        }
        String objectName = TETL1CommonUtil.getBoardStructFromAID((String)aidvar, (int)neid, (boolean)true);
        errorparam = new Param("nename", objectName);
        errorRowparams.addParam(errorparam);
        errorDataList.add(errorRowparams);
        rowparams.addRowErrors(errorRowparams);
        this.outputData.getBussinessParams().addRowParams(rowparams);
    }

    private String isNull(String temp) {
        if (temp == null) {
            temp = "";
        }
        return temp;
    }

    static class BranchPortEntry {
        private String branchPort;
        private String branchPortName;
        private String branchPortState;
        private String branchAid;

        BranchPortEntry() {
        }

        public String getBranchAid() {
            return this.branchAid;
        }

        public void setBranchAid(String branchAid) {
            this.branchAid = branchAid;
        }

        public String getBranchPort() {
            return this.branchPort;
        }

        public void setBranchPort(String branchPort) {
            this.branchPort = branchPort;
        }

        public String getBranchPortState() {
            return this.branchPortState;
        }

        public void setBranchPortState(String branchPortState) {
            this.branchPortState = branchPortState;
        }

        public String getBranchPortName() {
            return this.branchPortName;
        }

        public void setBranchPortName(String branchPortName) {
            this.branchPortName = branchPortName;
        }
    }

    static class LagParam {
        private String aid = "";
        private String slotid = "";
        private String aggregationNO = "";
        private String mainPort = "";
        private String mainPortid = "";
        private String state = "255";
        private String name = "";
        private String lagType = "";
        private String loadSharing = "";
        private String sharingMode = "";
        private String hoTime = "";
        private List branchPort = new ArrayList();

        LagParam() {
        }

        public String getHoTime() {
            return this.hoTime;
        }

        public void setHoTime(String hoTime) {
            this.hoTime = hoTime;
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public String getSlotid() {
            return this.slotid;
        }

        public void setSlotid(String slotid) {
            this.slotid = slotid;
        }

        public String getAggregationNO() {
            return this.aggregationNO;
        }

        public void setAggregationNO(String aggregationNO) {
            this.aggregationNO = aggregationNO;
        }

        public String getMainPort() {
            return this.mainPort;
        }

        public void setMainPort(String mainPort) {
            this.mainPort = mainPort;
        }

        public String getMainPortid() {
            return this.mainPortid;
        }

        public void setMainPortid(String mainPortid) {
            this.mainPortid = mainPortid;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public List getBranchPort() {
            return this.branchPort;
        }

        public void setBranchPort(List branchPort) {
            this.branchPort = branchPort;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLagType() {
            return this.lagType;
        }

        public void setLagType(String lagType) {
            this.lagType = lagType;
        }

        public String getLoadSharing() {
            return this.loadSharing;
        }

        public void setLoadSharing(String loadSharing) {
            this.loadSharing = loadSharing;
        }

        public String getSharingMode() {
            return this.sharingMode;
        }

        public void setSharingMode(String sharingMode) {
            this.sharingMode = sharingMode;
        }
    }
}

