/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping.TEQuickLeaveObject;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEQueryQuickLeaveBean
extends TETL1NEExplorerBean {
    private static final int VBIDPOS = 3;
    private static final int LPPORTPOS = 4;
    private static final String RTRV_VLANENTRY_VB_AID_PREFIX_VB = "VB-";

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        int slotId = 0;
        String tempStr = "";
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIdParam = rowparams.getParam("slotid");
            if (slotIdParam == null) {
                return false;
            }
            tempStr = slotIdParam.getValue();
            slotId = Integer.parseInt(tempStr);
            tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            tempStr = RTRV_VLANENTRY_VB_AID_PREFIX_VB + tempStr + "-" + "ALL";
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("VLANID")) {
            return false;
        }
        return super.convertPartValue(part, rowparams);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        try {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            ArrayList quickOperList = this.constuctOperationList(operationList);
            if (quickOperList != null && !quickOperList.isEmpty()) {
                int result = this.sendMessage(neid, quickOperList);
                if (result == 0) {
                    this.outputData = this.dealOperationList(quickOperList);
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("handleMessage fail!", (Throwable)e);
        }
    }

    private ArrayList constuctOperationList(List operationList) {
        ArrayList<TL1Operation> quickOperList;
        block7: {
            quickOperList = new ArrayList<TL1Operation>();
            try {
                TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
                TL1Operation operSour = definitions.getTL1Operation("RTRV-IGMP-QKLV");
                TL1Operation quickOper = null;
                TL1Operation operation = (TL1Operation)operationList.get(0);
                OutMsg output = operation.getOutMsg(0);
                int errorCode = output.getFault().getCompletionCode();
                if (0 == errorCode) {
                    int outputlen = operation.getOutMsgCount();
                    for (int i = 0; i < outputlen; ++i) {
                        quickOper = (TL1Operation)operSour.clone();
                        output = operation.getOutMsg(i);
                        String aid = output.getMsgBlock().getPart("AID").getValue();
                        String vlanId = output.getMsgBlock().getPart("VLANID").getValue();
                        String vblpList = output.getMsgBlock().getPart("VBLPLIST").getValue();
                        quickOper.getInMsg().getPart("AID").setValue(aid);
                        MsgBlock msgblock = quickOper.getInMsg().getMsgBlock();
                        DataBlock dataBlock = null;
                        Part part = null;
                        int len = msgblock.getDataBlockCount();
                        for (int j = 0; j < len; ++j) {
                            dataBlock = msgblock.getDataBlock(j);
                            int length = dataBlock.getPartCount();
                            for (int k = 0; k < length; ++k) {
                                part = dataBlock.getPart(k);
                                if (part.getName().equalsIgnoreCase("VLANID")) {
                                    part.setValue(vlanId);
                                }
                                if (!part.getName().equalsIgnoreCase("VBLPLIST")) continue;
                                part.setValue(vblpList);
                            }
                        }
                        quickOperList.add(quickOper);
                    }
                    break block7;
                }
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorCode));
                return null;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("constuct Operation List fail!", (Throwable)e);
                return null;
            }
        }
        return quickOperList;
    }

    private Datainterface dealOperationList(ArrayList quickOperList) {
        Datainterface result = null;
        TL1Operation operation = null;
        OutMsg output = null;
        String vbidStr = "";
        String vbPortStr = "";
        int slotid = 0;
        int vbid = 0;
        int vlanid = 0;
        int port = 0;
        int state = 0;
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        HashMap<TEQuickLeaveObject, TEQuickLeaveObject> portList = new HashMap<TEQuickLeaveObject, TEQuickLeaveObject>();
        int listlen = quickOperList.size();
        for (int i = 0; i < listlen; ++i) {
            operation = (TL1Operation)quickOperList.get(i);
            int outputlen = operation.getOutMsgCount();
            for (int j = 0; j < outputlen; ++j) {
                output = operation.getOutMsg(j);
                if (output.getFault().getCompletionCode() == 0) {
                    Part AID2 = output.getMsgBlock().getPart("AID");
                    slotid = TETL1CommonUtil.getNMSlotStr((String)AID2.getValue(), (int)this.neid);
                    vbidStr = AID2.getValue().split("-")[3];
                    vbid = Integer.valueOf(vbidStr);
                    vlanid = Integer.valueOf(output.getMsgBlock().getPart("VLANID").getValue());
                    vbPortStr = output.getMsgBlock().getPart("VBLP").getValue().split("-")[4];
                    port = Integer.valueOf(vbPortStr);
                    state = "Y".equalsIgnoreCase(output.getMsgBlock().getPart("QKLVEN").getValue()) ? 1 : 0;
                    TEQuickLeaveObject object = new TEQuickLeaveObject(slotid, vbid, vlanid);
                    TEQuickLeaveObject objectTmp = (TEQuickLeaveObject)portList.get(object);
                    if (objectTmp == null) {
                        objectTmp = object;
                        portList.put((TEQuickLeaveObject)object.clone(), object);
                    }
                    objectTmp.addPort(port);
                    objectTmp.addState(state);
                    continue;
                }
                errorDataList.add(this.handleErrorData(this.neid, this.subfunc, operation, output));
            }
        }
        result = this.convertDataToOutput(portList, errorDataList);
        return result;
    }

    private Datainterface convertDataToOutput(Map<TEQuickLeaveObject, TEQuickLeaveObject> portList, ArrayList errorDataList) {
        Datainterface outputData = new Datainterface();
        Set<Map.Entry<TEQuickLeaveObject, TEQuickLeaveObject>> set = portList.entrySet();
        Iterator<Map.Entry<TEQuickLeaveObject, TEQuickLeaveObject>> iterator = set.iterator();
        Map.Entry<TEQuickLeaveObject, TEQuickLeaveObject> entry = null;
        TEQuickLeaveObject objTmp = null;
        RowParams tmpRow = null;
        BussinessParams bp = new BussinessParams();
        String boardName = "";
        while (iterator.hasNext()) {
            entry = iterator.next();
            objTmp = entry.getValue();
            tmpRow = new RowParams();
            tmpRow.addParam("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)objTmp.getSlotID()));
            tmpRow.addParam("slotid", objTmp.getSlotID() + "");
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, objTmp.getSlotID());
            boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType);
            tmpRow.addParam("boardname", boardName);
            tmpRow.addParam("vbid", objTmp.getVbID() + "");
            tmpRow.addParam("vlanid", objTmp.getVlanID() + "");
            if (objTmp.getPortList().size() <= 0) continue;
            tmpRow.addParam("portlist", this.combinArrayList(objTmp.getPortList()));
            tmpRow.addParam("statelist", this.combinArrayList(objTmp.getLeavestate()));
            bp.addRowParams(tmpRow);
        }
        outputData.setBussinessParams(bp);
        if (null != errorDataList && !errorDataList.isEmpty()) {
            tmpRow = new RowParams();
            RowErrors rErrors = null;
            int size = errorDataList.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorDataList.get(i);
                tmpRow.addRowErrors(rErrors);
            }
            bp.addRowParams(tmpRow);
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        return outputData;
    }

    private String combinArrayList(List<Integer> list) {
        StringBuffer result = new StringBuffer("");
        String str = "";
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            result.append(str).append(list.get(i).toString());
            str = ",";
        }
        return result.toString();
    }
}

