/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping.TEIGMPRouteQueryBean;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping.TEIGMPUtilBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TEQueryIGMPTable
extends TEIGMPUtilBean {
    private static final int portListMaxLength = 4;
    private static final String QUERYRESULT_NULL = "SPECIFIED OBJECT ENTITY DOES NOT EXIST, Retrieving result is empty";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.curUser = user;
            this.curIpAddress = ipAddress;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            this.neType = ne.getNEType();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        this.addRTRVPORTError(neid, (TENE)ne);
                        return this.outputData;
                    }
                }
            }
            this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            List vlanList = this.commonQueryVlanid(inputData);
            if (vlanList.size() == 0) {
                TL1Operation queryOper = definitions.getTL1Operation("RTRV-MCGROUP-VB");
                RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
                String aid = "";
                Param slotIDParam = rowparams.getParam("slotid");
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)Integer.parseInt(slotIDParam.getValue()));
                aid = "VB-" + shelfSlotID + "-1";
                InMsg input = queryOper.getInMsg();
                input.getPart("AID").setValue(aid);
                this.tl1OperList.add(queryOper);
            } else {
                int n = vlanList.size();
                for (int i = 0; i < n; ++i) {
                    TEIGMPRouteQueryBean.Entry vlan = (TEIGMPRouteQueryBean.Entry)vlanList.get(i);
                    TL1Operation queryOper = definitions.getTL1Operation("RTRV-MCGROUP-VB");
                    InMsg input = queryOper.getInMsg();
                    input.getPart("AID").setValue(vlan.getAid());
                    input.getPart("VLANID").setValue(vlan.getVlanID());
                    this.tl1OperList.add(queryOper);
                }
            }
            if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList());
                HashSet<String> rowSet = new HashSet<String>();
                for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
                    RowParams row = this.outputData.getBussinessParams().getRowParams(i);
                    if (row.getParam("vbid") == null) continue;
                    if (row.getParam("portNum") != null && "/".equals(row.getParam("portNum").getValue())) {
                        this.outputData.getBussinessParams().removeRowParams(i);
                        continue;
                    }
                    String vb = row.getParam("vbid").getValue();
                    String vlanid = row.getParam("vlanid").getValue();
                    String mac = row.getParam("mac").getValue();
                    String key = vb + vlanid + mac;
                    if (rowSet.contains(key)) {
                        this.outputData.getBussinessParams().removeRowParams(i);
                        continue;
                    }
                    rowSet.add(key);
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.printLog();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        Param vbIDParam = null;
        StringBuffer sb = new StringBuffer();
        sb.append("VB-");
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIDParam = rowparams.getParam("slotid");
            vbIDParam = rowparams.getParam("vbid");
            if (slotIDParam == null || vbIDParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append(vbIDParam.getValue());
        }
        if (null != slotIDParam || null != vbIDParam) {
            part.setValue(sb.toString());
        } else {
            flag = false;
        }
        return flag;
    }

    public Param convertParamValue(Param oldParam1, HashMap partmap) {
        if (oldParam1.getName().equalsIgnoreCase("mac")) {
            Part mac = (Part)partmap.get("MACADDR");
            oldParam1.setValue(mac.getValue());
            return oldParam1;
        }
        if (oldParam1.getName().equalsIgnoreCase("vlanid")) {
            Part vlanid = (Part)partmap.get("VLANID");
            oldParam1.setValue(vlanid.getValue() == null ? "65534" : vlanid.getValue());
            return oldParam1;
        }
        if (oldParam1.getName().equalsIgnoreCase("slotid")) {
            Part AID2 = (Part)partmap.get("VBID");
            if (AID2 == null) {
                AID2 = (Part)partmap.get("AID");
            }
            if (AID2.getValue() == null) {
                oldParam1.setValue("/");
                return oldParam1;
            }
            oldParam1.setValue(String.valueOf(TETL1CommonUtil.getNMSlotStr((String)AID2.getValue(), (int)this.neid)));
            return oldParam1;
        }
        if (oldParam1.getName().equalsIgnoreCase("shelfName")) {
            Part AID3 = (Part)partmap.get("VBID");
            if (AID3 == null) {
                AID3 = (Part)partmap.get("AID");
            }
            if (AID3.getValue() == null) {
                oldParam1.setValue("/");
                return oldParam1;
            }
            oldParam1.setValue(String.valueOf(TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)TETL1CommonUtil.getNMSlotStr((String)AID3.getValue(), (int)this.neid))));
            return oldParam1;
        }
        if (oldParam1.getName().equalsIgnoreCase("vbid")) {
            Part AID4 = (Part)partmap.get("VBID");
            if (AID4 == null) {
                AID4 = (Part)partmap.get("AID");
            }
            String vbID = TETL1CommonUtil.parseAID((String)AID4.getValue(), (int)this.neid)[3];
            oldParam1.setValue(vbID);
            return oldParam1;
        }
        if (oldParam1.getName().equalsIgnoreCase("portNum")) {
            Part portNum = (Part)partmap.get("VBLPLIST");
            if (portNum.getValue() == null) {
                oldParam1.setValue("/");
                return oldParam1;
            }
            String[] str = portNum.getValue().split("&");
            oldParam1.setValue(String.valueOf(str.length));
            return oldParam1;
        }
        if (oldParam1.getName().equalsIgnoreCase("portlist")) {
            Part portNum = (Part)partmap.get("VBLPLIST");
            if (portNum.getValue() == null) {
                oldParam1.setValue("/");
                return oldParam1;
            }
            String[] str = portNum.getValue().split("&");
            StringBuffer portList = new StringBuffer();
            int n = str.length;
            for (int i = 0; i < n; ++i) {
                String port = TETL1CommonUtil.parseAID((String)str[i], (int)this.neid)[4];
                portList.append(port);
                int portlength = port.length();
                int m = 4 - portlength;
                for (int j = 0; j < m; ++j) {
                    portList.append(" ");
                }
            }
            oldParam1.setValue(portList.toString());
            return oldParam1;
        }
        return oldParam1;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        Part portNumvblp = (Part)partmap.get("ROUTERPORTLIST");
        return portNumvblp != null && portNumvblp.getValue() != null && !portNumvblp.getValue().equals("");
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> errorCodeList = new ArrayList<String>();
        errorCodeList.add(QUERYRESULT_NULL);
        return errorCodeList;
    }
}

