/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.l2switching.igmpsnooping.TEIGMPUtilBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEIGMPRouteQueryBean
extends TEIGMPUtilBean {
    private static final int portListMaxLength = 4;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TL1Definitions definitions_igmp = TECreateObjectFactory.parseTL1DesFile((int)neid);
            this.tl1OperList = new ArrayList();
            List vlanList = this.commonQueryVlanid(inputData);
            if (vlanList.size() == 0) {
                TL1Operation queryOper = definitions_igmp.getTL1Operation("RTRV-MCGROUP-VB");
                RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
                String aid_igmp = "";
                Param slotIDParam_igmp = rowparams.getParam("slotid");
                String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)Integer.parseInt(slotIDParam_igmp.getValue()));
                aid_igmp = "VB-" + shelfSlotID + "-1";
                InMsg input = queryOper.getInMsg();
                input.getPart("AID").setValue(aid_igmp);
                this.tl1OperList.add(queryOper);
            } else {
                int n = vlanList.size();
                for (int i = 0; i < n; ++i) {
                    Entry vlan = (Entry)vlanList.get(i);
                    TL1Operation queryOper_igmp = definitions_igmp.getTL1Operation("RTRV-MCGROUP-VB");
                    InMsg input = queryOper_igmp.getInMsg();
                    input.getPart("AID").setValue(vlan.getAid());
                    input.getPart("VLANID").setValue(vlan.getVlanID());
                    this.tl1OperList.add(queryOper_igmp);
                }
            }
            if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result_igmp = this.sendMessage(neid, this.tl1OperList);
            if (result_igmp == 0) {
                super.handleMessage(neid, this.tl1OperList, subFunc, null);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result_igmp));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.tl1OperList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        Param vbIDParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            StringBuffer sb = new StringBuffer();
            sb.append("VB-");
            slotIDParam = rowparams.getParam("slotid");
            vbIDParam = rowparams.getParam("vbid");
            if (slotIDParam == null || vbIDParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append(vbIDParam.getValue());
            part.setValue(sb.toString());
        }
        return flag;
    }

    public Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equalsIgnoreCase("vlanid")) {
            Part vlanid = (Part)partmap.get("VLANID");
            oldParam.setValue(vlanid.getValue() == null ? "65534" : vlanid.getValue());
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("slotid")) {
            Part AID2 = (Part)partmap.get("AID");
            if (AID2.getValue() == null) {
                oldParam.setValue("/");
                return oldParam;
            }
            oldParam.setValue(String.valueOf(TETL1CommonUtil.getNMSlotStr((String)AID2.getValue(), (int)this.neid)));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("shelfName")) {
            Part AID3 = (Part)partmap.get("AID");
            if (AID3.getValue() == null) {
                oldParam.setValue("/");
                return oldParam;
            }
            oldParam.setValue(String.valueOf(TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)TETL1CommonUtil.getNMSlotStr((String)AID3.getValue(), (int)this.neid))));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("vbid")) {
            Part AID4 = (Part)partmap.get("AID");
            String vbID = TETL1CommonUtil.parseAID((String)AID4.getValue(), (int)this.neid)[3];
            oldParam.setValue(vbID);
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("portNum")) {
            Part portNumvblp = (Part)partmap.get("VBLPLIST");
            Part portNum = (Part)partmap.get("ROUTERPORTLIST");
            if (portNumvblp.getValue() == null && portNum.getValue() == null) {
                oldParam.setValue("/");
                return oldParam;
            }
            String[] str = null;
            if (portNum.getValue() != null) {
                str = portNum.getValue().split("&");
            }
            if (portNumvblp.getValue() != null) {
                str = portNumvblp.getValue().split("&");
            }
            oldParam.setValue(String.valueOf(str.length));
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("portlist")) {
            Part portNumvblp = (Part)partmap.get("VBLPLIST");
            Part portNum = (Part)partmap.get("ROUTERPORTLIST");
            if (portNumvblp.getValue() == null && portNum.getValue() == null) {
                oldParam.setValue("/");
                return oldParam;
            }
            String[] str = null;
            if (portNum.getValue() != null) {
                str = portNum.getValue().split("&");
            }
            if (portNumvblp.getValue() != null) {
                str = portNumvblp.getValue().split("&");
            }
            StringBuffer portList = new StringBuffer();
            int n = str.length;
            for (int i = 0; i < n; ++i) {
                String port_igmp = TETL1CommonUtil.parseAID((String)str[i], (int)this.neid)[4];
                portList.append(port_igmp);
                int portlength = port_igmp.length();
                int m = 4 - portlength;
                for (int j = 0; j < m; ++j) {
                    portList.append(" ");
                }
            }
            oldParam.setValue(portList.toString());
            return oldParam;
        }
        return oldParam;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        Part portNumvblp = (Part)partmap.get("VBLPLIST");
        return portNumvblp.getValue() != null && !portNumvblp.getValue().equals("");
    }

    static class Entry {
        private String aid;
        private String vlanID;

        Entry() {
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public String getVlanID() {
            return this.vlanID;
        }

        public void setVlanID(String vlanID) {
            this.vlanID = vlanID;
        }
    }
}

