/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.vlanfiltering;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEModifyVLANBean
extends TETL1NEExplorerBean {
    private static final int MAX_ROWLEN = 30;
    private static final int VBPORT_FLAG = 28672;
    private static final String STRING_VB = "VB";
    private static final String STRING_VBLP = "VBLP";
    private ArrayList tempOperList = new ArrayList();
    private String shelfSlotStr = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.tl1OperList = new ArrayList();
            int cycleCount = 0;
            this.tempOperList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.tempOperList || 0 == this.tempOperList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            ArrayList resultOperList = new ArrayList();
            cycleCount = this.tempOperList.size() % 30 == 0 ? this.tempOperList.size() / 30 : this.tempOperList.size() / 30 + 1;
            int innerCycleCount = 0;
            for (int i = 0; i < cycleCount; ++i) {
                if (null == this.tempOperList || 0 == this.tempOperList.size()) continue;
                innerCycleCount = this.tempOperList.size() > 30 ? 30 : this.tempOperList.size();
                for (int j = innerCycleCount - 1; j >= 0; --j) {
                    this.tl1OperList.add((TL1Operation)this.tempOperList.get(j));
                    this.tempOperList.remove(j);
                }
                int result = this.sendMessage(neid, this.tl1OperList);
                if (0 == result) {
                    resultOperList.addAll((ArrayList)this.tl1OperList.clone());
                    this.tl1OperList.clear();
                    continue;
                }
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                break;
            }
            this.handleMessage(neid, resultOperList, subFunc, null);
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        String tempStr = "";
        int slotId = -1;
        String aid = "";
        String vbid = "";
        String vlanid = "";
        String portNoList = "";
        TL1Definitions definitions = null;
        ArrayList<TL1Operation> tempOperList = new ArrayList<TL1Operation>();
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        RowParams[] inputrows = inputData.getBussinessParams().getRowParams();
        TL1Operation operation = null;
        InMsg input = null;
        int inputlen = inputrows.length;
        for (int i = 0; i < inputlen; ++i) {
            if (this.shelfSlotStr.equals("")) {
                tempStr = inputrows[i].getParam("slotid").getValue();
                slotId = Integer.parseInt(tempStr);
                this.shelfSlotStr = tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            }
            operation = definitions.getTL1Operation("ED-VLANENTRY-VB");
            input = operation.getInMsg();
            vbid = inputrows[i].getParam("vbid").getValue();
            aid = "VB-" + this.shelfSlotStr + "-" + vbid;
            input.getPart("AID").setValue(aid);
            vlanid = inputrows[i].getParam("vlanidarr").getValue();
            input.getPart("VLANID").setValue(vlanid);
            portNoList = inputrows[i].getParam("portNoList").getValue();
            input.getPart("VBLPLIST").setValue(this.getVBLpList(vbid, portNoList));
            tempOperList.add(operation);
        }
        return tempOperList;
    }

    public String getVBLpList(String vbid, String portNoList) {
        StringBuffer vblpStr = new StringBuffer("");
        int vbPortId = -1;
        String[] vbPortArr = portNoList.split(",");
        String prefix = "VBLP-" + this.shelfSlotStr + "-" + vbid + "-";
        int len = vbPortArr.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                vblpStr.append("&");
            }
            vbPortId = (vbPortId = Integer.parseInt(vbPortArr[i])) < 28672 ? vbPortId : vbPortId - 28672;
            vblpStr.append(prefix).append(vbPortId);
        }
        return vblpStr.toString();
    }
}

