/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.vlanfiltering;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEManageVLANBean
extends TETL1NEExplorerBean {
    private static final int MAX_ROWLEN = 20;
    private static final int VBPORT_FLAG = 28672;
    private static final String DLT_VLANENTRY_VB = "DLT-VLANENTRY-VB";
    private static final String ENT_VLANENTRY_VB = "ENT-VLANENTRY-VB";
    private static final String STRING_VB = "VB";
    private static final String STRING_VBLP = "VBLP";
    private ArrayList tempOperList_valn = new ArrayList();
    private String shelfSlotStr = "";

    public Datainterface performBussinessProcess(int neid_vlan, SubFunc subFunc_vlan, Datainterface inputData_vlan, Datainterface memeryData, String user, String ipAddress) {
        try {
            int result;
            this.neid = neid_vlan;
            this.subfunc = subFunc_vlan;
            this.inputData = inputData_vlan;
            this.tl1OperList = new ArrayList();
            this.outputData = new Datainterface();
            int cycleCount = 0;
            this.tempOperList_valn = this.getOperation(neid_vlan, subFunc_vlan, inputData_vlan, memeryData);
            if ((null == this.tempOperList_valn || 0 == this.tempOperList_valn.size()) && 0 == this.tl1OperList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            ArrayList resultOperList_vlan = new ArrayList();
            if (null != this.tl1OperList && 0 != this.tl1OperList.size()) {
                result = this.sendMessage(neid_vlan, this.tl1OperList);
                if (0 == result) {
                    resultOperList_vlan.addAll((ArrayList)this.tl1OperList.clone());
                    this.tl1OperList.clear();
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    return this.outputData;
                }
            }
            if (null != this.tempOperList_valn && 0 != this.tempOperList_valn.size()) {
                cycleCount = this.tempOperList_valn.size() % 20 == 0 ? this.tempOperList_valn.size() / 20 : this.tempOperList_valn.size() / 20 + 1;
                int innerCycleCount = 0;
                for (int i = 0; i < cycleCount; ++i) {
                    if (null == this.tempOperList_valn || 0 == this.tempOperList_valn.size()) continue;
                    innerCycleCount = this.tempOperList_valn.size() > 20 ? 20 : this.tempOperList_valn.size();
                    for (int j = innerCycleCount - 1; j >= 0; --j) {
                        this.tl1OperList.add((TL1Operation)this.tempOperList_valn.get(j));
                        this.tempOperList_valn.remove(j);
                    }
                    result = this.sendMessage(neid_vlan, this.tl1OperList);
                    if (0 == result) {
                        resultOperList_vlan.addAll((ArrayList)this.tl1OperList.clone());
                        this.tl1OperList.clear();
                        continue;
                    }
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    break;
                }
            }
            this.handleMessage(neid_vlan, resultOperList_vlan, subFunc_vlan, null);
            if (this.isNeedOperationlog()) {
                this.writeLog(neid_vlan, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        String tempStr = "";
        int slotId = -1;
        String aid = "";
        String vbid = "";
        String vlanid = "";
        String portNoList = "";
        TL1Definitions definitions = null;
        ArrayList<Object> tempOperList_vlan = new ArrayList<Object>();
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        RowParams[] inputrows = inputData.getBussinessParams().getRowParams();
        RowParams inputrow = inputrows[0];
        ArrayList vlanIdList = this.getVlanIdArr(inputrow.getParam("vlanidarr").getValue());
        String tempFlag = inputrow.getParam("flag").getValue();
        TL1Operation operation = null;
        InMsg input = null;
        int inputlen = vlanIdList.size();
        for (int i = 0; i < inputlen; ++i) {
            if (this.shelfSlotStr.equals("")) {
                tempStr = inputrow.getParam("slotid").getValue();
                slotId = Integer.parseInt(tempStr);
                this.shelfSlotStr = tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            }
            if (tempFlag.equals("0")) {
                operation = definitions.getTL1Operation(DLT_VLANENTRY_VB);
                input = operation.getInMsg();
                vbid = inputrow.getParam("vbid").getValue();
                vlanid = String.valueOf(vlanIdList.get(i));
                aid = "VB-" + this.shelfSlotStr + "-" + vbid;
                input.getPart("AID").setValue(aid);
                input.getPart("VLANID").setValue(vlanid);
                this.tl1OperList.add(operation.clone());
                continue;
            }
            operation = definitions.getTL1Operation(ENT_VLANENTRY_VB);
            input = operation.getInMsg();
            vbid = inputrow.getParam("vbid").getValue();
            aid = "VB-" + this.shelfSlotStr + "-" + vbid;
            vlanid = String.valueOf(vlanIdList.get(i));
            portNoList = inputrow.getParam("portNoList").getValue();
            input.getPart("AID").setValue(aid);
            input.getPart("VLANID").setValue(vlanid);
            input.getPart("VBLPLIST").setValue(this.getVBLpList(vbid, portNoList));
            tempOperList_vlan.add(operation.clone());
        }
        return tempOperList_vlan;
    }

    public ArrayList getVlanIdArr(String vlanStr) {
        String[] vlanArr = vlanStr.split(",");
        ArrayList<String> resultVlanArr = new ArrayList<String>();
        int len = 0;
        int arrlen = vlanArr.length;
        for (int i = 0; i < arrlen; ++i) {
            if (-1 == vlanArr[i].indexOf("-")) {
                resultVlanArr.add(vlanArr[i]);
                continue;
            }
            String[] tempArr = vlanArr[i].split("-");
            resultVlanArr.add(tempArr[0]);
            int tempVar = Integer.parseInt(tempArr[0]);
            len = Integer.parseInt(tempArr[1]) - tempVar;
            for (int j = 0; j < len; ++j) {
                resultVlanArr.add(tempVar + j + 1 + "");
            }
        }
        return resultVlanArr;
    }

    public String getVBLpList(String vbid, String portNoList) {
        StringBuffer vblpStr = new StringBuffer();
        int vbPortId = -1;
        String[] vbPortArr = portNoList.split(",");
        String prefix = "VBLP-" + this.shelfSlotStr + "-" + vbid + "-";
        int len = vbPortArr.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                vblpStr.append("&");
            }
            vbPortId = (vbPortId = Integer.parseInt(vbPortArr[i])) < 28672 ? vbPortId : vbPortId - 28672;
            vblpStr.append(prefix).append(vbPortId);
        }
        return vblpStr.toString();
    }
}

