/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.vbmountport;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TENEVBContainer;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TEQueryVBMountPortBean
extends TETL1NEExplorerBean {
    private static final String RTRV_GETH = "RTRV-GETH";
    private static final String RTRV_FETH = "RTRV-FETH";
    private static final String RTRV_XGETH = "RTRV-XGETH";
    private static final String RTRV_VBLP = "RTRV-VBLP";
    private static final String STRING_VBLP = "VBLP";
    private static final String STRING_FAC = "FAC";
    private static final String STRING_ACC = "ACC";
    private static final String STRING_PORT = "PORT";
    private static final String STRING_VCTRUNK = "VCTRUNK";
    private static final int VCTRUNK_FLAG = 32768;
    private static final int VBPORT_FLAG = 28672;
    private String vbid = "";
    private int nmSlotId = -1;
    String shelfSlotStr = "";
    private static final int VBLP27_PORT = 27;
    private static final int VBLP28_PORT = 28;
    private static final int VBLP7_PORT = 7;
    private static final int VBLP8_PORT = 8;

    public TEQueryVBMountPortBean() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        Object[] slotIDArr = this.slotIDList.toArray();
                        int slotID = (Integer)slotIDArr[0];
                        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
                        return this.outputData;
                    }
                }
            }
            this.tl1OperList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.tl1OperList || 0 == this.tl1OperList.size()) {
                this.handleMessage(neid, this.tl1OperList, subFunc);
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        TL1Definitions definitions = null;
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        Param param = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        TL1Operation operation = null;
        InMsg input = null;
        param = inputData.getBussinessParams().getRowParams(0).getParam("slotid");
        this.nmSlotId = Integer.parseInt(param.getValue());
        this.shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)this.nmSlotId);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.nmSlotId);
        param = inputData.getBussinessParams().getRowParams(0).getParam("vbid");
        this.vbid = param.getValue();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        int shelfType = TEBoardUtil.getTl1SubrackTypeInt((int)neid, (int)ne.getNEType(), (int)this.nmSlotId);
        ArrayList vbinfo = TENEVBContainer.getInstance(neid).getVBList(neid).getLinkPortList(this.vbid);
        if (vbinfo == null) {
            return operList;
        }
        TELinkPortInfo linkport = null;
        String linkPortStr = "";
        int linkPortId = -1;
        String aid = "";
        String prefix = "";
        String vblpStr = "";
        int vblpId = -1;
        String mod1 = "";
        String cmdCode = "";
        int infolen = vbinfo.size();
        for (int i = 0; i < infolen; ++i) {
            linkport = (TELinkPortInfo)vbinfo.get(i);
            linkPortStr = linkport.getPortId();
            linkPortId = Integer.parseInt(linkPortStr);
            vblpStr = linkport.getLpNo();
            vblpId = Integer.parseInt(vblpStr) - 28672;
            if (!linkPortStr.equals("0")) {
                prefix = linkPortId < 32768 ? STRING_FAC : STRING_ACC;
                int n = linkPortId = linkPortId < 32768 ? linkPortId : linkPortId - 32768;
                if (this.isNotSupportDev(neid, shelfType, boardType, vblpId)) continue;
                operation = definitions.getTL1Operation(RTRV_GETH);
                input = operation.getInMsg();
                aid = prefix + "-" + this.shelfSlotStr + "-" + linkPortId;
                input.getPart("AID").setValue(aid);
                mod1 = prefix.equals(STRING_FAC) ? this.aidAndTypeList.getPayLoadMod2(this.neid, this.nmSlotId, linkPortId) : this.aidAndTypeList.getPayLoadMod2(this.neid, this.nmSlotId, linkPortId + 32768);
                if (!mod1.equals("")) {
                    cmdCode = operation.getCmdCode();
                    operation.setName(cmdCode + "-" + mod1);
                    operation.setMod1(mod1);
                }
                operList.add(operation);
            }
            aid = "VBLP-" + this.shelfSlotStr + "-" + this.vbid + "-" + vblpId;
            if (this.isNotSupportDev(neid, shelfType, boardType, vblpId)) continue;
            operation = definitions.getTL1Operation(RTRV_VBLP);
            input = operation.getInMsg();
            input.getPart("AID").setValue(aid);
            operList.add(operation);
        }
        return operList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowParams = null;
        RowParams errRow = new RowParams();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        boolean allSucc = true;
        int vbport = -1;
        TL1Operation operation = null;
        String portStr = "";
        int portId = -1;
        String aidStr = "";
        String prefix = "";
        String tl1CmdName = "";
        String vblpStr = "";
        int vblpId = -1;
        Part part = null;
        Param param = null;
        String tempStr = "";
        ArrayList portList = TENEVBContainer.getInstance(neid).getVBList(neid).getLinkPorts(this.vbid);
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.nmSlotId);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        String showSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)this.nmSlotId);
        if (portList != null) {
            int listlen = portList.size();
            for (int i = 0; i < listlen; ++i) {
                TELinkPortInfo linkport = (TELinkPortInfo)portList.get(i);
                vbport = Integer.parseInt(linkport.getLpNo());
                rowParams = new RowParams();
                rowParams.addParam("linkid", "");
                rowParams.addParam("vbport", String.valueOf(vbport -= 28672));
                rowParams.addParam("portid", linkport.getPortId());
                rowParams.addParam("portname", linkport.getPortName());
                rowParams.addParam("porttype", linkport.getPortType());
                rowParams.addParam("direction", linkport.getDirection());
                rowParams.addParam("portenable", linkport.getPortEnable());
                rowParams.addParam("portTag", linkport.getPortTag());
                rowParams.addParam("VLAN", linkport.getDefaultVlan());
                rowParams.addParam("VLANPRIORITY", linkport.getVlanPriority());
                rowParams.addParam("ATTR_ETHOVERSDH_MAC_WORKMODE", linkport.getWorkMode());
                rowParams.addParam("hubspoke", linkport.getHubspoke());
                rowParams.addParam("opertype", linkport.getLinkType());
                rowParams.addParam("cvlan", linkport.getCVlan());
                rowParams.addParam("svlan", linkport.getSVlan());
                int operlen = operationList.size();
                for (int j = 0; j < operlen; ++j) {
                    operation = (TL1Operation)operationList.get(j);
                    aidStr = operation.getInMsg().getPart("AID").getValue();
                    String[] aidSplit = TETL1CommonUtil.parseAID((String)aidStr, (int)this.neid);
                    prefix = aidSplit[0];
                    portStr = aidSplit[3];
                    portId = Integer.parseInt(portStr);
                    portId = prefix.equals(STRING_FAC) ? portId : portId + 32768;
                    portStr = String.valueOf(portId);
                    tl1CmdName = operation.getName();
                    if ((tl1CmdName.equals(RTRV_GETH) || tl1CmdName.equals(RTRV_XGETH) || tl1CmdName.equals(RTRV_FETH)) && linkport.getPortId().equals(portStr)) {
                        if (TETL1CommonUtil.isOperSuccess((TL1Operation)operation, (boolean)false)) {
                            tempStr = "-";
                            param = rowParams.getParam("porttype");
                            part = operation.getOutMsg(0).getMsgBlock().getPart("PORTTYPE");
                            if (part != null && part.getValue() != null) {
                                tempStr = part.getValue();
                            }
                            param.setValue(tempStr);
                            tempStr = "-";
                            param = rowParams.getParam("portenable");
                            part = operation.getOutMsg(0).getMsgBlock().getPart("PORTENABLE");
                            if (part != null && part.getValue() != null) {
                                tempStr = part.getValue();
                            }
                            param.setValue(tempStr);
                            tempStr = "-";
                            param = rowParams.getParam("portTag");
                            part = operation.getOutMsg(0).getMsgBlock().getPart("TAGTYPE");
                            if (part != null && part.getValue() != null) {
                                tempStr = part.getValue();
                            }
                            param.setValue(tempStr);
                            tempStr = "-";
                            param = rowParams.getParam("VLAN");
                            part = operation.getOutMsg(0).getMsgBlock().getPart("PVID");
                            if (part != null && part.getValue() != null) {
                                tempStr = part.getValue();
                            }
                            param.setValue(tempStr);
                            tempStr = "-";
                            param = rowParams.getParam("VLANPRIORITY");
                            part = operation.getOutMsg(0).getMsgBlock().getPart("PVPRI");
                            if (part != null && part.getValue() != null) {
                                tempStr = part.getValue();
                            }
                            param.setValue(tempStr);
                            tempStr = "-";
                            param = rowParams.getParam("ATTR_ETHOVERSDH_MAC_WORKMODE");
                            part = operation.getOutMsg(0).getMsgBlock().getPart("WORKMODE");
                            if (part != null && part.getValue() != null) {
                                tempStr = part.getValue();
                            }
                            param.setValue(tempStr);
                        } else {
                            allSucc = false;
                            errorMessage.setErrorcode(operation.getOutMsg(0).getFault().getErrCode());
                            errorMessage.setErrorinfo(operation.getOutMsg(0).getFault().getErrDesc());
                            rowError.setErrorMessage(errorMessage);
                            errorparam = new Param("neid", String.valueOf(neid));
                            rowError.addParam(errorparam);
                            errorparam = new Param("slotid", showSlot + "-" + boardName);
                            rowError.addParam(errorparam);
                            errorparam = new Param("portid", aidSplit[3]);
                            rowError.addParam(errorparam);
                            errRow.addRowErrors(rowError);
                        }
                    }
                    vblpStr = linkport.getLpNo();
                    vblpId = Integer.parseInt(vblpStr);
                    vblpStr = String.valueOf(vblpId -= 28672);
                    if (!operation.getName().equals(RTRV_VBLP) || !aidSplit[4].equals(vblpStr) || operation.getOutMsgCount() == 0) continue;
                    if (operation.getOutMsg(0).getFault().getCompletionCode() == 0) {
                        rowParams.getParam("hubspoke").setValue(operation.getOutMsg(0).getMsgBlock().getPart("ISOLATION").getValue());
                        continue;
                    }
                    allSucc = false;
                    errorMessage.setErrorcode(operation.getOutMsg(0).getFault().getErrCode());
                    errorMessage.setErrorinfo(operation.getOutMsg(0).getFault().getErrDesc());
                    rowError.setErrorMessage(errorMessage);
                    errorparam = new Param("neid", String.valueOf(neid));
                    rowError.addParam(errorparam);
                    errorparam = new Param("slotid", showSlot + "-" + boardName);
                    rowError.addParam(errorparam);
                    errorparam = new Param("vbid", "VBID-" + aidSplit[3]);
                    rowError.addParam(errorparam);
                    errorparam = new Param("vbport", STRING_PORT + aidSplit[4]);
                    rowError.addParam(errorparam);
                    errRow.addRowErrors(rowError);
                }
                bussinessParams.addRowParams(rowParams);
            }
        }
        if (null != errRow) {
            bussinessParams.addRowParams(errRow);
        }
        this.outputData.setBussinessParams(bussinessParams);
        if (allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (bussinessParams.getRowParamList().size() == 1) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
        this.addPortInfo();
    }

    private String getEthPort(String aidPre, String portno) {
        if (aidPre.equalsIgnoreCase(STRING_FAC)) {
            return STRING_PORT + portno;
        }
        return STRING_VCTRUNK + portno;
    }

    private void addPortInfo() {
        HashMap aidAndTypeMap = this.aidAndTypeList.getAidAndTypeMap();
        ArrayList aidAndTypeList = (ArrayList)aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)this.nmSlotId));
        RowParams rowparam = null;
        int len = aidAndTypeList.size();
        for (int i = 0; i < len; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String aid = aidType.getAid();
            if ((aid = aid.toUpperCase()).indexOf(STRING_FAC) == -1 && aid.indexOf(STRING_ACC) == -1 || aidType.getPldType().equals("")) continue;
            String[] aidarr = TETL1CommonUtil.parseAID((String)aid, (int)this.neid);
            String portname = this.getEthPort(aidarr[0], aidarr[3]);
            rowparam = new RowParams();
            rowparam.addParam("portname", portname);
            rowparam.addParam("mod2", aidType.getPldType());
            rowparam.addParam("acttype", aidType.getType());
            rowparam.addParam("isVBData", "2");
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
    }

    private boolean isNotSupportDev(int neid, int shelfType, int boardType, int vblpId) {
        return !(shelfType != 73 && shelfType != 75 && shelfType != 85 || (boardType != 2110 || vblpId != 7 && vblpId != 8) && (boardType != 2109 || vblpId != 27 && vblpId != 28));
    }
}

