/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.vbmountport;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TENEVBContainer;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TEVBInfoList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashSet;

public class TECfgPBMountPortBean
extends TETL1NEExplorerBean {
    private static final String DLT_VBLINK = "DLT-ETHLINK";
    private static final String ENT_ETHLINK = "ENT-ETHLINK";
    private static final String ED_GETH = "ED-GETH";
    private static final String NA_VALUESTR = "65535";
    private static final int VBPORT_FLAG = 28672;
    private static final int VCTRUNK_FLAG = 32768;
    private static final int PARTSUCESS = 1;
    private static final int FAIL = 2;
    private static final String TAG_AWARE = "TAGAWARE";
    private static final String STRING_FAC = "FAC";
    private static final String STRING_ACC = "ACC";
    private static final String STRING_VBLP = "VBLP";
    private ArrayList newInfoList = new ArrayList();
    private ArrayList delInfoList = new ArrayList();
    private ArrayList tempResultOperList = new ArrayList();
    private ArrayList oldInfoList = new ArrayList();
    private boolean needAddOper = true;
    private boolean needDelOper = true;
    private TEVBInfoList nevbInfo = null;
    TL1Definitions definitions = null;
    String vbid = "";
    int nmSlotId = -1;
    String shelfSlotStr = "";

    public TECfgPBMountPortBean() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.inputData = inputData;
            this.neid = neid;
            this.subfunc = subFunc;
            this.outputData = new Datainterface();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        Object[] slotIDArr = this.slotIDList.toArray();
                        int slotID = (Integer)slotIDArr[0];
                        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
                        return this.outputData;
                    }
                }
            }
            this.nevbInfo = TENEVBContainer.getInstance(neid).getVBList(neid);
            this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            if (null == this.tl1OperList || this.tl1OperList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (0 == result) {
                this.tempResultOperList.addAll(this.tl1OperList);
                this.tl1OperList.clear();
                if (this.needDelOper) {
                    this.tl1OperList = this.getSencondOper();
                    this.sendSecondCommond();
                }
                if (this.tl1OperList != null && this.tl1OperList.size() != 0) {
                    this.tempResultOperList.addAll(this.tl1OperList);
                }
                this.handleMessage(neid, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            int operaterResult = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            if (operaterResult == 1 || operaterResult == 2) {
                Param param = new Param();
                param.setName("vbfailid");
                param.setValue(this.vbid);
                for (int i = 0; i < this.outputData.getBussinessParams().getRowParamsCount(); ++i) {
                    RowErrors[] errors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    for (int j = 0; j < errors.length; ++j) {
                        errors[j].addParam(param);
                    }
                }
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void sendSecondCommond() {
        int result = -1;
        if (null != this.tl1OperList && 0 != this.tl1OperList.size() && 0 != (result = this.sendMessage(this.neid, this.tl1OperList))) {
            BussinessParams bussinessParams = new BussinessParams();
            RowParams rowParams = new RowParams();
            RowErrors rowError = new RowErrors();
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            Param param = new Param();
            param.setName("neid");
            param.setValue(String.valueOf(this.neid));
            rowError.addParam(param);
            rowParams.addRowErrors(rowError);
            bussinessParams.addRowParams(rowParams);
            this.outputData.setBussinessParams(bussinessParams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            this.definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getTL1Operation fail!", (Throwable)e);
            return null;
        }
        ArrayList sendOperList = new ArrayList();
        TELinkPortInfo aInfo = null;
        RowParams rowparam = null;
        Param param = null;
        String vbport = "";
        String portid = "";
        String linktype = "";
        String porttype = "";
        String cvlan = "";
        String svlan = "";
        String vlan = "";
        String portTag = "";
        String vlanPriority = "";
        String workMode = "";
        int lpNo = -1;
        int inputlen = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < inputlen; ++i) {
            rowparam = inputData.getBussinessParams().getRowParams(i);
            if (this.vbid.equals("") || this.nmSlotId == -1) {
                this.nmSlotId = Integer.parseInt(rowparam.getParam("slotid").getValue());
                this.shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)this.nmSlotId);
                this.vbid = rowparam.getParam("vbid").getValue();
            }
            if (rowparam.getParam("linktype").getValue().equals("-1")) break;
            vbport = "";
            param = rowparam.getParam("vbport");
            if (param != null && param.getValue() != null) {
                vbport = param.getValue();
                lpNo = Integer.parseInt(vbport);
                lpNo = lpNo < 28672 ? lpNo + 28672 : lpNo;
                vbport = String.valueOf(lpNo);
            }
            portid = "";
            param = rowparam.getParam("portid");
            if (param != null && param.getValue() != null) {
                portid = param.getValue();
            }
            linktype = "";
            param = rowparam.getParam("linktype");
            if (param != null && param.getValue() != null) {
                linktype = param.getValue();
            }
            porttype = "";
            param = rowparam.getParam("porttype");
            if (param != null && param.getValue() != null) {
                porttype = param.getValue();
            }
            cvlan = "-";
            param = rowparam.getParam("cvlan");
            if (param != null && param.getValue() != null) {
                cvlan = param.getValue();
            }
            svlan = "-";
            param = rowparam.getParam("svlan");
            if (param != null && param.getValue() != null) {
                svlan = param.getValue();
            }
            portTag = "-";
            param = rowparam.getParam("portTag");
            if (param != null && param.getValue() != null) {
                portTag = param.getValue();
            }
            vlan = "-";
            param = rowparam.getParam("VLAN");
            if (param != null && param.getValue() != null) {
                vlan = param.getValue();
            }
            vlanPriority = "-";
            param = rowparam.getParam("VLANPRIORITY");
            if (param != null && param.getValue() != null) {
                vlanPriority = param.getValue();
            }
            workMode = "-";
            param = rowparam.getParam("ATTR_ETHOVERSDH_MAC_WORKMODE");
            if (param != null && param.getValue() != null) {
                workMode = param.getValue();
            }
            aInfo = new TELinkPortInfo();
            aInfo.setPortAttribute(vbport, portid, linktype, porttype, cvlan, svlan);
            aInfo.setPortTag(portTag);
            aInfo.setDefaultVlan(vlan);
            aInfo.setVlanPriority(vlanPriority);
            aInfo.setWorkMode(workMode);
            this.newInfoList.add(aInfo);
        }
        this.oldInfoList = this.nevbInfo.getLinkPorts(this.vbid);
        TELinkPortInfo anOldInfo = null;
        int oldInfoListSize = 0;
        if (this.oldInfoList != null) {
            oldInfoListSize = this.oldInfoList.size();
        }
        for (int i = 0; i < oldInfoListSize; ++i) {
            anOldInfo = (TELinkPortInfo)this.oldInfoList.get(i);
            sendOperList.addAll(this.getDelLinkOperarion(anOldInfo));
        }
        if (0 == sendOperList.size() && 0 != this.newInfoList.size()) {
            sendOperList.addAll(this.getAddOperation());
            this.needDelOper = false;
        }
        return sendOperList;
    }

    public ArrayList getDelLinkOperarion(TELinkPortInfo anOldInfo) {
        TL1Operation operation = null;
        InMsg input = null;
        ArrayList<TL1Operation> sendOperList = new ArrayList<TL1Operation>();
        String vblpStr = "";
        int vblpId = -1;
        String linkfrom = "";
        String linkto = "";
        String linktoPortStr = "";
        int linktoPortId = -1;
        String prefix = "";
        boolean stillExist = false;
        TELinkPortInfo tempInfo = null;
        for (int i = this.newInfoList.size() - 1; i >= 0; --i) {
            tempInfo = (TELinkPortInfo)this.newInfoList.get(i);
            if (!tempInfo.getLpNo().equals(anOldInfo.getLpNo()) || !tempInfo.getPortId().equals(anOldInfo.getPortId()) || !tempInfo.getCVlan().equals(anOldInfo.getCVlan()) || !tempInfo.getSVlan().equals(anOldInfo.getSVlan())) continue;
            stillExist = true;
            this.newInfoList.remove(i);
            break;
        }
        if (!stillExist) {
            operation = this.definitions.getTL1Operation(DLT_VBLINK);
            input = operation.getInMsg();
            vblpStr = anOldInfo.getLpNo();
            vblpId = Integer.parseInt(vblpStr);
            vblpId = vblpId < 28672 ? vblpId : vblpId - 28672;
            linkfrom = "VBLP-" + this.shelfSlotStr + "-" + this.vbid + "-" + vblpId;
            input.getPart("LINKTO").setValue(linkfrom);
            linktoPortStr = anOldInfo.getPortId();
            linktoPortId = Integer.parseInt(linktoPortStr);
            prefix = linktoPortId < 32768 ? STRING_FAC : STRING_ACC;
            linktoPortId = linktoPortId < 32768 ? linktoPortId : linktoPortId - 32768;
            linkto = prefix + "-" + this.shelfSlotStr + "-" + linktoPortId;
            input.getPart("LINKFROM").setValue(linkto);
            if (!anOldInfo.getCVlan().equals(NA_VALUESTR)) {
                input.getPart("INTAG").setValue(anOldInfo.getCVlan());
            }
            if (!anOldInfo.getSVlan().equals(NA_VALUESTR)) {
                input.getPart("INSTAG").setValue(anOldInfo.getSVlan());
            }
            sendOperList.add(operation);
            this.delInfoList.add(anOldInfo);
            this.newInfoList.remove(anOldInfo);
        }
        return sendOperList;
    }

    public ArrayList getSencondOper() {
        ArrayList sendOperList = new ArrayList();
        ArrayList<String> failDelPortList = new ArrayList<String>();
        TL1Operation tempOper = null;
        ArrayList<TELinkPortInfo> delLinkList = new ArrayList<TELinkPortInfo>();
        int operlen = this.tempResultOperList.size();
        for (int i = 0; i < operlen; ++i) {
            tempOper = (TL1Operation)this.tempResultOperList.get(i);
            TELinkPortInfo delInfo = (TELinkPortInfo)this.delInfoList.get(i);
            if (tempOper.getOutMsgCount() == 0 || tempOper.getOutMsg(0).getFault().getCompletionCode() == 0) {
                delLinkList.add(delInfo);
                continue;
            }
            failDelPortList.add(delInfo.getPortId());
        }
        if (0 != delLinkList.size()) {
            this.nevbInfo.deletePBPort(this.vbid, delLinkList);
        }
        this.delFailDelPort(failDelPortList);
        if (null != this.newInfoList) {
            sendOperList = this.getAddOperation();
        } else {
            this.needAddOper = false;
            sendOperList.clear();
        }
        return sendOperList;
    }

    public void delFailDelPort(ArrayList failDelPortList) {
        TELinkPortInfo aInfo = null;
        for (int i = this.newInfoList.size() - 1; i > 0; --i) {
            aInfo = (TELinkPortInfo)this.newInfoList.get(i);
            if (!failDelPortList.contains(aInfo.getPortId())) continue;
            this.newInfoList.remove(i);
        }
    }

    public ArrayList getAddOperation() {
        String vblpStr = "";
        int vblpId = -1;
        String linkfrom = "";
        String linkto = "";
        String linktoPortStr = "";
        int linktoPortId = -1;
        String prefix = "";
        String tempStr = "";
        if (null == this.newInfoList || 0 == this.newInfoList.size()) {
            return null;
        }
        ArrayList<TL1Operation> sendOperList = new ArrayList<TL1Operation>();
        TL1Operation operation = null;
        InMsg input = null;
        String portStr = "";
        int portId = -1;
        String aid = "";
        String cmdCode = "";
        String mod1 = "";
        int infolen = this.newInfoList.size();
        for (int i = 0; i < infolen; ++i) {
            TELinkPortInfo aInfo = (TELinkPortInfo)this.newInfoList.get(i);
            operation = this.definitions.getTL1Operation(ED_GETH);
            portStr = aInfo.getPortId();
            portId = Integer.parseInt(portStr);
            prefix = portId < 32768 ? STRING_FAC : STRING_ACC;
            portId = portId < 32768 ? portId : portId - 32768;
            aid = prefix + "-" + this.shelfSlotStr + "-" + portId;
            input = operation.getInMsg();
            input.getPart("AID").setValue(aid);
            tempStr = aInfo.getPortType();
            if (!tempStr.equals("") && !tempStr.equals("-")) {
                input.getPart("PORTTYPE").setValue(tempStr);
            }
            if (prefix.equals(STRING_FAC)) {
                tempStr = aInfo.getPortEnable();
                if (!tempStr.equals("") && !tempStr.equals("-")) {
                    input.getPart("PORTENABLE").setValue(tempStr);
                }
                if (!(tempStr = aInfo.getWorkMode()).equals("") && !tempStr.equals("-")) {
                    input.getPart("WORKMODE").setValue(tempStr);
                }
            }
            String portTag = aInfo.getPortTag();
            input.getPart("TAGTYPE").setValue(portTag);
            if (!portTag.equals(TAG_AWARE)) {
                tempStr = aInfo.getDefaultVlan();
                if (!tempStr.equals("") && !tempStr.equals("-")) {
                    input.getPart("PVID").setValue(tempStr);
                }
                if (!(tempStr = aInfo.getVlanPriority()).equals("") && !tempStr.equals("-")) {
                    input.getPart("PVPRI").setValue(tempStr);
                }
            }
            if (!(mod1 = prefix.equals(STRING_FAC) ? this.aidAndTypeList.getPayLoadMod2(this.neid, this.nmSlotId, portId) : this.aidAndTypeList.getPayLoadMod2(this.neid, this.nmSlotId, portId + 32768)).equals("")) {
                cmdCode = operation.getCmdCode();
                operation.setName(cmdCode + "-" + mod1);
                operation.setMod1(mod1);
            }
            sendOperList.add(operation);
            operation = this.definitions.getTL1Operation(ENT_ETHLINK);
            input = operation.getInMsg();
            vblpStr = aInfo.getLpNo();
            vblpId = Integer.parseInt(vblpStr);
            vblpId = vblpId < 28672 ? vblpId : vblpId - 28672;
            linkfrom = "VBLP-" + this.shelfSlotStr + "-" + this.vbid + "-" + vblpId;
            input.getPart("LINKFROM").setValue(linkfrom);
            linktoPortStr = aInfo.getPortId();
            linktoPortId = Integer.parseInt(linktoPortStr);
            prefix = linktoPortId < 32768 ? STRING_FAC : STRING_ACC;
            linktoPortId = linktoPortId < 32768 ? linktoPortId : linktoPortId - 32768;
            linkto = prefix + "-" + this.shelfSlotStr + "-" + linktoPortId;
            input.getPart("LINKTO").setValue(linkto);
            tempStr = aInfo.getCVlan();
            if (!tempStr.equals(NA_VALUESTR) && !tempStr.equals("-")) {
                input.getPart("OUTTAG").setValue(tempStr);
            }
            if (!(tempStr = aInfo.getSVlan()).equals(NA_VALUESTR)) {
                input.getPart("OUTSTAG").setValue(tempStr);
            }
            if (!(tempStr = aInfo.getDirection()).equals("-")) {
                input.getPart("CTYPE").setValue(tempStr);
            }
            sendOperList.add(operation);
        }
        return sendOperList;
    }

    public void handleMessage(int neid, SubFunc subfunc) {
        int newInfoIndex = 0;
        TL1Operation operation = null;
        TELinkPortInfo aInfo = null;
        if (this.needAddOper) {
            int listlen = this.tempResultOperList.size();
            for (int i = 0; i < listlen; ++i) {
                operation = (TL1Operation)this.tempResultOperList.get(i);
                if (!operation.getName().equals(ENT_ETHLINK)) continue;
                if (operation.getOutMsgCount() != 0 && operation.getOutMsg(0).getFault().getCompletionCode() != 0) {
                    ++newInfoIndex;
                    continue;
                }
                aInfo = (TELinkPortInfo)this.newInfoList.get(newInfoIndex);
                if (this.nevbInfo.hasVB(this.vbid)) {
                    this.nevbInfo.setPortAttribute(this.vbid, aInfo.getLpNo(), aInfo.getPortId(), aInfo.getDirection(), aInfo.getLinkType(), aInfo.getPortType(), aInfo.getCVlan(), aInfo.getSVlan());
                }
                ++newInfoIndex;
            }
        }
        super.handleMessage(neid, this.tempResultOperList, subfunc, null);
        this.addErrorParams(this.inputData, this.outputData, this.neid);
    }

    private void addErrorParams(Datainterface inputData, Datainterface outputData, int neid) {
        RowParams rowparams = null;
        Param param = null;
        RowErrors rowerror = null;
        if (outputData == null || outputData.getBussinessParams() == null || inputData == null) {
            return;
        }
        int rowCount = outputData.getBussinessParams().getRowParamsCount();
        if (rowCount == 0) {
            return;
        }
        rowparams = outputData.getBussinessParams().getRowParams(rowCount - 1);
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        String nename = neObj.getNEName();
        int iSlotId = -1;
        int portid = -1;
        String portStr = "";
        String prefix = "";
        String portname = "";
        RowParams inputRow = inputData.getBussinessParams().getRowParams(0);
        String slotid = "UNKNOWN";
        int boardType = -1;
        String boardname = "UNKNOWN";
        TEBoard board = null;
        if (inputRow != null && (param = inputRow.getParam("slotid")) != null && param.getValue() != null) {
            slotid = param.getValue();
            board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(slotid));
            if (board != null) {
                boardname = board.getBoardName();
                boardType = board.getBoardType();
            } else {
                param = inputRow.getParam("boardType");
                if (param != null && param.getValue() != null) {
                    boardType = Integer.parseInt(param.getValue());
                    boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
                }
            }
        }
        int size = rowparams.getRowErrorsCount();
        for (int i = 0; i < size; ++i) {
            rowerror = rowparams.getRowErrors(i);
            param = rowerror.getParam("nename");
            if (param == null) {
                param = new Param();
                param.setName("nename");
                param.setValue(nename);
                rowerror.addParam(param);
            } else {
                param.setValue(nename);
            }
            param = rowerror.getParam("slotid");
            if (param == null) {
                param = new Param();
                param.setName("slotid");
                param.setValue(slotid);
                rowerror.addParam(param);
            } else {
                param.setValue(boardname);
            }
            String slotvar = TETL1CommonUtil.getShelfSlotName((int)neid, (int)Integer.parseInt(slotid));
            param = rowerror.getParam("boardname");
            if (param == null) {
                param = new Param();
                param.setName("boardname");
                param.setValue(slotvar + "-" + boardname);
                rowerror.addParam(param);
            } else {
                param.setValue(slotvar + "-" + boardname);
            }
            param = rowerror.getParam("LINKTO");
            if (param == null || param.getValue() == null) {
                param = rowerror.getParam("AID");
            }
            if (param == null || param.getValue() == null) continue;
            String[] aidSplit = TETL1CommonUtil.parseAID((String)param.getValue(), (int)this.neid);
            prefix = aidSplit[0];
            portStr = aidSplit[3];
            portid = Integer.parseInt(portStr);
            if (prefix.equals(STRING_ACC)) {
                portname = "VCTRUNK-" + portid;
            } else {
                iSlotId = Integer.parseInt(slotid);
                portname = TEConfigurationDataMgr.getInstance().getPortName(neid, iSlotId, boardType, portid);
            }
            portid = prefix.equals(STRING_FAC) ? portid : portid + 32768;
            param = rowerror.getParam("portname");
            if (param == null) {
                param = new Param();
                param.setName("portname");
                param.setValue(portname);
                rowerror.addParam(param);
            } else {
                param.setValue(portname);
            }
            param = rowerror.getParam("portid");
            if (param == null) {
                param = new Param();
                param.setName("portid");
                param.setValue(String.valueOf(portid));
                rowerror.addParam(param);
                continue;
            }
            param.setValue(String.valueOf(portid));
        }
    }
}

