/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice;

import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TELinkPortInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class TEVBInfoList {
    private static final int VBPORT_FLG = 28672;
    private static final String NA_VALUESTR = "65535";
    private static final String PORTTYPE_UNI = "UNI";
    private HashMap vbMemMap = new HashMap();
    private ArrayList otherLinkPortList = new ArrayList();

    public void clearMemData() {
        this.vbMemMap.clear();
        this.otherLinkPortList.clear();
    }

    public ArrayList getLinkPortList(String vbid) {
        return (ArrayList)this.vbMemMap.get(vbid);
    }

    public void addItem(String vbid) {
        ArrayList linkPortList = new ArrayList();
        this.vbMemMap.put(vbid, linkPortList);
    }

    public void initVBLink(String vbid, int lpCount) {
        ArrayList linkPortList = null;
        if (!this.hasVB(vbid)) {
            return;
        }
        linkPortList = this.getLinkPorts(vbid);
        TELinkPortInfo linkPortInfo = null;
        int lpNo = 0;
        for (int i = 0; i < lpCount; ++i) {
            linkPortInfo = new TELinkPortInfo();
            lpNo = 28672 + i + 1;
            linkPortInfo.setLpNo(String.valueOf(lpNo));
            linkPortList.add(linkPortInfo);
        }
    }

    public void addPort(String vbid, String lpNo, TELinkPortInfo linkPort) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        linkPortList.add(linkPort);
    }

    public void setPortAttribute(String vbid, String lpNo, String portid, String direction) {
        TELinkPortInfo linkPort = this.getLinkPortInfoByLpNo(vbid, lpNo);
        if (linkPort != null) {
            linkPort.setPortAttribute(lpNo, portid, "", PORTTYPE_UNI, NA_VALUESTR, NA_VALUESTR);
        }
    }

    public void setPortAttribute(String vbid, String lpNo, String portid, String direction, String linktype, String porttype, String cvlan, String svlan) {
        TELinkPortInfo linkPort = new TELinkPortInfo();
        linkPort.setPortAttribute(lpNo, portid, linktype, porttype, cvlan, svlan);
        ArrayList linkPortList = this.getLinkPortList(vbid);
        linkPortList.add(linkPort);
    }

    public void delPortAttribute(String vbid, String lpNo) {
        TELinkPortInfo linkPort = this.getLinkPortInfoByLpNo(vbid, lpNo);
        linkPort.clearAllAttribute();
    }

    public void delPBLink(String vbid, String lpNo, String portId, String cvlan, String svlan) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        TELinkPortInfo tempLinkPort = null;
        int len = linkPortList.size();
        for (int i = 0; i < len; ++i) {
            tempLinkPort = (TELinkPortInfo)linkPortList.get(i);
            if (!tempLinkPort.getLpNo().equals(lpNo) || !tempLinkPort.getPortId().equals(portId) || !tempLinkPort.getCVlan().equals(cvlan) || !tempLinkPort.getSVlan().equals(svlan)) continue;
            linkPortList.remove(i);
            break;
        }
    }

    public void delVB(String vbid) {
        this.vbMemMap.remove(vbid);
    }

    public boolean hasVB(String vbid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        return linkPortList != null;
    }

    public boolean hasVBLink(String vbid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        TELinkPortInfo tempLinkPort = null;
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            tempLinkPort = (TELinkPortInfo)linkPortList.get(i);
            if (null == tempLinkPort.getPortId() || tempLinkPort.getPortId().equals("") || tempLinkPort.getPortId().equals("0")) continue;
            return true;
        }
        return false;
    }

    public ArrayList getLinkPorts(String vbid) {
        ArrayList portList = this.getLinkPortList(vbid);
        if (null != portList) {
            Collections.sort(portList);
        }
        return portList;
    }

    public ArrayList getPortIdsByVB(String vbid) {
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList portList = this.getLinkPorts(vbid);
        TELinkPortInfo tempLinkPort = null;
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getPortId().equals("0")) continue;
            portidList.add(tempLinkPort.getPortId());
        }
        return portidList;
    }

    public void addOtherLinkPort(String linkPortId) {
        if (this.otherLinkPortList.contains(linkPortId)) {
            return;
        }
        this.otherLinkPortList.add(linkPortId);
    }

    public void clearOtherLinkPort() {
        this.otherLinkPortList.clear();
    }

    public ArrayList getOtherLinkPortList() {
        return this.otherLinkPortList;
    }

    public void deleteLinkport(ArrayList delVBList, ArrayList linkPortList) {
        int vblistlen = delVBList.size();
        for (int i = 0; i < vblistlen; ++i) {
            ArrayList linkPorts = this.getLinkPortList((String)delVBList.get(i));
            if (null == linkPorts) {
                return;
            }
            TELinkPortInfo tempLinkPort = null;
            boolean pblinktypeflg = false;
            int listlen = linkPorts.size();
            for (int j = 0; j < listlen; ++j) {
                tempLinkPort = (TELinkPortInfo)linkPorts.get(j);
                if (tempLinkPort.getLinkType().equals("")) {
                    if (!linkPortList.contains(tempLinkPort.getPortId())) continue;
                    tempLinkPort.clearAllAttribute();
                    continue;
                }
                if (tempLinkPort.getPortId().equals("0")) continue;
                pblinktypeflg = true;
                break;
            }
            if (!pblinktypeflg) continue;
            this.deletePBPort((String)delVBList.get(i), linkPortList);
        }
    }

    public void deletePBPort(String vbid, ArrayList linkPortList) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        if (null == linkPorts) {
            return;
        }
        TELinkPortInfo tempLinkPort = null;
        for (int i = linkPorts.size() - 1; i >= 0; --i) {
            tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (!linkPortList.contains(tempLinkPort.getPortId())) continue;
            linkPorts.remove(i);
        }
    }

    public ArrayList getAllUsedPort() {
        ArrayList<Integer> usedPortList = new ArrayList<Integer>();
        Iterator memMapIt = this.vbMemMap.values().iterator();
        ArrayList linkPorts = null;
        TELinkPortInfo linkPortInfo = null;
        while (memMapIt.hasNext()) {
            linkPorts = (ArrayList)memMapIt.next();
            int len = linkPorts.size();
            for (int i = 0; i < len; ++i) {
                linkPortInfo = (TELinkPortInfo)linkPorts.get(i);
                if (linkPortInfo.getPortId().equals("0") || usedPortList.contains(new Integer(linkPortInfo.getPortId()))) continue;
                usedPortList.add(new Integer(linkPortInfo.getPortId()));
            }
        }
        if (null != this.otherLinkPortList && 0 == this.otherLinkPortList.size()) {
            usedPortList.addAll(this.otherLinkPortList);
        }
        return usedPortList;
    }

    public TELinkPortInfo getLinkPortInfoByLpNo(String vbid, String lpNo) {
        TELinkPortInfo aInfo = null;
        ArrayList linkPortList = this.getLinkPortList(vbid);
        if (linkPortList == null) {
            return null;
        }
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            aInfo = (TELinkPortInfo)linkPortList.get(i);
            if (!aInfo.getLpNo().equals(lpNo)) continue;
            return aInfo;
        }
        return null;
    }
}

