/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TENEVBContainer;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice.lanservice.TEVBInfoList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TECreateVBBean
extends TETL1NEExplorerBean {
    private static final String RTRV_GETH = "RTRV-GETH";
    private static final String RTRV_XGETH = "RTRV-XGETH";
    private static final String RTRV_FETH = "RTRV-FETH";
    private static final String ED_GETH = "ED-GETH";
    private static final String ED_XGETH = "ED-XGETH";
    private static final String ENT_ETHLINK = "ENT-ETHLINK";
    private static final String NA_VALUESTR = "65535";
    private static final int VCTRUNK_FLAG = 32768;
    private static final int VBPORT_FLAG = 28672;
    private static final String PPTENABLE_ENABLE = "Y";
    private static final String TAGTYPE_TAGAWARE = "TAGAWARE";
    private static final String STRING_2WAY = "2WAY";
    private static final String VBTYPE_8021Q = "802.1q";
    private static final String VBTYPE_8021D = "802.1d";
    private static final String VBTYPE_8021AD = "802.1ad";
    private static final String ADD_SVLAN_BASE_PORT = "0";
    private static final String ADD_SVLAN_BASE_PORT_AND_CVLAN = "1";
    private static final String MOUNT_PORT = "2";
    private static final String MOUNT_PORT_AND_BASE_PORT_AND_SVLAN = "3";
    private ArrayList secondSendOperList = new ArrayList();
    private ArrayList tempResultOperList = new ArrayList();
    private TEVBInfoList nevbInfo = null;
    private String vbid = "1";
    private String lpCount = "";
    private String vbtype = "";
    private TL1Definitions definitions = null;

    public TECreateVBBean() {
        this.bQueryAidAndType = true;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        Param vbIdParam = null;
        Param param = null;
        int slotId = 0;
        String tempStr = "";
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIdParam = rowparams.getParam("slotid");
            vbIdParam = rowparams.getParam("vbid");
            if (slotIdParam == null || vbIdParam == null) {
                return false;
            }
            tempStr = slotIdParam.getValue();
            slotId = Integer.parseInt(tempStr);
            tempStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            tempStr = "VB-" + tempStr + "-" + vbIdParam.getValue();
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("VBNAME")) {
            tempStr = "";
            param = rowparams.getParam("vbname");
            if (null != param && null != param.getValue()) {
                tempStr = "\"" + param.getValue() + "\"";
            }
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("FLTREN")) {
            tempStr = "";
            param = rowparams.getParam("ingressfilter");
            if (null != param && null != param.getValue()) {
                tempStr = param.getValue();
            }
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("LEARNMODE")) {
            tempStr = "";
            param = rowparams.getParam("vbstudymode");
            if (null != param && null != param.getValue()) {
                tempStr = param.getValue();
            }
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("TYPE")) {
            tempStr = "";
            param = rowparams.getParam("vbtype");
            if (null != param && null != param.getValue()) {
                tempStr = param.getValue();
                if (tempStr.equals(ADD_SVLAN_BASE_PORT)) {
                    tempStr = VBTYPE_8021Q;
                } else if (tempStr.equals(ADD_SVLAN_BASE_PORT_AND_CVLAN)) {
                    tempStr = VBTYPE_8021D;
                } else if (tempStr.equals(MOUNT_PORT)) {
                    tempStr = VBTYPE_8021AD;
                }
            }
            part.setValue(tempStr);
            this.vbtype = tempStr;
            this.lpCount = rowparams.getParam("lpcount").getValue();
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String faultListSize;
        this.outputData = new Datainterface();
        this.nevbInfo = TENEVBContainer.getInstance(neid).getVBList(neid);
        TL1Operation operation = (TL1Operation)tl1OperList.get(0);
        if (operation.getOutMsgCount() > 0 && !(faultListSize = operation.getOutMsg(0).getFault().getErrCode()).equals("")) {
            TL1Operation tempOper = (TL1Operation)tl1OperList.get(0);
            tl1OperList.clear();
            tl1OperList.add(tempOper);
            RowParams temprow = this.inputData.getBussinessParams().getRowParams(0);
            this.inputData.getBussinessParams().clearRowParams();
            this.inputData.getBussinessParams().addRowParams(temprow);
            super.handleMessage(neid, tl1OperList, subfunc, null);
            RowParams rowparams = null;
            Param param = null;
            String vbid = "";
            int len = this.outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                rowparams = this.outputData.getBussinessParams().getRowParams(i);
                int size = rowparams.getRowErrorsCount();
                for (int j = 0; j < size; ++j) {
                    param = rowparams.getRowErrors(j).getParam("AID");
                    String[] aidSplit = TETL1CommonUtil.parseAID((String)param.getValue(), (int)this.neid);
                    vbid = aidSplit[3];
                    param = new Param();
                    param.setName("vbid");
                    param.setValue(vbid);
                    rowparams.getRowErrors(i).addParam(param);
                }
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            return;
        }
        this.tempResultOperList = (ArrayList)tl1OperList.clone();
        tl1OperList.clear();
        this.nevbInfo.addItem(this.vbid);
        if (this.vbtype.equalsIgnoreCase(VBTYPE_8021Q) || this.vbtype.equalsIgnoreCase(VBTYPE_8021D)) {
            this.nevbInfo.initVBLink(this.vbid, Integer.parseInt(this.lpCount));
        }
        this.sendSecondCommond();
        super.handleMessage(neid, this.tempResultOperList, subfunc, null);
        this.addErrorParams();
    }

    public void sendSecondCommond() {
        int result = -1;
        this.tl1OperList = this.getSecondOperation();
        if (null != this.tl1OperList && 0 != this.tl1OperList.size()) {
            result = this.sendMessage(this.neid, this.tl1OperList);
            if (0 == result) {
                this.tempResultOperList.addAll(this.tl1OperList);
                this.handleSecondData(this.tl1OperList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
        }
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList firstOperList = new ArrayList();
        try {
            this.definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        RowParams[] inputrows = inputData.getBussinessParams().getRowParams();
        Datainterface tempData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        tempData.setBussinessParams(bussiness);
        int rowlen = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowlen; ++i) {
            if (0 == i) {
                bussiness.addRowParams(inputrows[i]);
                firstOperList.addAll(super.getTL1Operation(neid, subFunc, tempData, memeryData));
                continue;
            }
            if (!inputrows[i].getParam("linkportflg").getValue().equals(ADD_SVLAN_BASE_PORT_AND_CVLAN)) continue;
            firstOperList.addAll(this.addPortOperation(inputrows[i]));
        }
        return firstOperList;
    }

    public ArrayList addPortOperation(RowParams inputrow) {
        ArrayList<TL1Operation> firstOperList = new ArrayList<TL1Operation>();
        Param param = null;
        String portName = "";
        int portId = -1;
        String aidPrefix = "";
        String tempStr = "";
        int slotId = -1;
        String shelfSlotId = "";
        String cmdCode = "";
        String vbid = "";
        String vbport = "";
        int vbPortId = -1;
        String mountPortAID = "";
        InMsg input = null;
        TL1Operation operation = null;
        operation = this.definitions.getTL1Operation(ED_GETH);
        param = inputrow.getParam("portname");
        if (param != null && param.getValue() != null && param.getValue() != "") {
            portName = param.getValue();
            if (portName.substring(0, 4).equals("PORT")) {
                portName = portName.substring(4);
                aidPrefix = "FAC";
            } else {
                portName = portName.substring(7);
                aidPrefix = "ACC";
            }
        }
        portId = Integer.parseInt(portName);
        tempStr = inputrow.getParam("slotid").getValue();
        slotId = Integer.parseInt(tempStr);
        shelfSlotId = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
        mountPortAID = aidPrefix + "-" + shelfSlotId + "-" + portName;
        input = operation.getInMsg();
        input.getPart("AID").setValue(mountPortAID);
        param = inputrow.getParam("porttype");
        if (!param.getValue().equals(TECreateVBBean.queryPortType(this.neid, mountPortAID))) {
            input.getPart("PORTTYPE").setValue(param.getValue());
        }
        if (aidPrefix.equals("FAC")) {
            input.getPart("PORTENABLE").setValue(PPTENABLE_ENABLE);
            param = inputrow.getParam("ATTR_ETHOVERSDH_MAC_WORKMODE");
            if (null != param && null != param.getValue()) {
                input.getPart("WORKMODE").setValue(param.getValue());
            }
        }
        String portTag = inputrow.getParam("portTag").getValue();
        input.getPart("TAGTYPE").setValue(portTag);
        if (!portTag.equals(TAGTYPE_TAGAWARE)) {
            param = inputrow.getParam("VLAN");
            if (param != null && !param.getValue().equals("-")) {
                input.getPart("PVID").setValue(param.getValue());
            }
            if ((param = inputrow.getParam("VLANPRIORITY")) != null && !param.getValue().equals("-")) {
                input.getPart("PVPRI").setValue(param.getValue());
            }
        }
        String mod1 = null;
        mod1 = aidPrefix.equals("FAC") ? this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId) : this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId + 32768);
        if (!mod1.equals("")) {
            cmdCode = operation.getCmdCode();
            operation.setName(cmdCode + "-" + mod1);
            operation.setMod1(mod1);
        }
        firstOperList.add(operation);
        operation = this.definitions.getTL1Operation(ENT_ETHLINK);
        input = operation.getInMsg();
        param = inputrow.getParam("vbid");
        vbid = param.getValue();
        param = inputrow.getParam("vbport");
        vbport = param.getValue();
        vbPortId = Integer.parseInt(vbport);
        vbPortId = vbPortId < 28672 ? vbPortId : vbPortId - 28672;
        tempStr = "VBLP-" + shelfSlotId + "-" + vbid + "-" + vbPortId;
        input.getPart("LINKFROM").setValue(tempStr);
        input.getPart("LINKTO").setValue(mountPortAID);
        input.getPart("CTYPE").setValue(STRING_2WAY);
        param = inputrow.getParam("opertype");
        if (null == param || "undefined".equals(param.getValue())) {
            this.secondSendOperList.add(operation);
            return firstOperList;
        }
        param = inputrow.getParam("cvlan");
        if (null != param && !"-".equals(param.getValue())) {
            tempStr = inputrow.getParam("cvlan").getValue();
            input.getPart("OUTTAG").setValue(tempStr);
        }
        if (null != (param = inputrow.getParam("svlan")) && !"-".equals(param.getValue())) {
            tempStr = inputrow.getParam("svlan").getValue();
            input.getPart("OUTSTAG").setValue(tempStr);
        }
        this.secondSendOperList.add(operation);
        return firstOperList;
    }

    public ArrayList getSecondOperation() {
        return this.secondSendOperList;
    }

    public void handleSecondData(ArrayList operList) {
        TL1Operation operation = null;
        int listlen = operList.size();
        for (int i = 0; i < listlen; ++i) {
            operation = (TL1Operation)operList.get(i);
            if (operation.getOutMsgCount() != 0 && operation.getOutMsg(0).getFault().getCompletionCode() != 0) continue;
            this.addMemPortInfo(operation);
        }
    }

    private void addMemPortInfo(TL1Operation operation) {
        Part linkfrom = null;
        Part linkto = null;
        String vblpStr = "";
        int vblpId = -1;
        String portStr = "";
        int portId = -1;
        String prefix = "";
        String[] aidSplit = null;
        TEVBInfoList vbinfo = TENEVBContainer.getInstance(this.neid).getVBList(this.neid);
        if (!this.vbtype.equalsIgnoreCase(VBTYPE_8021AD)) {
            linkfrom = operation.getInMsg().getPart("LINKFROM");
            aidSplit = TETL1CommonUtil.parseAID((String)linkfrom.getValue(), (int)this.neid);
            vblpStr = aidSplit[4];
            vblpId = Integer.parseInt(vblpStr);
            vblpStr = String.valueOf(vblpId += 28672);
            linkto = operation.getInMsg().getPart("LINKTO");
            aidSplit = TETL1CommonUtil.parseAID((String)linkto.getValue(), (int)this.neid);
            prefix = aidSplit[0];
            portStr = aidSplit[3];
            portId = Integer.parseInt(portStr);
            if (!"FAC".equals(prefix)) {
                portStr = String.valueOf(portId += 32768);
            }
            vbinfo.setPortAttribute(this.vbid, vblpStr, portStr, STRING_2WAY);
            return;
        }
        TL1Operation portOper = null;
        String porttype = "";
        String tl1CmdName = "";
        linkto = operation.getInMsg().getPart("LINKTO");
        aidSplit = TETL1CommonUtil.parseAID((String)linkto.getValue(), (int)this.neid);
        prefix = aidSplit[0];
        portStr = aidSplit[3];
        portId = Integer.parseInt(portStr);
        if (!"FAC".equals(prefix)) {
            portStr = String.valueOf(portId += 32768);
        }
        int len = this.tempResultOperList.size();
        for (int i = 0; i < len; ++i) {
            portOper = (TL1Operation)this.tempResultOperList.get(i);
            tl1CmdName = portOper.getName();
            if (!tl1CmdName.equals(ED_GETH) && !tl1CmdName.equals(ED_XGETH) || !portOper.getInMsg().getPart("AID").getValue().equals(operation.getInMsg().getPart("LINKTO").getValue())) continue;
            if (portOper.getInMsg().getPart("PORTTYPE") != null) {
                porttype = portOper.getInMsg().getPart("PORTTYPE").getValue();
                break;
            }
            porttype = TECreateVBBean.queryPortType(this.neid, portOper.getInMsg().getPart("AID").getValue());
            break;
        }
        linkfrom = operation.getInMsg().getPart("LINKFROM");
        aidSplit = TETL1CommonUtil.parseAID((String)linkfrom.getValue(), (int)this.neid);
        vblpStr = aidSplit[4];
        vblpId = Integer.parseInt(vblpStr) + 28672;
        vblpStr = String.valueOf(vblpId);
        String intag = operation.getInMsg().getPart("OUTTAG").getValue();
        String instag = operation.getInMsg().getPart("OUTSTAG").getValue();
        String STRING_CAWARE = "CAWARE";
        String STRING_SAWARE = "SAWARE";
        if (intag == null && porttype.equals(STRING_CAWARE)) {
            vbinfo.setPortAttribute(this.vbid, vblpStr, portStr, STRING_2WAY, ADD_SVLAN_BASE_PORT, STRING_CAWARE, NA_VALUESTR, instag);
            return;
        }
        if (intag != null && instag != null) {
            vbinfo.setPortAttribute(this.vbid, vblpStr, portStr, STRING_2WAY, ADD_SVLAN_BASE_PORT_AND_CVLAN, STRING_CAWARE, intag, instag);
            return;
        }
        if (intag == null && instag == null) {
            vbinfo.setPortAttribute(this.vbid, vblpStr, portStr, STRING_2WAY, MOUNT_PORT, STRING_SAWARE, NA_VALUESTR, NA_VALUESTR);
            return;
        }
        if (intag == null && porttype.equals(STRING_SAWARE)) {
            vbinfo.setPortAttribute(this.vbid, vblpStr, portStr, STRING_2WAY, MOUNT_PORT_AND_BASE_PORT_AND_SVLAN, STRING_SAWARE, NA_VALUESTR, instag);
            return;
        }
    }

    public static String queryPortType(int neid, String Aid) {
        TL1Definitions tl1definitions = null;
        String portType = "";
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return portType;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation(RTRV_GETH);
        TL1Operation tl1Operation2 = tl1definitions.getTL1Operation(RTRV_XGETH);
        TL1Operation tl1Operation3 = tl1definitions.getTL1Operation(RTRV_FETH);
        String tmpAid = Aid;
        tl1Operation.getInMsg().getStagBlock().getAID().getPart(0).setValue(tmpAid);
        tl1Operation2.getInMsg().getStagBlock().getAID().getPart(0).setValue(tmpAid);
        tl1Operation3.getInMsg().getStagBlock().getAID().getPart(0).setValue(tmpAid);
        tl1OperList.add(tl1Operation);
        tl1OperList.add(tl1Operation2);
        tl1OperList.add(tl1Operation3);
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 60);
        if (result.retCode == 0) {
            int len = tl1OperList.size();
            for (int i = 0; i < len; ++i) {
                TL1Operation tOper = (TL1Operation)tl1OperList.get(i);
                int size = tOper.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    HashMap partMap;
                    Part portTypePart;
                    OutMsg output = tOper.getOutMsg(row);
                    if (output.getFault().getCompletionCode() != 0 || (portTypePart = (Part)(partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output)).get("PORTTYPE")) == null) continue;
                    portType = portTypePart.getValue();
                    return portType;
                }
            }
        }
        return portType;
    }

    private void addErrorParams() {
        RowParams rowparams = null;
        Param param = null;
        RowErrors rowerror = null;
        int rowCount = this.outputData.getBussinessParams().getRowParamsCount();
        if (rowCount == 0) {
            return;
        }
        rowparams = this.outputData.getBussinessParams().getRowParams(rowCount - 1);
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)this.neid);
        String nename = neObj.getNEName();
        String slotid = "";
        String boardType = "";
        String boardname = "";
        int iSlotId = -1;
        int iBoardType = -1;
        int portid = -1;
        String portStr = "";
        String prefix = "";
        String portname = "";
        RowParams inputRow = this.inputData.getBussinessParams().getRowParams(0);
        if (inputRow != null) {
            slotid = inputRow.getParam("slotid").getValue();
            boardType = inputRow.getParam("boardType").getValue();
            boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, Integer.parseInt(boardType));
        }
        int size = rowparams.getRowErrorsCount();
        for (int i = 0; i < size; ++i) {
            rowerror = rowparams.getRowErrors(i);
            param = rowerror.getParam("nename");
            if (param == null) {
                param = new Param();
                param.setName("nename");
                param.setValue(nename);
                rowerror.addParam(param);
            } else {
                param.setValue(nename);
            }
            param = rowerror.getParam("slotid");
            if (param == null) {
                param = new Param();
                param.setName("slotid");
                param.setValue(slotid);
                rowerror.addParam(param);
            } else {
                param.setValue(boardname);
            }
            param = rowerror.getParam("boardname");
            String slotvar = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(slotid));
            if (param == null) {
                param = new Param();
                param.setName("boardname");
                param.setValue(slotvar + "-" + boardname);
                rowerror.addParam(param);
            } else {
                param.setValue(slotvar + "-" + boardname);
            }
            param = rowerror.getParam("LINKTO");
            if (param == null || param.getValue() == null) {
                param = rowerror.getParam("AID");
            }
            if (param == null || param.getValue() == null) continue;
            String[] aidSplit = TETL1CommonUtil.parseAID((String)param.getValue(), (int)this.neid);
            prefix = aidSplit[0];
            portStr = aidSplit[3];
            portid = Integer.parseInt(portStr);
            if (prefix.equals("ACC")) {
                portname = "VCTRUNK-" + portid;
            } else {
                iSlotId = Integer.parseInt(slotid);
                iBoardType = Integer.parseInt(boardType);
                portname = TEConfigurationDataMgr.getInstance().getPortName(this.neid, iSlotId, iBoardType, portid);
            }
            portid = prefix.equals("FAC") ? portid : portid + 32768;
            param = rowerror.getParam("portname");
            if (param == null) {
                param = new Param();
                param.setName("portname");
                param.setValue(portname);
                rowerror.addParam(param);
            } else {
                param.setValue(portname);
            }
            param = rowerror.getParam("portid");
            if (param == null) {
                param = new Param();
                param.setName("portid");
                param.setValue(String.valueOf(portid));
                rowerror.addParam(param);
                continue;
            }
            param.setValue(String.valueOf(portid));
        }
    }
}

