/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEGetEthNodeResourceBean
extends TETL1NEExplorerBean {
    public TEGetEthNodeResourceBean() {
        this.bQueryAidAndType = true;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param slotIDParam = null;
        StringBuffer sb = new StringBuffer();
        sb.append("SLOT-");
        if (part.getName().equalsIgnoreCase("LINKFROM")) {
            slotIDParam = rowparams.getParam("slotid");
            if (slotIDParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            part.setValue(sb.toString());
        } else if (part.getName().equalsIgnoreCase("LINKTO")) {
            slotIDParam = rowparams.getParam("slotid");
            if (slotIDParam == null) {
                return false;
            }
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            part.setValue(sb.toString());
        } else {
            return super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList<Object> tempOperationList = new ArrayList<Object>();
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        for (int t = 0; t < len; ++t) {
            tempOperationList.add(((TL1Operation)operationList.get(t)).clone());
        }
        Datainterface tempOutputData = super.convertToDatainterface(neid, subfunc, tempOperationList, null);
        if (!tempOutputData.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setBussinessParams(tempOutputData.getBussinessParams());
            this.outputData.setErrorMessage(tempOutputData.getErrorMessage());
            return;
        }
        TL1Operation operation = this.getOperation(tempOperationList);
        Part AID2 = operation.getInMsg().getPart("LINKFROM");
        int slotID = TETL1CommonUtil.getNMSlotStr((String)AID2.getValue(), (int)neid);
        HashMap vbMap = this.queryVlanID(slotID);
        HashMap hm = this.getData(operation, vbMap);
        this.outputData.setErrorMessage(tempOutputData.getErrorMessage());
        this.setData(this.outputData, hm);
    }

    private void setData(Datainterface outputData, HashMap hm) {
        Iterator it = hm.entrySet().iterator();
        while (it.hasNext()) {
            RowParams outPutRowparams = new RowParams();
            Map.Entry entry = it.next();
            Resource rs = (Resource)entry.getValue();
            outPutRowparams.addParam(new Param("slotid", rs.getSlot()));
            outPutRowparams.addParam(new Param("slot", TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(rs.getSlotid()))));
            String port = rs.getLinkFrom() + "&" + rs.getLinkTo() + "&" + rs.getPortid();
            outPutRowparams.addParam(new Param("portid", port));
            outPutRowparams.addParam("port", rs.getPortid());
            if (rs.getIntag() != null && !rs.getIntag().equals("NULL")) {
                outPutRowparams.addParam(new Param("intag", rs.getIntag()));
            }
            if (rs.getInstag() != null && !rs.getInstag().equals("NULL")) {
                outPutRowparams.addParam(new Param("instag", rs.getInstag()));
            }
            Param vlanParam = new Param();
            vlanParam.setName("vlanid");
            List vlanList = rs.getVlanList();
            if (vlanList == null || vlanList.size() == 0) continue;
            vlanParam.setValue((String)vlanList.get(0));
            int n = vlanList.size();
            for (int i = 1; i < n; ++i) {
                String vlanid = (String)vlanList.get(i);
                if (vlanid == null) continue;
                vlanParam.addOption(new Option(vlanid));
            }
            outPutRowparams.addParam(vlanParam);
            this.putOutputData(outputData, outPutRowparams);
        }
    }

    private HashMap getData(TL1Operation operation, HashMap vbMap) {
        HashMap hm = new HashMap();
        for (OutMsg out : operation.getOutMsg()) {
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            for (Map.Entry entry : partmap.entrySet()) {
                String name = (String)entry.getKey();
                if (!name.equals("LINKFROM")) continue;
                this.setLinkFromPort(hm, partmap, vbMap);
            }
        }
        return hm;
    }

    private void setLinkFromPort(HashMap hm, HashMap partmap, HashMap vbMap) {
        ArrayList<String> vlanList;
        Part linkFrom = (Part)partmap.get("LINKFROM");
        Part linkTo = (Part)partmap.get("LINKTO");
        String[] linkFromStr = TETL1CommonUtil.parseAID((String)linkFrom.getValue(), (int)this.neid);
        String[] linkToStr = TETL1CommonUtil.parseAID((String)linkTo.getValue(), (int)this.neid);
        int slotid = TETL1CommonUtil.getNMSlotStr((String)linkFrom.getValue(), (int)this.neid);
        int port = -1;
        if (linkFromStr[0].equals("FAC")) {
            port = Integer.parseInt(linkFromStr[3]);
        } else if (linkFromStr[0].equals("ACC")) {
            port = Integer.parseInt(linkFromStr[3]) + 32768;
        } else if (linkFromStr[0].equals("VBLP")) {
            port = Integer.parseInt(linkFromStr[3]);
        } else {
            return;
        }
        Resource rs = (Resource)hm.get(String.valueOf(port));
        String vlanid = "VLANID-/";
        if (rs == null) {
            vlanList = new ArrayList<String>();
            rs = new Resource();
            hm.put(String.valueOf(port), rs);
        } else {
            vlanList = rs.getVlanList();
        }
        rs.setPortid(String.valueOf(port));
        rs.setSlot(String.valueOf(slotid));
        rs.setSlotid(String.valueOf(slotid));
        Part inTagPart = (Part)partmap.get("INTAG");
        Part insTagPart = (Part)partmap.get("INSTAG");
        rs.setInstag(insTagPart.getValue());
        rs.setIntag(inTagPart.getValue());
        if (linkToStr[0].equals("VBLP")) {
            rs.setLinkFrom(linkTo.getValue());
            rs.setLinkTo(linkFrom.getValue());
            if (insTagPart.getValue() != null && inTagPart.getValue() != null) {
                this.addLANVlanidToList(vbMap, linkTo, vlanList, rs, inTagPart, insTagPart);
            } else if (this.isCaware(rs)) {
                vlanList = new ArrayList();
                String[] temp = this.isSTAGOrTAG("IN", insTagPart, inTagPart).split("-");
                vlanid = vlanid + "-" + temp[2] + "-" + temp[3];
                vlanList.add(vlanid);
                rs.setVlanList(vlanList);
                hm.put(String.valueOf(port), rs);
            } else {
                this.addLANVlanidToList(vbMap, linkTo, vlanList, rs, inTagPart, insTagPart);
            }
        } else {
            rs.setLinkFrom(linkFrom.getValue());
            rs.setLinkTo(linkTo.getValue());
            this.addLINEVlanidToList(vbMap, linkTo, vlanList, rs, inTagPart, insTagPart);
        }
    }

    private void addLINEVlanidToList(HashMap vbMap, Part linkTo, List vlanList, Resource rs, Part inTagPart, Part insTagPart) {
        String vlanid = this.isSTAGOrTAG("IN", insTagPart, inTagPart);
        if (vlanid != null) {
            vlanList.add(vlanid);
            rs.setVlanList(vlanList);
        }
        if (vlanid == null) {
            List vlanIDList = (List)vbMap.get(linkTo.getValue());
            if (vlanIDList != null) {
                int n = vlanIDList.size();
                for (int i = 0; i < n; ++i) {
                    vlanid = (String)vlanIDList.get(i);
                    if (vlanid == null && vlanList.size() == 0) {
                        vlanid = "VLANID-/";
                    }
                    vlanList.add(vlanid);
                }
                rs.setVlanList(vlanList);
            } else {
                vlanid = "VLANID-/";
                vlanList.add(vlanid);
                rs.setVlanList(vlanList);
            }
        }
    }

    private void addLANVlanidToList(HashMap vbMap, Part linkTo, List vlanList, Resource rs, Part inTagPart, Part insTagPart) {
        String vlanid = this.isTAGOrSTAG("IN", inTagPart, insTagPart);
        if (vlanid != null) {
            vlanList.add(vlanid);
            rs.setVlanList(vlanList);
        }
        if (vlanid == null) {
            List vlanIDList = (List)vbMap.get(linkTo.getValue());
            if (vlanIDList != null) {
                int n = vlanIDList.size();
                for (int i = 0; i < n; ++i) {
                    vlanid = (String)vlanIDList.get(i);
                    if (vlanid == null && vlanList.size() == 0) {
                        vlanid = "VLANID-/";
                    }
                    vlanList.add(vlanid);
                }
                rs.setVlanList(vlanList);
            } else {
                vlanid = "VLANID-/";
                vlanList.add(vlanid);
                rs.setVlanList(vlanList);
            }
        }
    }

    private boolean isCaware(Resource rs) {
        OutMsg[] outMsgs;
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            String[] linkTo;
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            String[] linkFrom = TETL1CommonUtil.parseAID((String)rs.getLinkFrom(), (int)this.neid);
            if (linkFrom[0].equals("FAC") || linkFrom[0].equals("ACC")) {
                TL1Operation queryFromOper = definitions.getTL1Operation("RTRV-FETH");
                String mod2Form = this.aidAndTypeList.getPayLoadMod2(this.neid, rs.getLinkFrom());
                queryFromOper.setMod1(mod2Form);
                queryFromOper.setName("RTRV-" + mod2Form);
                InMsg inputFrom = queryFromOper.getInMsg();
                inputFrom.getPart("AID").setValue(rs.getLinkFrom());
                operationList.add(queryFromOper);
            }
            if ((linkTo = TETL1CommonUtil.parseAID((String)rs.getLinkTo(), (int)this.neid))[0].equals("FAC") || linkTo[0].equals("ACC")) {
                TL1Operation queryToOper = definitions.getTL1Operation("RTRV-FETH");
                InMsg inputTo = queryToOper.getInMsg();
                String mod2To = this.aidAndTypeList.getPayLoadMod2(this.neid, rs.getLinkTo());
                queryToOper.setMod1(mod2To);
                queryToOper.setCmdCode("RTRV");
                queryToOper.setName("RTRV-" + mod2To);
                inputTo.getPart("AID").setValue(rs.getLinkTo());
                operationList.add(queryToOper);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operationList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query portType is error " + result.retCode);
        }
        if ((outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg()) != null && outMsgs.length != 0) {
            int n = outMsgs.length;
            for (int i = 0; i < n; ++i) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[i]);
                Part portType = (Part)hm.get("PORTTYPE");
                if (portType.getValue() == null) continue;
                return portType.getValue().equals("CAWARE");
            }
        }
        return true;
    }

    private HashMap queryVlanID(int slotID) {
        HashMap<String, ArrayList<String>> vbMap = new HashMap<String, ArrayList<String>>();
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-VLANENTRY-VB");
            InMsg input = queryOper.getInMsg();
            String AID2 = "VB-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotID) + "-ALL";
            input.getPart("AID").setValue(AID2);
            operationList.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operationList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query vb is error " + result.retCode);
            return vbMap;
        }
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        if (outMsgs != null && outMsgs.length != 0) {
            int n = outMsgs.length;
            for (int i = 0; i < n; ++i) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[i]);
                Part vblist = (Part)hm.get("VBLPLIST");
                if (vblist.getValue() == null) continue;
                String[] vbs = vblist.getValue().split("&");
                int m = vbs.length;
                for (int j = 0; j < m; ++j) {
                    Part vlanIDPart = (Part)hm.get("VLANID");
                    ArrayList<String> vlanIDList = (ArrayList<String>)vbMap.get(vbs[j]);
                    if (vlanIDList == null) {
                        vlanIDList = new ArrayList<String>();
                    }
                    vlanIDList.add(vlanIDPart.getValue() == null ? "VLANID-/" : "VLANID-" + vlanIDPart.getValue());
                    vbMap.put(vbs[j], vlanIDList);
                }
            }
        }
        return vbMap;
    }

    private String isTAGOrSTAG(String str, Part tag, Part sTag) {
        if (tag != null && tag.getValue() != null && !tag.getValue().equals("NULL")) {
            return str + "TAG" + "-" + tag.getValue() + "-" + tag.getValue() + "-" + sTag.getValue();
        }
        if (sTag != null && sTag.getValue() != null && !sTag.getValue().equals("NULL")) {
            return str + "STAG" + "-" + sTag.getValue() + "-" + tag.getValue() + "-" + sTag.getValue();
        }
        return null;
    }

    private String isSTAGOrTAG(String str, Part sTag, Part tag) {
        if (sTag != null && sTag.getValue() != null && !sTag.getValue().equals("NULL")) {
            return str + "STAG" + "-" + sTag.getValue() + "-" + tag.getValue() + "-" + sTag.getValue();
        }
        if (tag != null && tag.getValue() != null && !tag.getValue().equals("NULL")) {
            return str + "TAG" + "-" + tag.getValue() + "-" + tag.getValue() + "-" + sTag.getValue();
        }
        return null;
    }

    private TL1Operation getOperation(ArrayList tempOperationList) {
        int n = tempOperationList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation operation = (TL1Operation)tempOperationList.get(i);
            if (!operation.getName().equals("RTRV-ETHLINK")) continue;
            return operation;
        }
        return null;
    }

    private void putOutputData(Datainterface outPutData, RowParams outPutRowparams) {
        if (outPutRowparams.getParamCount() > 0) {
            outPutRowparams.addParam(new Param("neid", String.valueOf(this.neid)));
            TEGetEthNodeResourceBean.addParam(this.neid, outPutRowparams);
            outPutData.getBussinessParams().addRowParams(outPutRowparams);
        }
    }

    private static void addParam(int neid, RowParams rowparams1) {
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        Param param = null;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (null != rowparams1.getParam("neid")) {
            param = new Param("nename", neObj.getNEName());
            rowparams1.addParam(param);
        }
        if (null != rowparams1.getParam("slotid")) {
            try {
                slotid = Integer.parseInt(rowparams1.getParam("slotid").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (null != rowparams1.getParam("boardtype")) {
                try {
                    boardtype = Integer.parseInt(rowparams1.getParam("boardtype").getValue());
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowparams1.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                param = new Param("boardtype", boardtype + "");
                rowparams1.addParam(param);
            }
            param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
            rowparams1.addParam(param);
        }
        if (null != rowparams1.getParam("port")) {
            try {
                port = Integer.parseInt(rowparams1.getParam("port").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            String portName1 = port < 32768 ? "PORT" + port : "VCTRUNK" + (port - 32768);
            param = new Param("portname", portName1);
            rowparams1.addParam(param);
        }
    }

    public static void addReturnParam(int neid, RowParams rowparams) {
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        Param param = null;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (null != rowparams.getParam("neid")) {
            param = new Param("nename", neObj.getNEName());
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("slotid")) {
            try {
                slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (null != rowparams.getParam("boardtype")) {
                try {
                    boardtype = Integer.parseInt(rowparams.getParam("boardtype").getValue());
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowparams.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                param = new Param("boardtype", boardtype + "");
                rowparams.addParam(param);
            }
            param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("port")) {
            try {
                port = Integer.parseInt(rowparams.getParam("port").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            param = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port));
            rowparams.addParam(param);
        }
    }

    static class Resource {
        private String slotid;
        private String portid;
        private String slot;
        private List vlanList;
        private String linkFrom;
        private String linkTo;
        private String intag;
        private String instag;

        Resource() {
        }

        public String getIntag() {
            return this.intag;
        }

        public void setIntag(String intag) {
            this.intag = intag;
        }

        public String getInstag() {
            return this.instag;
        }

        public void setInstag(String instag) {
            this.instag = instag;
        }

        public String getSlotid() {
            return this.slotid;
        }

        public void setSlotid(String slotid) {
            this.slotid = slotid;
        }

        public String getPortid() {
            return this.portid;
        }

        public void setPortid(String portid) {
            this.portid = portid;
        }

        public List getVlanList() {
            return this.vlanList;
        }

        public void setVlanList(List vlanList) {
            this.vlanList = vlanList;
        }

        public String getSlot() {
            return this.slot;
        }

        public void setSlot(String slot) {
            this.slot = slot;
        }

        public String getLinkFrom() {
            return this.linkFrom;
        }

        public void setLinkFrom(String linkFrom) {
            this.linkFrom = linkFrom;
        }

        public String getLinkTo() {
            return this.linkTo;
        }

        public void setLinkTo(String linkTo) {
            this.linkTo = linkTo;
        }
    }
}

