/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEGetAvailablePortBean
extends TETL1NEExplorerBean {
    private static final int VB_AVAILPORT_NOT_ENOUGH = 140107;
    private static final int VBTRUNKFLG = 32768;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            BussinessParams bussinessParams = new BussinessParams();
            RowParams rowParams = null;
            int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
            String portid = "";
            TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
            ArrayList ethportList = configurDataMgr.getLogicPortList(neid, slotid);
            ArrayList vctrunkList = configurDataMgr.getETHVCTrunkPort(neid, configurDataMgr.getBoardType(neid, slotid));
            if (null == ethportList || 0 == ethportList.size()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
            } else {
                ethportList.addAll(vctrunkList);
                int listlen = ethportList.size();
                for (int i = 0; i < listlen; ++i) {
                    String portname;
                    int portNo;
                    portid = String.valueOf(ethportList.get(i));
                    rowParams = new RowParams();
                    rowParams.addParam("portid", portid);
                    if (Integer.parseInt(portid) - 32768 > 0) {
                        portNo = Integer.parseInt(portid) - 32768;
                        portname = "VCTRUNK" + portNo;
                    } else {
                        portNo = Integer.parseInt(portid);
                        portname = "PORT" + portNo;
                    }
                    rowParams.addParam("portname", portname);
                    bussinessParams.addRowParams(rowParams);
                }
                this.outputData.setBussinessParams(bussinessParams);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }
}

