/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethinterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgSetBean;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class TETL1EthInterfaceSetBean
extends TETL1GenCfgSetBean {
    private static Logger log = TELogFactory.getNormalLogger();

    public boolean isFillMsgBlock(String operationName, RowParams rowparams, MsgBlock msgBlock) {
        return !operationName.equals("RMV") && !operationName.equals("RST");
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        RowParams rowParams = null;
        for (int i = inputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = inputData.getBussinessParams().getRowParams(i);
            if (null != rowParams.getParam("DWDMTL1ATTR_BROADCAST_ENABLE_VCG")) {
                rowParams.getParam("DWDMTL1ATTR_BROADCAST_ENABLE_VCG").setName("DWDMTL1ATTR_BROADCAST_ENABLE_ETH");
            }
            if (null != rowParams.getParam("DWDMTL1ATTR_BROADCAST_LIMIT_VCG")) {
                rowParams.getParam("DWDMTL1ATTR_BROADCAST_LIMIT_VCG").setName("DWDMTL1ATTR_BROADCAST_LIMIT_ETH");
            }
            if (null != rowParams.getParam("DWDMTL1ATTR_VCG_LD_PORTBLOCK")) {
                rowParams.getParam("DWDMTL1ATTR_VCG_LD_PORTBLOCK").setName("DWDMTL1ATTR_MAC_LD_PORTBLOCK");
            }
            if (null == rowParams.getParam("DWDMTL1ATTR_VCG_LDENABLE")) continue;
            rowParams.getParam("DWDMTL1ATTR_VCG_LDENABLE").setName("DWDMTL1ATTR_MAC_LDENABLE");
        }
        StringBuffer filePath = new StringBuffer(TEPathManager.RESOURCE_PROFILE_PATH).append("gencfg").append(File.separator).append("attribres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        if (null == ne) {
            log.info("Get ne object fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            return this.outputData;
        }
        int neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        String fileName = TEGetFilePath.getFilePath((int)neType, (String)hostVersion, (String)filePath.toString());
        this.res = TEResourceUtil.getInstance((String)fileName);
        if (this.bQueryAidAndType) {
            this.slotIDList = this.getSlotIDFromInputDdata(inputData);
            if (this.slotIDList.size() > 0) {
                this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                if (this.aidAndTypeList == null) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                    return this.outputData;
                }
                if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                    Object[] slotIDArr = this.slotIDList.toArray();
                    int slotID = (Integer)slotIDArr[0];
                    Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
                    return this.outputData;
                }
            }
        }
        fileName = subFunc.getGenCfgAttrDesPath().getContent();
        StringBuffer funCmdFilePath = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH).append(fileName);
        fileName = TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neType, (String)hostVersion, (String)funCmdFilePath.toString());
        this.funCmd = TETL1GenCfgCmdFactory.getInstance().getFunCmd(fileName);
        if (null == this.funCmd) {
            log.info("Parse atrribute To TL1 mapping file fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        TL1Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            log.error("Get NE's Qx Description Fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        ArrayList operationList = this.getSetOperationList(definitions, this.funCmd, inputData);
        BussinessParams bussiness = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param param = null;
        Param lpbktypeParam = null;
        TL1Operation oper = null;
        String mod2Str = null;
        String mod2 = null;
        String aid = null;
        String nmPortStr = null;
        String shelfSlotStr = null;
        int slotId = -1;
        int size = bussiness.getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            rowparams = bussiness.getRowParams(i);
            mod2Str = rowparams.getParam("mode2").getValue();
            String[] mod2Split = mod2Str.split(",");
            int len = mod2Split.length;
            for (int j = 0; j < len; ++j) {
                if (!"DWDMTL1ATTR_MAC_MAC_LOOPBACK".equals(mod2Split[j])) continue;
                mod2 = mod2Split[j + 1];
                break;
            }
            if (null == mod2) break;
            lpbktypeParam = rowparams.getParam("DWDMTL1ATTR_MAC_MAC_LOOPBACK");
            if (lpbktypeParam != null && lpbktypeParam.getModifyFlag()) {
                oper = neType == 66 && lpbktypeParam.getValue().equals("NOLB") ? definitions.getTL1Operation("RLS-LPBK-FETH") : definitions.getTL1Operation("OPR-LPBK-GETH");
                String realMod2 = this.getRealMod2(mod2);
                TETL1CommonUtil.modifyMOD2((TL1Operation)oper, (String)realMod2);
                param = rowparams.getParam("slotid");
                slotId = Integer.parseInt(param.getValue());
                shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
                nmPortStr = rowparams.getParam("port").getValue();
                aid = "FAC-" + shelfSlotStr + "-" + nmPortStr;
                oper.getInMsg().getPart("AID").setValue(aid);
                oper.getInMsg().getPart("LOCN").setValue("MAC");
                if (neType != 66 || !lpbktypeParam.getValue().equals("NOLB")) {
                    oper.getInMsg().getPart("LPBKTYPE").setValue(lpbktypeParam.getValue());
                }
                operationList.add(oper);
            }
            if ((lpbktypeParam = rowparams.getParam("DWDMTL1ATTR_MAC_PHY_LOOPBACK")) == null || !lpbktypeParam.getModifyFlag()) continue;
            oper = neType == 66 && lpbktypeParam.getValue().equals("NOLB") ? definitions.getTL1Operation("RLS-LPBK-FETH") : definitions.getTL1Operation("OPR-LPBK-GETH");
            String realMod2 = this.getRealMod2(mod2);
            TETL1CommonUtil.modifyMOD2((TL1Operation)oper, (String)realMod2);
            param = rowparams.getParam("slotid");
            slotId = Integer.parseInt(param.getValue());
            shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotId);
            nmPortStr = rowparams.getParam("port").getValue();
            aid = "FAC-" + shelfSlotStr + "-" + nmPortStr;
            oper.getInMsg().getPart("AID").setValue(aid);
            oper.getInMsg().getMsgBlock().getPart("LOCN").setValue("PHY");
            if (neType != 66 || !lpbktypeParam.getValue().equals("NOLB")) {
                oper.getInMsg().getMsgBlock().getPart("LPBKTYPE").setValue(lpbktypeParam.getValue());
            }
            operationList.add(oper);
        }
        if (null == operationList || 0 == operationList.size()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)operationList, this.TIME_OUT);
        if (0 == result.retCode) {
            log.debug("Send command success!");
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, subFunc, operationList, filterErrorCodeList);
        } else {
            log.debug("Send command fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return this.outputData;
    }

    public String convertAttrID(String attrID) {
        if (attrID == null) {
            return null;
        }
        if (attrID.equals("DWDMTL1_ATTRPORT_ADVANCED_PST")) {
            return "DWDMTL1ATTRP_ETH_PST";
        }
        if (attrID.equals("DWDMTL1_ATTRPORT_ADVANCED_SST")) {
            return "DWDMTL1ATTRP_ETH_SST";
        }
        if (attrID.equals("DWDMTL1ATTR_BROADCAST_ENABLE_VCG")) {
            return "DWDMTL1ATTR_BROADCAST_ENABLE_ETH";
        }
        if (attrID.equals("DWDMTL1ATTR_BROADCAST_LIMIT_VCG")) {
            return "DWDMTL1ATTR_BROADCAST_LIMIT_ETH";
        }
        return attrID;
    }
}

