/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethinterface;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgQueryBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TETL1EthInterfaceQueryBean
extends TETL1GenCfgQueryBean {
    private static int VCTRUNK_NUM = 32768;

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        TL1Operation oper = null;
        String cmdCode = null;
        String mod1 = null;
        OutMsg outMsg = null;
        OutMsg finalOutMsg = null;
        String locn = null;
        Part part = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            int j;
            int len;
            oper = (TL1Operation)operationList.get(i);
            cmdCode = oper.getCmdCode();
            mod1 = oper.getMod1();
            if (!cmdCode.equals("RTRV") || !mod1.equals("LPBK")) continue;
            if (oper.getOutMsgCount() == 0 || oper.getOutMsg(0).getFault().getCompletionCode() != 0) {
                len = oper.getOutMsgCount();
                for (j = 0; j < len; ++j) {
                    outMsg = oper.getOutMsg(j);
                    part = new Part();
                    part.setName("attrId");
                    part.setValue("DWDMTL1ATTR_MAC_MAC_LOOPBACK");
                    outMsg.getMsgBlock().getDataBlock(2).addPart(part);
                    part = new Part();
                    part.setName("DWDMTL1ATTR_MAC_MAC_LOOPBACK");
                    part.setValue("/");
                    outMsg.getMsgBlock().getDataBlock(2).addPart(part);
                    part = new Part();
                    part.setName("attrId");
                    part.setValue("DWDMTL1ATTR_MAC_PHY_LOOPBACK");
                    outMsg.getMsgBlock().getDataBlock(2).addPart(part);
                    part = new Part();
                    part.setName("DWDMTL1ATTR_MAC_PHY_LOOPBACK");
                    part.setValue("/");
                    outMsg.getMsgBlock().getDataBlock(2).addPart(part);
                }
                continue;
            }
            finalOutMsg = (OutMsg)oper.getOutMsg(0).clone();
            finalOutMsg.getMsgBlock().getDataBlock(2).removePart(finalOutMsg.getMsgBlock().getPart("LPBKTYPE"));
            len = oper.getOutMsgCount();
            for (j = 0; j < len; ++j) {
                outMsg = oper.getOutMsg(j);
                locn = outMsg.getMsgBlock().getPart("LOCN").getValue();
                if (locn.equals("MAC")) {
                    part = new Part();
                    part.setName("DWDMTL1ATTR_MAC_MAC_LOOPBACK");
                    part.setValue(outMsg.getMsgBlock().getPart("LPBKTYPE").getValue());
                    finalOutMsg.getMsgBlock().getDataBlock(2).addPart(part);
                    continue;
                }
                if (!locn.equals("PHY")) continue;
                part = new Part();
                part.setName("DWDMTL1ATTR_MAC_PHY_LOOPBACK");
                part.setValue(outMsg.getMsgBlock().getPart("LPBKTYPE").getValue());
                finalOutMsg.getMsgBlock().getDataBlock(2).addPart(part);
            }
            oper.clearOutMsg();
            oper.addOutMsg(finalOutMsg);
        }
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList, this.aidAndTypeList);
        if (null == this.outputData) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
        RowParams rowParams = null;
        String aid = null;
        String pst = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            String sst;
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getParamCount() == 0 && rowParams.getRowErrorsCount() == 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            if (null != rowParams.getParam("AID")) {
                aid = rowParams.getParam("AID").getValue();
                rowParams.getParam("AID").setValue(this.getGencfgObjFromAID(neid, aid));
                String[] aidArr = TETL1CommonUtil.parseAID((String)aid, (int)neid);
                String portStr = aidArr[3];
                int portID = new Integer(portStr);
                if (aid.startsWith("ACC")) {
                    portID = 32768 + portID;
                    rowParams.getParam("AID").setValue(this.getGencfgObjFromAID(neid, aid));
                    if (null != rowParams.getParam("DWDMTL1ATTR_BROADCAST_ENABLE_ETH")) {
                        rowParams.getParam("DWDMTL1ATTR_BROADCAST_ENABLE_ETH").setName("DWDMTL1ATTR_BROADCAST_ENABLE_VCG");
                    }
                    if (null != rowParams.getParam("DWDMTL1ATTR_BROADCAST_LIMIT_ETH")) {
                        rowParams.getParam("DWDMTL1ATTR_BROADCAST_LIMIT_ETH").setName("DWDMTL1ATTR_BROADCAST_LIMIT_VCG");
                    }
                    if (null != rowParams.getParam("DWDMTL1ATTR_MAC_LD_PORTBLOCK")) {
                        rowParams.getParam("DWDMTL1ATTR_MAC_LD_PORTBLOCK").setName("DWDMTL1ATTR_VCG_LD_PORTBLOCK");
                    }
                    if (null != rowParams.getParam("DWDMTL1ATTR_MAC_LDENABLE")) {
                        rowParams.getParam("DWDMTL1ATTR_MAC_LDENABLE").setName("DWDMTL1ATTR_VCG_LDENABLE");
                    }
                }
                rowParams.addParam("port", String.valueOf(portID));
                String portmode = this.getPortModeFromAIDType(aid);
                rowParams.addParam("PORTMODE", portmode);
            }
            if (null == rowParams.getParam("DWDMTL1ATTRP_ETH_PST")) continue;
            pst = rowParams.getParam("DWDMTL1ATTRP_ETH_PST").getValue();
            if (null != rowParams.getParam("DWDMTL1ATTRP_ETH_SST") && !(sst = rowParams.getParam("DWDMTL1ATTRP_ETH_SST").getValue()).equals("") && !sst.equals("/")) {
                pst = pst + "," + sst;
            }
            rowParams.getParam("DWDMTL1ATTRP_ETH_PST").setValue(pst);
        }
    }

    private String getPortModeFromAIDType(String aid) {
        String actMod = this.aidAndTypeList.getMod2(this.neid, aid);
        String pldMod = this.aidAndTypeList.getPayLoadMod2(this.neid, aid);
        return pldMod + actMod;
    }

    protected boolean isFilterParam(RowParams rowparams, TETL1GenCfgFunAttr funAttr) {
        if (rowparams != null && this.extendAttr != "") {
            int portid = Integer.parseInt(rowparams.getParam("port").getValue());
            int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.nmCurrSlotID);
            if (TETL1CommonUtil.isFilterVCTrunkPort((int)this.neid, (int)bdtype, (int)this.nmCurrSlotID, (int)portid)) {
                return true;
            }
            if ("0".equals(this.extendAttr) ? portid < VCTRUNK_NUM : portid > VCTRUNK_NUM) {
                return true;
            }
        }
        return false;
    }

    public String convertAttrID(String attrID) {
        if (attrID == null) {
            return null;
        }
        if (attrID.equals("DWDMTL1_ATTRPORT_ADVANCED_PST")) {
            return "DWDMTL1ATTRP_ETH_PST";
        }
        if (attrID.equals("DWDMTL1_ATTRPORT_ADVANCED_SST")) {
            return "DWDMTL1ATTRP_ETH_SST";
        }
        return attrID;
    }

    public String getGencfgObjFromAID(int neID, String AID2) {
        String[] tmpStr = TETL1CommonUtil.parseAID((String)AID2, (int)neID);
        String portStr = tmpStr[3];
        String pathStr = tmpStr[4];
        StringBuffer buffer = new StringBuffer();
        buffer.append(neID).append("-");
        int slot = TETL1CommonUtil.getNMSlotStr((String)AID2, (int)neID);
        buffer.append(slot).append("-");
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slot);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        buffer.append(boardName).append("-");
        int port = Integer.parseInt(portStr);
        if (AID2.startsWith("ACC")) {
            port = VCTRUNK_NUM + port;
        }
        buffer.append(port);
        if (Integer.parseInt(pathStr) > 0) {
            buffer.append("-");
            buffer.append(pathStr);
        }
        return buffer.toString();
    }

    protected boolean notSupportSpecialCol(String newAttrID) {
        return newAttrID.equals("DWDMTL1ATTR_ETH_QINQ_TYPE") || newAttrID.equals("DWDMTL1ATTR_MAC_FCMODEAUTO");
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID) {
        return this.aidAndTypeList.getPayLoadMod2(neid, slotid, portid);
    }

    public boolean isSupportAttr(String attrID, TEGenCfgModel genCfgModel, int portNMID, int pathID) {
        return true;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> errorCodeList = new ArrayList<String>();
        errorCodeList.add("INVALID DATA PARAMETER, The specified object does not exist");
        return errorCodeList;
    }
}

