/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ethertest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ethertest.TENEEthTestQueryContainer;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.eventinterpret.TEEtherTestReport;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TEQueryEtherTest
extends TETL1NEExplorerBean {
    int slotID = -1;

    public TEQueryEtherTest() {
        this.bQueryAidAndType = true;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            String slotinfo = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
            this.slotID = Integer.parseInt(slotinfo);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        Object[] slotIDArr = this.slotIDList.toArray();
                        int slotID = (Integer)slotIDArr[0];
                        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((String)fault.getErrDesc()));
                        return this.outputData;
                    }
                }
            }
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            this.tl1OperList = new ArrayList();
            for (Map.Entry entry : this.aidAndTypeList.getAidAndTypeMap().entrySet()) {
                ArrayList teAIDAndTypeList = (ArrayList)entry.getValue();
                int m = teAIDAndTypeList.size();
                for (int j = 0; j < m; ++j) {
                    TEAIDAndType teAIDAndType = (TEAIDAndType)teAIDAndTypeList.get(j);
                    String mod2s = teAIDAndType.getPldType();
                    ArrayList pldTypesList = TETL1CommonUtil.parseString((String)mod2s, (String)"|");
                    String aid = teAIDAndType.getAid();
                    int n = pldTypesList.size();
                    for (int i = 0; i < n; ++i) {
                        String mod2 = (String)pldTypesList.get(i);
                        if (boardType == 60010 && aid.indexOf("ACC") != -1) {
                            this.addToTL1OperList(definitions, aid, mod2);
                            continue;
                        }
                        if (boardType == 60010 || mod2.indexOf("GETH") == -1 && !mod2.equals("FETH")) continue;
                        this.addToTL1OperList(definitions, aid, mod2);
                    }
                }
            }
            if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, (ArrayList)this.tl1OperList.clone());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void addToTL1OperList(TL1Definitions definitions, String aid, String mod2) {
        TL1Operation queryOper = definitions.getTL1Operation("RTRV-PING-ACC");
        InMsg input = queryOper.getInMsg();
        input.getPart("AID").setValue(aid);
        queryOper.setCmdCode("RTRV");
        queryOper.setMod1("PING");
        queryOper.setMod2(mod2);
        queryOper.setName("RTRV-PING-" + mod2);
        this.tl1OperList.add(queryOper);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        RowParams rowparams = null;
        RowErrors errorRowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        ArrayList<EthTestQuery> ethTestQueryList = new ArrayList<EthTestQuery>();
        TENEEthTestQueryContainer.getInstance().removeList(neid, this.slotID);
        int n = tl1OperList.size();
        for (int i = 0; i < n; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            OutMsg[] outs = tl1Operation.getOutMsg();
            rowparams = new RowParams();
            InMsg inMsg = tl1Operation.getInMsg();
            int m = outs.length;
            for (int j = 0; j < m; ++j) {
                EthTestQuery ethTestQuery = new EthTestQuery();
                OutMsg out = outs[j];
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                if (out.getFault().getCompletionCode() != 0) {
                    String errorCode = out.getFault().getErrCode();
                    String errorinfo = out.getFault().getErrDesc();
                    ErrorMessage errorMessage = new ErrorMessage();
                    Param errorparam = null;
                    errorRowparams = new RowErrors();
                    errorMessage.setErrorcode(errorCode);
                    errorMessage.setErrorinfo(errorinfo);
                    errorRowparams.setErrorMessage(errorMessage);
                    TENE ne = TENEListUtils.getNEObj((int)neid);
                    errorparam = new Param("nename", ne.getNEName());
                    errorRowparams.addParam(errorparam);
                    errorRowparams.addParam(new Param("slotid", String.valueOf(TETL1CommonUtil.getShelfSlotName((int)neid, (int)this.slotID))));
                    TEBoard board = ne.getBoard(this.slotID);
                    if (board != null) {
                        errorRowparams.addParam(new Param("boardname", board.getBoardName()));
                    } else {
                        errorRowparams.addParam(new Param("boardname", "UNKNOWN"));
                    }
                    Part aidPart = inMsg.getPart("AID");
                    String[] aid = TETL1CommonUtil.parseAID((String)aidPart.getValue(), (int)neid);
                    if (aid[0].indexOf("ACC") != -1) {
                        errorRowparams.addParam(new Param("portid", "VCTRUNK" + aid[3]));
                    } else {
                        errorRowparams.addParam(new Param("portid", TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)aidPart.getValue())));
                    }
                    errorDataList.add(errorRowparams);
                    continue;
                }
                Part aidPart = (Part)hm.get("AID");
                String[] aid = TETL1CommonUtil.parseAID((String)aidPart.getValue(), (int)neid);
                rowparams.addParam(new Param("mod2", tl1Operation.getMod2()));
                ethTestQuery.setMod2(tl1Operation.getMod2());
                rowparams.addParam(new Param("neid", String.valueOf(neid)));
                ethTestQuery.setNeid(String.valueOf(neid));
                rowparams.addParam(new Param("AID", aidPart.getValue()));
                ethTestQuery.setAid(aidPart.getValue());
                int slotid = TETL1CommonUtil.getNMSlotStr((String)aidPart.getValue(), (int)neid);
                rowparams.addParam(new Param("slotid", String.valueOf(slotid)));
                ethTestQuery.setSlotid(String.valueOf(slotid));
                TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
                String boardName = "UNKNOWN";
                if (board != null) {
                    boardName = board.getBoardName();
                }
                rowparams.addParam(new Param("boardname", boardName));
                ethTestQuery.setBoardname(boardName);
                int portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aidPart.getValue(), (int)neid);
                if (aid[0].indexOf("ACC") != -1) {
                    rowparams.addParam("portid", "VCTRUNK" + aid[3]);
                    ethTestQuery.setPortid(String.valueOf(portID));
                    ethTestQuery.setChannel(aid[4]);
                } else {
                    rowparams.addParam("portid", TETL1CommonUtil.getGencfgObjFromAID((int)neid, (String)aidPart.getValue()));
                    ethTestQuery.setPortid(String.valueOf(portID));
                    ethTestQuery.setChannel(aid[4]);
                }
                Part sendMode = (Part)hm.get("TESTMODE");
                this.convertValue(rowparams, sendMode, "sendMode");
                ethTestQuery.setSendMode(sendMode.getValue());
                Part testFrameNum = (Part)hm.get("PKTNUM");
                this.convertValue(rowparams, testFrameNum, "testFrameNum");
                ethTestQuery.setTestFrameNum(testFrameNum.getValue());
                Part sendCounter = (Part)hm.get("TOTALSEND");
                this.convertValue(rowparams, sendCounter, "sendCounter");
                ethTestQuery.setTOTALSEND(sendCounter.getValue());
                Part responseCounter = (Part)hm.get("RESPONDRECV");
                this.convertValue(rowparams, responseCounter, "responseCounter");
                ethTestQuery.setRESPONDRECV(responseCounter.getValue());
                Part receiveCounter = (Part)hm.get("NORMALRECV");
                this.convertValue(rowparams, receiveCounter, "receiveCounter");
                ethTestQuery.setNORMALRECV(receiveCounter.getValue());
                TEEtherTestReport report = TEEtherTestReport.getTthTestReport((int)neid, (int)this.slotID, (int)Integer.parseInt(ethTestQuery.getPortid()), (int)Integer.parseInt(ethTestQuery.getChannel()));
                HashMap reportedData = report.getReportData();
                ArrayList ethTestReportList = (ArrayList)reportedData.get("" + neid + this.slotID + ethTestQuery.getPortid() + ethTestQuery.getChannel());
                TEEtherTestReport.EthTestReport ethTestReport = null;
                ethTestReport = ethTestQuery.getSendMode().equals("BURST") ? this.getEthTestReport(ethTestQuery.getAid(), ethTestReportList, true) : this.getEthTestReport(ethTestQuery.getAid(), ethTestReportList, false);
                if (ethTestReport != null && ethTestReport.getIPFLAG().equals("COMPLD")) {
                    this.convertValue(rowparams, "COMPLD", "process");
                } else {
                    this.convertValue(rowparams, "PROCESS", "process");
                }
                this.outputData.getBussinessParams().addRowParams(rowparams);
                ethTestQueryList.add(ethTestQuery);
            }
        }
        TENEEthTestQueryContainer.getInstance().addList(neid, this.slotID, ethTestQueryList);
        this.outputData.setErrorMessage(new ErrorMessage());
        if (errorDataList.size() != 0) {
            rowparams = new RowParams();
            for (int x = errorDataList.size() - 1; x >= 0; --x) {
                rowparams.addRowErrors((RowErrors)errorDataList.get(x));
            }
            this.outputData.getBussinessParams().addRowParams(rowparams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        }
    }

    private TEEtherTestReport.EthTestReport getEthTestReport(String aid, ArrayList ethTestReportList, boolean isCompld) {
        for (int j = ethTestReportList.size() - 1; j > 0; --j) {
            TEEtherTestReport.EthTestReport ethTestReport = (TEEtherTestReport.EthTestReport)ethTestReportList.get(j);
            if (!(isCompld ? ethTestReport.getAid().equals(aid) && ethTestReport.getIPFLAG().equals("COMPLD") : ethTestReport.getAid().equals(aid))) continue;
            return ethTestReport;
        }
        return null;
    }

    private void convertValue(RowParams rowparams, Part temp, String rowString) {
        if (temp.getValue() != null) {
            rowparams.addParam(rowString, temp.getValue());
        } else {
            rowparams.addParam(rowString, "/");
        }
    }

    private void convertValue(RowParams rowparams, String value, String rowString) {
        if (value != null) {
            rowparams.addParam(rowString, value);
        } else {
            rowparams.addParam(rowString, "/");
        }
    }

    static class EthTestQuery {
        private String aid;
        private String portid;
        private String channel;
        private String RESPONDRECV;
        private String NORMALRECV;
        private String TOTALSEND;
        private String IPFLAG;
        private String slotid;
        private String boardname;
        private String mod2;
        private String sendMode;
        private String testFrameNum;
        private String neid;

        EthTestQuery() {
        }

        public String getChannel() {
            return this.channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public String getNeid() {
            return this.neid;
        }

        public void setNeid(String neid) {
            this.neid = neid;
        }

        public String getSlotid() {
            return this.slotid;
        }

        public void setSlotid(String slotid) {
            this.slotid = slotid;
        }

        public String getBoardname() {
            return this.boardname;
        }

        public void setBoardname(String boardname) {
            this.boardname = boardname;
        }

        public String getMod2() {
            return this.mod2;
        }

        public void setMod2(String mod2) {
            this.mod2 = mod2;
        }

        public String getSendMode() {
            return this.sendMode;
        }

        public void setSendMode(String sendMode) {
            this.sendMode = sendMode;
        }

        public String getTestFrameNum() {
            return this.testFrameNum;
        }

        public void setTestFrameNum(String testFrameNum) {
            this.testFrameNum = testFrameNum;
        }

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public String getPortid() {
            return this.portid;
        }

        public void setPortid(String portid) {
            this.portid = portid;
        }

        public String getRESPONDRECV() {
            return this.RESPONDRECV;
        }

        public void setRESPONDRECV(String respondrecv) {
            this.RESPONDRECV = respondrecv;
        }

        public String getNORMALRECV() {
            return this.NORMALRECV;
        }

        public void setNORMALRECV(String normalrecv) {
            this.NORMALRECV = normalrecv;
        }

        public String getTOTALSEND() {
            return this.TOTALSEND;
        }

        public void setTOTALSEND(String totalsend) {
            this.TOTALSEND = totalsend;
        }

        public String getIPFLAG() {
            return this.IPFLAG;
        }

        public void setIPFLAG(String ipflag) {
            this.IPFLAG = ipflag;
        }
    }
}

