/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.ether100gtest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.tl1ngwdm.ip.ether100gtest.TEEtherTestReport;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TETL1QueryEtherTest
extends TETL1NEExplorerBean {
    private static final String MODEL_ATTRNAME = "DWDMTL1_ATTRPORT_ETHTEST";
    private String mod2 = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.slotIDList = this.getSlotIDFromInputDdata(inputData);
        this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
        Param reportParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"report");
        if (null != reportParam && "true".equals(reportParam.getValue())) {
            TEEtherTestReport ethTestReport;
            Param slotidParam = inputData.getBussinessParams().getRowParams(0).getParam("slotid");
            int slotID = 0;
            if (slotidParam != null) {
                slotID = Integer.parseInt(slotidParam.getValue());
            }
            if (!(ethTestReport = TEEtherTestReport.getTthTestReport(neid, slotID)).hasRegisterd()) {
                ethTestReport.register();
            }
            return this.reportData(ethTestReport);
        }
        if (null == (inputData = this.createInputDataAddPort(neid, inputData)).getBussinessParams().getRowParams(0).getParam("AID")) {
            return new Datainterface();
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        TL1Operation operstate = null;
        TL1Definitions definitions = null;
        TEGenCfgPortAttribute portAttribute = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (MarshalException e) {
            TELogFactory.getNormalLogger().error("TEPRBSSetStateBean.getTL1Operation() fail!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("TEPRBSSetStateBean.getTL1Operation() fail!", (Throwable)e);
        }
        catch (ValidationException e) {
            TELogFactory.getNormalLogger().error("TEPRBSSetStateBean.getTL1Operation() fail!", (Throwable)e);
        }
        ArrayList tmpList = super.getTL1Operation(neid, subFunc, inputData, memeryData);
        Param bdtype = inputData.getBussinessParams().getRowParams(0).getParam("boardType");
        int boardtype = Integer.parseInt(bdtype.getValue());
        List list = TEGenCfgDataMgr.getAttrSupportCPPortAttr((int)neid, (String)MODEL_ATTRNAME, (int)boardtype);
        this.mod2 = inputData.getBussinessParams().getRowParams(0).getParam("mod2").getValue();
        String slotidParam = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            portAttribute = (TEGenCfgPortAttribute)list.get(i);
            String aid = TETL1CommonUtil.combineAID((int)neid, (int)Integer.parseInt(slotidParam), (int)portAttribute.getPort(), (int)portAttribute.getPath());
            String tempMod2 = TETL1CommonUtil.getTL1CmdMod2((String)("RTRV-" + this.mod2));
            operstate = definitions.getTL1Operation(tempMod2);
            TETL1CommonUtil.modifyMOD2((TL1Operation)operstate, (String)this.mod2);
            operstate.getInMsg().getStagBlock().getAID().getPart(0).setValue(aid);
            tmpList.add(operstate);
        }
        return tmpList;
    }

    private Datainterface reportData(TEEtherTestReport ethTestReport) {
        Datainterface reportData = ethTestReport.getReportData();
        Datainterface returnReportData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        returnReportData.setBussinessParams(bussinessParams);
        for (int len = reportData.getBussinessParams().getRowParamsCount() - 1; len >= 0; --len) {
            RowParams rowparams = (RowParams)reportData.getBussinessParams().getRowParams(len).clone();
            bussinessParams.addRowParams(rowparams);
        }
        return returnReportData;
    }

    private Datainterface createInputDataAddPort(int neID, Datainterface inputData) {
        Param slotidParam = inputData.getBussinessParams().getRowParams(0).getParam("slotid");
        int slotID = 0;
        if (slotidParam != null) {
            slotID = Integer.parseInt(slotidParam.getValue());
        }
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        List list = TEGenCfgDataMgr.getAttrSupportCPPortAttr((int)this.neid, (String)MODEL_ATTRNAME, (int)boardType);
        BussinessParams bussiness = new BussinessParams();
        RowParams row = null;
        TEGenCfgPortAttribute portAttribute = null;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            portAttribute = (TEGenCfgPortAttribute)list.get(i);
            String aid = TETL1CommonUtil.combineAID((int)neID, (int)slotID, (int)portAttribute.getPort(), (int)portAttribute.getPath());
            if (!this.aidAndTypeList.getAllMod2(this.neid, slotID, portAttribute.getPort()).contains("100GETH") && !this.aidAndTypeList.getAllMod2(this.neid, slotID, portAttribute.getPort()).contains("40GETH")) continue;
            row = (RowParams)inputData.getBussinessParams().getRowParams(0).clone();
            row.addParam("AID", aid);
            bussiness.addRowParams(row);
        }
        if (bussiness.getRowParamsCount() != 0) {
            inputData.setBussinessParams(bussiness);
        }
        return inputData;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equals("port")) {
            Part part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                String aidStruct = TETL1CommonUtil.getBoardStructFromAID((String)part.getValue(), (int)this.neid, (boolean)false);
                aidStruct = aidStruct + "-" + this.mod2;
                oldParam.setValue(aidStruct);
            }
            return oldParam;
        }
        if (oldParam.getName().equals("aid")) {
            Part part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equals("teststate")) {
            Part part = (Part)partmap.get("IPFLAG");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equals("sendDirection")) {
            Part part = (Part)partmap.get("TSTMOD");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("SPLTE");
            }
            return oldParam;
        }
        if (oldParam.getName().equals("sendFlag")) {
            Part part = (Part)partmap.get("SENDMOD");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("IDLE");
            }
            return oldParam;
        }
        if (oldParam.getName().equals("testFrameFormat")) {
            Part part = (Part)partmap.get("PKTTYPE");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("FIXED");
            }
            return oldParam;
        }
        if (oldParam.getName().equals("testFrameNum")) {
            Part part = (Part)partmap.get("PKTNUM");
            if (part != null && part.getValue() != null) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("0");
            }
            return oldParam;
        }
        if (oldParam.getName().equals("testFramePackLen")) {
            Part part = (Part)partmap.get("PKTLEN");
            if (part != null && part.getValue() != null && !"0".equals(part.getValue())) {
                oldParam.setValue(part.getValue());
            } else {
                oldParam.setValue("1024");
            }
            return oldParam;
        }
        if (oldParam.getName().equals("pst")) {
            Part partpst = (Part)partmap.get("PST");
            Part partsst = (Part)partmap.get("SST");
            String pst = "";
            if (partpst != null && partpst.getValue() != null) {
                pst = partpst.getValue();
            }
            if (partsst != null && partsst.getValue() != null) {
                pst = pst + "," + partsst.getValue();
            }
            oldParam.setValue(pst);
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        Param slotidParam = this.inputData.getBussinessParams().getRowParams(0).getParam("slotid");
        int slotID = 0;
        if (slotidParam != null) {
            slotID = Integer.parseInt(slotidParam.getValue());
        }
        if (TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID) == 2313) {
            tl1Operation.setMod2("40GETH");
            tl1Operation.setName("RTRV-RSLT-40GETH");
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("INVALID DATA PARAMETER, Unsupported command returned by card");
        list.add("INVALID DATA PARAMETER, Command not supported");
        return list;
    }
}

