/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.ip.erps;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class TEERPSGetPortListBean
extends TETL1NEExplorerBean {
    private static final int VB_AVAILPORT_NOT_ENOUGH = 140107;
    private static final int VCTRUNKFLG = 32768;
    private static final int AP3_PORT = 32771;
    private static final int AP4_PORT = 32772;
    private static final int OSN8800A = 73;
    private static final int OSN8800AII = 75;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.outputData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowParams = null;
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(slotid);
        this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, set);
        if (this.aidAndTypeList == null) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        String portid = null;
        int portNo = -1;
        String portname = null;
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = configurDataMgr.getBoard(neid, slotid);
        String shelfType = TEBoardUtil.getTl1SubrackType((int)neid, (int)ne.getNEType(), (int)slotid);
        if (null == board) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
            return this.outputData;
        }
        int boardType = board.getBoardType();
        ArrayList ethportList = TETL1CommonUtil.getUsableEthPortList((int)neid, (int)slotid, (TEAIDAndTypeList)this.aidAndTypeList);
        if (0 == ethportList.size()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
        } else {
            Collections.sort(ethportList);
            int listlen = ethportList.size();
            for (int i = 0; i < listlen; ++i) {
                portid = String.valueOf(ethportList.get(i));
                if (!(ne.getNEType() != 73 && ne.getNEType() != 75 || !shelfType.equalsIgnoreCase("SHELF8800T32") && !shelfType.equalsIgnoreCase("SHELF8800T64") || boardType != 2110 && boardType != 2109 || Integer.parseInt(portid) != 32771 && Integer.parseInt(portid) != 32772)) continue;
                rowParams = new RowParams();
                rowParams.addParam("portid", portid);
                rowParams.addParam("slotid", String.valueOf(slotid));
                if (Integer.parseInt(portid) - 32768 > 0) {
                    portname = this.getVCTrunkName(Integer.parseInt(portid) - 32768);
                } else {
                    portNo = Integer.parseInt(portid);
                    portname = this.getMACName(portNo);
                }
                rowParams.addParam("portname", portname);
                bussinessParams.addRowParams(rowParams);
            }
            this.outputData.setBussinessParams(bussinessParams);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        return this.outputData;
    }

    private String getVCTrunkName(int vcTrunkID) {
        StringBuffer vcTurnkStr = new StringBuffer("VCTRUNK");
        vcTurnkStr.append(vcTrunkID);
        return vcTurnkStr.toString();
    }

    private String getMACName(int portID) {
        StringBuffer portStr = new StringBuffer("PORT");
        portStr.append(portID);
        return portStr.toString();
    }
}

