/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl;

import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMServiceTypeListAdapterIF;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMSrvRangeKey;
import com.huawei.nglct.nemgr.neadapter.functionadapter.WDMSrvRangeResult;
import com.huawei.nglct.nemgr.tl1necommon.staticdata.TL1MapDesMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.TEServiceTypeKey;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.TEServiceTypeRowDataProcessor;
import com.huawei.nglct.nemgr.tl1ngwdm.config.wdminterface.TETL1GetServieType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TL1NgwdmServiceTypeListAdapter
implements WDMServiceTypeListAdapterIF {
    public List<Integer> getWDMServiceTypeList(WDMSrvRangeKey key) {
        int neid = key.getNeID();
        int slotid = key.getSlotid();
        int portid = key.getPortid();
        int pathid = key.getPathid();
        TEServiceTypeKey typeKey = new TEServiceTypeKey();
        typeKey.setNeid(neid);
        typeKey.setSlotid(slotid);
        typeKey.setPortid(portid);
        typeKey.setPathid(pathid);
        TEServiceTypeRowDataProcessor process = new TEServiceTypeRowDataProcessor();
        return process.getServiceType(typeKey);
    }

    public String getInterfaceName() {
        return WDMServiceTypeListAdapterIF.class.getName();
    }

    public Map<Integer, String> getServiceTypeByID(int neid, List<Integer> serviceType) {
        HashMap<Integer, String> serviceTypeMap = new HashMap<Integer, String>();
        for (int i = 0; i < serviceType.size(); ++i) {
            if (serviceType.get(i) == null) continue;
            String serviceTypeStr = this.getSpecialTypeStr(neid, serviceType.get(i));
            if (serviceTypeStr == null) {
                serviceTypeStr = TL1MapDesMgr.getInstance().getStringValueByInt(serviceType.get(i).intValue(), String.valueOf(271534));
            }
            serviceTypeMap.put(serviceType.get(i), serviceTypeStr);
        }
        return serviceTypeMap;
    }

    private String getSpecialTypeStr(int neid, Integer serValue) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String servType = null;
        if (ne.getNEType() == 66) {
            if (ne.getShowNEVersion().compareTo("5.67.03.10") < 0) {
                switch (serValue) {
                    case 263: {
                        servType = "GE-SYNC";
                        break;
                    }
                    case 3329: {
                        servType = "CPRI";
                        break;
                    }
                    case 3330: {
                        servType = "CPRI-CUT";
                        break;
                    }
                    case 3331: {
                        servType = "CPRI2457";
                        break;
                    }
                }
            }
            if (ne.getShowNEVersion().compareTo("5.67.02.11") < 0) {
                switch (serValue) {
                    case 1793: {
                        servType = "HDTV";
                        break;
                    }
                    case 1794: {
                        servType = "HDTV14835";
                        break;
                    }
                    case 2050: {
                        servType = "DVB-SDI";
                        break;
                    }
                }
            }
        }
        return servType;
    }

    public List<TEGenCfgPortAttribute> getSupportServiceTypePortList(int neid, int slotid, int portid, int boardType) {
        ArrayList<TEGenCfgPortAttribute> portList = new ArrayList<TEGenCfgPortAttribute>();
        portList.addAll(TEGenCfgDataMgr.getAttrSupportCPPortAttr((int)neid, (String)"DWDMTL1_ATTRPORT_CLIENTPRO", (int)boardType, (int)portid));
        portList.addAll(TEGenCfgDataMgr.getAttrSupportCPPortAttr((int)neid, (String)"DWDMTL1_ATTRPORT_CLNTPLDTYPE", (int)boardType, (int)portid));
        portList.addAll(TEGenCfgDataMgr.getAttrSupportCPPortAttr((int)neid, (String)"DWDMTL1_ATTRPORT_PLDTYPE", (int)boardType, (int)portid));
        return portList;
    }

    public boolean isBoardSupportServiceType(int neid, int boardType) {
        return TEGenCfgDataMgr.isBoardSupportAttr((int)neid, (int)boardType, (String)"DWDMTL1_ATTRPORT_CLIENTPRO") || TEGenCfgDataMgr.isBoardSupportAttr((int)neid, (int)boardType, (String)"DWDMTL1_ATTRPORT_CLNTPLDTYPE") || TEGenCfgDataMgr.isBoardSupportAttr((int)neid, (int)boardType, (String)"DWDMTL1_ATTRPORT_PLDTYPE");
    }

    public int getBoardMode(int neid, int slotID) {
        return -1;
    }

    public WDMSrvRangeResult getWDMServiceTypeList(List<WDMSrvRangeKey> keyList) {
        TETL1GetServieType getSrcTypeObj = new TETL1GetServieType();
        return getSrcTypeObj.getWDMServiceTypeList(keyList);
    }
}

