/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.db.jni.dbservice.TELogPara;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.neadapter.functionadapter.TEGenCfgInterface;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectUtils;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenOperationResult;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValueResult;
import com.huawei.nglct.nemgr.tl1necommon.staticdata.TL1MapDesMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl.TEGenCfgMod2;
import com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl.TL1GenAttrUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TL1NGwdmGenCfgAdapter
implements TEGenCfgInterface {
    private static final int TIME_OUT = 100;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String FLAG_SET = "set";
    private static final String FLAG_QUERY = "query";
    private static final String QUERY_OPER_OBJ = "Query WDM Port Attributes";
    private static final String SET_OPER_OBJ = "Set WDM Port Attributes";
    private final Map<Integer, String> errorCodeMessageMap = new HashMap<Integer, String>();
    public static final String PAYLOADTYPE = "DWDMTL1_ATTRPORT_PLDTYPE";
    public static final String CLNTTYPE = "DWDMTL1_ATTRPORT_CLNTPLDTYPE";
    public static final String CLIENTPROTYPE = "DWDMTL1_ATTRPORT_CLIENTPRO";
    private Hashtable<Integer, TL1Operation> attrIDCMDMap = new Hashtable();
    private static final int LOGMAXLENGTH = 255;
    public static final int W32PORT_ATTR_LINE_CAPACITY = 10001012;
    public static final int W32PORT_ATTR_LATENCE_MODE = 272286;
    private static final Map<Integer, String> ODU_INDEX_TO_MOD2 = new Hashtable<Integer, String>();
    private TETL1GenCfgFunCmd funCmd = null;
    private static final List<Integer> aidAffectAttrList;

    public List<Integer> getWDMSubbdTypeList(int neid, int slotid) {
        return null;
    }

    public TEGenOperationResult queryAttribFromNE(String attribType, TEGenAttrObjectValue attrs) {
        return this.sendGenOperation(attribType, attrs, FLAG_QUERY);
    }

    private void translateAttrs(TEGenAttrObjectValue attrs) {
        List attrList = attrs.getAttrIDList();
        for (int i = 0; i < attrList.size(); ++i) {
            String str;
            int attrid = ((TEGenValue)attrList.get(i)).getAttrID();
            int value = -1;
            boolean isSucc = true;
            try {
                value = Integer.parseInt(((TEGenValue)attrList.get(i)).getValue());
            }
            catch (NumberFormatException ex) {
                isSucc = false;
            }
            if (isSucc && (str = TL1MapDesMgr.getInstance().getStringValueByInt(value, String.valueOf(attrid))) != null) {
                ((TEGenValue)attrList.get(i)).setValue(str);
            }
            TEGenObjectID objectID = attrs.getObjectID();
            int neID = objectID.getNEID();
            int slotID = objectID.getSlotIDInInt();
            TEGenValue genValue = (TEGenValue)attrs.getAttrIDList().get(i);
            String attrName = this.getTL1AttrName(genValue, neID, slotID);
            genValue.setAttrName(attrName);
        }
    }

    private void translateAttrValue(TEGenValue genValue) {
        int attrid = genValue.getAttrID();
        Integer value = TL1MapDesMgr.getInstance().getIntValueByStr(genValue.getValue(), String.valueOf(attrid));
        if (value != null) {
            genValue.setValue(String.valueOf(value));
        }
    }

    public TEGenOperationResult setAttribToNE(String attribType, TEGenAttrObjectValue attrs) {
        return this.sendGenOperation(attribType, attrs, FLAG_SET);
    }

    public boolean isSupportAttri(TEGnlValueElement gnlValueElement) {
        if (gnlValueElement == null) {
            return false;
        }
        int[] objList = gnlValueElement.getGnlKeyValue().getTEOBJECTID();
        TEGenObjectID genObjectID = new TEGenObjectID(objList);
        TEGenValue genValue = new TEGenValue(gnlValueElement);
        int neID = genObjectID.getNEID();
        int slotID = genObjectID.getSlotIDInInt();
        String attrName = this.getTL1AttrName(genValue, neID, slotID);
        return TEGenObjectUtils.isSupportAttri((TEGenObjectID)genObjectID, (String)attrName);
    }

    private TEGenOperationResult sendGenOperation(String attribType, TEGenAttrObjectValue attrs, String queryOrSet) {
        this.translateAttrs(attrs);
        List<TL1Operation> operList = this.buildTL1SetOperList(attribType, attrs, queryOrSet);
        TEGenOperationResult operResult = new TEGenOperationResult();
        if (!operList.isEmpty()) {
            TELogFactory.getNormalLogger().info("begin to SendCommand.");
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(attrs.getNEID(), operList, 100);
            TELogFactory.getNormalLogger().info("end to SendCommand. result->" + result.retCode);
            if (0 != result.retCode) {
                this.setFailErrorInfo(attrs, operResult, result.retCode);
            } else {
                this.handleResponseMessage(operList, operResult, attrs, queryOrSet);
                this.writeLog(operList, attrs, queryOrSet);
            }
        } else {
            TELogFactory.getNormalLogger().info("Not found attrs in " + attribType);
            this.setFailErrorInfo(attrs, operResult, 38737);
        }
        return operResult;
    }

    private String getErrorMessage(int errorCode) {
        if (this.errorCodeMessageMap.containsKey(errorCode)) {
            return this.errorCodeMessageMap.get(errorCode);
        }
        String errorMessage = TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode);
        this.errorCodeMessageMap.put(errorCode, errorMessage);
        return errorMessage;
    }

    private void setFailErrorInfo(TEGenAttrObjectValue attrs, TEGenOperationResult operResult, int errorCode) {
        operResult.setWholeErrorCode(2);
        operResult.setErrorInfo(this.getErrorMessage(operResult.getWholeErrorCode()));
        for (TEGenValue attrValue : attrs.getAttrIDList()) {
            TEGenValueResult attrResult = new TEGenValueResult();
            attrResult.attrID = attrValue.getAttrID();
            attrResult.errorCode = errorCode;
            attrResult.errorInfo = this.getErrorMessage(attrResult.errorCode);
            operResult.getGenResultList().add(attrResult);
        }
    }

    private void handleResponseMessage(List<TL1Operation> operList, TEGenOperationResult operResult, TEGenAttrObjectValue attrs, String queryOrSet) {
        List attrIDList = attrs.getAttrIDList();
        ArrayList<TEGenValueResult> operResultList = new ArrayList<TEGenValueResult>();
        operResult.setGenResultList(operResultList);
        boolean isFail = false;
        boolean isSucc = false;
        int size = attrIDList.size();
        for (int i = 0; i < size; ++i) {
            TEGenValue genValue = (TEGenValue)attrIDList.get(i);
            TL1Operation tl1Oper = this.attrIDCMDMap.get(genValue.getAttrID());
            TEGenValueResult genValueResult = new TEGenValueResult();
            genValueResult.attrID = genValue.getAttrID();
            if (tl1Oper == null) {
                isFail = true;
                genValueResult.errorCode = 38737;
                genValueResult.errorInfo = this.getErrorMessage(genValueResult.errorCode);
                operResultList.add(genValueResult);
                continue;
            }
            Fault fault = this.getFaultFromOper(tl1Oper);
            if (fault == null || fault.getCompletionCode() == 0) {
                isSucc = true;
                if (queryOrSet.equalsIgnoreCase(FLAG_QUERY)) {
                    genValue.setValue(this.getQuerryAttrValue(tl1Oper, TEGenValue.convertAttrNameToQxName((String)genValue.getAttrName())));
                    this.translateAttrValue(genValue);
                    genValueResult.attrValue = genValue.getValue();
                } else {
                    TEGenObjectID objectID = attrs.getObjectID();
                    this.refreshAidBuffer(objectID, genValue.getAttrID());
                }
                genValueResult.errorCode = 0;
                genValueResult.errorInfo = this.getErrorMessage(genValueResult.errorCode);
            } else {
                tl1Oper.addCmdFault(fault);
                isFail = true;
                if (genValue.getAttrID() == 10001012 && fault.getErrDesc().equals("INVALID DATA PARAMETER, Command not supported")) {
                    genValueResult.errorCode = 0;
                    genValueResult.errorInfo = "";
                } else {
                    genValueResult.errorCode = 2;
                    genValueResult.errorInfo = fault.getErrDesc();
                }
            }
            operResultList.add(genValueResult);
        }
        if (isSucc && isFail) {
            operResult.setWholeErrorCode(1);
        } else if (isSucc && !isFail) {
            operResult.setWholeErrorCode(0);
        } else {
            operResult.setWholeErrorCode(2);
        }
        operResult.setErrorInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)operResult.getWholeErrorCode()));
    }

    private void writeLog(List<TL1Operation> operList, TEGenAttrObjectValue attrs, String queryOrSet) {
        try {
            if (!attrs.isNeedOperationLog() || attrs.getLogPara() == null) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            List attrIDList = attrs.getAttrIDList();
            TELogPara logPara = attrs.getLogPara();
            int size = attrIDList.size();
            for (int i = 0; i < size; ++i) {
                TEGenValue genValue = (TEGenValue)attrIDList.get(i);
                TL1Operation tl1Oper = this.attrIDCMDMap.get(genValue.getAttrID());
                if (tl1Oper == null) continue;
                TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj((int)attrs.getNEID());
                String operObj = "";
                operObj = null == neObj ? String.valueOf(attrs.getNEID()) : neObj.getNEName();
                loginfo = new TELogInfo();
                loginfo.setCmdID(logPara.getCmdID());
                loginfo.setLocation(logPara.getIpAddr());
                loginfo.setUserID(logPara.getUserID());
                loginfo.setOperateObject(operObj);
                if (queryOrSet.equalsIgnoreCase(FLAG_QUERY)) {
                    loginfo.setOperateName(QUERY_OPER_OBJ);
                } else {
                    loginfo.setOperateName(SET_OPER_OBJ);
                }
                ArrayList faultList = tl1Oper.getCmdFaultList();
                boolean hasSuccess = false;
                boolean hasFail = false;
                StringBuilder errInfo = new StringBuilder("");
                int length = faultList.size();
                for (int j = 0; j < length; ++j) {
                    Fault fault = (Fault)faultList.get(j);
                    if (fault.getCompletionCode() != 0) {
                        hasFail = true;
                        if ("".equals(errInfo.toString())) {
                            errInfo.append(TETL1CommonUtil.getOperationResult((Fault)fault));
                            continue;
                        }
                        errInfo.append("\n").append(TETL1CommonUtil.getOperationResult((Fault)fault));
                        continue;
                    }
                    hasSuccess = true;
                }
                if (!hasFail) {
                    loginfo.setErrCode(0);
                    loginfo.setResult(0);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
                    loginfo.setOperateDesc(tl1Oper.getCmdDetail());
                } else if (hasSuccess) {
                    loginfo.setErrCode(1);
                    loginfo.setResult(1);
                    loginfo.setErrInfo(errInfo.toString());
                    loginfo.setOperateDesc(tl1Oper.getCmdDetail());
                } else {
                    loginfo.setErrCode(1107329312);
                    loginfo.setResult(2);
                    loginfo.setErrInfo(errInfo.toString());
                    loginfo.setOperateDesc(tl1Oper.getCmdDetail() + "Result Desc:" + loginfo.getErrInfo());
                }
                loginfoList.add(loginfo);
            }
            this.writeLog(loginfoList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private void writeLog(List loginfoList) {
        if (loginfoList.isEmpty()) {
            return;
        }
        DeploymentMode runningStatus = TESysManagerBean.getInstance().getSysStauts();
        TELogInfo loginfo = null;
        int size = loginfoList.size();
        for (int i = 0; i < size; ++i) {
            loginfo = (TELogInfo)loginfoList.get(i);
            String operDesc = loginfo.getOperateDesc();
            if (TESysManagerConstants.SYS_SINGLE_STATUS != runningStatus && operDesc.length() > 255) {
                String temp;
                do {
                    temp = operDesc;
                    String firstLog = temp.substring(0, 255);
                    loginfo.setOperateDesc(firstLog);
                    TELogMgr.writeLog((TELogInfo)loginfo);
                } while ((operDesc = temp.substring(255, temp.length())).length() > 255);
            }
            loginfo.setOperateDesc(operDesc);
            TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
        }
    }

    private String getQuerryAttrValue(TL1Operation tl1Oper, String attrName) {
        if (tl1Oper.getOutMsgCount() > 0) {
            OutMsg outmsg = tl1Oper.getOutMsg(0);
            int msgsize = outmsg.getMsgBlock().getDataBlockCount();
            for (int msgindex = 0; msgindex < msgsize; ++msgindex) {
                DataBlock datablock = outmsg.getMsgBlock().getDataBlock(msgindex);
                int partsize = datablock.getPartCount();
                for (int partindex = 0; partindex < partsize; ++partindex) {
                    Part part = datablock.getPart(partindex);
                    String convertAttrID = part.getConvert();
                    if (attrName.equals("DWDMTL1_ATTRPORT_WORKFEC")) {
                        attrName = "DWDMTL1_ATTRPORT_FEC";
                    }
                    if ((convertAttrID == null || convertAttrID.equals("")) && this.funCmd != null) {
                        convertAttrID = this.funCmd.getParamAttrID(part.getName());
                    }
                    if (convertAttrID == null || !convertAttrID.equals(attrName)) continue;
                    return part.getValue();
                }
            }
        }
        return "";
    }

    private Fault getFaultFromOper(TL1Operation tl1Oper) {
        if (tl1Oper.getOutMsgCount() > 0) {
            return tl1Oper.getOutMsg(0).getFault();
        }
        return null;
    }

    private List<TL1Operation> buildTL1SetOperList(String attribType, TEGenAttrObjectValue attrs, String queryOrSet) {
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(attribType);
        String path = TEResourceManager.getPath() + funCmdFilePath.toString();
        this.funCmd = TETL1GenCfgCmdFactory.getInstance().getFunCmd(path);
        if (null == this.funCmd) {
            log.info("Parse atrribute To TL1 mapping file fail!");
            return tl1OperList;
        }
        List attrIDList = attrs.getAttrIDList();
        TEGenObjectID objectID = attrs.getObjectID();
        this.attrIDCMDMap.clear();
        int size = attrIDList.size();
        for (int i = 0; i < size; ++i) {
            TEGenValue genValue = (TEGenValue)attrIDList.get(i);
            TL1Operation oper = this.createTL1Oper(objectID, genValue, this.funCmd, queryOrSet);
            if (oper == null) continue;
            this.attrIDCMDMap.put(genValue.getAttrID(), oper);
            tl1OperList.add(oper);
        }
        return tl1OperList;
    }

    private TL1Operation createTL1Oper(TEGenObjectID objectID, TEGenValue genValue, TETL1GenCfgFunCmd funCmd, String queryOrSet) {
        int neid = objectID.getNEID();
        int slotid = objectID.getSlotIDInInt();
        TEAIDAndTypeList aidTypeList = this.getAIDTypeList(neid, slotid);
        String attrName = genValue.getAttrName();
        TETL1GenCfgFunAttr funAttrForSet = funCmd.getGenCfgFunAttr(attrName, queryOrSet);
        if (null == funAttrForSet) {
            return null;
        }
        String operationName = funAttrForSet.getTl1cmdcode();
        String tl1CmdStr = "";
        String realMod2 = "";
        String defineMod = funAttrForSet.getMod();
        if (defineMod.equals("mod2")) {
            TEGenCfgMod2 mod2 = this.getMod2(objectID, genValue, funAttrForSet, aidTypeList);
            if (mod2 == null) {
                return null;
            }
            tl1CmdStr = operationName + "-" + mod2.getTl1desMod2();
            realMod2 = mod2.getRealMod2();
        } else {
            tl1CmdStr = operationName + "-" + defineMod;
            realMod2 = defineMod;
        }
        int oduIndex = objectID.getODUIndexInInt();
        if (!this.mod2Equals(oduIndex, realMod2)) {
            genValue.setAttrSupportFlag(false);
        }
        TEGenObjectID objectIDForAID = objectID.clone();
        this.resetObjectID(objectIDForAID, genValue, aidTypeList, realMod2);
        TL1Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
        }
        catch (Exception e) {
            log.error("Get NE's TL1 Description Fail!");
            return null;
        }
        TL1Operation operation = definitions.getTL1Operation(tl1CmdStr);
        if (null == operation) {
            return null;
        }
        TL1Operation tl1Operation = (TL1Operation)operation.clone();
        TETL1CommonUtil.modifyMOD2((TL1Operation)tl1Operation, (String)realMod2);
        if (TL1GenAttrUtil.fillStagBlock(tl1Operation, objectIDForAID) && (queryOrSet.equalsIgnoreCase(FLAG_QUERY) || TL1GenAttrUtil.fillMsgBlock(tl1Operation, genValue, funCmd, neid))) {
            return tl1Operation;
        }
        return null;
    }

    private boolean mod2Equals(int oduIndex, String realMod2) {
        if (realMod2.equalsIgnoreCase("TDC")) {
            return true;
        }
        if (!(realMod2.indexOf("OTU") != -1 || realMod2.indexOf("ODU") != -1 || realMod2.equalsIgnoreCase("OCH") || realMod2.equalsIgnoreCase("OC") || realMod2.equalsIgnoreCase("LPT") || realMod2.equalsIgnoreCase("WDM"))) {
            return oduIndex == 12342;
        }
        if (realMod2.equalsIgnoreCase("OCH") || realMod2.equalsIgnoreCase("OC") || realMod2.equalsIgnoreCase("LPT") || realMod2.equalsIgnoreCase("WDM")) {
            return oduIndex == 12292;
        }
        String e2eMod2 = ODU_INDEX_TO_MOD2.get(oduIndex);
        return null != e2eMod2 && realMod2.equals(e2eMod2);
    }

    private String getTL1AttrName(TEGenValue genValue, int neid, int slotid) {
        String attrName = genValue.getAttrName();
        if (genValue.getAttrID() == 271534) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            if (genCfgModel.getAttrFromId(PAYLOADTYPE) != null) {
                genValue.setAttrName(PAYLOADTYPE);
                return PAYLOADTYPE;
            }
            if (genCfgModel.getAttrFromId(CLNTTYPE) != null) {
                genValue.setAttrName(CLNTTYPE);
                return CLNTTYPE;
            }
            if (genCfgModel.getAttrFromId(CLIENTPROTYPE) != null) {
                genValue.setAttrName(CLIENTPROTYPE);
                return CLIENTPROTYPE;
            }
        } else if (genValue.getAttrID() == 270400) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            if (genCfgModel.getAttrFromId("DWDMTL1ATTR_MAC_MAXPKGLEN") != null) {
                genValue.setAttrName("DWDMTL1ATTR_MAC_MAXPKGLEN");
                return "DWDMTL1ATTR_MAC_MAXPKGLEN";
            }
            if (genCfgModel.getAttrFromId("DWDMTL1ATTR_MAC_MAXPKTLEN") != null) {
                genValue.setAttrName("DWDMTL1ATTR_MAC_MAXPKTLEN");
                return "DWDMTL1ATTR_MAC_MAXPKTLEN";
            }
        } else if (genValue.getAttrID() == 272275) {
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            if (genCfgModel.getAttrFromId("DWDMTL1_ATTRPORT_WORKFEC") != null) {
                genValue.setAttrName("DWDMTL1_ATTRPORT_WORKFEC");
                return "DWDMTL1_ATTRPORT_WORKFEC";
            }
            if (genCfgModel.getAttrFromId("DWDMTL1_ATTRPORT_FEC") != null) {
                genValue.setAttrName("DWDMTL1_ATTRPORT_FEC");
                return "DWDMTL1_ATTRPORT_FEC";
            }
        } else {
            String tl1AttrName = TL1MapDesMgr.getInstance().getTL1AttributeNameFromQx(attrName);
            if (tl1AttrName != null) {
                return tl1AttrName;
            }
        }
        return attrName;
    }

    private TEAIDAndTypeList getAIDTypeList(int neid, int slotid) {
        TEAIDAndTypeList aidAndTypeList = null;
        try {
            HashSet<Integer> slotIDList = new HashSet<Integer>();
            slotIDList.add(slotid);
            aidAndTypeList = TETL1CommonUtil.queryPortTypeFromBuffer((int)neid, slotIDList);
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("getMod2 failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("getMod2 failed!", (Throwable)e);
        }
        if (aidAndTypeList == null) {
            return null;
        }
        return aidAndTypeList;
    }

    private TEGenCfgMod2 getMod2(TEGenObjectID objectID, TEGenValue genValue, TETL1GenCfgFunAttr funAttrForSet, TEAIDAndTypeList aidAndTypeList) {
        int neid = objectID.getNEID();
        int slotid = objectID.getSlotIDInInt();
        int portid = objectID.getPortIDInInt();
        int pathid = objectID.getPathIDInInt();
        int oduIndex = objectID.getODUIndexInInt();
        if (genValue.getAttrID() == 10001012 || genValue.getAttrID() == 272286) {
            return this.getMod2FromOduIndex(oduIndex);
        }
        ArrayList list = funAttrForSet.getModifierList();
        ArrayList mod2List = null;
        if (aidAndTypeList == null) {
            return null;
        }
        int temppathid = this.getAttrPortPathID(objectID, genValue);
        mod2List = temppathid > 0 ? aidAndTypeList.getAllMod2(neid, slotid, portid, pathid) : aidAndTypeList.getAllMod2(neid, slotid, portid);
        int len = mod2List.size();
        for (int i = 0; i < len; ++i) {
            String realmod2 = (String)mod2List.get(i);
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                String tempMod2 = (String)list.get(j);
                if (!realmod2.equals(tempMod2)) continue;
                String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(realmod2);
                return new TEGenCfgMod2(realmod2, tl1Mod2);
            }
        }
        return new TEGenCfgMod2("UNEQ", "UNEQ");
    }

    private TEGenCfgMod2 getMod2FromOduIndex(int oduIndex) {
        String mod2 = ODU_INDEX_TO_MOD2.get(oduIndex);
        if (mod2 != null && mod2.indexOf("ODU") != -1) {
            return new TEGenCfgMod2(mod2, "ODUN");
        }
        return new TEGenCfgMod2("UNEQ", "UNEQ");
    }

    private void resetObjectID(TEGenObjectID objectID, TEGenValue genValue, TEAIDAndTypeList aidTypeList, String realMod2) {
        int neID = objectID.getNEID();
        int slotID = objectID.getSlotIDInInt();
        int portID = objectID.getPortIDInInt();
        int temppathid = 0;
        temppathid = aidTypeList != null && realMod2 != null && (genValue.getAttrID() == 10001012 || genValue.getAttrID() == 272286) ? aidTypeList.getPortPathID(neID, slotID, portID, realMod2) : this.getAttrPortPathID(objectID, genValue);
        if (temppathid <= 0 || realMod2.equalsIgnoreCase("TDC")) {
            if (objectID.containODUIndex()) {
                objectID.removeID(5);
            }
            if (objectID.containPathID()) {
                if (!TEGenObjectUtils.isPathLevelAttriForE2E((int)neID, (int)objectID.getPathIDInInt())) {
                    genValue.setPortAttrFlag(true);
                }
                objectID.removeID(4);
            }
        }
    }

    private int getAttrPortPathID(TEGenObjectID objectID, TEGenValue genValue) {
        int INVALID_PATH_ID_PORT = -1;
        int neID = objectID.getNEID();
        int slotID = objectID.getSlotIDInInt();
        int portID = objectID.getPortIDInInt();
        int pathID = objectID.getPathIDInInt();
        pathID = TEGenObjectUtils.getAttriPathIDFor1800NA((int)neID, (int)pathID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        String attrName = genValue.getAttrName();
        List portAttrList = TEGenCfgDataMgr.getAttrSupportCPPortAttr((int)neID, (String)attrName, (int)boardType, (int)portID);
        boolean INVALID_PATH_ID_ZERO = false;
        boolean hasPortLevel = false;
        int tempPathID = -1;
        for (TEGenCfgPortAttribute portAttr : portAttrList) {
            tempPathID = portAttr.getPath();
            if (tempPathID > 0) continue;
            hasPortLevel = true;
            break;
        }
        if (hasPortLevel && pathID <= 1) {
            return -1;
        }
        return pathID;
    }

    private void refreshAidBuffer(TEGenObjectID objectID, int attrID) {
        if (!aidAffectAttrList.contains(attrID)) {
            return;
        }
        TETL1CommonUtil.refreshSlotAIDBuffer((int)objectID.getNEID(), (int)objectID.getSlotIDInInt());
    }

    public String getInterfaceName() {
        return TEGenCfgInterface.class.getName();
    }

    public String getWDMInterfaceCmdFilePath() {
        return "tl1ngwdm\\conf\\gencfg\\wdminterfacetl1.xml";
    }

    public List<TEGenOperationResult> setAttribListToNE(String attribType, List<TEGenAttrObjectValue> attrsList) {
        ArrayList<TEGenOperationResult> operList = new ArrayList<TEGenOperationResult>();
        for (TEGenAttrObjectValue attrValue : attrsList) {
            TEGenOperationResult operResult = this.setAttribToNE(attribType, attrValue);
            operList.add(operResult);
        }
        return operList;
    }

    public TEGenOperationResult queryAttribFromDatabase(String attribType, TEGenAttrObjectValue attrs) {
        return this.queryAttribFromNE(attribType, attrs);
    }

    static {
        ODU_INDEX_TO_MOD2.put(12325, "ODU4");
        ODU_INDEX_TO_MOD2.put(12326, "ODU3");
        ODU_INDEX_TO_MOD2.put(12327, "ODU2");
        ODU_INDEX_TO_MOD2.put(12328, "ODU5G");
        ODU_INDEX_TO_MOD2.put(12329, "ODU1");
        ODU_INDEX_TO_MOD2.put(12332, "ODU0");
        ODU_INDEX_TO_MOD2.put(12336, "ODUFLEX");
        ODU_INDEX_TO_MOD2.put(12309, "OTU4");
        ODU_INDEX_TO_MOD2.put(12310, "OTU3");
        ODU_INDEX_TO_MOD2.put(12311, "OTU2");
        ODU_INDEX_TO_MOD2.put(12312, "OTU5G");
        ODU_INDEX_TO_MOD2.put(12313, "OTU1");
        aidAffectAttrList = new ArrayList<Integer>();
        aidAffectAttrList.add(271534);
    }
}

