/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl;

import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.HashMap;

public class TL1GenAttrUtil {
    private static final HashMap<Integer, String> rateValueMap = new HashMap();
    private static final String DEFAULTRATE_VALUE = "125.00";

    public static boolean fillMsgBlock(TL1Operation tl1Operation, TEGenValue genValue, TETL1GenCfgFunCmd funCmd, int neid) {
        String attrName = TEGenValue.convertAttrNameToQxName((String)genValue.getAttrName());
        String attrValue = genValue.getValue();
        String operName = tl1Operation.getName();
        DataBlock dataBlock = null;
        Part part = null;
        MsgBlock msgBlock = tl1Operation.getInMsg().getMsgBlock();
        if (operName.equalsIgnoreCase("ED-CLNT") && attrName.equalsIgnoreCase("DWDMTL1_ATTRPORT_CLNTPLDTYPE") && (attrValue.equalsIgnoreCase("CBR10G") || attrValue.equalsIgnoreCase("ANY"))) {
            dataBlock = msgBlock.getDataBlock(1);
            part = dataBlock.getPart(0);
            part.setValue(attrValue);
            String aid = tl1Operation.getInMsg().getStagBlock().getAID().getPart(0).getValue();
            String defaultRateValue = DEFAULTRATE_VALUE;
            if (aid != null && !aid.isEmpty()) {
                int slotNMID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neid);
                int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
                defaultRateValue = rateValueMap.get(boardType);
                if (defaultRateValue == null) {
                    defaultRateValue = DEFAULTRATE_VALUE;
                }
            }
            part = dataBlock.getPart(1);
            part.setValue(defaultRateValue);
            return true;
        }
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                String tl1attr = part.getConvert();
                if ((tl1attr == null || tl1attr.equals("")) && funCmd != null) {
                    tl1attr = funCmd.getParamAttrID(part.getName());
                }
                if (attrName.equals("DWDMTL1_ATTRPORT_WORKFEC")) {
                    attrName = "DWDMTL1_ATTRPORT_FEC";
                }
                if (tl1attr == null || !tl1attr.equals(attrName)) continue;
                part.setValue(attrValue);
                return true;
            }
        }
        return false;
    }

    public static boolean fillStagBlock(TL1Operation tl1Operation, TEGenObjectID objectID) {
        StagBlock stagBlock = tl1Operation.getInMsg().getStagBlock();
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int slotid = objectID.getSlotIDInInt();
        int portid = objectID.getPortIDInInt();
        int pathid = objectID.getPathIDInInt();
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (!part.getName().equals("AID")) continue;
            String aid = TETL1CommonUtil.combineAID((int)objectID.getNEID(), (int)slotid, (int)portid, (int)pathid);
            part.setValue(aid);
            return true;
        }
        return false;
    }

    static {
        rateValueMap.put(1381, "270.00");
        rateValueMap.put(2278, "9953.28");
        rateValueMap.put(2315, "9953.28");
        rateValueMap.put(2297, "9953.28");
        rateValueMap.put(2479, "9953.28");
        rateValueMap.put(2480, "9953.28");
    }
}

