/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nemgr.neadapter.functionadapter.emca.TEeMCASectionIF;
import com.huawei.nglct.nemgr.neadapter.functionadapter.emca.TEeMCASectionNodeObj;
import com.huawei.nglct.nemgr.tl1ngwdm.functionadapterimpl.TETL1FunctionAapter;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.List;

public class TETL1eMCASectionMgrAdapter
extends TETL1FunctionAapter
implements TEeMCASectionIF {
    private static final String NSCMD_EMCA_GET_SECTION = "RTRV-OD-SEC";
    private static final String NSCMD_EMCA_ADD_SECTION = "ENT-OD-SEC";
    private static final String NSCMD_EMCA_DEL_SECTION = "DLT-OD-SEC";
    private static final String NSCMD_EMCA_CHECK_SECTION = "AUD-OD-SEC";
    private static final String EMCA_SECID = "SEC-";

    public String getInterfaceName() {
        return TEeMCASectionIF.class.getName();
    }

    public List getQuerySectionOperList(TENE sinkNe, String sectionID) {
        TL1Operation oper = TECreateObjectFactory.getTL1Operation((int)sinkNe.getNEID(), (String)NSCMD_EMCA_GET_SECTION);
        if (oper != null) {
            oper.getInMsg().getPart("SECID").setValue(this.buildSectionAID(sectionID));
            ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
            operationList.add(oper);
            return operationList;
        }
        TELogFactory.getNormalLogger().error("Build NSCMD_EMCA_GET_SECTION failed for neid=" + sinkNe.getNEID() + "!");
        return new ArrayList();
    }

    public List getAddSectionOperList(TENE sinkNe, List<TEeMCASectionNodeObj> nodeInfoList) {
        this.TIME_OUT = 40;
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        for (int i = 0; i < nodeInfoList.size(); ++i) {
            TL1Operation oper = TECreateObjectFactory.getTL1Operation((int)sinkNe.getNEID(), (String)NSCMD_EMCA_ADD_SECTION);
            if (oper != null) {
                if ((oper = this.buildTL1AddOperation(oper, nodeInfoList.get(i))) == null) continue;
                operationList.add(oper);
                continue;
            }
            TELogFactory.getNormalLogger().error("Build NSCMD_EMCA_ADD_SECTION failed for neid=" + sinkNe.getNEID() + "!");
        }
        return operationList;
    }

    private TL1Operation buildTL1AddOperation(TL1Operation addoper, TEeMCASectionNodeObj nodeInfo) {
        String aid;
        String sectionAID = this.buildSectionAID(nodeInfo.getSectionID());
        addoper.getInMsg().getPart("SECID").setValue(sectionAID);
        addoper.getInMsg().getPart("NODESNUM").setValue(String.valueOf(nodeInfo.getTotalNum()));
        addoper.getInMsg().getPart("NODETYPE").setValue(nodeInfo.getBoardTye(nodeInfo.getNodeType()));
        addoper.getInMsg().getPart("NODEPOS").setValue(String.valueOf(nodeInfo.getNodePos()));
        TENE ne = TENEListMgr.getInstance().getInterNE((int)nodeInfo.getSessionNodeId());
        if (ne == null) {
            TELogFactory.getNormalLogger().error("neID = " + nodeInfo.getSessionNodeId() + " is null.");
            return null;
        }
        addoper.getInMsg().getPart("NEID").setValue(ne.getNEName());
        int cpType = nodeInfo.getwBdtype();
        String bdPortAID = TETL1CommonUtil.combineAID((int)ne.getNEID(), (int)nodeInfo.getwSlot(), (int)nodeInfo.getwPort(), (int)-1, (int)cpType);
        addoper.getInMsg().getPart("BDPORT").setValue(bdPortAID);
        String bdName = TEBoardConfigurationDataMgr.getInstance().getBoardTypeName(ne.getNEID(), cpType);
        if (bdName.isEmpty()) {
            TELogFactory.getNormalLogger().error("SlotID = " + nodeInfo.getwSlot() + " neID = " + ne.getNEID() + " have no Board.");
            return null;
        }
        addoper.getInMsg().getPart("BDTYPE").setValue(bdName);
        int subBdType = nodeInfo.getBySubBdType();
        if (subBdType != 0) {
            addoper.getInMsg().getPart("ATTACHNO").setValue(String.valueOf(nodeInfo.getBySubBdType()));
        }
        if (!(aid = this.createAID(nodeInfo)).isEmpty()) {
            addoper.getInMsg().getPart("RES1").setValue(aid);
        }
        return addoper;
    }

    private String createAID(TEeMCASectionNodeObj node) {
        int neid = (int)node.getSessionNodeId();
        int slotid = node.getwSlot();
        int otherPort = node.getOtherEndPort();
        String aid = "";
        if (otherPort > 0) {
            aid = this.combineAID(neid, slotid, otherPort);
        }
        return aid;
    }

    private String combineAID(int neid, int slotid, int otherPort) {
        StringBuffer sb = new StringBuffer();
        String aidPre = "FAC";
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)slotid);
        sb.append(aidPre);
        sb.append("-");
        sb.append(neSlot);
        if (otherPort <= 0) {
            return "";
        }
        sb.append("-");
        sb.append(otherPort);
        return sb.toString();
    }

    public List getDelSectionOperList(TENE sinkNe, String SECID) {
        TL1Operation oper = TECreateObjectFactory.getTL1Operation((int)sinkNe.getNEID(), (String)NSCMD_EMCA_DEL_SECTION);
        if (oper != null) {
            oper.getInMsg().getPart("SECID").setValue(this.buildSectionAID(SECID));
            ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
            operationList.add(oper);
            return operationList;
        }
        TELogFactory.getNormalLogger().error("Build NSCMD_EMCA_DEL_SECTION failed for neid=" + sinkNe.getNEID() + "!");
        return new ArrayList();
    }

    public void handleQuerySectionOperList(List oper, int sequenceid, List<TEeMCASectionNodeObj> getSectionNodeObjList, List<TEErrInfo> getSectionErrInfoList) {
        for (int i = 0; i < oper.size(); ++i) {
            TEErrInfo errorInfo;
            OutMsg output;
            TL1Operation getOper = (TL1Operation)oper.get(i);
            if (!getOper.getName().equalsIgnoreCase(NSCMD_EMCA_GET_SECTION) || (output = getOper.getOutMsg(0)) == null) continue;
            int errorCodeInt = output.getFault().getCompletionCode();
            if (errorCodeInt == 0) {
                errorCodeInt = this.handleQueryOperOutputParam(getSectionNodeObjList, getOper);
                if (errorCodeInt == 0) continue;
                errorInfo = new TEErrInfo(sequenceid, errorCodeInt);
                errorInfo.setStrOperDesc(output.getFault().getErrDesc());
                errorInfo.setErrorCode(errorCodeInt);
                getSectionErrInfoList.add(errorInfo);
                continue;
            }
            errorInfo = new TEErrInfo(sequenceid, errorCodeInt);
            errorInfo.setStrOperDesc(output.getFault().getErrDesc());
            errorInfo.setErrorCode(errorCodeInt);
            getSectionErrInfoList.add(errorInfo);
        }
    }

    private int handleQueryOperOutputParam(List<TEeMCASectionNodeObj> getSectionNodeObjList, TL1Operation getOper) {
        for (int j = 0; j < getOper.getOutMsgCount(); ++j) {
            OutMsg output = getOper.getOutMsg(j);
            try {
                TEeMCASectionNodeObj nodeObj = new TEeMCASectionNodeObj();
                nodeObj.setSectionID(output.getMsgBlock().getPart("SECID").getValue());
                int totalNum = Integer.parseInt(output.getMsgBlock().getPart("NODESNUM").getValue());
                if (totalNum != getOper.getOutMsgCount()) {
                    return 1090650123;
                }
                nodeObj.setTotalNum(totalNum);
                nodeObj.setNodeType(nodeObj.getBoardName(output.getMsgBlock().getPart("NODETYPE").getValue()));
                nodeObj.setNodePos(Integer.parseInt(output.getMsgBlock().getPart("NODEPOS").getValue()));
                TENE ne = TENEListMgr.getInstance().getNEByNEName(output.getMsgBlock().getPart("NEID").getValue());
                if (ne != null) {
                    nodeObj.setSessionNodeId((long)ne.getNEID());
                    String PortAID = output.getMsgBlock().getPart("BDPORT").getValue();
                    int slotID = TETL1CommonUtil.getNMSlotStr((String)PortAID, (int)ne.getNEID());
                    nodeObj.setwSlot(slotID);
                    int wBdtype = TEConfigurationDataMgr.getInstance().getBoardType(ne.getNEID(), slotID);
                    nodeObj.setwBdtype(wBdtype);
                    nodeObj.setwPort(TETL1CommonUtil.getPortIDFromAID((String)PortAID, (int)ne.getNEID()));
                }
                if (output.getMsgBlock().getPart("ATTACHNO").getValue() != null) {
                    try {
                        nodeObj.setBySubBdType(Integer.parseInt(output.getMsgBlock().getPart("ATTACHNO").getValue()));
                    }
                    catch (Exception e) {
                        nodeObj.setBySubBdType(0);
                    }
                }
                if (output.getMsgBlock().getPart("RES1").getValue() != null) {
                    try {
                        int resPort = TETL1CommonUtil.getPortIDFromAID((String)output.getMsgBlock().getPart("RES1").getValue(), (int)((int)nodeObj.getSessionNodeId()));
                        nodeObj.setOtherEndPort(resPort);
                    }
                    catch (Exception e) {
                        nodeObj.setOtherEndPort(0);
                    }
                }
                getSectionNodeObjList.add(nodeObj);
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("build sectionNode failed!", (Throwable)e);
            }
        }
        return 0;
    }

    public void handleAddSectionOperList(List oper, int sequenceid, List<TEErrInfo> getSectionErrInfoList) {
        for (int i = 0; i < oper.size(); ++i) {
            OutMsg output;
            TL1Operation getOper = (TL1Operation)oper.get(i);
            if (!getOper.getName().equalsIgnoreCase(NSCMD_EMCA_ADD_SECTION) || getOper.getOutMsg().length == 0 || (output = getOper.getOutMsg(0)) == null || output.getFault() == null || output.getFault().getErrCode().isEmpty()) continue;
            int errorCodeInt = output.getFault().getCompletionCode();
            TEErrInfo errorInfo = new TEErrInfo(sequenceid, errorCodeInt);
            errorInfo.setStrOperDesc(output.getFault().getErrDesc());
            errorInfo.setErrorCode(errorCodeInt);
            if (getSectionErrInfoList.contains(errorInfo)) continue;
            getSectionErrInfoList.add(errorInfo);
        }
    }

    public List getCheckSectionOperList(TENE sinkNe, List<String> sectionIDListStr) {
        this.TIME_OUT = 40;
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        TL1Operation oper = TECreateObjectFactory.getTL1Operation((int)sinkNe.getNEID(), (String)NSCMD_EMCA_CHECK_SECTION);
        if (oper != null) {
            String sectionListStr = this.convertSectionID(sectionIDListStr);
            oper = this.buildCheckTL1Operation(oper, sectionListStr);
            operationList.add(oper);
        } else {
            TELogFactory.getNormalLogger().error("Build AUD-OD-SEC failed for neid=" + sinkNe.getNEID() + "!");
        }
        return operationList;
    }

    private TL1Operation buildCheckTL1Operation(TL1Operation oper, String string) {
        oper.getInMsg().getPart("SECIDLIST").setValue(this.buildSectionAID(string));
        return oper;
    }

    private String convertSectionID(List secList) {
        StringBuffer sectionIDBuf = new StringBuffer();
        int size = secList.size();
        for (int i = 0; i < size; ++i) {
            String sectionNode = (String)secList.get(i);
            sectionIDBuf.append(sectionNode);
            if (i == size - 1) continue;
            sectionIDBuf.append("&");
        }
        return sectionIDBuf.toString();
    }

    private String buildSectionAID(String sectionID) {
        return EMCA_SECID + sectionID;
    }
}

